/*------------------------------------------------------\
|                                                       |
|  Title   :          RDS ACCES functions               |
|                                                       |
|  Date    :            03/04/92                        |
|                                                       |
|  Author  :         Jacomme Ludovic                    |
|                                                       |
\------------------------------------------------------*/

#ifndef RDSACCESDEF
#define RDSACCESDEF

/*------------------------------------------------------\
|                 Les variables globales                |
\------------------------------------------------------*/

 extern rds_fig *HeadFigureRds;

/*------------------------------------------------------\
|                    Les fonctions                      |
\------------------------------------------------------*/
/*------------------------------------------------------\
|           Les fonctions d'Allocation d'objets         |
\------------------------------------------------------*/

  extern rds_fig *AllocFigureRds();
  extern rds_ins *AllocInstanceRds();
  extern rds_rec *AllocRectangleRds();

/*------------------------------------------------------\
|          Les fonctions de Liberation d'objets         |
\------------------------------------------------------*/

  extern void FreeFigureRds();
  extern void FreeInstanceRds();
  extern void FreeRectangleRds();

/*------------------------------------------------------\
|           Les fonctions de Creation d'objets          |
\------------------------------------------------------*/

  extern rds_rec *AddRectangleInsRds();
  extern rds_rec *AddRectangleFigRds();
  extern rds_ins *AddInstanceRds();
  extern rds_fig *AddFigureRds();

/*------------------------------------------------------\
|           Les fonctions de recherche d'objets         |
\------------------------------------------------------*/

  extern rds_fig *GetFigureRds();
  extern rds_rec *GetRectangleByPoint();

/*------------------------------------------------------\
|                Les fonctions diverses                 |
\------------------------------------------------------*/

  extern long GetBoundingBox();
  extern void ReverseLinkInstanceRds();
  extern void ReverseLinkFigureRds();
  extern void ReverseLinkRds();

/*------------------------------------------------------\
|          Les fonctions de Destruction d'objets        |
\------------------------------------------------------*/

  extern boolean DelRectangleInsRds();
  extern boolean DelRectangleFigRds();
  extern boolean DelInstanceRds();
  extern boolean DelFigureRds();

  extern void    DelListRectangleInsRds();
  extern void    DelListRectangleFigRds();
  extern void    DelListInstanceRds();
  extern void    DelListFigureRds();

/*------------------------------------------------------\
|      Les fonctions de Visualisation d'objets          |
\------------------------------------------------------*/

  extern void ViewRectangleRds();
  extern void ViewInstanceRds();
  extern void ViewFigureRds();

  extern long ViewListRectangleRds();
  extern void ViewListInstanceRds();
  extern void ViewListFigureRds();

#endif
