/*------------------------------------------------------\
|                                                       |
|  Title   :          RDS Acces functions               |
|                                                       |
|  Date    :            21/09/92                        |
|                                                       |
|  Author  :         Jacomme ludovic                    |
|                                                       |
\------------------------------------------------------*/

/*------------------------------------------------------\
|                Les fichiers a inclure                 |
\------------------------------------------------------*/

#include MUT_H
#include MPH_H

#include RDS_H

#include "rdsmem.h"
#include "rdstools.h"
#include "rdsdebug.h"
#include <stdio.h>
#include <string.h>

/*------------------------------------------------------\
|                Les Messages d'erreur                  |
\------------------------------------------------------*/

#include "rdserror.h"

/*------------------------------------------------------\
|               Les variables globales                  |
\------------------------------------------------------*/

rds_fig        *HeadFigureRds  = (rds_fig *)NULL;

static char RdsLayerName[ RDS_MAX_LAYER ] [ 12 ] = 

       {

         "RDS_NWELL  ",
         "RDS_PWELL  ",
         "RDS_NDIF   ",
         "RDS_PDIF   ",
         "RDS_NTIE   ",
         "RDS_PTIE   ",
         "RDS_POLY   ",
         "RDS_GATE   ",
         "RDS_TPOLY  ",
         "RDS_CONT   ",
         "RDS_ALU1   ",
         "RDS_TALU1  ",
         "RDS_VIA1   ",
         "RDS_ALU2   ", 
         "RDS_TALU2  ",
         "RDS_VIA2   ",
         "RDS_ALU3   ",
         "RDS_TALU3  ",
         "RDS_ACTIVE ",
         "RDS_INP_N  ",
         "RDS_INP_P  ",
         "RDS_CPAS   ",
         "RDS_PPOL   ",
         "RDS_REF    ",
         "RDS_ABOX   ",
         "RDS_DEFAULT"
       };

static char MbkTypeName[ MAX_MBKTYPE ] [ 11 ] = 
    
       {
         "CONNECTOR",
         "SEGMENT",
         "CONTACT",
         "REFERENCE",
         "VIA",
         "INSTANCE",
         "FIGURE",
         "UNKNOWN"
       };

static char ExtractName[ RDS_MAX_EXTRACT ] [ 8 ] = 
   
       {
         "NONE   ",
         "EXTER  ",
         "INTER  ",
         "REF REF",
         "REF CON",
         "GRILLE ",
         "DRAIN  ",
         "SOURCE ",
         "TRANS  "
       };

static char TransfName[ RDS_MAX_TRANSF ] [ 8 ] = 
 
       {
         "NOSYM",
         "ROT_P", 
         "SYMXY",
         "ROT_M",
         "SYM_X",
         "SY_RM",
         "SYM_Y",
         "SY_RP"
       };

/*------------------------------------------------------\
|           Les fonctions d'Allocation d'objets         |
\------------------------------------------------------*/
/*------------------------------------------------------\
|          Allocation d'une figure pour RDS             |
\------------------------------------------------------*/

  rds_fig *AllocFigureRds()

  {
    return ((rds_fig *)RAZStruct(sizeof(rds_fig)));
  }


/*------------------------------------------------------\
|         Allocation d'une instance pour RDS            |
\------------------------------------------------------*/

  rds_ins *AllocInstanceRds()

  {
    return ((rds_ins *)RAZStruct(sizeof(rds_ins)));
  }

/*------------------------------------------------------\
|         Allocation d'un rectangle pour RDS            |
\------------------------------------------------------*/

  rds_rec *AllocRectangleRds()

  {
    return ((rds_rec *)RAZStruct(sizeof(rds_rec)));
  }

/*------------------------------------------------------\
|          Les fonctions de Creation d'objets           |
\------------------------------------------------------*/
/*------------------------------------------------------\
|            Creation d'une figure pour RDS             |
\------------------------------------------------------*/

  rds_fig *AddFigureRds( FigName, Mbk, Flags  )

           char *FigName;
           void *Mbk;
           char  Flags;

  {
    rds_fig *Figure;

    Figure        = AllocFigureRds();

    Figure->name  = namealloc( FigName );
    Figure->mbk   = Mbk;
    Figure->flags = Flags;
    Figure->next  = HeadFigureRds;

#define PREVIOUS user

    if ( IsModeReverseRds( Figure ))
    {
       Figure->PREVIOUS = (void *)&HeadFigureRds;
       if ( HeadFigureRds != (rds_fig *)NULL ) 
         HeadFigureRds->PREVIOUS = (void *)&Figure->next;
    }

#undef PREVIOUS

    HeadFigureRds = Figure;

    return( Figure );
  }

/*------------------------------------------------------\
|            Creation d'une instance pour RDS           |
\------------------------------------------------------*/

  rds_ins *AddInstanceRds( Figure, ModName, InsName, X, Y, Trans, Mbk )

           rds_fig *Figure;
           char    *ModName;
           char    *InsName;
           int      X;
           int      Y;
           char     Trans;
           void    *Mbk;

  {
    rds_ins *Instance;

    Instance           = AllocInstanceRds();
    Instance->mod_name = namealloc( ModName );
    Instance->ins_name = namealloc( InsName );
    Instance->x        = X;
    Instance->y        = Y;
    Instance->transf   = Trans;
    Instance->flags    = Figure->flags;
    Instance->mbk      = Mbk;
    Instance->next     = Figure->instance;

#define PREVIOUS user

    if ( IsModeReverseRds( Instance ))
    {
       Instance->PREVIOUS = (void *)&Figure->instance;
       if ( Figure->instance != (rds_ins *)NULL ) 
         Figure->instance->PREVIOUS = (void *)&Instance->next;
    }

#undef PREVIOUS

    Figure->instance = Instance;

    return( Instance );
  }

/*------------------------------------------------------\
|            Creation d'un rectangle pour RDS           |
\------------------------------------------------------*/

  rds_rec *AddRectangleInsRds( Instance, RecName,
                               X, Y, Dx, Dy,
                               Layer, MbkType, ExType, Mbk )
           rds_ins  *Instance;
           char     *RecName;
           int       X;
           int       Y;
           int       Dx;
           int       Dy;
           char      Layer;
           char      MbkType;
           char      ExType;
           void     *Mbk;
  {
    rds_rec *Rectangle;

    Rectangle = AllocRectangleRds();

    if ( RecName != (char *)NULL )
    {
      if (!( ExType & RDS_RECTANGLE_LINK ))
       
        Rectangle->u_rec.name = namealloc( RecName );
    }
    else if ( MbkType == MBK_CONNECTOR ) UnknownConnector();

    Rectangle->x            = X;
    Rectangle->y            = Y;
    Rectangle->dx           = Dx;
    Rectangle->dy           = Dy;
    Rectangle->layer        = Layer;
    Rectangle->mbk_type     = MbkType;
    Rectangle->extract_type = ExType;
    Rectangle->mbk          = Mbk;

#define PREVIOUS user

    if ( IsModeReverseRds( Instance ))
    {
       Rectangle->PREVIOUS = (void *)&(Instance->layertab[Layer]);
       if ( Instance->layertab[Layer] != (rds_rec *)NULL ) 
         Instance->layertab[Layer]->PREVIOUS = (void *)&(Rectangle->next);
    }

#undef PREVIOUS

    Rectangle->next           = Instance->layertab[Layer];
    Instance->layertab[Layer] = Rectangle;

    return( Rectangle );
  }

/*------------------------------------------------------\
|            Creation d'un rectangle pour RDS           |
\------------------------------------------------------*/

  rds_rec *AddRectangleFigRds( Figure, RecName,
                               X, Y, Dx, Dy,
                               Layer, MbkType, ExType, Mbk )

           rds_fig  *Figure;
           char     *RecName;
           int       X;
           int       Y;
           int       Dx;
           int       Dy;
           char      Layer;
           char      MbkType;
           char      ExType;
           void     *Mbk;

  {
    rds_rec *Rectangle;

    Rectangle = AllocRectangleRds();

    if ( RecName != (char *)NULL )
    {
      if (!( ExType & RDS_RECTANGLE_LINK ))
         Rectangle->u_rec.name = namealloc( RecName );
    }
    else 
      if ( MbkType == MBK_CONNECTOR ) UnknownConnector();

    Rectangle->x            = X;
    Rectangle->y            = Y;
    Rectangle->dx           = Dx;
    Rectangle->dy           = Dy;
    Rectangle->layer        = Layer;
    Rectangle->mbk_type     = MbkType;
    Rectangle->extract_type = ExType;
    Rectangle->mbk          = Mbk;

#define PREVIOUS user

    if ( IsModeReverseRds( Figure ))
    {
       Rectangle->PREVIOUS = (void *)&Figure->layertab[Layer];
       if ( Figure->layertab[Layer] != (rds_rec *)NULL ) 
         Figure->layertab[Layer]->PREVIOUS = (void *)&Rectangle->next;
    }

#undef PREVIOUS

    Rectangle->next         = Figure->layertab[Layer];
    Figure->layertab[Layer] = Rectangle;

    return( Rectangle );
  }

/*------------------------------------------------------\
|         Les fonctions de Recherche d'objets           |
\------------------------------------------------------*/
/*------------------------------------------------------\
|           Recherche d'une figure par son nom          |
\------------------------------------------------------*/

  rds_fig *GetFigureRds( FigureName )

           char *FigureName;
  {
    char    *SearchName;
    rds_fig *Index;

    SearchName = namealloc( FigureName );

    for ( Index  = HeadFigureRds;
          Index != (rds_fig *)NULL;
          Index  = Index->next )
    {
      if ( SearchName == Index->name ) break;
    }

    return( Index );
  }


/*------------------------------------------------------\
|        Recherche d'un rectangle par un point          |
\------------------------------------------------------*/

  rds_rec *GetRectangleByPoint( X, Y, Layer )

           long X;
           long Y;
           char Layer;
  {
    rds_rec *Index;
    rds_fig *Figure;
    rds_ins *Instance;

    for ( Figure  = HeadFigureRds;
          Figure != (rds_fig *)NULL;
          Figure  = Figure->next ) 
    {
      for ( Index  = Figure->layertab[ Layer ];
            Index != (rds_rec *)NULL;
            Index  = Index->next )

        if (( X >= Index->x             ) &&
            ( Y >= Index->y             ) &&
            ( X <= Index->x + Index->dx ) && 
            ( Y <= Index->y + Index->dy ))    return( Index );
 
      for ( Instance  = Figure->instance;
            Instance != (rds_ins *)NULL;
            Instance  = Instance->next )
      {
        for ( Index  = Instance->layertab[ Layer ];
              Index != (rds_rec *)NULL;
              Index  = Index->next )

          if (( X >= Index->x             ) &&
              ( Y >= Index->y             ) &&
              ( X <= Index->x + Index->dx ) && 
              ( Y <= Index->y + Index->dy ))    return( Index );
      }
    }
    return (rds_rec *)NULL ;
  }

/*------------------------------------------------------\
|                Les fonctions diverses                 |
\------------------------------------------------------*/
/*------------------------------------------------------\
|              Calcul de la bounding box                |
\------------------------------------------------------*/

  long GetBoundingBox( FigureRds, XMin, YMin, XMax, YMax )

       rds_fig *FigureRds;
       long    *XMin;
       long    *YMin;
       long    *XMax;
       long    *YMax;
  {
    rds_rec *Rectangle;
    rds_ins *Instance;
    char     Layer;

    long     X1;
    long     Y1;
    long     X2;
    long     Y2;
    long     XMinRds;
    long     YMinRds;
    long     XMaxRds;
    long     YMaxRds;

    long     MaskCounter;

    boolean  ComputeBound;
   
    MaskCounter  = 0;
    ComputeBound = TRUE;

    for ( Layer = RDS_NWELL; 
          Layer < RDS_REF; 
          Layer++ )
    {
      for ( Rectangle  = FigureRds->layertab[ Layer ];
            Rectangle != (rds_rec *)NULL;
            Rectangle  = Rectangle->next )
      {
        MaskCounter++;

        X1 = Rectangle->x;
        X2 = X1 + Rectangle->dx;
        Y1 = Rectangle->y;
        Y2 = Y1 + Rectangle->dy;

        if ( ComputeBound ) 
        {
          ComputeBound = FALSE; 

          XMaxRds = X2;
          YMaxRds = Y2;
          XMinRds = X1;
          YMinRds = Y1;
        }
        else
        {
          if ( XMaxRds < X2 ) XMaxRds = X2;
          if ( YMaxRds < Y2 ) YMaxRds = Y2;
          if ( XMinRds > X1 ) XMinRds = X1;
          if ( YMinRds > Y1 ) YMinRds = Y1;
        }
      }
    }

    for ( Instance  = FigureRds->instance;
          Instance != (rds_ins *)NULL;
          Instance  = Instance->next )
    {
      for ( Layer = RDS_NWELL; 
            Layer < RDS_REF; 
            Layer++ )
      {
        for ( Rectangle  = Instance->layertab[ Layer ];
              Rectangle != (rds_rec *)NULL;
              Rectangle  = Rectangle->next )
        {
          MaskCounter++;

          X1 = Rectangle->x;
          X2 = X1 + Rectangle->dx;
          Y1 = Rectangle->y;
          Y2 = Y1 + Rectangle->dy;

          if ( ComputeBound ) 
          {
            ComputeBound = FALSE; 

            XMaxRds = X2;
            YMaxRds = Y2;
            XMinRds = X1;
            YMinRds = Y1;
          }
          else
          {
            if ( XMaxRds < X2 ) XMaxRds = X2;
            if ( YMaxRds < Y2 ) YMaxRds = Y2;
            if ( XMinRds > X1 ) XMinRds = X1;
          }
        }
      }
    }

    *XMin = XMinRds;
    *XMax = XMaxRds;
    *YMin = YMinRds;
    *YMax = YMaxRds;

    return( MaskCounter );
  }

/*------------------------------------------------------\
|       Creation du double chainage pour une Instance   |
\------------------------------------------------------*/

  void ReverseLinkInstanceRds( InstanceRds )

       rds_ins *InstanceRds;
  {
    char      Layer;
    rds_rec  *Rectangle;
    rds_rec **Previous;

    InstanceRds->flags |= RDS_MODE_REVERSE_LINK;

    for ( Layer = 0;
          Layer < RDS_MAX_LAYER;
          Layer++ )
    {
      Previous = &InstanceRds->layertab[ Layer ];

      for ( Rectangle  = *Previous;
            Rectangle != (rds_rec *)NULL;
            Rectangle  = Rectangle->next )
      {
        Rectangle->user = (void *)Previous;
        Previous        = &Rectangle->next;
      }
    }
  }

/*------------------------------------------------------\
|       Creation du double chainage pour une figure     |
\------------------------------------------------------*/

  void ReverseLinkFigureRds( FigureRds )

       rds_fig *FigureRds;
  {
    char      Layer;
    rds_ins  *Instance;
    rds_rec  *Rectangle;
    void    **Previous;

    FigureRds->flags |=RDS_MODE_REVERSE_LINK;

    for ( Layer = 0;
          Layer < RDS_MAX_LAYER;
          Layer++ )
    {
      Previous = (void **)&FigureRds->layertab[ Layer ];

      for ( Rectangle  = *(rds_rec **)Previous;
            Rectangle != (rds_rec *)NULL;
            Rectangle  = Rectangle->next )
      {
        Rectangle->user = (void *)Previous;
        Previous        = (void **)&Rectangle->next;
      }
    }

    Previous = (void **)&FigureRds->instance;

    for ( Instance  = *(rds_ins **)Previous;
          Instance != (rds_ins *)NULL;
          Instance  = Instance->next )
    {
      ReverseLinkInstanceRds( Instance ); 
 
      Instance->user = (void *)Previous;
      Previous       = (void **)&Instance->next;
    }
  }

/*------------------------------------------------------\
|   Creation du double chainage pour toutes les figures |
\------------------------------------------------------*/

  void ReverseLinkRds()

  {
    rds_fig  *Figure;
    rds_fig **Previous;

    Previous = &HeadFigureRds;

    for ( Figure  = HeadFigureRds;
          Figure != (rds_fig *)NULL;
          Figure  = Figure->next )
    {
      ReverseLinkFigureRds( Figure );

      Figure->user = (void *)Previous;
      Previous     = &Figure->next;
    }
 }

/*------------------------------------------------------\
|                  ChangeFigureMode                     |
\------------------------------------------------------*/

/*------------------------------------------------------\
|         Les fonctions de Liberation d'objets          |
\------------------------------------------------------*/
/*------------------------------------------------------\
|          Liberation d'un rectangle pour RDS           |
\------------------------------------------------------*/

  void FreeRectangleRds( RectangleRds )

       rds_rec *RectangleRds;
  {
    mbkfree((char *)RectangleRds);
  }

/*------------------------------------------------------\
|          Liberation d'une instance pour RDS           |
\------------------------------------------------------*/

  void FreeInstanceRds( InstanceRds )

       rds_ins *InstanceRds;
  {
    mbkfree((char *)InstanceRds);
  }

/*------------------------------------------------------\
|           Liberation d'une figure pour RDS            |
\------------------------------------------------------*/

  void FreeFigureRds( FigureRds )

       rds_fig *FigureRds;
  {
    mbkfree((char *)FigureRds);
  }

/*------------------------------------------------------\
|        Les fonctions de Destruction d'objets          |
\------------------------------------------------------*/
/*------------------------------------------------------\
|         Destruction d'un rectangle pour RDS           |
\------------------------------------------------------*/

  boolean DelRectangleInsRds( Instance, RectangleRds )

       rds_ins *Instance;
       rds_rec *RectangleRds;
  {
    rds_rec  *Rectangle;
    rds_rec **Previous;

    if ( IsModeReverseRds( Instance ))
    {

#define PREVIOUS user

       *((rds_rec **)RectangleRds->PREVIOUS) = RectangleRds->next;
       if ( RectangleRds->next != (rds_rec *)NULL )
         RectangleRds->next->PREVIOUS = RectangleRds->PREVIOUS;

       FreeRectangleRds( RectangleRds );

       return ( TRUE ); 

#undef PREVIOUS

    }

    Previous  = &Instance->layertab[ RectangleRds->layer ];
    Rectangle = *Previous;

    while ( Rectangle != (rds_rec *)NULL )
    {
      if ( Rectangle == RectangleRds )
      {
        *Previous = Rectangle->next;

        FreeRectangleRds( Rectangle );

        return( TRUE );
      }

      Previous  = &Rectangle->next;
      Rectangle = *Previous;
    }

    return ( FALSE );
  }

/*------------------------------------------------------\
|         Destruction d'un rectangle pour RDS           |
\------------------------------------------------------*/

  boolean DelRectangleFigRds( Figure, RectangleRds )

       rds_fig *Figure;
       rds_rec *RectangleRds;
  {
    rds_rec  *Rectangle;
    rds_rec **Previous;

    if ( IsModeReverseRds( Figure ))
    {

#define PREVIOUS user

       *((rds_rec **)RectangleRds->PREVIOUS) = RectangleRds->next;
       if ( RectangleRds->next != (rds_rec *)NULL )
         RectangleRds->next->PREVIOUS = RectangleRds->PREVIOUS;

       FreeRectangleRds( RectangleRds );

       return ( TRUE ); 

#undef PREVIOUS
    
    }

    Previous  = &Figure->layertab[ RectangleRds->layer ];
    Rectangle = *Previous;

    while ( Rectangle != (rds_rec *)NULL )

    {
      if ( Rectangle == RectangleRds )

      {
        *Previous = Rectangle->next;

        FreeRectangleRds( Rectangle );

        return( TRUE );
      }

      Previous  = &Rectangle->next;
      Rectangle = *Previous;
    }

    return ( FALSE );
  }

/*------------------------------------------------------\
|    Destruction d'une liste de rectangles pour RDS     |
\------------------------------------------------------*/

  void DelListRectangleInsRds( Instance, Layer )

       rds_ins *Instance;
       char     Layer;
  {
    rds_rec *Rectangle;
    rds_rec *Next;

    Rectangle = Instance->layertab[Layer];

    Instance->layertab[Layer] = (rds_rec *)NULL;

    while ( Rectangle != (rds_rec *)NULL )

    {
      Next = Rectangle->next;

      FreeRectangleRds( Rectangle );

      Rectangle = Next;
    }
  }

/*------------------------------------------------------\
|    Destruction d'une liste de rectangles pour RDS     |
\------------------------------------------------------*/

  void DelListRectangleFigRds( Figure, Layer )

       rds_fig *Figure;
       char     Layer;
  {
    rds_rec *Rectangle;
    rds_rec *Next;

    Rectangle = Figure->layertab[Layer];

    Figure->layertab[Layer] = (rds_rec *)NULL;

    while ( Rectangle != (rds_rec *)NULL )

    {
      Next = Rectangle->next;

      FreeRectangleRds( Rectangle );

      Rectangle = Next;
    }
  }

/*------------------------------------------------------\
|         Destruction d'une instance pour RDS           |
\------------------------------------------------------*/

  boolean DelInstanceRds( FigureRds, InstanceRds )

       rds_fig *FigureRds;
       rds_ins *InstanceRds;
  {
    rds_ins  *Instance;
    rds_ins **Previous;
    int       Count;

    if ( IsModeReverseRds( FigureRds ))
    {

#define PREVIOUS user

       *((rds_ins **)(InstanceRds->PREVIOUS)) = InstanceRds->next;
       if ( InstanceRds->next != (rds_ins *)NULL )
         InstanceRds->next->PREVIOUS = InstanceRds->PREVIOUS;

       for ( Count = 0; Count < RDS_MAX_LAYER; Count++)
         DelListRectangleInsRds( InstanceRds, Count );

       FreeInstanceRds( InstanceRds );

       return ( TRUE ); 
    }

#undef PREVIOUS

    Instance = FigureRds->instance;
    Previous = &FigureRds->instance;

    while ( Instance != (rds_ins *)NULL )

    {
      if ( Instance == InstanceRds )

      {
        for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

          DelListRectangleInsRds( Instance, Count );

        *Previous = Instance->next;

        FreeInstanceRds( Instance );

        return( TRUE );
      }

      Previous = &Instance->next;
      Instance = *Previous;
    }

    return ( FALSE );
  }

/*------------------------------------------------------\
|     Destruction d'une liste d'instances pour RDS      |
\------------------------------------------------------*/

  void DelListInstanceRds( FigureRds, InstanceRds )

       rds_fig *FigureRds;
       rds_ins *InstanceRds;
  {
    rds_ins **Previous;
    rds_ins  *Index;
    rds_ins  *Next;
    int       Count;

    if ( IsModeReverseRds( FigureRds ))
    {

#define PREVIOUS user

      Previous = (rds_ins **)(InstanceRds->PREVIOUS);

#undef PREVIOUS

    }
    else
    {
      Previous = &FigureRds->instance;

      for ( Index = FigureRds->instance;
            ( Index != (rds_ins *)NULL ) &&
            ( Index != InstanceRds     );
            Index = Index->next )
      {
        Previous = &Index->next;
      }
    }

    *Previous = (rds_ins *)NULL;

    while ( Index != (rds_ins *)NULL )
    {
      Next = Index->next;

      for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

        DelListRectangleInsRds( Index, Count );

      FreeInstanceRds( Index );

      Index = Next;
   }
 }

/*------------------------------------------------------\
|           Destruction d'une figure pour RDS           |
\------------------------------------------------------*/

  boolean DelFigureRds( FigureRds )

       rds_fig *FigureRds;
  {
    rds_fig  *Figure;
    rds_fig **Previous;
    int       Count;

    if ( IsModeReverseRds( FigureRds ))
    {

#define PREVIOUS user

       *((rds_fig **)FigureRds->PREVIOUS) = FigureRds->next;
       if ( FigureRds->next != (rds_fig *)NULL )
         FigureRds->next->PREVIOUS = FigureRds->PREVIOUS;

       for ( Count = 0; Count < RDS_MAX_LAYER; Count++)
         DelListRectangleFigRds( FigureRds, Count );

       DelListInstanceRds( FigureRds );
       FreeFigureRds     ( FigureRds );

       return ( TRUE ); 

#undef PREVIOUS
    }

    Previous = &HeadFigureRds;
    Figure   =  HeadFigureRds;

    while ( Figure != (rds_fig *)NULL )

    {
      if ( Figure == FigureRds )

      {
        for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

          DelListRectangleFigRds( Figure, Count );

        *Previous = Figure->next;

        DelListInstanceRds( Figure );
        FreeFigureRds     ( Figure );

        return( TRUE );
      }

      Previous = &Figure->next;
      Figure   = *Previous;
    }

    return ( FALSE );
  }

/*------------------------------------------------------\
|      Destruction d'une liste de figures pour RDS      |
\------------------------------------------------------*/

  void DelListFigureRds( FigureRds )

       rds_fig *FigureRds;

  {
    rds_fig  *Index;
    rds_fig **Previous;
    rds_fig  *Next;
    int       Count;


    if ( IsModeReverseRds( FigureRds ))
    {

#define PREVIOUS user

       Previous = (rds_fig **)FigureRds->PREVIOUS;

#undef PREVIOUS

    }
    else
    {
      Previous = &HeadFigureRds;

      for ( Index  = HeadFigureRds;
            ( Index != (rds_fig *)NULL ) && 
            ( Index != FigureRds );
            Index  = Index->next )
      {
        Previous = &Index->next;
      }
    }

    *Previous = (rds_fig *)NULL;

    while ( Index != (rds_fig *)NULL )

    {
      Next = Index->next;

      for ( Count = 0; Count < RDS_MAX_LAYER; Count++)

        DelListRectangleFigRds( Index, Count );

      DelListInstanceRds( Index );
      FreeFigureRds     ( Index );

     Index = Next;
   }
 }

/*------------------------------------------------------\
|        Les fonctions de Visualisation d'objets        |
\------------------------------------------------------*/
/*------------------------------------------------------\
|            Compte les liens du champ Link             |
\------------------------------------------------------*/

  char CountLink( Rectangle )

       rds_rec *Rectangle;
   {
      rds_rec *Index;
      char     Counter;
     
      Counter = 1;
      Index   = Rectangle->u_rec.link;
      
      while ( Index != Rectangle )
      {
        if (Index == (rds_rec *)NULL) return( 0 );

        Index = Index->u_rec.link;
        Counter++;
      }

      return ( Counter );
   }

/*------------------------------------------------------\
|        Visualisation d'un rectangles pour RDS         |
\------------------------------------------------------*/

  void ViewRectangleRds( Rectangle )

       rds_rec  *Rectangle;
  {
    char Counter;
    
    PrintHeadLine();

    printf("|---Rectangle : ");

    if (( Rectangle->mbk_type == MBK_SEGMENT ))
    {
        if ( Rectangle->extract_type == RDS_SEG_TRANS )
        {
          printf("TRANSISTOR");

          if ((Counter = CountLink( Rectangle )) == 5)
            printf(", %d\n", Counter);
          else 
            printf(" Link ERROR, %d !\n", Counter);
        }
        else 
        if ( IsLinkedRectangleRds( Rectangle ))
        {
          Counter = CountLink( Rectangle );
          printf("LINKED RECTANGLE, %d\n", Counter);
        }
    }
    else 
        if ( Rectangle->mbk_type == MBK_VIA )
           {
             printf("VIA");

             if ((Counter = CountLink( Rectangle )) > 1)
               printf(", %d\n", Counter);
             else 
               printf(" Link ERROR, %d !\n", Counter);
           }
        else 
           if ( Rectangle->u_rec.name != (char *)NULL )
             printf("%s\n", Rectangle->u_rec.name );
           else 
             printf("! No name !\n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    PrintHeadLine();
    printf("|---Position     : X  = %-6d  Y  = %-6d\n", Rectangle->x,
                                                        Rectangle->y );
    PrintHeadLine();
    printf("|---Size         : Dx = %-6d  Dy = %-6d\n", Rectangle->dx,
                                                        Rectangle->dy);
    PrintHeadLine();
    printf("|---Mbk Type     : %s\n", MbkTypeName[ Rectangle->mbk_type ]);
    PrintHeadLine();
    printf("|---Extract Type : %s\n", ExtractName[ Rectangle->extract_type & 
                                                   ~RDS_RECTANGLE_LINK ]);
    PrintHeadLine();
    printf("|---Layer        : %s\n", RdsLayerName[ Rectangle->layer ]);
    PrintHeadLine();
    printf("|---Flags        : %d\n", Rectangle->flags );
    PrintHeadLine();
    if ( Rectangle->user == NULL ) 
      printf("|---User         : Empty\n" );
    else                           
      printf("|---User         : Busy \n" );
    PrintHeadLine();
    if ( Rectangle->equi == (rds_rec *)NULL ) 
      printf("|---Equi         : Empty\n" );
    else  
      printf("|---Equi         : Busy \n" );
    PrintHeadLine();
    printf("|\n");

    HeadLine--;
  }

/*------------------------------------------------------\
|       Visualisation d'une liste de rectangles         |
\------------------------------------------------------*/

  long ViewListRectangleRds( Rectangle )

       rds_rec  *Rectangle;
  {
    long Counter;

    for ( Counter = 0; Rectangle != (rds_rec *)NULL; Counter++ )
    {
      ViewRectangleRds( Rectangle );
      Rectangle = Rectangle->next;
    }
    return( Counter );
  }

/*------------------------------------------------------\
|        Visualisation d'une Instance pour RDS          |
\------------------------------------------------------*/

  void ViewInstanceRds( Instance )

       rds_ins  *Instance;
  {
    char    Layer;
    boolean Empty;

    PrintHeadLine();

    printf("|---Instance : ");

    if ( Instance->ins_name != (char *)NULL )
      printf("%s\n", Instance->ins_name );
    else 
      printf("! No name ERROR !\n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    PrintHeadLine();
    printf("|---Modele   : ");

    if ( Instance->mod_name != (char *)NULL )
      printf("%s\n", Instance->mod_name );
    else 
      printf("! No name ERROR !\n");

    PrintHeadLine();
    printf("|---Position : X  = %-6d  Y  = %-6d\n", Instance->x , 
                                                    Instance->y );
    PrintHeadLine();
    printf("|---Transf   : %s\n", TransfName[ Instance->transf ] );

    PrintHeadLine();
    printf("|\n");

    for ( Empty = TRUE, Layer = 0; Layer < RDS_MAX_LAYER ; Layer++ )

     Empty &= ViewListRectangleRds( Instance->layertab[ Layer ] ) == 0;

    if ( Empty )
    {
      PrintHeadLine();
      printf("|---Rectangle List is empty\n");
    }

    PrintHeadLine();
    printf("|\n");

    HeadLine--;
  }

/*------------------------------------------------------\
|       Visualisation d'une liste d'instances           |
\------------------------------------------------------*/

  void ViewListInstanceRds( Instance )

       rds_ins  *Instance;
  {
    while ( Instance != (rds_ins *)NULL )
    {
      ViewInstanceRds( Instance );
      Instance = Instance->next;
    }
  }

/*------------------------------------------------------\
|          Visualisation d'une Figure pour RDS          |
\------------------------------------------------------*/

  void ViewFigureRds( Figure )

       rds_fig  *Figure;
  {
    rds_ins *Instance;
    char     Layer;
    boolean  Empty;

    PrintHeadLine();

    printf("|---Figure : ");

    if ( Figure->name != (char *)NULL )

         printf("%s\n", Figure->name );
    else 
         printf("! No name ERROR !\n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    PrintHeadLine();
    printf("|---Models  : \n");

    HeadLine++;
    PrintHeadLine();
    printf("|\n");

    for ( Empty = TRUE, Instance = Figure->instance;
          Instance != (rds_ins *)NULL;
          Instance = Instance->next )
    {
      Empty = FALSE;
      
      PrintHeadLine();

      if ( Instance->mod_name != (char *)NULL )

           printf("|---%s\n", Instance->mod_name );
      else 
           printf("|---! No name ERROR !\n");
    }

    if ( Empty )
    {
      PrintHeadLine();
      printf("|---Model list is empty\n");
    }
    
    PrintHeadLine();
    printf("|\n");

    HeadLine--;

    if ( ! Empty ) ViewListInstanceRds( Figure->instance );

    for ( Empty = TRUE, Layer = 0; Layer < RDS_MAX_LAYER ; Layer++ )

     Empty &= ViewListRectangleRds( Figure->layertab[ Layer ] ) == 0;

    if ( Empty )
    {
      PrintHeadLine();
      printf("|---Rectangle List is empty\n");
    }

    PrintHeadLine();
    printf("|\n");

    HeadLine--;
  }

/*------------------------------------------------------\
|         Visualisation d'une liste de figures          |
\------------------------------------------------------*/

  void ViewListFigureRds( Figure )

       rds_fig  *Figure;
  {
    if ( Figure == (rds_fig *)NULL) 
    {
      printf("\n|---Figure List is empty");
      return;
    }

    while ( Figure != (rds_fig *)NULL )
    {
      ViewFigureRds( Figure );
      Figure = Figure->next;
    }
  }
