/*------------------------------------------------------\
|                                                       |
|  Title   :   Structures and fonctions for RDS         |
|                                                       |
|  Date    :            30.09.92                        |
|                                                       |
|  Author  :        Jacomme Ludovic                     |
|                                                       |
\------------------------------------------------------*/

/*------------------------------------------------------\
|                    Les constantes                     |
\------------------------------------------------------*/

#ifndef _RDS_
#define _RDS_

#  define TRUE  1
#  define FALSE 0
#  define ERROR 1
#  define OK    0

/*------------------------------------------------------\
|                   Flags for the models                |
\------------------------------------------------------*/

#define RDS_MODE_ALL          (1 << 0)
#define RDS_MODE_TREAT        (1 << 1)
#define RDS_MODE_REVERSE_LINK (1 << 2)

#define IsModeAllRds( Figure )     ( (Figure)->flags & RDS_MODE_ALL )
#define IsModeTreatRds( Figure )   ( (Figure)->flags & RDS_MODE_TREAT )
#define IsModeReverseRds( Figure ) ( (Figure)->flags & RDS_MODE_REVERSE_LINK )

/*------------------------------------------------------\
|                         Mbk Type                      |
\------------------------------------------------------*/

#  define MBK_CONNECTOR 0
#  define MBK_SEGMENT   1
#  define MBK_CONTACT   2         
#  define MBK_REFERENCE 3
#  define MBK_VIA       4
#  define MBK_INSTANCE  5
#  define MBK_FIGURE    6
#  define MBK_UNKNOWN   7

#  define MAX_MBKTYPE   MBK_UNKNOWN + 1

/*------------------------------------------------------\
|                      Extract Type                     |
\------------------------------------------------------*/

#  define RDS_RECTANGLE_LINK (char)0x80

#  define RDS_NONE       (char)0x00

#  define RDS_CON_EXTER  (char)0x01
#  define RDS_CON_INTER  (char)0x02
#  define RDS_REF_REF    (char)0x03
#  define RDS_REF_CON    (char)0x04

#  define RDS_SEG_GRILLE (char)0x85        
#  define RDS_SEG_DRAIN  (char)0x86
#  define RDS_SEG_SOURCE (char)0x87
#  define RDS_SEG_TRANS  (char)0x88
  
#  define RDS_MAX_EXTRACT 9

#  define IsLinkedRectangleRds( Rectangle )              \
                                                         \
      ( (Rectangle->extract_type) & RDS_RECTANGLE_LINK )

/*------------------------------------------------------\
|           Transformations  pour les instances         |
\------------------------------------------------------*/

#  define RDS_NOSYM  0
#  define RDS_ROT_P  1
#  define RDS_SYMXY  2
#  define RDS_ROT_M  3
#  define RDS_SYM_X  4
#  define RDS_SY_RM  5
#  define RDS_SYM_Y  6
#  define RDS_SY_RP  7

#  define RDS_MAX_TRANSF    RDS_SY_RP + 1

/*------------------------------------------------------\
|             Les differents layers pour RDS            |
\------------------------------------------------------*/

#  define RDS_NWELL   0
#  define RDS_PWELL   1
#  define RDS_NDIF    2
#  define RDS_PDIF    3
#  define RDS_NTIE    4
#  define RDS_PTIE    5
#  define RDS_POLY    6
#  define RDS_GATE    7
#  define RDS_TPOLY   8
#  define RDS_CONT    9
#  define RDS_ALU1    10
#  define RDS_TALU1   11
#  define RDS_VIA1    12
#  define RDS_ALU2    13
#  define RDS_TALU2   14
#  define RDS_VIA2    15
#  define RDS_ALU3    16
#  define RDS_TALU3   17
#  define RDS_ACTIV   18
#  define RDS_NIMP    19
#  define RDS_PIMP    20
#  define RDS_CPAS    21
#  define RDS_PPOL    22
#  define RDS_REF     23
#  define RDS_ABOX    24
#  define RDS_DEFAULT 25

#  define RDS_MAX_LAYER   RDS_DEFAULT + 1

#  define RDS_NOP     (char )255

/*------------------------------------------------------\
|                       Les types                       |
\------------------------------------------------------*/

  typedef unsigned char byte;
  typedef unsigned int  word;
  typedef unsigned char boolean;

  typedef struct rds_rectangle

  {
    struct rds_rectangle *next;
    long                  x;
    long                  y;
    long                  dx;
    long                  dy;
    void                 *mbk;

    union 
    {
      char                 *name;
      struct rds_rectangle *link;
    } u_rec;

    struct rds_rectangle *equi;
    void                 *user;
    char                  mbk_type;
    char                  layer;
    char                  flags;
    char                  extract_type;
  } rds_rec;


  typedef struct rds_instance

  {
    struct rds_instance  *next;
    char                 *mod_name;
    char                 *ins_name;
    void                 *mbk;
    long                  x;
    long                  y;
    char                  transf;
    char                  flags;
    struct rds_rectangle *layertab[ RDS_MAX_LAYER ];
    struct rds_rectangle *couronne[ RDS_MAX_LAYER ];
    void                 *user;
  } rds_ins;

 
  typedef struct rds_figure
 
  {
    struct rds_figure    *next;
    char                 *name;
    struct rds_rectangle *layertab[ RDS_MAX_LAYER ];
    struct rds_instance  *instance;
    void                 *mbk;
    char                  mode;
    char                  flags;
    char                  flagtab[ RDS_MAX_LAYER ];
    struct rds_rectangle *bboxtab[ RDS_MAX_LAYER ];
    void                 *translist;
    void                 *user;
  } rds_fig;
 
/*------------------------------------------------------\
|                 Les variables globales                |
\------------------------------------------------------*/

 extern rds_fig *HeadFigureRds;

/*------------------------------------------------------\
|                    Les fonctions                      |
\------------------------------------------------------*/
/*------------------------------------------------------\
|               chargement et Sauvegarde                |
\------------------------------------------------------*/

extern void         SaveRdsFig();
extern rds_fig    * LoadRdsFig();

/*------------------------------------------------------\
|              Allocation d'une structure               |
\------------------------------------------------------*/

  extern char *RAZStruct();
 
/*------------------------------------------------------\
|           Les fonctions d'Allocation d'objets         |
\------------------------------------------------------*/

  extern rds_fig *AllocFigureRds();
  extern rds_ins *AllocInstanceRds();
  extern rds_rec *AllocRectangleRds();

/*------------------------------------------------------\
|          Les fonctions de Liberation d'objets         |
\------------------------------------------------------*/

  extern void FreeFigureRds();
  extern void FreeInstanceRds();
  extern void FreeRectangleRds();

/*------------------------------------------------------\
|           Les fonctions de Creation d'objets          |
\------------------------------------------------------*/

  extern rds_rec *AddRectangleInsRds();
  extern rds_rec *AddRectangleFigRds();
  extern rds_ins *AddInstanceRds();
  extern rds_fig *AddFigureRds();

/*------------------------------------------------------\
|          Les fonctions de Recherche d'objets          |
\------------------------------------------------------*/

  extern rds_fig *GetFigureRds();
  extern rds_rec *GetRectangleByPoint();

/*------------------------------------------------------\
|                 Les fonctions diverses                |
\------------------------------------------------------*/

  extern long GetBoundingBox();
  extern void ReverseLinkInstanceRds();
  extern void ReverseLinkFigureRds();
  extern void ReverseLinkRds();

/*------------------------------------------------------\
|          Les fonctions de Destruction d'objets        |
\------------------------------------------------------*/

  extern boolean DelRectangleInsRds();
  extern boolean DelRectangleFigRds();
  extern boolean DelInstanceRds();
  extern boolean DelFigureRds();

  extern void    DelListRectangleInsRds();
  extern void    DelListRectangleFigRds();
  extern void    DelListInstanceRds();
  extern void    DelListFigureRds();

/*------------------------------------------------------\
|      Les fonctions de Visualisation d'objets          |
\------------------------------------------------------*/

  extern void ViewRectangleRds();
  extern void ViewInstanceRds();
  extern void ViewFigureRds();

  extern long ViewListRectangleRds();
  extern void ViewListInstanceRds();
  extern void ViewListFigureRds();

/*------------------------------------------------------\
|          Les fonctions de changement de mode          |
\------------------------------------------------------*/

  extern void ChangeFigureModeRds();

/*------------------------------------------------------\
| Rounds a value to the nearest physical grid step      |
\------------------------------------------------------*/

#define RoundSup(X) (((X)>=0) ? ((((X) + ( PHYSICAL_GRID_PARAM >> 1))    \
                                       / PHYSICAL_GRID_PARAM         ) * \
                                         PHYSICAL_GRID_PARAM         )   \
                              :  (((X) / PHYSICAL_GRID_PARAM         ) * \
                                         PHYSICAL_GRID_PARAM         )   )

#define RoundInf(X) (((X)>=0) ?  (((X) / PHYSICAL_GRID_PARAM         ) * \
                                         PHYSICAL_GRID_PARAM         )   \
                              : ((((X) - ( PHYSICAL_GRID_PARAM >> 1 ))   \
                                      /  PHYSICAL_GRID_PARAM         ) * \
                                         PHYSICAL_GRID_PARAM         )   )

#endif
