
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: sl_compile.c						*/
/* date		: november 20 91					*/
/*                June 23 92                                            */
/* author	: BURGUN L.						*/
/*									*/
/*									*/
/* ###--------------------------------------------------------------### */

#include "mut309.h"
#include "log120.h"
#include <math.h>
#include "beh104.h"
#include "../synthe/sl_type.h"
#include "sl_util.h"

/*----------------------------------------------------------------------------
createAuxOperBeh  : cree des variables auxiliaires pour les chapeaux des 
                    latches 
------------------------------------------------------------------------------
retour		: une expression decoupee (un atome, en fait ... ) 
------------------------------------------------------------------------------*/

chain_list *createAuxOperBeh(expr,beh,par,name)
chain_list *expr;
befig_list *beh;
sl_param *par;
char *name;
{
int static co = 1;

if (ATOM(expr))
   {
   beaux_list *aux;

   if (!strcmp(VALUE_ATOM(expr),"'0'") || !strcmp(VALUE_ATOM(expr),"'1'"))
      return(copyExpr(expr));


	/* appel recursif jusqu'aux entrees primaires ou latches */

   aux = beh->BEAUX;
   while (aux)
      {
      if (!strcmp(aux->NAME,VALUE_ATOM(expr)))
         {
         aux->ABL = createAuxOperBeh(aux->ABL,beh,par,EMPTYTH);
         par->guardedAux = addchain(par->guardedAux,aux->NAME);
         par->delayPI = addptype(par->delayPI,0,aux->NAME);
         }
      aux = aux->NEXT;
      }
   return(copyExpr(expr));
   }
else
   {
   chain_list *exprRes;

   if (name == NULL)
      name = gensym("auxctrl",co++);

   exprRes = createExpr(OPER(expr));
   while (expr = CDR(expr))
      {
      addQExpr(exprRes,createAuxOperBeh(CAR(expr),beh,par,NULL));
      }

		/* si name = EMPTYTH aux deja cree */

   if (name != (char *) EMPTYTH)
      {
      beh->BEAUX = beh_addbeaux(beh->BEAUX,name,NULL,NULL);
      par->guardedAux = addchain(par->guardedAux,name);
      par->delayPI = addptype(par->delayPI,0,name);
      beh->BEAUX->ABL = exprRes; 
      return (createAtom(name));
      }
   else
      return (exprRes);
   }
}

/*----------------------------------------------------------------------------
compileVHDL   	: compile un vbe , cree eventuellement les BDD et verifie la 
		  coherence de la description. Le systeme des BDD doit etre
		  initialise auparavant.
		  si gcOk = 1 on peut effectuer un garbage collector.
		  si vhb_reorder > 1 on peut re-ordonnancer les bdds du circuit.
------------------------------------------------------------------------------
retour		: NULL si la compilation n'a pas fonctionne 
                  l'ordonnancement des variables d'entrees sinon.
------------------------------------------------------------------------------*/

chain_list *compileVHDL(file,orderPI,order,par,saveaux,gcOK,vhb_reorder,makeBdd,trace,func,latches)
char *file;
chain_list *orderPI;
int order;
sl_param *par;
int saveaux;
int gcOK;
int vhb_reorder;
int makeBdd;
int trace;
char *(*func)();
int latches;
{
befig_list *vhdlloadbefig();
befig_list *beh;
beaux_list *aux;
chain_list *ptChain;
chain_list *makeOrderAbl();
chain_list *makeOrderBddBeh();
bebus_list *bus;
bebux_list *bux;
biabl_list *biabl;
bereg_list *reg;
int coInter;
char *path;
int i;
int indice = 0;
char *filep;

   filep = (char *) mbkalloc (strlen(file) + 1);

   strcpy(filep,file);

   file = filep;

   for (i=0; i< strlen(file); i++)
       if (file[i] == '/')
          indice = i; 

   if (indice == 0)
      {
      path = ".";
      file[strlen(file) - 4] = '\0';
      } 
   else
      {
      path = (char *) mbkalloc (indice + 1);
      strncpy(path,file,indice);
      path[indice] = '\0';
      for (i=0;i<=indice;i++)
         file++;
      file[strlen(file) - 4] = '\0';
      }

		/* maj des var. d'environnement du compilateur */

   putenv(genNAME("VH_LIBLST=%s",path));
   putenv("VH_BEHSFX=vbe");
   mbkenv();
   BVL_ERRFLG = 0;

		/* compilation du VHDL */

   beh = vhdlloadbefig (NULL,file,trace);
   if (beh->ERRFLG != 0)
      {
      return(NULL);
      }

   beh->NEXT = VHB_HEDFIG;
   VHB_HEDFIG = beh;

   
   reg = beh->BEREG;
   while (reg)
      {
      biabl = reg->BIABL;
      while (biabl)
         {
         biabl->USER = NULL;
         biabl = biabl->NEXT;
         }
      reg = reg->NEXT;
      }


	/* verification de la declaration correcte d'attribut 'stable

           forme valide      (l = '0') and not l'stable   : front descendant
                             (and (not l) (not (stable l)))

           ou                (l = '1') and not l'stable   : front montant
                             (and l (not (stable l)))
         */ 

   if (beh->TYPE & BEH_STABLE)
      {
      reg = beh->BEREG;
      while (reg)
         {
         biabl = reg->BIABL;
         while (biabl)
            {
            chain_list *inter = biabl->CNDABL;

		/* patch eliminant les egalites avec NXOR */

            biabl->CNDABL = remegalExpr(biabl->CNDABL);
            if (searchOperExpr(biabl->CNDABL,STABLE))
               {
               chain_list *pattern1,*pattern2;

               pattern1 = charToExpr("(and (not x) (not (stable x)))");
               pattern2 = charToExpr("(and x (not (stable x)))");

               if (!PMExpr(biabl->CNDABL,pattern1) &&
                   !PMExpr(biabl->CNDABL,pattern2))
                  {
                  printf("VHDL : Error - bad usage of the 'stable' attribut\n");
                  return(NULL);
                  }
               else
                  {
                  biabl->USER = addptype(NULL,0,0); 
                  }

               /*    (and (not x) (not (stable x))) --> x */
               /*    (and x (not (stable x))) --> (not x) */

               if (ATOM(CADR(biabl->CNDABL)))
                  biabl->CNDABL = notExpr(CADR(biabl->CNDABL));
               else
                  biabl->CNDABL = CADR(CADR(biabl->CNDABL));
               
               freeExpr(pattern1);
               freeExpr(pattern2);
               }
            freeExpr(inter);
            biabl = biabl->NEXT;
            }
         reg = reg->NEXT;
         }
      }


	/* on renomme les variables de la befig pour les vecteurs */

   if (func != NULL)
      renameBeh(beh,func);

		/* mise a jour de la liste des aux a conserver */

   if (par)		/* pour la synthese uniquement */
      { 
      pTH labelTH = createTH(100);
      ptype_list *delayPI = par->delayPI;
      par->guardedAux = NULL;

      while (delayPI)
         {
         beaux_list *aux = beh->BEAUX;

			/* est-ce une variable auxiliaire ? */
         while (aux)
            {
            if (!strcmp(aux->NAME,delayPI->DATA))
               par->guardedAux = addchain(par->guardedAux,delayPI->DATA);
            aux = aux->NEXT;
            }
         delayPI = delayPI->NEXT;
         }

			/* probleme du chapeau des latches */

      if (latches)
         {
         reg = beh->BEREG;
         while (reg)
            {
            biabl = reg->BIABL;
            while (biabl)
               {
               char *name;
               int aux = searchTH(labelTH,biabl->LABEL);

               name = biabl->LABEL;
                  
			/* si la commande n'a pas encore ete traite */

               if (aux == EMPTYTH)
                  {
                  biabl->CNDABL = createAuxOperBeh(biabl->CNDABL,beh,par,name);
                  addTH(labelTH,biabl->LABEL,biabl->CNDABL);
                  }
               else
                  {
                  biabl->CNDABL = copyExpr((chain_list *) aux);
                  }
   
               biabl = biabl->NEXT;
               }
            reg = reg->NEXT;
            }
         }

      destroyTH(labelTH);
      }

   mapExprBeh(beh,flatArityExpr);


   if (makeBdd)
      {
		/* calcul de l'ordonnancement si automatique
                   ou pas de calcul precedent de l'ordonnancement */

      if (!orderPI || order)		/* pas d'ordonnancement */
         {
         orderPI = makeOrderAbl(beh,order,trace);
         if (trace == 2)
            {
            system("clear");
   	    printf("\nMakeOrderAbl : automatic order : \n" );
	    afficheLC(orderPI);
            getchar();
            }
         }

		/* creation des bdd */


      coInter = 0;

		/* ajout des var. auxiliaires pour ne pas les eliminer */

      if (saveaux == 1)
         {
         aux = beh->BEAUX;
         while (aux)
            {
            orderPI = addchain(orderPI,aux->NAME); 
            aux = aux->NEXT ;
            coInter++;
            }
         }
      else
		/* pour le circuit synthetise  ajout des aux de delaypi*/
         {
         if (par)
            {
            chain_list *guardedAux; 
 
            guardedAux = par->guardedAux; 
            while ( guardedAux)
               { 
               if (existAuxBeh(beh,guardedAux->DATA)) 
                  orderPI = addchain(orderPI,guardedAux->DATA); 
               guardedAux = guardedAux->NEXT; 
               coInter++;
               } 
            }
         }

      beh->CIRCUI =  initializeCct(file,coInter+2*countInputBeh(beh)+1,100);

      ptChain = orderPI;
      while (ptChain) 
        {
        addInputCct(beh->CIRCUI,ptChain->DATA);
        ptChain = ptChain->NEXT ;
        } 


		/* si l'ordonnancement n'est pas complet */

      ptChain = berinToChain_list(beh);
      while (ptChain) 
        {
        if (searchInputCct(beh->CIRCUI,ptChain->DATA) == EMPTYTH)
           addInputCct(beh->CIRCUI,ptChain->DATA);
        ptChain = ptChain->NEXT ;
        } 


      while ( makeBddBeh(beh,beh->CIRCUI,vhb_reorder,trace,50) == 1 )
         {
         if (trace)
            {
            printf("Running makeOrderBddBeh ...");
            }
         if (trace == 2)
            {
            system("clear");
            printf("\n---> Number of nodes = %d\n",numberNodeAllBdd());
            }

         orderPI = makeOrderBddBeh (beh,0,NULL,NULL,2,10,gcOK,0,8,0);
         if (trace == 2)
            {
   	    printf("\nRe-ordonnancement automatique : \n" );
	    afficheLC(orderPI);
            getchar();
            }
         vhb_reorder--;
         printf("\n");
         }


      if (trace)
         {
         printf("---> Final number of nodes = %d",numberNodeAllBdd());
         }

      if (gcOK)
         {
         gcNodeBeh(beh);
         printf("(%d)\n\n",numberNodeAllBdd());
         }

		/* verification de la coherence */

   }


		/* retour liste triee des entrees */
   if (makeBdd)
      return(orderPI);
   else
      return((chain_list *)1);
}

/*----------------------------------------------------------------------------
remegalExpr   	: elimine les horreurs du style 
                        (not (xor a '0'))  --> not a
                        (not (xor a '1'))  --> a
------------------------------------------------------------------------------
retour		: une expression
------------------------------------------------------------------------------*/

chain_list *remegalExpr(expr)
chain_list *expr;
{
if (ATOM(expr))
   return(copyExpr(expr));
else
   {
   chain_list *ret;

   if ((OPER(expr) == NOT) && !ATOM(CADR(expr)) && (OPER(CADR(expr)) == XOR))
      {
      chain_list *filsExpr;
      chain_list *filsCst;

      filsExpr = CADR(expr);
      filsCst = CADR(CDR(filsExpr));

      if (ATOM(filsCst) && !strcmp(VALUE_ATOM(filsCst),"'1'"))
         {
         return(copyExpr(CADR(filsExpr))); 
         } 
      if (ATOM(filsCst) && !strcmp(VALUE_ATOM(filsCst),"'0'"))
         {
         return(notExpr(copyExpr(CADR(filsExpr))));
         } 
      }

   ret = createExpr(OPER(expr));
   
   while (expr = CDR(expr))
      {
      addQExpr(ret,remegalExpr(CAR(expr)));
      }
   return(ret);
   }
}

/*----------------------------------------------------------------------------
decompileVHDL   : decompile une befig vers un vbe
                  reecrit les BD
------------------------------------------------------------------------------
retour		: void
------------------------------------------------------------------------------*/

void decompileVHDL(beh,name,path,trace)
befig_list *beh;
char *name;
char *path;
int trace;
{
char *saveName;
bereg_list *reg;

		/* remise a jour des BD */

reg = beh->BEREG;
while (reg)
   {
   biabl_list *biabl;
   
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->USER)	/* BD detectee */
         {
         chain_list *expr;

         if (ATOM(biabl->CNDABL))    	/* CNDABL = ck */
            {
            expr = charToExpr("(and (not x) (not (stable x)))");
            substPhyExpr(expr,"x",biabl->CNDABL);
            }
         else				/* CNDABL = (not ck) */
            {
            expr = charToExpr("(and x (not (stable x)))");
            substPhyExpr(expr,"x",CADR(biabl->CNDABL));
            }

         freeExpr(biabl->CNDABL);
         biabl->CNDABL = expr;
         }
      biabl = biabl->NEXT;
      } 
   reg = reg->NEXT;
   }

if (name)
   {
   saveName = beh->NAME;
   beh->NAME = name;
   }

vhdlsavebefig(beh,trace);

if (strcmp(path,"."))
   system(genNAME("mv %s.vbe %s/%s.vbe",beh->NAME,path,beh->NAME));

if (name)
   {
   beh->NAME = saveName;
   }

}
