
# line 12 "pat_prspat.yac"
#include <stdio.h>
#include <mut309.h>
#include <pat103.h>
#include "pat_defs.h"
#include "pat_type.h"
#include "pat_prspat.h"

/* ###--------------------------------------------------------------### */
/* function	: pat_prspat						*/
/* description	: parse a file in pat format and return a PASEQ		*/
/* called func.	: pat_pat_yyparse						*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_prspat (ptseq, fp, maxpat)

struct paseq *ptseq;
FILE         *fp;
unsigned int  maxpat;

  {
  extern FILE *pat_yyin;

  PAT_SEQPNT = ptseq;
  pat_yyin       = fp;

  pat_yyparse ();

  ptseq = PAT_SEQPNT;

  return (ptseq);
  }


# line 46 "pat_prspat.yac"
typedef union 
  {
  int           valu;
  char          immd;
  char         *text;
  struct array  arra;
  } pat_YYSTYPE;
# define _IN 257
# define _INOUT 258
# define _LESym 259
# define _OUT 260
# define AbstractLit 261
# define BEFORE 262
# define BEGIN_ 263
# define BitStringLit 264
# define Colon 265
# define Comma 266
# define Comment 267
# define DOWNTO 268
# define Dot 269
# define END_ 270
# define Format 271
# define Identifier 272
# define LeftParen 273
# define Literal 274
# define QuestionMark 275
# define REGISTER 276
# define RightParen 277
# define SAVE 278
# define SIGNAL 279
# define Semicolon 280
# define TO 281
# define UnknownChar 282
#define pat_yyclearin pat_yychar = -1
#define pat_yyerrok pat_yyerrflag = 0
extern int pat_yychar;
extern short pat_yyerrflag;
#ifndef pat_YYMAXDEPTH
#define pat_YYMAXDEPTH 150
#endif
pat_YYSTYPE pat_yylval, pat_yyval;
# define pat_YYERRCODE 256

# line 615 "pat_prspat.yac"


#include "lex.pat_yy.c"

/* ###--------------------------------------------------------------### */
/* function	: user_error						*/
/* description	: print an error message depending on the arg. `code`	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void user_error (code, str, dat)

int   code;
char *str;
char  dat;
  {
  static int error_nbr = 0;

  err_flg = 1;
  (void)fprintf (stderr,"Error %d line %d : ",code,linnum);

  switch (code)
    {
    case 1:
      (void)fprintf (stderr,"illegal format for one-bit signal\n");
      break;
    case 2:
      (void)fprintf (stderr,"illegal input-output value `%c`\n",dat);
      break;
    case 3:
      (void)fprintf (stderr,"too many input-output values\n");
      break;
    case 4:
      (void)fprintf (stderr,"cannot force the value of output `%s`\n",str);
      break;
    case 5:
      (void)fprintf (stderr,"cannot compare the value of input `%s`\n",str);
      break;
    case 6:
      (void)fprintf (stderr,"too many input-outputs\n");
      break;
    case 7:
      (void)fprintf (stderr,"`%s` already declared with another mode\n",str);
      break;
    case 8:
      (void)fprintf (stderr,"goup `%s` already declared\n",str);
      break;
    case 9:
      (void)fprintf (stderr,"pattern label `%s` already used\n",str);
      break;
    case 10:
      (void)fprintf (stderr,"illegal value for `%s` format `%c`\n",str,dat);
      break;
    case 11:
      (void)fprintf (stderr,"conflictual action on pattern `%s`\n",str);
      break;
    case 12:
      (void)fprintf (stderr,"range of `%s` and value mismatch\n",str);
      break;
    case 13:
      (void)fprintf (stderr,"`%s` already declared as an input\n",str);
      break;
    case 14:
      (void)fprintf (stderr,"too many hierarchical names\n");
      break;
    case 15:
      (void)fprintf (stderr,"no enough input-output values\n");
      break;
    }
  error_nbr++;
  if (error_nbr > 30)
    {
    (void)fprintf (stderr,"too many errors. Cannot continue further more\n");
    (void)fprintf (stderr,"\n\thave a nice day ...\n");
    exit (1);
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: pat_yywrap						*/
/* description	: used by lex						*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static int  pat_yywrap ()
  {
  return (1);
  }

/* ###--------------------------------------------------------------### */
/* function	: pat_yyerror						*/
/* description	: print an error message (errors detected by yacc)	*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static void pat_yyerror (str)

char *str;
  {
  err_flg = 1;
  fprintf (stderr,"%s line : %d\n",str,linnum);
  }

/* ###--------------------------------------------------------------### */
/* function	: addiol						*/
/* description	: add a list of PAIOL structure at the top of the list	*/
/* called func.	: pat_addpaiol						*/
/* ###--------------------------------------------------------------### */

static struct paiol *addiol (lastiol, gname, format, mode, blank)

struct paiol *lastiol;
struct array  gname;
char          format;
char          mode;
short         blank;

  {
  struct paiol *ptiol = lastiol;
  char          extname[100];
  short         i;
  short         inc = 1;

  if (gname.left == -1)
    ptiol = pat_addpaiol (ptiol,gname.ident,format,mode,blank);
  else
    {
    if (gname.left >= gname.right)
      inc = -1;

    for (i=gname.left ; i!=(gname.right+inc) ; i+=inc)
      {
      sprintf (extname,"%s %d",gname.ident,i);
      ptiol = pat_addpaiol (ptiol,extname,format,mode,blank);
      }
    }

  return (ptiol);
  }

/* ###--------------------------------------------------------------### */
/* function	: addini						*/
/* description	: add a list of PAINI structure at the top of the list	*/
/* called func.	: pat_addpaini						*/
/* ###--------------------------------------------------------------### */

static struct paini *addini (lastini, gname, value)

struct paini *lastini;
struct array  gname;
char         *value;

  {
  struct paini *ptini = lastini;
  char         *frc;
  char         *cmp;
  int           length;
  int           size;
  int           index;
  int           i;
  int           inc;
  char          extname[100];
  char          format;

  if (gname.left < gname.right)
    {
    length = gname.right - gname.left + 1;
    inc    = 1;
    }
  else
    {
    length = gname.left - gname.right + 1;
    inc    = -1;
    }

  switch (value[0])
    {
    case 'X' :
    case 'x' :
      size = (strlen(value) - 3) * 4;
      format = 'X';
      index = 2;
      break;
    case 'O' :
    case 'o' :
      size = (strlen(value) - 3) * 3;
      format = 'O';
      index = 2;
      break;
    case 'B' :
    case 'b' :
      size = strlen(value) - 3;
      format = 'B';
      index = 2;
      break;
    case '"' :
      size = strlen(value) - 2;
      format = 'B';
      index = 1;
      break;
    case '\'' :
      size = 1;
      format = 'B';
      index = 1;
      break;
    }

  if (length != size)
    user_error (12,gname.ident,' ');
  else
    {
    if (gname.left == -1)
      ptini = pat_addpaini (ptini,gname.ident,value[index]);
    else
      {
      for (i=gname.left ; i!=(gname.right+inc) ;)
        {
        tobin  (value[index],&frc,&cmp);
        switch (format)
          {
          case 'X':
          case 'x':
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[0]);
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[1]);
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[2]);
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[3]);
            break;
          case 'O':
          case 'o':
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[1]);
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[2]);
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[3]);
            break;
          case 'B':
          case 'b':
            sprintf (extname,"%s %d",gname.ident,i);
            i += inc;
            ptini = pat_addpaini (ptini,extname,frc[3]);
            break;
          }
        index++;
        }
      }
    }
  return (ptini);
  }

static tobin (value,str1,str2)

char  value;
char **str1;
char **str2;

  {

  switch (value)
    {
    case '*':
      *str1 = "****"; *str2 = "****"; break;
    case '-':
    case '0':
      *str1 = "0000"; *str2 = "----"; break;
    case '+':
    case '1':
      *str1 = "0001"; *str2 = "---+"; break;
    case '2':
      *str1 = "0010"; *str2 = "--+-"; break;
    case '3':
      *str1 = "0011"; *str2 = "--++"; break;
    case '4':
      *str1 = "0100"; *str2 = "-+--"; break;
    case '5':
      *str1 = "0101"; *str2 = "-+-+"; break;
    case '6':
      *str1 = "0110"; *str2 = "-++-"; break;
    case '7':
      *str1 = "0111"; *str2 = "-+++"; break;
    case '8':
      *str1 = "1000"; *str2 = "+---"; break;
    case '9':
      *str1 = "1001"; *str2 = "+--+"; break;
    case 'A':
    case 'a':
      *str1 = "1010"; *str2 = "+-+-"; break;
    case 'B':
    case 'b':
      *str1 = "1011"; *str2 = "+-++"; break;
    case 'C':
    case 'c':
      *str1 = "1100"; *str2 = "++--"; break;
    case 'D':
    case 'd':
      *str1 = "1101"; *str2 = "++-+"; break;
    case 'E':
    case 'e':
      *str1 = "1110"; *str2 = "+++-"; break;
    case 'F':
    case 'f':
      *str1 = "1111"; *str2 = "++++"; break;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: isevent						*/
/* description	: detect an event on an input-output and add if needed	*/
/*		  a PAEVT structure at the top of the list		*/
/* called func.	: tobin, pat_addpaevt					*/
/* ###--------------------------------------------------------------### */

static struct paevt *isevent (lastevt,index,compare,value,rank)

struct paevt *lastevt;
short         index;
char          compare;
char          value;
int           rank;

  {
  struct paiol *ptiol;
  int           check;
  int           i;
  char          cmp_val;
  char          frc_val;
  char         *frc;
  char         *cmp;

  ptiol = PAT_SEQPNT->PAIOL + index;
  if ((value == '*') || (value == '-') || (value == '+'))
    compare = 'C';

  tobin (value,&frc,&cmp);
  switch (ptiol->MODE)
    {
    case 'I':
      for (i=rank ; i<4 ; i++)
        {
        frc_val = frc[i];
        if (ptiol->VALUE != frc_val)
          {
          lastevt = pat_addpaevt (lastevt, index, frc_val); 
          ptiol->VALUE  = frc_val;
          }
        index++;
        ptiol++;
        }
      break;
    case 'O':
    case 'S':
    case 'R':
      for (i=rank ; i<4 ; i++)
        {
        cmp_val = cmp[i];
        if ((ptiol->VALUE != cmp_val) || (cmp_val == '*'))
          {
          lastevt = pat_addpaevt (lastevt, index, cmp_val); 
          ptiol->VALUE  = cmp_val;
          }
        index++;
        ptiol++;
        }
      break;
    case 'T':
      if (compare == 'F')
        {
        for (i=rank ; i<4 ; i++)
          {
          frc_val = frc[i];
          if (ptiol->VALUE != frc_val)
            {
            lastevt = pat_addpaevt (lastevt, index, frc_val); 
            ptiol->VALUE  = frc_val;
            }
          index++;
          ptiol++;
          }
        }
      else
        {
        for (i=rank ; i<4 ; i++)
          {
          cmp_val = cmp[i];
          if ((ptiol->VALUE != cmp_val) || (cmp_val == '*'))
            {
            lastevt = pat_addpaevt (lastevt, index, cmp_val); 
            ptiol->VALUE  = cmp_val;
            }
          index++;
          ptiol++;
          }
        }
      break;
    }
  return (lastevt);
  }

static void pshtab (gname)

struct array gname;

  {
  if (tab_idx > 30)
    user_error (6,NULL,' ');
  else
    {
    tab [tab_idx] = gname;
    tab_idx++;
    }
  }

static void pshnam (str)

char *str;

  {
  if (nam_idx > 30)
    user_error (14,NULL,' ');
  else
    {
    namtab [nam_idx] = str;
    nam_idx++;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: initab						*/
/* description	: create a new dictionnary				*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

static struct entry **initab ()

  {
  struct entry **head;
  int            i;

  head = (struct entry **) mbkalloc (sizeof(struct entry *) * PAT_HSZDFN);

  for (i=0 ; i<PAT_HSZDFN ; i++)
    head[i] = NULL;

  return (head);
  }

/* ###--------------------------------------------------------------### */
/* function	: addent						*/
/* description	: add a new entry in a dictionnary			*/
/* called func.	: mbkaloc						*/
/* ###--------------------------------------------------------------### */

static struct entry *addent (head, key)

struct entry *head;
char         *key;

  {
  struct entry *entry;
  int           i;

  if (entry_head == NULL)
    {
    entry_head = (struct entry *) mbkalloc (sizeof(struct entry) * PAT_ALODFN);

    entry = entry_head;
    for (i=1 ; i<PAT_ALODFN ; i++)
      {
      entry->next = entry + 1;
      entry++;
      }
    entry->next = NULL;
    }

  entry       = entry_head;
  entry_head  = entry_head->next;

  entry->next = head;
  entry->data = NULL;
  entry->key  = key;

  return (entry);
  }

/* ###--------------------------------------------------------------### */
/* function	: addrcd						*/
/* description	: add a new record in a dictionnary			*/
/* called func.	: mbkaloc						*/
/* ###--------------------------------------------------------------### */

static struct recrd *addrcd (head, key)

struct recrd *head;
char         *key;

  {
  struct recrd *recrd;
  int           i;

  if (recrd_head == NULL)
    {
    recrd_head = (struct recrd *) mbkalloc (sizeof(struct recrd) * PAT_ALODFN);

    recrd = recrd_head;
    for (i=1 ; i<PAT_ALODFN ; i++)
      {
      recrd->next = recrd + 1;
      recrd++;
      }
    recrd->next = NULL;
    }

  recrd          = recrd_head;
  recrd_head     = recrd_head->next;

  recrd->next     = head;
  recrd->fd0_val  = 0;
  recrd->fd1_val  = 0;
  recrd->pt0_val  = 0;
  recrd->pt1_val  = 0;
  recrd->key      = key;

  return (recrd);
  }

/* ###--------------------------------------------------------------### */
/* function	: addtab						*/
/* description	: add a new information into a dictionnary. If the	*/
/*		  key or the context doesn't exist create a new record	*/
/* called func.	: addrcd, addent					*/
/* ###--------------------------------------------------------------### */

static void addtab (head, key_str, ctx_str, field, valu)

struct entry **head;
char          *key_str;
char          *ctx_str;
int            field;
int            valu;

  {
  int           found = 0;
  int           index;
  struct entry *entry_pnt;
  struct recrd *recrd_pnt;

  index     = (int) key_str % PAT_HSZDFN;
  entry_pnt = head[index];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 0)
    {
    head[index] = addent (head[index],key_str);
    entry_pnt   = head[index];
    }

  found = 0;
  recrd_pnt = entry_pnt->data;
  while (recrd_pnt != NULL)
    {
    if (recrd_pnt->key == ctx_str)
      {
      found = 1;
      break;
      }
    recrd_pnt = recrd_pnt->next;
    }

  if (found == 0)
    {
    entry_pnt->data = addrcd (entry_pnt->data, ctx_str);
    recrd_pnt       = entry_pnt->data ;
    }

  switch (field)
    {
    case 0 :
      recrd_pnt->fd0_val = valu;
      break;
    case 1 :
      recrd_pnt->fd1_val = valu;
      break;
    case 6 :
      recrd_pnt->pt0_val = valu;
      break;
    case 7 :
      recrd_pnt->pt1_val = valu;
      break;
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: chktab						*/
/* description	: extract an information from a dictionnary. Return	*/
/*		  0 if the information has not been found.		*/
/* called func.	: none							*/
/* ###--------------------------------------------------------------### */

static int chktab (head, key_str, ctx_str, field)

struct entry **head;
char          *key_str;
char          *ctx_str;
int            field;

  {
  int           found = 0;
  int           valu = 0;
  struct entry *entry_pnt;
  struct recrd *recrd_pnt;

  entry_pnt = head [(int)key_str % PAT_HSZDFN];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 1)
    {
    found     = 0;
    recrd_pnt = entry_pnt->data;
    while (recrd_pnt != NULL)
      {
      if (recrd_pnt->key == ctx_str)
        {
        found = 1;
        break;
        }
      recrd_pnt = recrd_pnt->next;
      }
    if (found == 1)
      {
      switch (field)
        {
        case 0 :
          valu = recrd_pnt->fd0_val;
          break;
        case 1 :
          valu = recrd_pnt->fd1_val;
          break;
        case 6 :
          valu = recrd_pnt->pt0_val;
          break;
        case 7 :
          valu = recrd_pnt->pt1_val;
          break;
        }
      }
    }
  return (valu);
  }

/* ###--------------------------------------------------------------### */
/* function	: fretab						*/
/* description	: remove entirely a dictionnary				*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

static void fretab (pt_hash)

struct entry **pt_hash;
  {
  struct entry *pt_entry;
  struct entry *pt_nxtentry;
  struct recrd *pt_record;
  int           i;

  if (pt_hash != NULL)
    {
    for (i=0 ; i<PAT_HSZDFN ; i++)
      {
      if ((pt_entry = pt_hash[i]) != NULL)
        {
        while (pt_entry != NULL)
          {
          pt_record = pt_entry->data;

          while (pt_record->next != NULL)
            pt_record = pt_record->next;

          pt_record->next = recrd_head;
          recrd_head      = pt_entry->data;

          pt_nxtentry     = pt_entry->next;
          pt_entry->next  = entry_head;
          entry_head      = pt_entry;
          pt_entry        = pt_nxtentry;
          }
        }
      }
    mbkfree (pt_hash);
    }
  }

static void islegal (index, comp, value, flag, status)

int  index;				/* ptiol's index		*/
char comp;				/* '?' presence (C,F)		*/
char value;				/* value (+,-,*,0,...,9,a,...,f)*/
char flag;				/* comparison flag (C,F)	*/
int  status;				/* (0,1,2) (bit,array,inside)	*/

  {
  int           code;
  struct paiol *ptiol;

	/* ###------------------------------------------------------### */
	/*   Giving a code to each group of values			*/
	/* ###------------------------------------------------------### */

  switch (value)
    {
    case '*':
      code = 0; flag = 'C'; break;
    case '0':
    case '1':
      code = 1; break;
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
      code = 2; break;
    case '8':
    case '9':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
      code = 3; break;
    case '+':
    case '-':
      code = 4; flag = 'C'; break;
    }

	/* ###------------------------------------------------------### */
	/*   Checking parameters' consistency :				*/
	/*     a '?' inside the value of an array	-> error	*/
	/*     '+' or '-' preceded by a '?'		-> error	*/
	/*     '+' or '-' for an array			-> error	*/
	/* ###------------------------------------------------------### */

  if ((status == 2) && (comp == 'C'))
    user_error (2,NULL,'?');

  if ((code == 4) && (comp == 'C'))
    user_error (2,NULL,'?');

  if ((code == 4) && (status != 0))
    user_error (2,NULL,value);

	/* ###------------------------------------------------------### */
	/*   Checking coherence of value and input-output format :	*/
	/*     2,...,9,a,...,f and binary format	-> error	*/
	/*     a,...,f,+,-     and octal  format	-> error	*/
	/*     +,-             and hexa.  format	-> error	*/
	/* ###------------------------------------------------------### */

  ptiol = PAT_SEQPNT->PAIOL + index;
  switch (ptiol->FORMAT)
    {
    case 'b' :
    case 'B' :
      if ((code == 2) || (code == 3))
        user_error (10,ptiol->NAME,'B');
      break;
    case 'o' :
    case 'O' :
      if (code >= 3)
        user_error (10,ptiol->NAME,'O');
      break;
    case 'x' :
    case 'X' :
      if (code == 4)
        user_error (10,ptiol->NAME,'X');
      break;
    }

	/* ###------------------------------------------------------### */
	/*   Checking coherence of value and input-output mode		*/
	/*     compare a value on an input		-> error	*/
	/*     put an undefined value on an input	-> error	*/
	/*     force a value on an output		-> error	*/
	/* ###------------------------------------------------------### */

  switch (ptiol->MODE)
    {
    case 'I' :
      if ((flag == 'C') || (code == 4) || (code == 0))
        user_error (5,ptiol->NAME,' ');
      break;
    case 'O' :
    case 'R' :
    case 'S' :
      if (flag != 'C')
        user_error (4,ptiol->NAME,' ');
      break;
    }
  }
short pat_yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 48,
	265, 54,
	-2, 33,
	};
# define pat_YYNPROD 59
# define pat_YYLAST 131
short pat_yyact[]={

   8,  15,  17,  79,  16,  58,  28,  61,  28,  83,
  79,  12,  87,  68,  55,  37,  24,  45,  57,  39,
  19,  32,  24,  18,  67,  70,  49,  59,  12,  73,
  24,  36,  40,  48,  49,  38,  25,  54,  71,  39,
  31,  51,  50,  77,  14,   7,  42,  35,  47,  46,
  27,  23,   5,  76,  65,  33,  56,  26,  29,  52,
  10,   9,  11,  43,  62,  30,   6,   4,  72,  60,
  41,  34,   3,   2,   1,  78,  13,  22,  21,  20,
  44,   0,  53,   0,   0,   0,   0,  63,   0,   0,
   0,   0,  66,   0,   0,  64,   0,   0,   0,   0,
   0,   0,   0,  74,  69,   0,   0,   0,  44,  75,
   0,  82,   0,  81,  84,  80,   0,   0,  85,   0,
  86,   0,   0,  88,   0,   0,   0,   0,   0,   0,
  66 };
short pat_yypact[]={

-1000,-1000,-256,-227,-256,-1000,-1000,-1000,-274,-1000,
-1000,-1000,-1000,-250,-219,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-252,-1000,-1000,-1000,-1000,-1000,-240,
-258,-229,-222,-237,-239,-274,-1000,-242,-225,-263,
-245,-271,-1000,-1000,-1000,-274,-231,-1000,-1000,-1000,
-274,-1000,-253,-1000,-247,-1000,-223,-1000,-1000,-1000,
-241,-274,-239,-1000,-1000,-265,-1000,-240,-250,-274,
-1000,-268,-274,-1000,-1000,-1000,-272,-1000,-262,-1000,
-274,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-274 };
short pat_yypgo[]={

   0,  44,  79,  78,  77,  42,  47,  76,  49,  75,
  51,  74,  73,  72,  71,  70,  69,  68,  41,  67,
  52,  66,  45,  46,  64,  63,  62,  61,  60,  59,
  56,  55,  48,  54,  53,  43 };
short pat_yyr1[]={

   0,  12,  14,  11,  13,  19,  19,  20,  20,  20,
  15,  24,  24,  23,  23,  23,  22,  22,  21,  21,
  27,  28,   6,   6,  29,  29,   1,   1,   1,   2,
   3,   4,  10,  31,  31,  30,  30,   7,   7,   7,
   7,   7,  26,  16,  16,  25,  25,  33,  32,  34,
  34,  35,   9,   9,   8,  17,   5,   5,  18 };
short pat_yyr2[]={

   0,   0,   0,   8,   1,   1,   2,   1,   1,   2,
   2,   0,   2,   1,   1,   2,   1,   1,   1,   1,
   4,   7,   0,   1,   1,   3,   1,   1,   1,   1,
   4,   6,   2,   0,   3,   1,   1,   1,   1,   1,
   1,   1,   6,   0,   2,   2,   1,   0,   4,   1,
   2,   2,   0,   1,   1,   1,   1,   2,   1 };
short pat_yychk[]={

-1000, -11, -12, -13, -19, -20, -21, -22, 256, -27,
 -28, -26, 267,  -7,  -1, 257, 260, 258, 279, 276,
  -2,  -3,  -4, -10, 272, 263, -20, -18, 280,  -1,
 -10, 259, 273, -31, -14,  -6, 271, 273, 264, 261,
 269, -15, -23, -25, -22, 256,  -8, -32, 272, 265,
  -5, -18, -29,  -1, 262, 277, -30, 281, 268, 272,
 -16, 278, -24, -18, -32, -33, -18, 277, 266,  -8,
 272, 261, -17, 270, -18, -23, -34, -35,  -9, 275,
  -6,  -1, -18, 277, -18, -18, -35, 274,  -5 };
short pat_yydef[]={

   1,  -2,   0,   0,   4,   5,   7,   8,   0,  18,
  19,  16,  17,   0,   0,  37,  38,  39,  40,  41,
  26,  27,  28,  29,  33,   2,   6,   9,  58,  22,
  29,   0,   0,  32,   0,   0,  23,   0,   0,   0,
   0,  43,  11,  13,  14,   0,   0,  46,  -2,  47,
  20,  56,   0,  24,   0,  30,   0,  35,  36,  34,
   0,   0,  10,  15,  45,  52,  57,  22,   0,   0,
  54,   0,   0,  55,  44,  12,  52,  49,   0,  53,
   0,  25,  42,  31,   3,  48,  50,  51,  21 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define pat_YYFLAG -1000
# define pat_YYERROR goto pat_yyerrlab
# define pat_YYACCEPT return(0)
# define pat_YYABORT return(1)

/*	parser for yacc output	*/

#ifdef pat_YYDEBUG
int pat_yydebug = 0; /* 1 for debugging */
#endif
pat_YYSTYPE pat_yyv[pat_YYMAXDEPTH]; /* where the values are stored */
int pat_yychar = -1; /* current input token number */
int pat_yynerrs = 0;  /* number of errors */
short pat_yyerrflag = 0;  /* error recovery flag */

pat_yyparse() {

	short pat_yys[pat_YYMAXDEPTH];
	short pat_yyj, pat_yym;
	register pat_YYSTYPE *pat_yypvt;
	register short pat_yystate, *pat_yyps, pat_yyn;
	register pat_YYSTYPE *pat_yypv;
	register short *pat_yyxi;

	pat_yystate = 0;
	pat_yychar = -1;
	pat_yynerrs = 0;
	pat_yyerrflag = 0;
	pat_yyps= &pat_yys[-1];
	pat_yypv= &pat_yyv[-1];

 pat_yystack:    /* put a state and value onto the stack */

#ifdef pat_YYDEBUG
	if( pat_yydebug  ) printf( "state %d, char 0%o\n", pat_yystate, pat_yychar );
#endif
		if( ++pat_yyps> &pat_yys[pat_YYMAXDEPTH] ) { pat_yyerror( "yacc stack overflow" ); return(1); }
		*pat_yyps = pat_yystate;
		++pat_yypv;
		*pat_yypv = pat_yyval;

 pat_yynewstate:

	pat_yyn = pat_yypact[pat_yystate];

	if( pat_yyn<= pat_YYFLAG ) goto pat_yydefault; /* simple state */

	if( pat_yychar<0 ) if( (pat_yychar=pat_yylex())<0 ) pat_yychar=0;
	if( (pat_yyn += pat_yychar)<0 || pat_yyn >= pat_YYLAST ) goto pat_yydefault;

	if( pat_yychk[ pat_yyn=pat_yyact[ pat_yyn ] ] == pat_yychar ){ /* valid shift */
		pat_yychar = -1;
		pat_yyval = pat_yylval;
		pat_yystate = pat_yyn;
		if( pat_yyerrflag > 0 ) --pat_yyerrflag;
		goto pat_yystack;
		}

 pat_yydefault:
	/* default state action */

	if( (pat_yyn=pat_yydef[pat_yystate]) == -2 ) {
		if( pat_yychar<0 ) if( (pat_yychar=pat_yylex())<0 ) pat_yychar = 0;
		/* look through exception table */

		for( pat_yyxi=pat_yyexca; (*pat_yyxi!= (-1)) || (pat_yyxi[1]!=pat_yystate) ; pat_yyxi += 2 ) ; /* VOID */

		while( *(pat_yyxi+=2) >= 0 ){
			if( *pat_yyxi == pat_yychar ) break;
			}
		if( (pat_yyn = pat_yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( pat_yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( pat_yyerrflag ){

		case 0:   /* brand new error */

			pat_yyerror( "syntax error" );
		pat_yyerrlab:
			++pat_yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			pat_yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( pat_yyps >= pat_yys ) {
			   pat_yyn = pat_yypact[*pat_yyps] + pat_YYERRCODE;
			   if( pat_yyn>= 0 && pat_yyn < pat_YYLAST && pat_yychk[pat_yyact[pat_yyn]] == pat_YYERRCODE ){
			      pat_yystate = pat_yyact[pat_yyn];  /* simulate a shift of "error" */
			      goto pat_yystack;
			      }
			   pat_yyn = pat_yypact[*pat_yyps];

			   /* the current pat_yyps has no shift onn "error", pop stack */

#ifdef pat_YYDEBUG
			   if( pat_yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *pat_yyps, pat_yyps[-1] );
#endif
			   --pat_yyps;
			   --pat_yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	pat_yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef pat_YYDEBUG
			if( pat_yydebug ) printf( "error recovery discards char %d\n", pat_yychar );
#endif

			if( pat_yychar == 0 ) goto pat_yyabort; /* don't discard EOF, quit */
			pat_yychar = -1;
			goto pat_yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production pat_yyn */

#ifdef pat_YYDEBUG
		if( pat_yydebug ) printf("reduce %d\n",pat_yyn);
#endif
		pat_yyps -= pat_yyr2[pat_yyn];
		pat_yypvt = pat_yypv;
		pat_yypv -= pat_yyr2[pat_yyn];
		pat_yyval = pat_yypv[1];
		pat_yym=pat_yyn;
			/* consult goto table to find next state */
		pat_yyn = pat_yyr1[pat_yyn];
		pat_yyj = pat_yypgo[pat_yyn] + *pat_yyps + 1;
		if( pat_yyj>=pat_YYLAST || pat_yychk[ pat_yystate = pat_yyact[pat_yyj] ] != -pat_yyn ) pat_yystate = pat_yyact[pat_yypgo[pat_yyn]];
		switch(pat_yym){
			
case 1:
# line 97 "pat_prspat.yac"
{
		/* ###----------------------------------------------### */
		/*    initialize a dictionnary				*/
		/* ###----------------------------------------------### */

		hshtab = initab ();
		} break;
case 2:
# line 106 "pat_prspat.yac"
{
		PAT_SEQPNT        = pat_addpaseq (NULL);

		PAT_SEQPNT->PAGRP = (struct pagrp *) reverse (grp_pnt);
		iol_pnt           = (struct paiol *) reverse (iol_pnt);
		PAT_SEQPNT->PAIOL = pat_crtpaiol (iol_pnt);
		pat_frepaiol (iol_pnt);
		stt_nbr++;
		} break;
case 3:
# line 119 "pat_prspat.yac"
{
		PAT_SEQPNT->PACOM  = (struct pacom *) reverse (com_pnt);
		PAT_SEQPNT->PAPAT  = (struct papat *) reverse (pat_pnt);
		PAT_SEQPNT->ERRFLG = err_flg;
		PAT_SEQPNT->ENDFLG = 'Y';
		PAT_SEQPNT->IOLNBR = dcl_nbr;
		PAT_SEQPNT->SUBSEQ++;
		} break;
case 17:
# line 167 "pat_prspat.yac"
{
		com_pnt = pat_addpacom (com_pnt, pat_yypvt[-0].text, stt_nbr);
		stt_nbr = 0;
		} break;
case 20:
# line 183 "pat_prspat.yac"
{
		int length;
		int lclmod;
		char name[100];

		if ((lclmod = chktab (hshtab,pat_yypvt[-2].arra.ident,NULL,PAT_MODDFN)) != 0)
		  {
		  if (lclmod == 'I')
		    user_error (13,pat_yypvt[-2].arra.ident,' ');
		  if (lclmod != pat_yypvt[-3].immd)
		    user_error (7,pat_yypvt[-2].arra.ident,' ');
		  }
		else
		  addtab (hshtab,pat_yypvt[-2].arra.ident,NULL,PAT_MODDFN,pat_yypvt[-3].immd);

		if (pat_yypvt[-2].arra.left < pat_yypvt[-2].arra.right)
		  length = pat_yypvt[-2].arra.right - pat_yypvt[-2].arra.left + 1;
		else
		  length = pat_yypvt[-2].arra.left - pat_yypvt[-2].arra.right + 1;

		stt_nbr++;
		iol_pnt = addiol (iol_pnt, pat_yypvt[-2].arra, pat_yypvt[-1].immd, pat_yypvt[-3].immd, pat_yypvt[-0].valu);

		if (length != 1)
		  grp_pnt = pat_addpagrp (grp_pnt,pat_yypvt[-2].arra.ident,length,dcl_nbr,0);
		else
		  {
		  if (pat_yypvt[-1].immd != 'B')
		    user_error (1,NULL,' ');
		  }

		dcl_nbr += length;
		} break;
case 21:
# line 226 "pat_prspat.yac"
{
		int i;
		int lclmod;
		int length = 0;

		if (chktab (hshtab,pat_yypvt[-5].text,NULL,PAT_MODDFN) != 0)
		  user_error (8,pat_yypvt[-5].text,' ');
		else
		  addtab (hshtab,pat_yypvt[-5].text,NULL,PAT_MODDFN,pat_yypvt[-6].immd);

		stt_nbr++;

		for (i=0 ; i<tab_idx ; i++)
                  {
		  if ((lclmod=chktab(hshtab,tab[i].ident,NULL,PAT_MODDFN)) != 0)
		    {
		    if (lclmod != pat_yypvt[-6].immd)
		      user_error (7,tab[i].ident,' ');
		    }
		  else
		    addtab (hshtab,tab[i].ident,NULL,PAT_MODDFN,pat_yypvt[-6].immd);

		  iol_pnt = addiol (iol_pnt, tab[i], pat_yypvt[-1].immd, pat_yypvt[-6].immd, pat_yypvt[-0].valu);
		  if (tab[i].left < tab[i].right)
		    length += tab[i].right - tab[i].left + 1;
		  else
		    length += tab[i].left - tab[i].right + 1;
                  }

		grp_pnt  = pat_addpagrp (grp_pnt, pat_yypvt[-5].text, length, dcl_nbr, 1);
		tab_idx  = 0;
		dcl_nbr += length;
		} break;
case 22:
# line 263 "pat_prspat.yac"
{ pat_yyval.immd = 'B'; } break;
case 23:
# line 265 "pat_prspat.yac"
{ pat_yyval.immd = pat_yypvt[-0].immd; } break;
case 24:
# line 270 "pat_prspat.yac"
{ pshtab (pat_yypvt[-0].arra); } break;
case 25:
# line 274 "pat_prspat.yac"
{ pshtab (pat_yypvt[-0].arra); } break;
case 26:
# line 279 "pat_prspat.yac"
{ pat_yyval.arra = pat_yypvt[-0].arra; } break;
case 27:
# line 281 "pat_prspat.yac"
{ pat_yyval.arra = pat_yypvt[-0].arra; } break;
case 28:
# line 283 "pat_prspat.yac"
{ pat_yyval.arra = pat_yypvt[-0].arra; } break;
case 29:
# line 288 "pat_prspat.yac"
{
		pat_yyval.arra.ident = pat_yypvt[-0].text;
		pat_yyval.arra.left  = -1;
		pat_yyval.arra.right = -1;
		} break;
case 30:
# line 300 "pat_prspat.yac"
{
		pat_yyval.arra.ident = pat_yypvt[-3].text;
		pat_yyval.arra.left  = pat_yypvt[-1].valu;
		pat_yyval.arra.right = pat_yypvt[-1].valu;
		} break;
case 31:
# line 314 "pat_prspat.yac"
{
		pat_yyval.arra.ident = pat_yypvt[-5].text;
		pat_yyval.arra.left  = pat_yypvt[-3].valu;
		pat_yyval.arra.right = pat_yypvt[-1].valu;
		} break;
case 32:
# line 324 "pat_prspat.yac"
{
		char name[256];
		int  i;

		strcpy (name,pat_yypvt[-1].text);
		for (i=0; i<nam_idx ; i++)
		 {
		 strcat (name,".");
		 strcat (name,namtab[i]);
		 }
		nam_idx = 0;
		pat_yyval.text = namealloc (name);
		} break;
case 34:
# line 344 "pat_prspat.yac"
{ pshnam (pat_yypvt[-0].text); } break;
case 37:
# line 354 "pat_prspat.yac"
{ pat_yyval.immd = 'I'; } break;
case 38:
# line 356 "pat_prspat.yac"
{ pat_yyval.immd = 'O'; } break;
case 39:
# line 358 "pat_prspat.yac"
{ pat_yyval.immd = 'T'; } break;
case 40:
# line 360 "pat_prspat.yac"
{ pat_yyval.immd = 'S'; } break;
case 41:
# line 362 "pat_prspat.yac"
{ pat_yyval.immd = 'R'; } break;
case 42:
# line 372 "pat_prspat.yac"
{
		struct papat *lcl_pat;
		struct paini *lcl_ini;

		if ((lcl_pat = (struct papat *)
		               chktab (hshtab,pat_yypvt[-1].text,NULL,PAT_PATDFN)) != NULL)
		  lcl_pat->PAINI = addini (lcl_pat->PAINI,pat_yypvt[-5].arra,buff);
		else
		  {
		  lbl_lst = addchain (lbl_lst,pat_yypvt[-3].valu);
		  lcl_ini = (struct paini *)chktab (hshtab,pat_yypvt[-1].text,NULL,PAT_INIDFN);
		  lcl_ini = addini (lcl_ini,pat_yypvt[-5].arra,buff);

		  addtab (hshtab,pat_yypvt[-1].text,NULL,PAT_INIDFN,(int)lcl_ini);
		  }
		} break;
case 44:
# line 394 "pat_prspat.yac"
{
		PAT_SEQPNT->SAVFLG = 'Y';
		} break;
case 45:
# line 402 "pat_prspat.yac"
{
		char flag;
		struct paini *lcl_ini;

		if (chktab (hshtab,pat_yypvt[-1].text,NULL,PAT_PATDFN) != 0)
		  user_error (9,pat_yypvt[-1].text,' ');
		else
		  addtab (hshtab,pat_yypvt[-1].text,NULL,PAT_PATDFN,(int)pat_pnt);

		if ((flag = chktab (hshtab,pat_yypvt[-1].text,NULL,PAT_FLGDFN)) != 0)
		  {
		  if (pat_pnt->ACTFLAG != 'U')
		    user_error (11,pat_pnt->LABEL,' ');
		  else
		    pat_pnt->ACTFLAG = flag;
		  }

		if ((lcl_ini = (struct paini *)
                               chktab (hshtab,pat_yypvt[-1].text,NULL,PAT_INIDFN)) != NULL)
		  {
		  if (pat_pnt->ACTFLAG != 'U')
		    user_error (11,pat_pnt->LABEL,' ');
		  else
		    {
		    pat_pnt->ACTFLAG = 'I';
		    pat_pnt->PAINI   = lcl_ini;
		    }
		  }

		pat_pnt->LABEL   = pat_yypvt[-1].text;
		} break;
case 47:
# line 438 "pat_prspat.yac"
{
		pat_pnt = pat_addpapat (pat_pnt, NULL, linnum);
		cur_grp = PAT_SEQPNT->PAGRP;
		cur_idx = 0;
		cmp_flg = 'F';
		end_flg = 'Y';
		} break;
case 48:
# line 447 "pat_prspat.yac"
{
		if (cur_idx != dcl_nbr)
		  user_error (15,NULL,' ');
		pat_pnt->PAEVT = evt_pnt;
		evt_pnt = NULL;
		stt_nbr++;
		} break;
case 51:
# line 465 "pat_prspat.yac"
{
		if (cur_idx > dcl_nbr)
		  user_error (3,NULL,' ');
		else
		  {
		  if ((cur_grp != NULL) &&
		      (cur_idx == (cur_grp->LENGTH + cur_grp->FINDEX)))
		    {
		/* ###----------------------------------------------### */
		/*    End of array reached. Update current group pnt.	*/
		/* ###----------------------------------------------### */

		    cur_grp = cur_grp->NEXT;
		    end_flg = 'Y';
		    }

		  if (end_flg == 'N')
		    {
		/* ###----------------------------------------------### */
		/*    Continuing inside an array			*/
		/* ###----------------------------------------------### */

		    islegal (cur_idx, pat_yypvt[-1].immd, pat_yypvt[-0].immd, cmp_flg, 2);
		    switch ((PAT_SEQPNT->PAIOL + cur_idx)->FORMAT)
		      {
		      case 'X':
		        evt_pnt  = isevent (evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,0);
		        cur_idx += 4;
		        break;
		      case 'O':
		        evt_pnt  = isevent (evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,1);
		        cur_idx += 3;
		        break;
		      case 'B':
		        evt_pnt = isevent (evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,3);
		        cur_idx++;
		        break;
		      }
		    }
		  else
		    {
		/* ###----------------------------------------------### */
		/*    Begining a new array or a new single bit		*/
		/* ###----------------------------------------------### */

		    cmp_flg = pat_yypvt[-1].immd;

		    if ((cur_grp != NULL) && (cur_idx == cur_grp->FINDEX))
		      {
		/* ###----------------------------------------------### */
		/*    Begining a new array				*/
		/* ###----------------------------------------------### */

		      islegal (cur_idx, pat_yypvt[-1].immd, pat_yypvt[-0].immd, cmp_flg, 1);
		      end_flg = 'N';
		      switch ((PAT_SEQPNT->PAIOL + cur_idx)->FORMAT)
		        {
		        case 'X':
		          switch (cur_grp->LENGTH % 4)
		            {
		            case 1:
		              evt_pnt = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,3);
		              cur_idx++;
		              break;
		            case 2:
		              evt_pnt  = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,2);
		              cur_idx += 2;
		              break;
		            case 3:
		              evt_pnt  = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,1);
		              cur_idx += 3;
		              break;
		            case 0:
		              evt_pnt  = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,0);
		              cur_idx += 4;
		              break;
		            }
		          break;
		        case 'O':
		          switch (cur_grp->LENGTH % 3)
		            {
		            case 1:
		              evt_pnt = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,3);
		              cur_idx++;
		              break;
		            case 2:
		              evt_pnt  = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,2);
		              cur_idx += 2;
		              break;
		            case 0:
		              evt_pnt  = isevent(evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,1);
		              cur_idx += 3;
		              break;
		            }
		          break;
		        case 'B':
		          evt_pnt = isevent (evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,3);
		          cur_idx++;
		          break;
		        }
		      }
		    else
		      {
		/* ###----------------------------------------------### */
		/*    Begining a new single bit				*/
		/* ###----------------------------------------------### */

		      islegal (cur_idx, pat_yypvt[-1].immd, pat_yypvt[-0].immd, cmp_flg, 0);
		      evt_pnt = isevent (evt_pnt,cur_idx,cmp_flg,pat_yypvt[-0].immd,3);
		      cur_idx++;
		      }
		    }
		  }
		} break;
case 52:
# line 583 "pat_prspat.yac"
{ pat_yyval.immd = 'F'; } break;
case 53:
# line 585 "pat_prspat.yac"
{ pat_yyval.immd = 'C'; } break;
case 54:
# line 590 "pat_prspat.yac"
{ pat_yyval.text = pat_yypvt[-0].text; } break;
case 55:
# line 595 "pat_prspat.yac"
{ pat_yyerrok; } break;
case 56:
# line 600 "pat_prspat.yac"
{ pat_yyval.valu = 0; } break;
case 57:
# line 603 "pat_prspat.yac"
{
		if (pat_yypvt[-1].valu < 15)
		  pat_yyval.valu = pat_yypvt[-1].valu + 1;
		else
		  pat_yyval.valu = 15;
		} break;
case 58:
# line 613 "pat_prspat.yac"
{ pat_yyerrok; } break; 
		}
		goto pat_yystack;  /* stack new state and value */

	}
