/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_crtpaiol.c					*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a PAT	*/
/*		  data structure					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include <pat103.h>

/* ###--------------------------------------------------------------### */
/* function	: pat_crtpaiol						*/
/* description	: create a table of PAIOL structures organized in a	*/
/*		  simply chained list. Then, copy the content of the	*/
/*		  old paiol list in the new table			*/
/* called func.	: mbkalloc						*/
/* ###--------------------------------------------------------------### */

struct paiol *pat_crtpaiol (paiollist)

struct paiol *paiollist;	/* list of PAIOLs to be put in a table	*/

  {
  struct paiol *ptiol = NULL;
  struct paiol *lcl_ptiol;
  int           size = 0;

  lcl_ptiol = paiollist;
  while (lcl_ptiol != NULL)
    {
    size++;
    lcl_ptiol = lcl_ptiol->NEXT;
    }

  if (size != 0)
    {
    ptiol     = (struct paiol *) mbkalloc (size * sizeof(struct paiol));
    lcl_ptiol = ptiol;

    while (paiollist != NULL)
      {
      lcl_ptiol->NAME   = paiollist->NAME;
      lcl_ptiol->FORMAT = paiollist->FORMAT;
      lcl_ptiol->MODE   = paiollist->MODE;
      lcl_ptiol->BLANK  = paiollist->BLANK;
      lcl_ptiol->VALUE  = paiollist->VALUE;
      lcl_ptiol->SIG    = paiollist->SIG;
      lcl_ptiol->NEXT   = lcl_ptiol + 1;

      paiollist         = paiollist->NEXT;
      lcl_ptiol++;
      }
    (lcl_ptiol - 1)->NEXT = NULL;

    }
  return (ptiol);
  }
