/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat.h							*/
/* date		: Sep  8 1992						*/
/* version	: v102							*/
/* description	: Contains defines and definition of PAT structures	*/
/*									*/
/* ###--------------------------------------------------------------### */

#ifndef PAT_DEFINE
#define PAT_DEFINE

	/* ###------------------------------------------------------### */
	/*    data structures						*/
	/* ###------------------------------------------------------### */

typedef struct paseq			/* complete sequence of patterns*/
  {
  struct paseq   *NEXT;			/* next sequence		*/
  struct pagrp   *PAGRP;		/* list of declared arraies	*/
  struct paiol   *PAIOL;		/* list of inputs-outputs	*/
  struct papat   *PAPAT;		/* list of patterns		*/
  struct pacom   *PACOM;		/* list of comments		*/
  unsigned short  IOLNBR;		/* number of paiol structures	*/
  unsigned short  SUBSEQ;		/* subsequence number		*/
  char            SAVFLG;		/* save flag ('Y' or 'N')	*/
  char            ENDFLG;		/* end flag ('Y' or 'N')	*/
  char            ERRFLG;		/* error flag			*/
  }
paseq_list;

typedef struct pagrp			/* actual or virtual array	*/
  {
  struct pagrp   *NEXT;			/* next array			*/
  char           *NAME;			/* array's name			*/
  unsigned short  LENGTH;		/* array's number of bit	*/
  unsigned short  FINDEX;		/* index of the first paiol	*/
  short           FLAG;			/* actual or virtual (0,1)	*/
  }
pagrp_list;

typedef struct paiol			/* input-output signal		*/
  {
  struct paiol *NEXT;			/* next input-output		*/
  char         *NAME;			/* input-output's name		*/
  char          FORMAT;			/* read-write format B,O,X	*/
  char          MODE;			/* mode I,B,O,Z,T,R,S,X,W,U	*/
  char          BLANK;			/* number of blank columns	*/
  char          VALUE;			/* input-output's current value	*/
  void         *SIG;			/* pointer on the signal	*/
  }
paiol_list;

typedef struct papat			/* pattern			*/
  {
  struct papat   *NEXT;			/* next pattern			*/
  char           *LABEL;		/* pattern's label		*/
  struct paini   *PAINI;		/* list of initializations	*/
  struct paevt   *PAEVT;		/* list of events		*/
  unsigned short  LINE;			/* pattern's line number	*/
  char            ACTFLAG;		/* action flag (U,I)		*/
  char            SIMFLAG;		/* simulation flag (U,S)	*/
  }
papat_list;

typedef struct paini			/* initialized register		*/
  {
  struct paini *NEXT;			/* next initialization		*/
  char         *NAME;			/* register's name		*/
  char          VALUE;			/* initialization's value	*/
  }
paini_list;

typedef struct paevt			/* event			*/
  {
  struct paevt   *NEXT;			/* next event			*/
  unsigned short  INDEX;		/* input-output's index		*/
  char            USRVAL;		/* value given by the user	*/
  char            SIMVAL;		/* caqlculated value		*/
  }
paevt_list;

typedef struct pacom			/* comment line			*/
  {
  struct pacom   *NEXT;			/* next comment			*/
  char           *TEXT;			/* text of the comment		*/
  unsigned short  POSITION;		/* nbr of decl. or pat. before	*/
  }
pacom_list;

	/* ###------------------------------------------------------### */
	/*    low-level functions					*/
	/* ###------------------------------------------------------### */

extern struct paseq *pat_addpaseq ();	/* add a paseq structure	*/
extern struct papat *pat_addpapat ();	/* add a papat structure	*/
extern struct paevt *pat_addpaevt ();	/* add a paevt structure	*/
extern struct paini *pat_addpaini ();	/* add a paini structure	*/
extern struct pacom *pat_addpacom ();	/* add a pacom structure	*/
extern struct pagrp *pat_addpagrp ();	/* add a pagrp structure	*/
extern struct paiol *pat_addpaiol ();	/* add a paiol structure	*/

extern struct paiol *pat_crtpaiol ();	/* create a table of paiols	*/

extern void          pat_frepaiol ();	/* delete a list of paiols	*/
extern void          pat_frepaini ();	/* delete a list of painis	*/
extern void          pat_frepaevt ();	/* delete a list of paevts	*/
extern void          pat_frepapat ();	/* delete a list of papats	*/
extern void          pat_frepacom ();	/* delete a list of pacoms	*/

	/* ###------------------------------------------------------### */
	/*    high-level functions					*/
	/* ###------------------------------------------------------### */

extern void          pat_debug ();	/* pat structure displayer	*/

	/* ###------------------------------------------------------### */
	/*    parser-driver functions					*/
	/* ###------------------------------------------------------### */

extern struct paseq *pat_prspat ();	/* pat format parser		*/
extern void          pat_drvpat ();	/* pat format driver		*/

#endif
