/* ###--------------------------------------------------------------### */
/*                                                                      */
/* file         : mvl_parse.c 	                                      */
/* date         : Nov  12 1991                                          */
/* author       : L.A TABUSSE & H.G. VUONG & P. BAZARGAN-SABET          */
/* description  : Parser VHDL --> MBK					*/
/* Called Func. : mbkalloc <mbk>, mvl_y_in <yacc>			*/
/*                                                                      */
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include <sys/types.h>
#include "../mvl_include.h"
#include "mvl_parse.h"
#include "../util/mvl_utdef.h"

void vhdlloadlofig(pt_lofig, figname, mode)

struct lofig *pt_lofig;
char *figname;
char mode;

  {
  char   filename[120];
  struct loins *pt_loins, *pt_loinsaux;
  struct locon *pt_locon, *pt_loconaux;
  struct losig *pt_losig, *pt_losigaux;

  /* Initialization of some variables */
  MVL_LINNUM = 1;
  strcpy(MVL_CURFIL,figname);
  /* FAST_MODE asked for MBK */
  FAST_MODE = 'Y';

  if ((mode != 'A') && (mode != 'P') && (mode != 'C'))
    {
    printf("vhdlloadfig : Bad mode '%c' asked\n", mode);
    EXIT(1);
    }

  /* Opening file */
  mvl_y_in = (FILE *) mbkfopen(figname, IN_LO, READ_TEXT);
  if((mvl_y_in == NULL) && (mode == 'P'))
    {
    strcpy(IN_LO, "vbe");
    mvl_y_in = (FILE *) mbkfopen(figname, IN_LO, READ_TEXT);
    }
  if(mvl_y_in == NULL)
    {
    (void)fprintf(stderr,"\n*** mbk error *** can't open file : %s.%s\n",
						figname, IN_LO);
    EXIT(1);
    }

  /* TRACE_MODE asked for MBK */
  if(TRACE_MODE == 'Y')
    {
    (void)printf("\n--- mbk --- parsing file : %s.%s in mode : %c\n",
                figname, IN_LO, mode);
    }

  MVL_LOFPNT = pt_lofig; /* passing main parameter */

  /* Parsing */
  if(mvl_y_parse() != 0)
    {
    (void)fprintf(stderr,"\n*** mbk error *** abnormal parsing for :  %s\n",filename);
    EXIT(1);
    }

  /* Closing file */
  if(fclose(mvl_y_in) != 0)
    {
    (void)fprintf(stderr,"\n*** mbk error *** can't close file :  %s\n",filename);
    EXIT(1);
    }

  if(strcmp(IN_LO,"vbe") == 0)
    {
    strcpy(IN_LO,"vst");
    return;
    }

 if (mode == 'P' )
   {
   pt_locon = MVL_LOFPNT->LOCON;
   while (pt_locon != NULL)
     {
     if (pt_locon->TYPE == 'I')
       {
       pt_loconaux = pt_locon;
       pt_locon = pt_locon->NEXT;
       dellocon(MVL_LOFPNT, pt_loconaux->NAME);
       }
     else
       {
       /* pt_locon->SIG = NULL; */
       pt_locon = pt_locon->NEXT;
       }
     }
   pt_losig = MVL_LOFPNT->LOSIG;
   while (pt_losig != NULL)  
     {
     if (pt_losig->TYPE == 'E') 
       {
       pt_losig = pt_losig->NEXT;
       continue;
       }
     pt_losigaux = pt_losig;
     pt_losig = pt_losig->NEXT;
     dellosig(MVL_LOFPNT, pt_losigaux->INDEX);
     }
   pt_loins = MVL_LOFPNT->LOINS;
   while (pt_loins != NULL)
     {
     pt_loinsaux = pt_loins;
     pt_loins = pt_loins->NEXT;
     delloins(MVL_LOFPNT, pt_loinsaux->INSNAME);
     }
   }
 }

