/************************************************************************/
/*                                                                      */
/*  universal format traducer (11/2/91)         version 3.0             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/*                                                                      */
/*  the format to traduce is take in the name of the command. The       */
/*  result of the compilation is x2y file. if you do a link between     */
/*  x2p and ap2cp, you make a traducer between ap and cp formats        */
/*  the Makefile know what is the licite command.                       */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/*                                                                      */
/*  Modif Nov 2, 1991 Franck                                            */
/*  There are three parameters : the file name to traduce               */
/*                               the format in and output               */
/*  All environnement is readen unix environnement except               */
/*  of course parsed and driven format files                            */
/*                                                                      */
/************************************************************************/

#include MUT_H
#include MLO_H
#include MPH_H

#ident "@(#)mbk traducter 3.0 11/2/91 Alliance"

/***********************************************************************
	CP		layout VTI
	HNS	 	netlist VTI
	FNE	 	extracted netlist VTI
	FDN	 	extracted netlist DAX
	HDN	 	extracted hierarchical netlist DAX

	AP	 	layout ALLIANCE
	AL	 	netlist ALLIANCE
	ALX	 	extracted netlist ALLIANCE

	EDI	 	netlist or layout EDIF

	CCT	 	structurel HILO
	VST	 	structurel VHDL 

	SPI	 	structurel SPICE 
***********************************************************************/

#define NONE		-1

#define LO		0	/* netlist */
#define PH		1	/* layout */

/*
* if something isn't normal
*/
void usage(argc, argv)
int	argc;
char	*argv[];
{
	printf("------------ %s traducer ----------------\n",argv[0]);
	printf("usage : %s format_in format_out file_in [file_out]\n", argv[0]);
	printf("        <file> to traduce\n");
	exit(1);
}

/*
 * return the type of the data format
 */
int type_format (ext)
char *ext;
{
	if (strcmp (ext, "cp") == 0)		return PH;
	if (strcmp (ext, "hns") == 0)		return LO;
	if (strcmp (ext, "fne") == 0)		return LO;
	if (strcmp (ext, "fdn") == 0)		return LO;
	if (strcmp (ext, "hdn") == 0)		return LO;

	if (strcmp (ext, "ap") == 0)		return PH;
	if (strcmp (ext, "al") == 0)		return LO;
	if (strcmp (ext, "alx") == 0)		return LO;

	if (strcmp (ext, "edi") == 0)		return LO;

	if (strcmp (ext, "cct") == 0)		return LO;
	if (strcmp (ext, "vst") == 0)		return LO;

	if (strcmp (ext, "spi") == 0)		return LO;
	return NONE;
}

/*
* Read the argument in line command	 
* set environnement
*/
get_arg (argc, argv, filename_in, filename_out)
int	argc;
char	*argv[];
char	**filename_in;
char	**filename_out;
{
	/**** test command line **** reading arguments ****/

	if (argc != 4 && argc != 5)
		usage (argc, argv);
	*filename_in = namealloc (argv[3]);

	if (argc == 4)
		*filename_out = namealloc (argv[3]); 
	else
		*filename_out = namealloc (argv[4]); 

	if( TRACE_MODE == 'Y' ) 
	  	printf ("filename_in %s, filename_out %s\n", 
			*filename_in, *filename_out); 

	strcpy( IN_LO, argv[1]);
	strcpy( IN_PH, argv[1]);
	strcpy( OUT_PH, argv[2]);
	strcpy( OUT_LO, argv[2]);

	if ( type_format( IN_LO) != type_format( OUT_LO )
	||   type_format( IN_LO) == NONE 
	||   type_format(OUT_LO) == NONE ) {
		printf("ERROR : forbiden traducing %s -> %s \n",
			IN_LO, OUT_LO);
		usage (argc, argv);
	}

	if( TRACE_MODE == 'Y' )
		printf ("format_in %s, format_out %s\n", IN_LO, OUT_LO);
}


main( argc, argv)
int	argc;
char	*argv[];
{
char		*filename_in;
char		*filename_out;
phfig_list  	*phfig;
lofig_list  	*lofig;

	/***** get argument and set environnement *****/

	mbkenv();

	get_arg( argc, argv, &filename_in, &filename_out);
	
	/***** loading the cell *****/

	if (type_format( IN_LO) == LO ) { /* IN_LO&IN_PH are identical here */
		lofig = GETLOFIG( filename_in, 'A');
	} else {
		phfig = GETPHFIG( filename_in, 'A');
	}

	/***** writing out the file *****/

	if (type_format( OUT_LO) == LO ) {/* OUT_LO&OUT_PH are identical here*/
		lofig->NAME=filename_out;
		SAVELOFIG( lofig);
	} else {
		phfig->NAME=filename_out;
		SAVEPHFIG( phfig);
	}

	return 0 ;
}
