#include MUT_H
#include MLO_H
#include MPH_H
#include <string.h>

#define TRUE	(1)
#define FALSE	(0)


char *Layer(i)
char i;
{
static   char  layer_l[TALU3 + 1][8] = {

             "NWELL",
             "PWELL",
             "NTIE",
             "PTIE",
             "NDIF",
             "PDIF",
             "NTRANS",
             "PTRANS",
             "POLY",
             "ALU1",
             "ALU2",
             "ALU3",
             "TPOLY",
             "TALU1" ,
             "TALU2",
             "TALU3"
             };
   return layer_l[i];
}

 
char *Via(i)
char i;
{
static   char  via_l[CONT_VIA2 + 1][20] = {
             "CONT_POLY",
             "CONT_VIA",
             "CONT_DIF_N",
             "CONT_DIF_P",
             "CONT_BODY_N",
             "CONT_BODY_P",
             "C_X_N",
             "C_X_P",
             "CONT_VIA2"
             };
   return via_l[i];
}


int isvirtual( ref )
char  *ref ;
{

char  *ref_a2r, *ref_a2rl, *ref_a2l, *ref_con ;

   ref_a2r  = namealloc( "ref_a2r"  ) ;
   ref_a2rl = namealloc( "ref_a2rl" ) ;
   ref_a2l  = namealloc( "ref_a2l"  ) ;
   ref_con  = namealloc( "ref_con"  ) ;

   return ref == ref_a2r || ref == ref_a2rl || ref == ref_a2l || ref == ref_con ;
}


main(argc, argv)
int argc ;
char *argv[] ;
{
 phfig_list  *phfig ;
 int  i, z, n, m, a, e, s, h, c, p, v, r ;


	if( argc < 2 )  {

		fprintf( stdout, "Usage : cleanup <cell> [z][n][m][a][s][h][c][p][v][r]\n" ) ;
		exit( -1 ) ;
  		}

	mbkenv() ;
	phfig = getphfig( argv[1], 'A' ) ;

	z = n = m = a = s = h = c = p = v = r = TRUE ;
   e = FALSE ;

	for( i = argc ; i > 2 ; i-- )   {   int  ind ;

		ind = i-1 ;

		if( strcmp( argv[ ind ], "z" ) == 0 )		z = FALSE ;
		else
		if( strcmp( argv[ ind ], "n" ) == 0 )		n = FALSE ;
		else
		if( strcmp( argv[ ind ], "m" ) == 0 )		m = FALSE ;
		else
		if( strcmp( argv[ ind ], "a" ) == 0 )		a = FALSE ;
		else
		if( strcmp( argv[ ind ], "s" ) == 0 )		s = FALSE ;
		else
		if( strcmp( argv[ ind ], "h" ) == 0 )		h = FALSE ;
		else
		if( strcmp( argv[ ind ], "c" ) == 0 )		c = FALSE ;
		else
		if( strcmp( argv[ ind ], "p" ) == 0 )		p = FALSE ;
		else
		if( strcmp( argv[ ind ], "v" ) == 0 )		v = FALSE ;
		else
		if( strcmp( argv[ ind ], "r" ) == 0 )		r = FALSE ;
		else	{
			fprintf( stdout, "Invalid argument : %s\n", argv[ ind ] ) ;
			e = TRUE ;
		  }
	  }

	if( e )	exit( -1 ) ;

	if( n )	null( phfig ) ;		/* Destroy null segment 				*/

	if( m )  coli( phfig ) ;		/* Colinear unification					*/

	if( z )	zero( phfig ) ;		/*	Center all x,y to 0					*/

	if( a )  alim( phfig ) ;		/* Alim dimension check					*/

	if( r )  reduc( phfig ) ;		/* Via supperposition destruction	*/

	if( s )  check( phfig ) ;		/* Symbolic connections					*/

	if( h )	tiny( phfig ) ;		/* Heigth check							*/

	if( c )  conn( phfig ) ;		/* Destroy null connectors				*/

	if( p )  polar( phfig ) ;		/* Generation of PTIE & NTIE			*/

	if( v )	virtu( phfig ) ;		/* Check virtual connectors			*/

	savephfig( phfig ) ;
	exit(0);
}

/********************************************************************************
 *		Null segment destruction
 ********************************************************************************/


null( phfig )
phfig_list *phfig ;
{
 phseg_list *phseg1 ;
 phseg_list *next1 ;
 
 
   for( phseg1 = phfig->PHSEG ; phseg1 != NULL ; phseg1 = next1)  {
 
      next1= phseg1->NEXT ;
 
      if( phseg1->TYPE == HOR )  {
         if( phseg1->X1 == phseg1->X2 )   delphseg( phfig, phseg1 ) ;
        }  
      else 
      if( phseg1->Y1 == phseg1->Y2 )   delphseg( phfig, phseg1 ) ;
     }   
}


/********************************************************************************
 *		Colinear unification  H/H & V/V
 ********************************************************************************/

coli( phfig )
phfig_list *phfig ;
{
 phseg_list *phseg1 ;
 phseg_list *next1 ;


	for( phseg1 = phfig->PHSEG ; phseg1 != NULL ; phseg1 = next1)	{	phseg_list *phseg2, *next2 ;

		next1 = phseg1->NEXT ;

		for( phseg2 = next1 ; phseg2 != NULL ; phseg2 = next2 )	{

			next2 = phseg2->NEXT ;

			if( phseg1->LAYER != phseg2->LAYER )	continue ;
			if( phseg1->LAYER == NTRANS )				continue ;
			if( phseg1->LAYER == PTRANS )				continue ;

			if( col_unif( phfig, phseg1, phseg2 ) )	{ next1 = phfig->PHSEG ; break ; }
		  }
	  }
}


/********************************************************************************
 *		Unificate only colinear segment with extention checking.
 ********************************************************************************/

int col_unif( phfig, phseg1, phseg2 )
phfig_list *phfig ;
phseg_list *phseg1 ;
phseg_list *phseg2 ;
{
 int ext ;	/* Layer extention */

/*
 *       Array of double layer extention for H/H or V/V layer unification
 */
 
static int dext[] = {

               0,    /* NWELL  0    */
               0,    /* PWELL  1    */
               1,    /* NTIE   2    */
               1,    /* PTIE   3    */
               1,    /* NDIF   4    */
               1,    /* PDIF   5    */
               1,    /* NTRANS 6    */
               1,    /* PTRANS 7    */
               1,    /* POLY   8    */
               1,    /* ALU1   9    */
               2,    /* ALU2   10   */
               2,    /* ALU3   11   */
               1,    /* TPOLY  12   */
               1,    /* TALU1  13   */
               2,    /* TALU2  14   */
               2     /* TALU3  15   */
            } ;


   if( phseg1->WIDTH != phseg2->WIDTH )   return FALSE ;
   if( phseg1->TYPE  != phseg2->TYPE )    return FALSE ;
 
   ext = SCALE_X * dext[ phseg2->LAYER ] ;
 
   if( phseg1->TYPE == HOR  &&  phseg1->Y1 == phseg2->Y2 )  {  phseg_list  *supseg, *minseg ;
 
      if(   (phseg1->X1 < phseg2->X1)
         ||
            (phseg1->X1 == phseg2->X1  &&  phseg2->X2 > phseg1->X2)
        )
         {  supseg = phseg2 ; minseg = phseg1 ; }
      else
         { supseg = phseg1 ; minseg = phseg2 ; }
 
      if( minseg->X2 + ext < supseg->X1 ) return FALSE ;        /* Not connected */
 
      if( minseg->X2 < supseg->X2 )    minseg->X2 = supseg->X2 ;
      delphseg( phfig, supseg ) ;
      return TRUE ;
     }
 
   else
   if( phseg1->TYPE == VER  &&  phseg1->X1 == phseg2->X2 )  {  phseg_list  *supseg, *minseg ;

      if(   (phseg1->Y1 < phseg2->Y1)
         ||
            (phseg1->Y1 == phseg2->Y1  &&  phseg2->Y2 > phseg1->Y2)
        )
         {  supseg = phseg2 ; minseg = phseg1 ; }
      else
         { supseg = phseg1 ; minseg = phseg2 ; }

      if( minseg->Y2 + ext < supseg->Y1 ) return FALSE ;        /* Not connected */

      if( minseg->Y2 < supseg->Y2 )    minseg->Y2 = supseg->Y2 ;
      delphseg( phfig, supseg ) ;
      return TRUE ; 
     }

	return FALSE ;
}


/********************************************************************************
 *		Coordinates alignement to 0,0 (left down corner)
 ********************************************************************************/
zero( phfig )
phfig_list  *phfig ;
{
 long  x, y ;
 phins_list  *phins ;
 phcon_list  *phcon ;
 phseg_list  *phseg ;
 phvia_list  *phvia ;
 phref_list  *phref ;

	x = phfig->XAB1;
	y = phfig->YAB1;

	phfig->XAB1 = phfig->YAB1 = 0;
	phfig->XAB2 -= x; phfig->YAB2 -= y;

	for( phins = phfig->PHINS; phins != NULL ; phins = phins->NEXT) {
		phins->XINS -= x;
		phins->YINS -= y;
	}
	for( phcon = phfig->PHCON; phcon != NULL ; phcon = phcon->NEXT) {
		phcon->XCON -= x;
		phcon->YCON -= y;
	}
	for( phseg = phfig->PHSEG; phseg != NULL ; phseg = phseg->NEXT) {
		phseg->X1 -= x;
		phseg->Y1 -= y;
		phseg->X2 -= x;
		phseg->Y2 -= y;
	}
	for( phvia = phfig->PHVIA; phvia != NULL ; phvia = phvia->NEXT) {
		phvia->XVIA -= x;
		phvia->YVIA -= y;
	}
	for( phref = phfig->PHREF; phref != NULL ; phref = phref->NEXT) {
		phref->XREF -= x;
		phref->YREF -= y;
	}
}


/********************************************************************************
 *		Alim width verification
 ********************************************************************************/

alim( phfig )
phfig_list  *phfig ;
{
phcon_list  *phcon ;


	for( phcon = phfig->PHCON ; phcon != NULL ; phcon = phcon->NEXT )	{ int  is_vdd, is_vss ; phseg_list  *phseg ;

		is_vdd = strncmp( phcon->NAME, "vdd", 3 ) == 0 ;
		is_vss = strncmp( phcon->NAME, "vss", 3 ) == 0 ;

		if( (is_vdd  ||  is_vss)  &&  phcon->LAYER == ALU2 )	{

			phcon->WIDTH = is_vdd ? 6*SCALE_X : 8*SCALE_X ;

			for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )	{

				if(  (phcon->XCON == phseg->X1  &&  phcon->YCON == phseg->Y1)
					||
					  (phcon->XCON == phseg->X2  &&  phcon->YCON == phseg->Y2)
				  )

					if( phseg->LAYER == ALU2  &&  phseg->TYPE == HOR )	{
						phseg->WIDTH = phcon->WIDTH ;
						break ;
					  }
			  }

			if( phseg == NULL )
				fprintf( stdout, "Warning : There is no segment on connector %s, X = %d, Y = %d\n",
										phcon->NAME, phcon->XCON, phcon->YCON ) ;
		  }
	  }
}



/********************************************************************************
 *		Check symbolic connections
 ********************************************************************************/

check( phfig )
phfig_list *phfig ;
{

phseg_list  *phseg ;
phseg_list    *seg ;
phcon_list  *phcon ;
phvia_list  *phvia ;
phref_list  *phref ;

int  sext1, sext2 ;
int  scon ;
int  svia ;


   for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )   {

      sext1 = sext2 = 0 ;

      if(    phseg->LAYER != ALU1   && phseg->LAYER != POLY   && phseg->LAYER != ALU2
          && phseg->LAYER != NTRANS && phseg->LAYER != PTRANS )   continue ;

      for( seg = phfig->PHSEG ; seg != NULL ; seg = seg->NEXT )   {

          if( seg == phseg ) continue ;

          if( ! (      phseg->LAYER == seg->LAYER
                  || ( phseg->LAYER == POLY && ( seg->LAYER == NTRANS || seg->LAYER == PTRANS ) )
                  || ( phseg->LAYER == NTRANS && seg->LAYER == POLY )
                  || ( phseg->LAYER == PTRANS && seg->LAYER == POLY )))   continue ;


          if( phseg->TYPE != seg->TYPE )

             if( phseg->TYPE == HOR )   {

                if( phseg->X1 == seg->X1 && phseg->Y1 <= seg->Y2 && phseg->Y1 >= seg->Y1 )   sext1 = 1 ;
                if( phseg->X2 == seg->X1 && phseg->Y2 <= seg->Y2 && phseg->Y2 >= seg->Y1 )   sext2 = 1 ;
               }
             else  {

                if( phseg->Y1 == seg->Y1 && phseg->X1 <= seg->X2 && phseg->X1 >= seg->X1 )   sext1 = 1 ;
                if( phseg->Y2 == seg->Y1 && phseg->X2 <= seg->X2 && phseg->X2 >= seg->X1 )   sext2 = 1 ;
               }
          else

             if( phseg->TYPE == HOR )   {

                if( phseg->Y1 == seg->Y1 && phseg->X1 >= seg->X1 && phseg->X1 <= seg->X2 )   sext1 = 1 ;
                if( phseg->Y1 == seg->Y1 && phseg->X2 >= seg->X1 && phseg->X2 <= seg->X2 )   sext2 = 1 ;
               }
             else   {

                if( phseg->X1 == seg->X1 && phseg->Y1 >= seg->Y1 && phseg->Y1 <= seg->Y2 )   sext1 = 1 ;
                if( phseg->X1 == seg->X1 && phseg->Y2 >= seg->Y1 && phseg->Y2 <= seg->Y2 )   sext2 = 1 ;
               }
         }

      for( phcon = phfig->PHCON ; phcon != NULL ; phcon = phcon->NEXT )   {

         if( phcon->LAYER != phseg->LAYER ) continue ;

         if( phseg->X1 == phcon->XCON && phseg->Y1 == phcon->YCON )   sext1 = 1 ;
         if( phseg->X2 == phcon->XCON && phseg->Y2 == phcon->YCON )   sext2 = 1 ;
        }

      for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )   {

         if( ! (    (phvia->TYPE == CONT_POLY && ( phseg->LAYER == ALU1 || phseg->LAYER == POLY ))
                 || (phvia->TYPE == CONT_VIA  && ( phseg->LAYER == ALU1 || phseg->LAYER == ALU2 ))
                 || (phvia->TYPE == C_X_N     && ( phseg->LAYER == NTRANS ))
                 || (phvia->TYPE == C_X_P     && ( phseg->LAYER == PTRANS ))
                 || (phseg->LAYER == ALU1 && (    phvia->TYPE == CONT_DIF_N
                                               || phvia->TYPE == CONT_DIF_P
                                               || phvia->TYPE == CONT_BODY_N
                                               || phvia->TYPE == CONT_BODY_P
                                             ))
               ))   continue ;

         if( phseg->X1 == phvia->XVIA && phseg->Y1 == phvia->YVIA )   sext1 = 1 ;
         if( phseg->X2 == phvia->XVIA && phseg->Y2 == phvia->YVIA )   sext2 = 1 ;
        }

      for( phref = phfig->PHREF ; phref != NULL ; phref = phref->NEXT )   {

         if( !( isvirtual( phref->FIGNAME ) && phseg->LAYER == ALU1 ) )   continue ;

         if( phseg->X1 == phref->XREF && phseg->Y1 == phref->YREF )   sext1 = 1 ;
         if( phseg->X2 == phref->XREF && phseg->Y2 == phref->YREF )   sext2 = 1 ;
        }

      if( sext1 && sext2 )   continue ;

      if( ! sext1 && ! sext2 )
         fprintf( stdout, "Segment %s X1=%d Y1=%d X2=%d Y2=%d is not symbolic on both extremities\n",
                  Layer( phseg->LAYER ),
                  phseg->X1 / SCALE_X, phseg->Y1 / SCALE_X, phseg->X2 / SCALE_X, phseg->Y2 / SCALE_X ) ;
      else
      if( phseg->LAYER != NTRANS && phseg->LAYER != PTRANS )   {
         if( ! sext1 )
            fprintf( stdout, "Segment %s X1=%d Y1=%d X2=%d Y2=%d is not symbolic on X1,Y1 extremities\n",
                     Layer( phseg->LAYER ),
                     phseg->X1 / SCALE_X, phseg->Y1 / SCALE_X, phseg->X2 / SCALE_X, phseg->Y2 / SCALE_X ) ;
         if( ! sext2 )
            fprintf( stdout, "Segment %s X1=%d Y1=%d X2=%d Y2=%d is not symbolic on X2,Y2 extremities\n",
                     Layer( phseg->LAYER ),
                     phseg->X1 / SCALE_X, phseg->Y1 / SCALE_X, phseg->X2 / SCALE_X, phseg->Y2 / SCALE_X ) ;
        }
     }

   for( phcon = phfig->PHCON ; phcon != NULL ; phcon = phcon->NEXT )   {

      scon = 0 ;

      for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )  {

         if( phcon->LAYER != phseg->LAYER )   continue ;

         if(    phseg->TYPE == HOR
             && phcon->YCON == phseg->Y1 && phcon->XCON >= phseg->X1 && phcon->XCON <= phseg->X2 )   scon = 1 ;
         if(    phseg->TYPE == VER
             && phcon->XCON == phseg->X1 && phcon->YCON >= phseg->Y1 && phcon->YCON <= phseg->Y2 )   scon = 1 ;
        }

      for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )   {

         if( ! (    (phvia->TYPE == CONT_POLY && ( phcon->LAYER == ALU1 || phcon->LAYER == POLY ))
                 || (phvia->TYPE == CONT_VIA  && ( phcon->LAYER == ALU1 || phcon->LAYER == ALU2 ))
                 || (phvia->TYPE == C_X_N     && ( phcon->LAYER == NTRANS ))
                 || (phvia->TYPE == C_X_P     && ( phcon->LAYER == PTRANS ))
                 || (phcon->LAYER == ALU1 && (    phvia->TYPE == CONT_DIF_N
                                               || phvia->TYPE == CONT_DIF_P
                                               || phvia->TYPE == CONT_BODY_N
                                               || phvia->TYPE == CONT_BODY_P
                                             ))
               ))   continue ;


         if( phcon->XCON == phvia->XVIA && phcon->YCON == phvia->YVIA )   scon = 1 ;
        }

      if( ! scon )
         fprintf( stdout, "Connector %s at ( %d, %d) is not symbolic\n",
                  Layer( phcon->LAYER ),
                  phcon->XCON / SCALE_X, phcon->YCON / SCALE_X ) ;
     }

   for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )   {   /*  Inclusion not treated  */

      svia = 0 ;

      for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )   {

         if( ! (    (phvia->TYPE == CONT_POLY && ( phseg->LAYER == ALU1 || phseg->LAYER == POLY ))
                 || (phvia->TYPE == CONT_VIA  && ( phseg->LAYER == ALU1 || phseg->LAYER == ALU2 ))
                 || (phvia->TYPE == C_X_N     && ( phseg->LAYER == NTRANS ))
                 || (phvia->TYPE == C_X_P     && ( phseg->LAYER == PTRANS ))
                 || (phseg->LAYER == ALU1 && (    phvia->TYPE == CONT_DIF_N
                                               || phvia->TYPE == CONT_DIF_P
                                               || phvia->TYPE == CONT_BODY_N
                                               || phvia->TYPE == CONT_BODY_P
                                             ))
               ))   continue ;


            if(    phseg->TYPE == HOR
                && phvia->YVIA == phseg->Y1 && phvia->XVIA >= phseg->X1 && phvia->XVIA <= phseg->X2 )   svia = 1 ;
            if(    phseg->TYPE == VER
                && phvia->XVIA == phseg->X1 && phvia->YVIA >= phseg->Y1 && phvia->YVIA <= phseg->Y2 )   svia = 1 ;
        }

      if( ! svia )
         fprintf( stdout, "Via %s at ( %d, %d) is not symbolic\n", Via( phvia->TYPE ),
                           phvia->XVIA / SCALE_X, phvia->YVIA / SCALE_X ) ;
     }
}



/********************************************************************************
 *		Height data-path verification
********************************************************************************/

tiny( phfig )
phfig_list  *phfig ;
{

	if( (phfig->YAB2 - phfig->YAB1) % (60 * SCALE_X) != 0 )

		fprintf( stdout, "Cell abutment box are not multiple of 60 lamdas : %d\n", (phfig->YAB2 - phfig->YAB1) / SCALE_X ) ;
}


/********************************************************************************
 *		Non util connectors are scrahed
********************************************************************************/

conn( phfig )
phfig_list  *phfig ;
{
 char  *star ;
 phcon_list  *phcon, *tmpcon ;


	star = namealloc( "*" ) ;

	for( phcon = phfig->PHCON ; phcon != NULL ; phcon = tmpcon )	{

		tmpcon = phcon->NEXT ;
		if( phcon->NAME == star )	delphcon( phfig, phcon ) ;
	  }
}


/********************************************************************************
 *		Automatic generation of NTIE & PTIE Layers
********************************************************************************/

polar( phfig )
phfig_list  *phfig ;
{
 phseg_list  *phseg ;
 phvia_list  *phvia ;


/*
 *		First we transform all NTIE and PTIE in NDIF and PDIF, to eliminate design errors :
 *	Put an PTIE in place of PDIF.
 */

	for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )	{

		if( phseg->LAYER == NTIE )	phseg->LAYER = NDIF ;
		if( phseg->LAYER == PTIE )	phseg->LAYER = PDIF ;
	  }

	for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )	{

		if( phvia->TYPE == CONT_BODY_N )	phvia->TYPE = CONT_DIF_N ;
		if( phvia->TYPE == CONT_BODY_P )	phvia->TYPE = CONT_DIF_P ;
	  }

/*
 *		Now we generate the layers NTIE & PTIE.
 */

	for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )

		if( phseg->LAYER == NDIF  ||  phseg->LAYER == PDIF )

					if( innwell( phseg->X1, phseg->Y1, phfig ) )	{

						if( phseg->LAYER == NDIF )	phseg->LAYER = NTIE ;
					  }
					else
						if( phseg->LAYER == PDIF )	phseg->LAYER = PTIE ;


	for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )

		if( phvia->TYPE == CONT_DIF_N  ||  phvia->TYPE == CONT_DIF_P )

			if( innwell( phvia->XVIA, phvia->YVIA, phfig ) )	{

				if( phvia->TYPE == CONT_DIF_N )	phvia->TYPE = CONT_BODY_N ;
			  }
			else	if( phvia->TYPE == CONT_DIF_P )	phvia->TYPE = CONT_BODY_P ;
}


int innwell( x, y, phfig )
long  x, y ;
phfig_list  *phfig ;
{
int  inwell ;
phseg_list  *nseg ;


   inwell = FALSE ;

	for( nseg = phfig->PHSEG ; nseg != NULL ; nseg = nseg->NEXT )	{

		if( nseg->LAYER == NWELL )

			if( nseg->TYPE == HOR )

				inwell = (
								 x >= nseg->X1
							&&  x <= nseg->X2
							&&  y >= (nseg->Y1 - nseg->WIDTH/2)
							&&  y <= (nseg->Y2 + nseg->WIDTH/2) ) ;

			else

				inwell = (
								 x >= nseg->X1 - nseg->WIDTH/2
							&&  x <= nseg->X2 + nseg->WIDTH/2
							&&  y >= nseg->Y1
							&&  y <= nseg->Y2 ) ;


		if( inwell )	break ;
	  }

	return  inwell ;
}


/********************************************************************************
 *		Verifie the placement of the virtual connectors and the name.
********************************************************************************/


virtu( phfig )
phfig_list  *phfig ;
{
phref_list *phref ;
char  *num ;
static  int  vcoord[] = { 53, 48, 43, 38, 33, 28, 23, 18, 13, 8 } ;


	for( phref = phfig->PHREF ; phref != NULL ; phref = phref->NEXT )

		if( isvirtual( phref->FIGNAME ) )	{

			num = strrchr( phref->NAME, (int) '_' ) ;

			if( num == NULL  ||  num[1] < '0'  ||  num[1] > '9'  ||  num[2] != '\0' )
				fprintf( stdout, "Illegal name of virtual connector : name = %s : x = %ld : y = %ld\n",
										phref->NAME, phref->XREF/SCALE_X, phref->YREF/SCALE_X ) ;
			else
				if( vcoord[ atoi( ++num ) ] != (phref->YREF - phfig->YAB1)/SCALE_X )
					fprintf( stdout, "Illegal number of track for the virtual connector : name = %s : y = %ld\n",
											phref->NAME, phref->YREF/SCALE_X ) ;
		  }
}


/********************************************************************************
 *		Two phvia's supperposed will be transformed in one.
********************************************************************************/

reduc( phfig )
phfig_list  *phfig ;
{
phvia_list  *phvia, *via, *tmpvia ;


	for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )

		for( via = phvia->NEXT ; via != NULL ; via = tmpvia )	{

			tmpvia = via->NEXT ;

			if( via->XVIA == phvia->XVIA  &&  via->YVIA == phvia->YVIA )

				if( via->TYPE == phvia->TYPE )	{ tmpvia = tmpvia == NULL ? NULL : via->NEXT ; delphvia( phfig, via ) ; }
            else
                fprintf( "Two contacts different type  %s and %s stacked at ( %d, %d)\n",
                         Via( phvia->TYPE ), Via( phvia->TYPE ),
                         via->XVIA / SCALE_X, via->YVIA / SCALE_X ) ;
		  }
}
