extern char *malloc(), *realloc();

# line 2 "edi_lo.yac"

/*----------------------------------------------------------------------*/
/* 			@(#) Edif Parser For MBK.			*/
/*----------------------------------------------------------------------*/
/*			version 1.0: 	by Fred Petrot.			*/
/*			version 1.1: 	by Mokhtar Hirech (Jan. 92)	*/
/*----------------------------------------------------------------------*/

#include "mut306.h"
#include "mlo400.h"

/* ----	Defines          -----------------------------------------------*/

#define MAXSTRLEN 	200
#define OUTLINE 	"outline"
#define ALL 		"all"
#define NULL 		0

/* ----	Global Variables -----------------------------------------------*/

char		EDIFL_BLACKBOX 	= 'N';	
int		EDIFL_BUS_WIDTH 	= 0;
char		EDIFL_DIRECTION 	= 'X'; /* directions: X=INOUT, I=INPUT, O=OUTPUT */
lofig_list	*EDIFL_LOFIG 	= (lofig_list *) NULL;
lofig_list	*EDIFL_PTFIG 	= (lofig_list *) NULL;
int		index 		= 0;
char		EDIFL_SIGTYPE 	= 'Z'; /* Z=not alr. defined, I=interne, E=externe */
losig_list	*EDIFL_PTSIG   	= (losig_list *) NULL;
locon_list	*EDIFL_PTCON  	= (locon_list *) NULL;
lofig_list	*EDIFL_INS_PTMODEL = (lofig_list *) NULL;
chain_list	*EDIFL_INS_SIGCHAIN= (chain_list *) NULL;
chain_list	*EDIFL_INS_PARCHAIN= (chain_list *) NULL;
locon_list	*EDIFL_INS_PTCON 	= (locon_list *) NULL;
char		*EDIFL_PORTNAME 	= (char *) NULL;
int 		no_locon_to_load= 0;
int 		no_figure_to_load= 0;
char		*EDIFL_FILENAME;
char		*EDIFL_FIGNAME;
char		EDIFL_MODE;
char		*EDIFL_PTNAME;
char		EDIFL_INS_MODELNAME [MAXSTRLEN];
char		EDIFL_TMP [MAXSTRLEN];
loins_list	*EDIFL_PTINS;

static 	char	bus_nameref();
extern  char	*edif_busname();

# line 52 "edi_lo.yac"
typedef union 	{
	long	lval;
	char	sval[100];
	} EDIFLSTYPE;
# define T_EDIF 257
# define T_EDIFVERSION 258
# define T_EDIFLEVEL 259
# define T_LIBRARY 260
# define T_TECHNOLOGY 261
# define T_CELLTYPE 262
# define T_CELLTYPE_GENERIC 263
# define T_CELL 264
# define T_CELLTYPE_TIE 265
# define T_CELLTYPE_RIPPER 266
# define T_PROPERTY 267
# define T_VIEW 268
# define T_VIEWTYPE 269
# define T_INTERFACE 270
# define T_CONTENTS 271
# define T_NET 272
# define T_JOINED 273
# define T_INSTANCE 274
# define T_VIEWREF 275
# define T_CELLREF 276
# define T_PORT 277
# define T_DIRECTION 278
# define T_INOUT 279
# define T_INPUT 280
# define T_PORTREF 281
# define T_NETLIST 282
# define T_KEYWORDMAP 283
# define T_STATUS 284
# define T_KEYWORDLEVEL 285
# define T_EXTERNAL 286
# define T_LIBRARYREF 287
# define T_IDENT 288
# define T_OUTPUT 289
# define T_INSTANCEREF 290
# define T_MEMBER 291
# define T_ARRAY 292
# define T_RENAME 293
# define T_NAME 294
# define T_STRING 295
# define T_INTEGER 296
#define ediflclearin ediflchar = -1
#define ediflerrok ediflerrflag = 0
extern int ediflchar;
extern int ediflerrflag;
#ifndef EDIFLMAXDEPTH
#define EDIFLMAXDEPTH 150
#endif
EDIFLSTYPE edifllval, ediflval;
# define EDIFLERRCODE 256

# line 808 "edi_lo.yac"


extern 	char		edifltext[];
extern 	FILE		*ediflin;
extern 	int		edifllineno;


/*----------------------------------------------------------------------*/
/*	bus_nameref: checks that name ref is bus name ref and with 	*/
/*	the same width. It returns 1 if ok.				*/
/* 	Do not forget that locon list is in reverse order.		*/
/*----------------------------------------------------------------------*/

static char bus_nameref(ptlocon, bnameref, bus_width)
locon_list	*ptlocon;
char		*bnameref;
int		bus_width;
{
	int 		i,n;
	char 		port_name[100];
	locon_list	*loconp;

       	sprintf(&port_name[0], "%s %d", bnameref, --bus_width);
	
	/* 	Search for a connector named <bnameref bus_width-1>	*/
	for (loconp = ptlocon; loconp != (locon_list *) NULL; loconp = loconp->NEXT)
		if (loconp->NAME == namealloc(port_name)) break;

	if (loconp == (locon_list *) NULL)  return 0; /* not found */

	/* 			  check bus_width.			*/
	for (loconp = loconp->NEXT; loconp != (locon_list *) NULL; 
		loconp = loconp->NEXT) {
		sprintf(&port_name[0], "%s %d", bnameref, bus_width - 1);
		if (loconp->NAME == namealloc(port_name) && bus_width >= 0) --bus_width; 
		else break;
	}

	return (bus_width == 0);
}


void edifloadlofig (ptfig,figname,mode)
lofig_list	*ptfig;
char		*figname;
char		 mode;
{
	char		filename[120];
	lofig_list	*pt;
	losig_list	*ptsig;
	losig_list	*ptsignext;
	loins_list	*ptins;
	loins_list	*ptinsnext;

	edifllineno=0;

	/*	 opening file		*/

	sprintf(filename, "%s/%s.%s", WORK_LIB, figname, IN_LO);
		if((ediflin = mbkfopen(figname, IN_LO, READ_TEXT)) == NULL) {
 			printf("\n*** mbk error *** can't open file :	%s\n",filename);
 			exit(1);
	}

	if(TRACE_MODE == 'Y') {
 		printf("\n--- mbk --- edifloadlofig : parsing file");
		printf(" %s in mode %c\n", filename, mode);
		printf("edif parser version 3.04\n");
 	}

	/*		 parsing		*/
	
	EDIFL_LOFIG = ptfig;
	/*EDIFL_MODE	= mode; modified by hm on 05-05-92*/
	EDIFL_MODE	= 'A';
	EDIFL_FILENAME = filename;
	EDIFL_FIGNAME = figname;

	if (ediflparse() != 0) {
 		printf("\n*** mbk error *** abnormal parsing for :	%s\n", filename);
 		exit(1);
 	}

	if (fclose(ediflin) != 0) {
 		printf("\n*** mbk error *** can't close file :	%s\n",
		filename);
 		exit(1);
 	}

	if (EDIFL_BLACKBOX == 'Y') {
		ptfig->MODE = 'A';
		for (pt = HEAD_LOFIG; pt != NULL; pt = pt->NEXT) {
			if (pt == ptfig) break;
			for (ptins = ptfig->LOINS; ptins != NULL; ptins = ptins->NEXT) {
				if (strcmp(pt->NAME , ptins->FIGNAME) == 0)
					break;
				}
			if (ptins == NULL)
				dellofig(pt->NAME);
			}	
		for (pt = HEAD_LOFIG; pt != (lofig_list *) NULL; pt = pt->NEXT) {
			if (pt != ptfig) {
				for (ptsig = pt->LOSIG; ptsig != (losig_list *) NULL; 
				     ptsig = ptsig->NEXT) free(ptsig);
				
				pt->LOSIG = (losig_list *) NULL;
				for (ptins = pt->LOINS; ptins != (loins_list *) NULL; 
				     ptins = ptins->NEXT) delloins(pt , ptins->INSNAME);
				
				pt->MODE = 'P';
			}
		}
	}

	for (pt = HEAD_LOFIG; pt != NULL; pt = pt->NEXT) 
		if (pt != ptfig && !pt->LOSIG) 
			pt->MODE = (pt->LOSIG == NULL) ? 'P' : 'A';
}

ediflerror(s)
char *s;
{
	fprintf(stderr, "\n*** mbk error *** edif : %s at ligne %d on %s\n",
				s, edifllineno + 1, edifltext);
	exit(-1);
}


lofig_list *get_figure_pt(name)
char 	*name;
{
   	lofig_list	*pt;

	/* scan figure list */
	for (pt = HEAD_LOFIG; pt; pt=pt->NEXT)
		if (!strcmp(pt->NAME, name)) return pt;
	return (lofig_list *)NULL;
}
int ediflexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define EDIFLNPROD 99
# define EDIFLLAST 498
int ediflact[]={

   160,     4,    83,     4,   137,   158,     6,   135,     6,     5,
     4,     5,    77,   156,   112,     6,     4,   132,     5,    28,
    20,     6,    19,    14,     5,    16,    15,     9,   195,   175,
   146,   138,   139,    11,   177,    17,    26,   181,    84,    82,
   105,   140,   193,   123,   159,   183,   143,   127,   110,    95,
    90,   161,    88,    81,    76,    53,   117,    54,    55,    50,
    13,     8,   100,     2,    68,   130,   108,    62,   115,   192,
   170,   180,    79,    97,    43,    39,    49,   164,   200,   199,
    29,   197,   191,   190,   185,   174,   168,   167,   166,   165,
   151,   150,   149,   141,    91,    86,    85,    60,    59,    58,
    33,    27,    23,    22,    21,    78,    12,   129,   128,   106,
    94,   125,   124,   114,   182,   188,   171,   173,   144,   162,
   142,   120,   119,    65,   118,    51,   113,    71,   102,   101,
    93,    89,    70,    69,    61,    56,    45,    44,    38,    35,
    74,    36,    30,    96,    92,    87,    64,    63,    57,    52,
    41,    40,    37,    25,    24,    18,     7,    10,    98,   103,
   109,   178,     1,     0,     0,     0,     0,     0,   107,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   152,   155,     0,     0,     0,   153,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   172,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     4,     0,     4,
     0,     0,     6,   172,     6,     5,     0,     5,   187,     4,
   194,     0,     0,     0,     6,     0,    67,     5,     0,     0,
    67,     0,   110,    67,   181,    67,    99,   196,   176,   147,
   179,   131,   183,   126,   131,    99,   163,   122,    67,   121,
    67,    72,   104,    67,    66,    67,    67,    46,    42,    31,
    80,     0,     0,     3,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    32,     0,     0,
     0,     0,    34,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    47,     0,     0,     0,    48,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    73,     0,     0,
     0,     0,     0,    75,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   111,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   116,     0,     0,     0,     0,     0,     0,
     0,     0,   133,   134,     0,     0,     0,   136,     0,     0,
     0,     0,     0,     0,     0,     0,   145,     0,   148,     0,
     0,     0,     0,     0,   154,     0,     0,     0,   157,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   169,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   184,     0,     0,
   186,     0,     0,     0,   189,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   198 };
int ediflpact[]={

  -194, -1000,  -272,  -197, -1000, -1000,  -261,  -199,  -273,  -269,
  -270,  -253, -1000,  -274,  -276,    63,    62,    61,  -250,    60,
  -277, -1000, -1000, -1000,    39, -1000,  -272, -1000,    59, -1000,
 -1000,  -272,  -199, -1000,  -199, -1000, -1000,    34,    33, -1000,
 -1000, -1000,  -272, -1000, -1000, -1000,  -272,  -203,  -203, -1000,
  -208, -1000, -1000,    58,    57,    56, -1000,    26, -1000, -1000,
 -1000,    23, -1000, -1000, -1000, -1000,  -272, -1000, -1000, -1000,
 -1000, -1000,  -272,  -215,   -29,  -216,  -243, -1000, -1000,   -39,
 -1000,  -244,    55, -1000,    54,  -218,  -220,    53, -1000, -1000,
 -1000, -1000,     8,    21,    -1, -1000, -1000, -1000, -1000,  -278,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -272,    15,     2,     6,  -279, -1000, -1000, -1000,
 -1000,  -272,  -285, -1000, -1000, -1000,  -287, -1000, -1000, -1000,
 -1000,  -248,    52,  -229, -1000,  -272,   -11,  -272,    51,    50,
    49, -1000, -1000,  -272,  -225,  -283, -1000,  -272,  -291, -1000,
 -1000, -1000,     3,   -41,    10, -1000,    48,    47,    46, -1000,
 -1000, -1000,    45,  -272,    29, -1000,    44,   -12, -1000,    -7,
 -1000, -1000, -1000,  -236, -1000, -1000,  -272, -1000,    43,  -272,
 -1000, -1000, -1000,  -272,    42, -1000,    41,    28,     1,   -13,
    40, -1000, -1000, -1000, -1000, -1000,  -272, -1000,    38,    37,
 -1000 };
int ediflpgo[]={

     0,   162,   300,   161,   157,   156,   106,   155,   154,   153,
   152,   151,   150,    76,   149,   148,   147,   146,    65,   145,
   144,   143,    73,   142,   138,   137,   136,   135,   134,   133,
   132,    72,   131,   130,   129,   128,   126,   124,   122,   121,
   120,   119,   118,    66,    77,   117,    71,   116,   115,   114,
   113,   112,   111,   110,   109,    68,   108,   107,   105 };
int ediflr1[]={

     0,     1,     5,     6,     7,     7,     9,    10,    10,    11,
    14,    12,    15,    15,    16,    16,    17,    19,    20,    20,
    21,    21,     8,     8,    23,    24,    24,    25,    27,    26,
    13,    13,    13,    28,    28,    29,    29,    18,    30,    33,
    33,    34,    34,    35,    36,    36,    37,    37,    38,    40,
    40,    41,    41,     3,    42,    39,    45,    39,    44,    44,
    47,    46,    48,    48,    46,    49,    49,    43,    50,    50,
    51,    52,    52,    52,    52,    32,    53,    53,    54,    54,
    54,    22,    22,    55,    55,    56,    56,    57,    57,    57,
    31,    31,    58,    58,     2,     2,     2,     2,     4 };
int ediflr2[]={

     0,    15,    11,     7,     0,     4,    10,     0,     4,     2,
     1,    13,     0,     4,     2,     2,    15,     6,     0,     4,
     2,     2,     0,     4,    10,     0,     4,     2,     1,    13,
     6,     6,     6,     0,     4,     2,     2,     6,    17,     0,
     4,     2,     2,     7,     0,     4,     2,     2,    11,     6,
     8,     7,     9,     6,     1,    13,     1,    19,     0,     4,
     2,     6,     0,     4,     2,     7,    13,     6,     0,     4,
     2,     7,    13,    13,    19,     6,     0,     4,     2,     2,
     2,     9,    15,     0,     4,     2,     2,     7,     7,     7,
     0,     4,     4,     2,     3,     3,     9,     9,     7 };
int ediflchk[]={

 -1000,    -1,   257,    -2,   288,   296,   293,    -5,   258,   288,
    -4,   294,    -6,   259,   296,   295,   295,   288,    -7,   296,
   296,    41,    41,    41,    -8,    -9,   286,    41,   296,    41,
   -23,   260,    -2,    41,    -2,    -6,    -6,   -10,   -24,    41,
   -11,   -12,   264,    41,   -25,   -26,   264,    -2,    -2,   -13,
   262,   -13,   -14,   263,   265,   266,   -27,   -15,    41,    41,
    41,   -28,    41,   -16,   -17,   -18,   268,   267,    41,   -29,
   -30,   -18,   268,    -2,   -31,    -2,   269,    41,   -58,   -31,
    -2,   269,   282,    41,   282,    41,    41,   -19,   270,   -32,
   270,    41,   -20,   -33,   -53,    41,   -21,   -22,   -18,   277,
    41,   -34,   -35,   -18,   271,    41,   -54,   -22,   -43,   -18,
   273,    -2,   292,   -36,   -50,   -55,    -2,    41,   -37,   -38,
   -39,   274,   272,    41,   -51,   -52,   281,    41,   -56,   -57,
   -18,   278,   296,    -2,    -2,   292,    -2,   291,   279,   280,
   289,    41,   -40,   275,   -42,    -2,    41,   290,    -2,    41,
    41,    41,   -55,   -31,    -2,   -43,   296,    -2,   296,    41,
    41,    41,   -41,   276,   -44,    41,    41,    41,    41,    -2,
    41,   -47,   -18,   -45,    41,    41,   290,    41,    -3,   287,
   -46,   273,   -49,   281,    -2,    41,    -2,   -44,   -48,    -2,
    41,    41,    41,    41,   -46,    41,   290,    41,    -2,    41,
    41 };
int edifldef[]={

     0,    -2,     0,     0,    94,    95,     0,     0,     0,     0,
     0,     0,     4,     0,     0,     0,     0,     0,    22,     0,
     0,    96,    97,    98,     0,     5,     0,     3,     0,     1,
    23,     0,     0,     2,     0,     7,    25,     0,     0,     6,
     8,     9,     0,    24,    26,    27,     0,     0,     0,    10,
     0,    28,    12,     0,     0,     0,    33,     0,    30,    31,
    32,     0,    11,    13,    14,    15,     0,    90,    29,    34,
    35,    36,     0,     0,     0,     0,     0,    37,    91,     0,
    93,     0,     0,    92,     0,     0,     0,     0,    18,    39,
    76,    16,     0,     0,     0,    17,    19,    20,    21,     0,
    38,    40,    41,    42,    44,    75,    77,    78,    79,    80,
    68,    83,     0,     0,     0,     0,     0,    43,    45,    46,
    47,     0,     0,    67,    69,    70,     0,    81,    84,    85,
    86,     0,     0,     0,    54,     0,     0,     0,     0,     0,
     0,    83,    90,     0,     0,     0,    71,     0,     0,    87,
    88,    89,     0,     0,     0,    58,     0,     0,     0,    82,
    48,    49,     0,     0,     0,    56,     0,     0,    50,     0,
    55,    59,    60,     0,    72,    73,     0,    51,     0,     0,
    58,    62,    64,     0,     0,    52,     0,     0,     0,     0,
     0,    53,    57,    61,    63,    65,     0,    74,     0,     0,
    66 };
typedef struct { char *t_name; int t_val; } edifltoktype;
#ifndef EDIFLDEBUG
#	define EDIFLDEBUG	0	/* don't allow debugging */
#endif

#if EDIFLDEBUG

edifltoktype edifltoks[] =
{
	"T_EDIF",	257,
	"T_EDIFVERSION",	258,
	"T_EDIFLEVEL",	259,
	"T_LIBRARY",	260,
	"T_TECHNOLOGY",	261,
	"T_CELLTYPE",	262,
	"T_CELLTYPE_GENERIC",	263,
	"T_CELL",	264,
	"T_CELLTYPE_TIE",	265,
	"T_CELLTYPE_RIPPER",	266,
	"T_PROPERTY",	267,
	"T_VIEW",	268,
	"T_VIEWTYPE",	269,
	"T_INTERFACE",	270,
	"T_CONTENTS",	271,
	"T_NET",	272,
	"T_JOINED",	273,
	"T_INSTANCE",	274,
	"T_VIEWREF",	275,
	"T_CELLREF",	276,
	"T_PORT",	277,
	"T_DIRECTION",	278,
	"T_INOUT",	279,
	"T_INPUT",	280,
	"T_PORTREF",	281,
	"T_NETLIST",	282,
	"T_KEYWORDMAP",	283,
	"T_STATUS",	284,
	"T_KEYWORDLEVEL",	285,
	"T_EXTERNAL",	286,
	"T_LIBRARYREF",	287,
	"T_IDENT",	288,
	"T_OUTPUT",	289,
	"T_INSTANCEREF",	290,
	"T_MEMBER",	291,
	"T_ARRAY",	292,
	"T_RENAME",	293,
	"T_NAME",	294,
	"T_STRING",	295,
	"T_INTEGER",	296,
	"-unknown-",	-1	/* ends search */
};

char * ediflreds[] =
{
	"-no such reduction-",
	"r_edif : T_EDIF r_namedef r_edifversion r_ediflevel l_externals l_finedif ')'",
	"r_edifversion : T_EDIFVERSION T_INTEGER T_INTEGER T_INTEGER ')'",
	"r_ediflevel : T_EDIFLEVEL T_INTEGER ')'",
	"l_externals : /* empty */",
	"l_externals : l_externals r_external",
	"r_external : T_EXTERNAL r_namedef r_ediflevel l_finexternal ')'",
	"l_finexternal : /* empty */",
	"l_finexternal : l_finexternal r_finexternal",
	"r_finexternal : r_extcell",
	"r_extcell : T_CELL r_namedef r_celltype",
	"r_extcell : T_CELL r_namedef r_celltype l_finextcell ')'",
	"l_finextcell : /* empty */",
	"l_finextcell : l_finextcell r_finextcell",
	"r_finextcell : r_extview",
	"r_finextcell : r_property",
	"r_extview : T_VIEW r_namedef T_VIEWTYPE T_NETLIST ')' r_extinterface ')'",
	"r_extinterface : T_INTERFACE l_finextinterf ')'",
	"l_finextinterf : /* empty */",
	"l_finextinterf : l_finextinterf r_finextinterf",
	"r_finextinterf : r_port",
	"r_finextinterf : r_property",
	"l_finedif : /* empty */",
	"l_finedif : l_finedif r_library",
	"r_library : T_LIBRARY r_namedef r_ediflevel l_finlibrary ')'",
	"l_finlibrary : /* empty */",
	"l_finlibrary : l_finlibrary r_finlibrary",
	"r_finlibrary : r_cell",
	"r_cell : T_CELL r_namedef r_celltype",
	"r_cell : T_CELL r_namedef r_celltype l_fincell ')'",
	"r_celltype : T_CELLTYPE T_CELLTYPE_GENERIC ')'",
	"r_celltype : T_CELLTYPE T_CELLTYPE_TIE ')'",
	"r_celltype : T_CELLTYPE T_CELLTYPE_RIPPER ')'",
	"l_fincell : /* empty */",
	"l_fincell : l_fincell r_fincell",
	"r_fincell : r_view",
	"r_fincell : r_property",
	"r_property : T_PROPERTY l_anything ')'",
	"r_view : T_VIEW r_namedef T_VIEWTYPE T_NETLIST ')' r_interface l_finview ')'",
	"l_finview : /* empty */",
	"l_finview : l_finview r_finview",
	"r_finview : r_contents",
	"r_finview : r_property",
	"r_contents : T_CONTENTS l_fincontents ')'",
	"l_fincontents : /* empty */",
	"l_fincontents : l_fincontents r_fincontents",
	"r_fincontents : r_instance",
	"r_fincontents : r_net",
	"r_instance : T_INSTANCE r_namedef r_viewref l_anything ')'",
	"r_viewref : T_VIEWREF r_namedef ')'",
	"r_viewref : T_VIEWREF r_namedef r_cellref ')'",
	"r_cellref : T_CELLREF r_namedef ')'",
	"r_cellref : T_CELLREF r_namedef r_libraryref ')'",
	"r_libraryref : T_LIBRARYREF r_namedef ')'",
	"r_net : T_NET r_namedef",
	"r_net : T_NET r_namedef r_joined l_finnet ')'",
	"r_net : T_NET T_ARRAY r_namedef T_INTEGER ')'",
	"r_net : T_NET T_ARRAY r_namedef T_INTEGER ')' r_array_joined l_finnet ')'",
	"l_finnet : /* empty */",
	"l_finnet : l_finnet r_finnet",
	"r_finnet : r_property",
	"r_array_joined : T_JOINED l_array_joined ')'",
	"l_array_joined : /* empty */",
	"l_array_joined : l_array_joined r_array_joined",
	"r_array_joined : r_array_portref",
	"r_array_portref : T_PORTREF r_namedef ')'",
	"r_array_portref : T_PORTREF r_namedef T_INSTANCEREF r_namedef ')' ')'",
	"r_joined : T_JOINED l_finjoined ')'",
	"l_finjoined : /* empty */",
	"l_finjoined : l_finjoined r_finjoined",
	"r_finjoined : r_portref",
	"r_portref : T_PORTREF r_namedef ')'",
	"r_portref : T_PORTREF r_namedef T_INSTANCEREF r_namedef ')' ')'",
	"r_portref : T_PORTREF T_MEMBER r_namedef T_INTEGER ')' ')'",
	"r_portref : T_PORTREF T_MEMBER r_namedef T_INTEGER ')' T_INSTANCEREF r_namedef ')' ')'",
	"r_interface : T_INTERFACE l_fininterface ')'",
	"l_fininterface : /* empty */",
	"l_fininterface : l_fininterface r_fininterface",
	"r_fininterface : r_port",
	"r_fininterface : r_joined",
	"r_fininterface : r_property",
	"r_port : T_PORT r_namedef l_finport ')'",
	"r_port : T_PORT T_ARRAY r_namedef T_INTEGER ')' l_finport ')'",
	"l_finport : /* empty */",
	"l_finport : l_finport r_finport",
	"r_finport : r_direction",
	"r_finport : r_property",
	"r_direction : T_DIRECTION T_INOUT ')'",
	"r_direction : T_DIRECTION T_INPUT ')'",
	"r_direction : T_DIRECTION T_OUTPUT ')'",
	"l_anything : /* empty */",
	"l_anything : l_anything r_anything",
	"r_anything : l_anything ')'",
	"r_anything : r_namedef",
	"r_namedef : T_IDENT",
	"r_namedef : T_INTEGER",
	"r_namedef : T_RENAME T_IDENT T_STRING ')'",
	"r_namedef : T_RENAME r_name T_STRING ')'",
	"r_name : T_NAME T_IDENT ')'",
};
#endif /* EDIFLDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define EDIFLERROR		goto ediflerrlab
#define EDIFLACCEPT	{ free(edifls); free(ediflv); return(0); }
#define EDIFLABORT		{ free(edifls); free(ediflv); return(1); }
#define EDIFLBACKUP( newtoken, newvalue )\
{\
	if ( ediflchar >= 0 || ( ediflr2[ edifltmp ] >> 1 ) != 1 )\
	{\
		ediflerror( "syntax error - cannot backup" );\
		goto ediflerrlab;\
	}\
	ediflchar = newtoken;\
	ediflstate = *ediflps;\
	edifllval = newvalue;\
	goto ediflnewstate;\
}
#define EDIFLRECOVERING()	(!!ediflerrflag)
#ifndef EDIFLDEBUG
#	define EDIFLDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int edifldebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define EDIFLFLAG		(-1000)

/*
** static variables used by the parser
*/
static EDIFLSTYPE *ediflv;			/* value stack */
static int *edifls;			/* state stack */

static EDIFLSTYPE *ediflpv;			/* top of value stack */
static int *ediflps;			/* top of state stack */

static int ediflstate;			/* current state */
static int edifltmp;			/* extra var (lasts between blocks) */

int ediflnerrs;			/* number of errors */

int ediflerrflag;			/* error recovery flag */
int ediflchar;			/* current input token number */


/*
** ediflparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
ediflparse()
{
	register EDIFLSTYPE *ediflpvt;	/* top of value stack for $vars */
	unsigned ediflmaxdepth = EDIFLMAXDEPTH;

	/*
	** Initialize externals - ediflparse may be called more than once
	*/
	ediflv = (EDIFLSTYPE*)malloc(ediflmaxdepth*sizeof(EDIFLSTYPE));
	edifls = (int*)malloc(ediflmaxdepth*sizeof(int));
	if (!ediflv || !edifls)
	{
		ediflerror( "out of memory" );
		return(1);
	}
	ediflpv = &ediflv[-1];
	ediflps = &edifls[-1];
	ediflstate = 0;
	edifltmp = 0;
	ediflnerrs = 0;
	ediflerrflag = 0;
	ediflchar = -1;

	goto ediflstack;
	{
		register EDIFLSTYPE *edifl_pv;	/* top of value stack */
		register int *edifl_ps;		/* top of state stack */
		register int edifl_state;		/* current state */
		register int  edifl_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if EDIFLBACKUP was called.
		*/
	ediflnewstate:
		edifl_pv = ediflpv;
		edifl_ps = ediflps;
		edifl_state = ediflstate;
		goto edifl_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	ediflstack:
		edifl_pv = ediflpv;
		edifl_ps = ediflps;
		edifl_state = ediflstate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	edifl_stack:
		/*
		** put a state and value onto the stacks
		*/
#if EDIFLDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( edifldebug )
		{
			register int edifl_i;

			(void)printf( "State %d, token ", edifl_state );
			if ( ediflchar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( ediflchar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( edifl_i = 0; edifltoks[edifl_i].t_val >= 0;
					edifl_i++ )
				{
					if ( edifltoks[edifl_i].t_val == ediflchar )
						break;
				}
				(void)printf( "%s\n", edifltoks[edifl_i].t_name );
			}
		}
#endif /* EDIFLDEBUG */
		if ( ++edifl_ps >= &edifls[ ediflmaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int ediflps_index = (edifl_ps - edifls);
			int ediflpv_index = (edifl_pv - ediflv);
			int ediflpvt_index = (ediflpvt - ediflv);
			ediflmaxdepth += EDIFLMAXDEPTH;
			ediflv = (EDIFLSTYPE*)realloc((char*)ediflv,
				ediflmaxdepth * sizeof(EDIFLSTYPE));
			edifls = (int*)realloc((char*)edifls,
				ediflmaxdepth * sizeof(int));
			if (!ediflv || !edifls)
			{
				ediflerror( "yacc stack overflow" );
				return(1);
			}
			edifl_ps = edifls + ediflps_index;
			edifl_pv = ediflv + ediflpv_index;
			ediflpvt = ediflv + ediflpvt_index;
		}
		*edifl_ps = edifl_state;
		*++edifl_pv = ediflval;

		/*
		** we have a new state - find out what to do
		*/
	edifl_newstate:
		if ( ( edifl_n = ediflpact[ edifl_state ] ) <= EDIFLFLAG )
			goto edifldefault;		/* simple state */
#if EDIFLDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		edifltmp = ediflchar < 0;
#endif
		if ( ( ediflchar < 0 ) && ( ( ediflchar = edifllex() ) < 0 ) )
			ediflchar = 0;		/* reached EOF */
#if EDIFLDEBUG
		if ( edifldebug && edifltmp )
		{
			register int edifl_i;

			(void)printf( "Received token " );
			if ( ediflchar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( ediflchar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( edifl_i = 0; edifltoks[edifl_i].t_val >= 0;
					edifl_i++ )
				{
					if ( edifltoks[edifl_i].t_val == ediflchar )
						break;
				}
				(void)printf( "%s\n", edifltoks[edifl_i].t_name );
			}
		}
#endif /* EDIFLDEBUG */
		if ( ( ( edifl_n += ediflchar ) < 0 ) || ( edifl_n >= EDIFLLAST ) )
			goto edifldefault;
		if ( ediflchk[ edifl_n = ediflact[ edifl_n ] ] == ediflchar )	/*valid shift*/
		{
			ediflchar = -1;
			ediflval = edifllval;
			edifl_state = edifl_n;
			if ( ediflerrflag > 0 )
				ediflerrflag--;
			goto edifl_stack;
		}

	edifldefault:
		if ( ( edifl_n = edifldef[ edifl_state ] ) == -2 )
		{
#if EDIFLDEBUG
			edifltmp = ediflchar < 0;
#endif
			if ( ( ediflchar < 0 ) && ( ( ediflchar = edifllex() ) < 0 ) )
				ediflchar = 0;		/* reached EOF */
#if EDIFLDEBUG
			if ( edifldebug && edifltmp )
			{
				register int edifl_i;

				(void)printf( "Received token " );
				if ( ediflchar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( ediflchar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( edifl_i = 0;
						edifltoks[edifl_i].t_val >= 0;
						edifl_i++ )
					{
						if ( edifltoks[edifl_i].t_val
							== ediflchar )
						{
							break;
						}
					}
					(void)printf( "%s\n", edifltoks[edifl_i].t_name );
				}
			}
#endif /* EDIFLDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *ediflxi = ediflexca;

				while ( ( *ediflxi != -1 ) ||
					( ediflxi[1] != edifl_state ) )
				{
					ediflxi += 2;
				}
				while ( ( *(ediflxi += 2) >= 0 ) &&
					( *ediflxi != ediflchar ) )
					;
				if ( ( edifl_n = ediflxi[1] ) < 0 )
					EDIFLACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( edifl_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( ediflerrflag )
			{
			case 0:		/* new error */
				ediflerror( "syntax error" );
				goto skip_init;
			ediflerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				edifl_pv = ediflpv;
				edifl_ps = ediflps;
				edifl_state = ediflstate;
				ediflnerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				ediflerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( edifl_ps >= edifls )
				{
					edifl_n = ediflpact[ *edifl_ps ] + EDIFLERRCODE;
					if ( edifl_n >= 0 && edifl_n < EDIFLLAST &&
						ediflchk[ediflact[edifl_n]] == EDIFLERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						edifl_state = ediflact[ edifl_n ];
						goto edifl_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if EDIFLDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( edifldebug )
						(void)printf( _POP_, *edifl_ps,
							edifl_ps[-1] );
#	undef _POP_
#endif
					edifl_ps--;
					edifl_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				EDIFLABORT;
			case 3:		/* no shift yet; eat a token */
#if EDIFLDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( edifldebug )
				{
					register int edifl_i;

					(void)printf( "Error recovery discards " );
					if ( ediflchar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( ediflchar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( edifl_i = 0;
							edifltoks[edifl_i].t_val >= 0;
							edifl_i++ )
						{
							if ( edifltoks[edifl_i].t_val
								== ediflchar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							edifltoks[edifl_i].t_name );
					}
				}
#endif /* EDIFLDEBUG */
				if ( ediflchar == 0 )	/* reached EOF. quit */
					EDIFLABORT;
				ediflchar = -1;
				goto edifl_newstate;
			}
		}/* end if ( edifl_n == 0 ) */
		/*
		** reduction by production edifl_n
		** put stack tops, etc. so things right after switch
		*/
#if EDIFLDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( edifldebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				edifl_n, ediflreds[ edifl_n ] );
#endif
		edifltmp = edifl_n;			/* value to switch over */
		ediflpvt = edifl_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using edifl_state here as temporary
		** register variable, but why not, if it works...
		** If ediflr2[ edifl_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto edifl_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int edifl_len = ediflr2[ edifl_n ];

			if ( !( edifl_len & 01 ) )
			{
				edifl_len >>= 1;
				ediflval = ( edifl_pv -= edifl_len )[1];	/* $$ = $1 */
				edifl_state = ediflpgo[ edifl_n = ediflr1[ edifl_n ] ] +
					*( edifl_ps -= edifl_len ) + 1;
				if ( edifl_state >= EDIFLLAST ||
					ediflchk[ edifl_state =
					ediflact[ edifl_state ] ] != -edifl_n )
				{
					edifl_state = ediflact[ ediflpgo[ edifl_n ] ];
				}
				goto edifl_stack;
			}
			edifl_len >>= 1;
			ediflval = ( edifl_pv -= edifl_len )[1];	/* $$ = $1 */
			edifl_state = ediflpgo[ edifl_n = ediflr1[ edifl_n ] ] +
				*( edifl_ps -= edifl_len ) + 1;
			if ( edifl_state >= EDIFLLAST ||
				ediflchk[ edifl_state = ediflact[ edifl_state ] ] != -edifl_n )
			{
				edifl_state = ediflact[ ediflpgo[ edifl_n ] ];
			}
		}
					/* save until reenter driver code */
		ediflstate = edifl_state;
		ediflps = edifl_ps;
		ediflpv = edifl_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( edifltmp )
	{
		
case 1:
# line 88 "edi_lo.yac"
{ 
	    		if (TRACE_MODE == 'Y') 
				 printf ("--- mbk --- edifloadlofig : ");
		  } break;
case 2:
# line 95 "edi_lo.yac"
{ 
			if ((ediflpvt[-3].lval!=2) || (ediflpvt[-2].lval!=0) || (ediflpvt[-1].lval!=0)) {
		 	 printf ("*** mbk error *** unable to read this version of edif\n");
		 	 exit (1);
			}
		  } break;
case 3:
# line 104 "edi_lo.yac"
{ 
			if (ediflpvt[-1].lval != 0) {
			 printf ("\n[EdifLevel INCORRECT]\n");
			 exit (1);
			}
		  } break;
case 10:
# line 129 "edi_lo.yac"
{
			lofig_list *ptf;

			if (!(ptf = get_figure_pt(ediflpvt[-1].sval)))  {
				EDIFL_PTFIG = addlofig (ediflpvt[-1].sval);
				no_figure_to_load = 0; 
				no_locon_to_load = 0;
			}
			else {
				if (!strcmp(ediflpvt[-1].sval,EDIFL_FIGNAME)) EDIFL_PTFIG = EDIFL_LOFIG;
				if (ptf->LOCON && (incatalog(namealloc(ediflpvt[-1].sval)) || ptf->LOSIG)) 
				 	no_figure_to_load = 1; 
				else 	no_figure_to_load = 0; 

				no_locon_to_load = (ptf->LOCON) ? 1 : 0;
			}
			index = 0;
		  } break;
case 11:
# line 148 "edi_lo.yac"
{
			EDIFL_PTFIG->MODE = EDIFL_MODE;
			if ((EDIFL_MODE != 'A') && (EDIFL_PTFIG != EDIFL_LOFIG))
				dellofig(EDIFL_PTFIG->NAME);
		  } break;
case 16:
# line 166 "edi_lo.yac"
{
			if (incatalog(namealloc(ediflpvt[-5].sval))
			    && (EDIFL_PTFIG == EDIFL_LOFIG && EDIFL_MODE == 'A'))
			   EDIFL_BLACKBOX = 'Y';
		  } break;
case 28:
# line 199 "edi_lo.yac"
{ 
			lofig_list *ptf;

			if (!(ptf = get_figure_pt(ediflpvt[-1].sval)))  {
				EDIFL_PTFIG = addlofig (ediflpvt[-1].sval);
				no_figure_to_load = 0;
				no_locon_to_load = 0;
			}
			else {
				if (!strcmp(ediflpvt[-1].sval,EDIFL_FIGNAME)) EDIFL_PTFIG = EDIFL_LOFIG;
				if (ptf->LOCON && (incatalog(namealloc(ediflpvt[-1].sval)) || ptf->LOSIG)) 
				 	no_figure_to_load = 1; 
				else 	no_figure_to_load = 0; 

				no_locon_to_load = (ptf->LOCON) ? 1 : 0;
			}
			index = 0;
		  } break;
case 29:
# line 219 "edi_lo.yac"
{
			EDIFL_PTFIG->MODE = EDIFL_MODE;
			if ((EDIFL_MODE != 'A') && (EDIFL_PTFIG != EDIFL_LOFIG)) 
				dellofig(EDIFL_PTFIG->NAME);
		  } break;
case 38:
# line 244 "edi_lo.yac"
{
			if (incatalog(namealloc(ediflpvt[-6].sval)) && (EDIFL_PTFIG == EDIFL_LOFIG)
			  && (EDIFL_PTFIG == EDIFL_LOFIG && EDIFL_MODE == 'A')) EDIFL_BLACKBOX = 'Y';
		  } break;
case 43:
# line 259 "edi_lo.yac"
{ 

if (no_figure_to_load == 0) {
		    char *array_cname, *array_sname;
		    locon_list  *ptcon;
		    char end;

		    if (EDIFL_MODE == 'A') {
			if (TRACE_MODE == 'Y') {
				printf ("--- mbk --- edifloadlofig : ");
				printf ("checking figure %s\n",EDIFL_PTFIG->NAME);
			}
			for (EDIFL_PTINS=EDIFL_PTFIG->LOINS; EDIFL_PTINS; 
				EDIFL_PTINS=EDIFL_PTINS->NEXT) 
			{
			  EDIFL_INS_PTCON=EDIFL_PTINS->LOCON;
			  while (EDIFL_INS_PTCON != (locon_list *) NULL)
			  {
				if (!(array_cname = edif_busname(EDIFL_INS_PTCON->NAME)))
				 {
				  if (EDIFL_INS_PTCON->SIG == NULL) 
				   {
					printf ("\n*** mbk error *** edifloadlofig : ");
					printf ("\n    Connector ");
					printf ("%s ",EDIFL_INS_PTCON->NAME);
					printf ("of instance ");
					printf ("%s ",EDIFL_PTINS->INSNAME);
					printf ("has no signal ");
					printf ("in figure ");
					printf ("%s.\n",EDIFL_PTFIG->NAME);
					exit (1);
				   }
				  else 
					if (array_sname = edif_busname(getsigname(EDIFL_INS_PTCON->SIG))) 
					{
					 printf("\n*** mbk error *** edifloadlofig : ");
					 printf("\n    Signal Bus '%s' attached to single connector '%s'\n",
						 array_sname, EDIFL_INS_PTCON->NAME);
					 exit (1);
					}
				  EDIFL_INS_PTCON = EDIFL_INS_PTCON->NEXT;
				 }
				else
				 {
					ptcon = EDIFL_INS_PTCON; end = 1;
					if (ptcon->SIG) 
					{
						array_sname = edif_busname(getsigname(ptcon->SIG));
				     		while ((ptcon != (locon_list *) NULL) && (array_cname == edif_busname(ptcon->NAME))) {
							if ((ptcon->SIG) && (array_sname != edif_busname(getsigname(ptcon->SIG)))) 
							{ end = 0; break;}
					   		ptcon = ptcon->NEXT;
						}
					} else end = 0;

					if (!end) {
					 printf("\n*** mbk error *** edifloadlofig : ");
					 printf("\n    Connector Bus '%s' of instance `%s' is not properly connected\n",
						 array_cname, EDIFL_PTINS->INSNAME);
					 exit (1);
					}

					if (ptcon) EDIFL_INS_PTCON = ptcon; else EDIFL_INS_PTCON = NULL;
				 }
			  }
			 }
			 EDIFL_PTCON=EDIFL_PTFIG->LOCON;
			 while  (EDIFL_PTCON != (locon_list *) NULL)
			 {


				if (!(array_cname = edif_busname(EDIFL_PTCON->NAME)))
				 {
				  if (EDIFL_PTCON->SIG == NULL) 
				   {
					printf ("*** mbk error *** ");
					printf ("edifloadlofig : \n");
					printf ("connector ");
					printf ("%s ",EDIFL_PTCON->NAME);
					printf ("of figure ");
					printf ("%s ",EDIFL_PTFIG->NAME);
					printf ("has no signal ");
					exit (1);
				   }
				  else 
					if (array_sname = edif_busname(getsigname(EDIFL_PTCON->SIG))) 
					{
					 printf("\n*** mbk error *** ");
					 printf("edifloadlofig : \n");
					 printf("signal bus '%s' attached to not bussed connector '%s'\n",
						 array_sname, EDIFL_PTCON->NAME);
					 exit (1);
					}
				   EDIFL_PTCON = EDIFL_PTCON->NEXT;
				 }
				else
				 {
					ptcon = EDIFL_PTCON; end = 1;
					if (ptcon->SIG) 
					{
						array_sname = edif_busname(getsigname(ptcon->SIG));
				     		while ((ptcon != (locon_list *) NULL) && (array_cname == edif_busname(ptcon->NAME))) {
							if ((ptcon->SIG) && (array_sname != edif_busname(getsigname(ptcon->SIG)))) 
							{ end = 0; break;}
					   		ptcon = ptcon->NEXT;
						}
					} else end = 0;

					if (!end) {
					 printf("\n*** mbk error *** ");
					 printf("edifloadlofig : \n");
					 printf("Connector Bus '%s' of figure `%s' is not properly connected\n",
						 array_cname, EDIFL_PTFIG->NAME);
					 exit (1);
					}

					if (ptcon) EDIFL_PTCON = ptcon; else EDIFL_PTCON = NULL;
				 }
			 }
		  }
		}
} break;
case 48:
# line 392 "edi_lo.yac"
{
		    if (no_figure_to_load == 0) {
			if (EDIFL_MODE == 'A') {
				EDIFL_INS_PTMODEL= getlofig(EDIFL_INS_MODELNAME, 'P');
				EDIFL_INS_SIGCHAIN = NULL;
				for (EDIFL_INS_PTCON = EDIFL_INS_PTMODEL->LOCON;
				     EDIFL_INS_PTCON != NULL; 
				     EDIFL_INS_PTCON = EDIFL_INS_PTCON->NEXT) 
					EDIFL_INS_SIGCHAIN = addchain (EDIFL_INS_SIGCHAIN, NULL);
				EDIFL_INS_PARCHAIN = NULL;
				addloins(EDIFL_PTFIG, ediflpvt[-3].sval, EDIFL_INS_PTMODEL, EDIFL_INS_SIGCHAIN);
			}
		     }
		} break;
case 51:
# line 413 "edi_lo.yac"
{ 
			if(EDIFL_MODE == 'A') strcpy (EDIFL_INS_MODELNAME, ediflpvt[-1].sval); 
		  } break;
case 52:
# line 417 "edi_lo.yac"
{ 
			if ((EDIFL_MODE == 'A')) strcpy (EDIFL_INS_MODELNAME, ediflpvt[-2].sval); 
		  } break;
case 54:
# line 426 "edi_lo.yac"
{ 
if (no_figure_to_load == 0) {
			if (EDIFL_MODE == 'A') {
				EDIFL_PTSIG = addlosig (EDIFL_PTFIG, ++index, 
				    addchain (NULL, namealloc (ediflpvt[-0].sval)), 'Z', NULL);
				EDIFL_SIGTYPE = 'I';
			}
}
		  } break;
case 55:
# line 436 "edi_lo.yac"
{ 
if (no_figure_to_load == 0) {
			if (EDIFL_MODE == 'A') EDIFL_PTSIG->TYPE = EDIFL_SIGTYPE; 
}
		  } break;
case 56:
# line 442 "edi_lo.yac"
{
if (no_figure_to_load == 0) {
                        int i;
                        char port_name[100];

			if (ediflpvt[-1].lval <= 0)
				{ 
				  printf("\n*** mbk error *** edifloadlofig : Array width must be > 0\n");
				  exit (1); 
				}

			if (EDIFL_MODE == 'A') 
                           for (i=0; i < ediflpvt[-1].lval; i++) {
                                sprintf(&port_name[0], "%s %d", ediflpvt[-2].sval, i); 
                                EDIFL_PTSIG = addlosig (EDIFL_PTFIG, ++index,
                                    addchain (NULL, namealloc (port_name)), 'Z', NULL);
                                EDIFL_SIGTYPE = 'I';
				EDIFL_BUS_WIDTH = ediflpvt[-1].lval;
                           }
}
		  } break;
case 57:
# line 464 "edi_lo.yac"
{
if (no_figure_to_load == 0) {
			int 		i;
		     	losig_list  	*ptsig;

                        if (EDIFL_MODE == 'A') 
			{
				ptsig = EDIFL_PTSIG; 
			   	for (i = EDIFL_BUS_WIDTH - 1; i >= 0; i--) {
					ptsig->TYPE = EDIFL_SIGTYPE;
					ptsig = ptsig->NEXT;
			     	}
			}
}
                  } break;
case 65:
# line 500 "edi_lo.yac"
{ 

if (no_figure_to_load == 0) {
		    int 	i;
                    char 	port_name[100];
		    losig_list 	*ptsig;

                    if (EDIFL_MODE == 'A') {
			ptsig = EDIFL_PTSIG;
                        if (bus_nameref(EDIFL_PTFIG->LOCON, ediflpvt[-1].sval, EDIFL_BUS_WIDTH))
                        {
			   for (i = EDIFL_BUS_WIDTH - 1; i >= 0; i--)
			    {
                                sprintf(&port_name[0], "%s %d", ediflpvt[-1].sval, i); 
                                EDIFL_PTCON = getlocon (EDIFL_PTFIG, &port_name[0]);
                                EDIFL_PTCON->SIG = ptsig;
				ptsig = ptsig->NEXT;
                                if (TRACE_MODE == 'Y') {
                                        printf ("--- mbk --- edifloadlofig : signal %s on ",
                                        EDIFL_PTCON->SIG->NAMECHAIN->DATA);
                                        printf ("connector %s\n", EDIFL_PTCON->NAME);
                                }
			    }
                           EDIFL_SIGTYPE = 'E';
                        }
                        else {
				printf ("\n*** mbk error *** edifloadlofig : "); 
                                printf ("\n    Connector '%s' in figure '%s' do not refer to an ARRAY construct", ediflpvt[-1].sval, EDIFL_PTFIG->NAME); 
				printf ("\n    or it is a bus with incompatible width than Signal Bus");
                                exit (1);
                        }
                    }
}
                  } break;
case 66:
# line 536 "edi_lo.yac"
{ 

if (no_figure_to_load == 0) {
		    int         i;
                    char        port_name[100];
                    losig_list  *ptsig; 

                    if (EDIFL_MODE == 'A') {
			ptsig = EDIFL_PTSIG;
                        EDIFL_PTINS = getloins (EDIFL_PTFIG, ediflpvt[-2].sval);
			if (bus_nameref(EDIFL_PTINS->LOCON, ediflpvt[-4].sval, EDIFL_BUS_WIDTH))
                        {
                                sprintf(&port_name[0], "%s %d", ediflpvt[-4].sval, EDIFL_BUS_WIDTH - 1); 
                        	EDIFL_PORTNAME = namealloc (&port_name[0]);
                        	for (EDIFL_PTCON = EDIFL_PTINS->LOCON; EDIFL_PTCON;
                             		EDIFL_PTCON = EDIFL_PTCON->NEXT)
                                	if (EDIFL_PORTNAME == EDIFL_PTCON->NAME) break;

				if (EDIFL_PTCON == (locon_list *) NULL) {
                                	printf ("*** mbk *** edifloadlofig error : ");
                                	printf ("bus connector %s not found ", ediflpvt[-4].sval);
                                	printf (" in instance %s", ediflpvt[-2].sval);
                                	printf (" of figure %s\n", EDIFL_PTINS->FIGNAME);
                                	exit (1);
				}
				else {
			    		for (i = EDIFL_BUS_WIDTH - 1; (i >= 0) && EDIFL_PTCON; i--)
                             		{
					 	EDIFL_PTCON->SIG = ptsig;
                                                ptsig = ptsig->NEXT;
                                                if (TRACE_MODE == 'Y') {
                                                       printf("*** mbk error *** edifloadlofig : ");
                                                       printf("signal %s",EDIFL_PTCON->SIG->NAMECHAIN->DATA);                       
                                                       printf(" on connector %s", EDIFL_PTCON->NAME);                               
                                                       printf(" of instance %s", ediflpvt[-2].sval);
                                                       printf(" of figure %s\n", EDIFL_PTINS->FIGNAME);                             
                                                }
						EDIFL_PTCON = EDIFL_PTCON->NEXT;
					}
				}

			}
			else  {
				for (EDIFL_PTCON = EDIFL_PTINS->LOCON; EDIFL_PTCON; EDIFL_PTCON = EDIFL_PTCON->NEXT)
					if (EDIFL_PTCON->NAME == namealloc(ediflpvt[-4].sval)) break;

                                printf ("\n*** mbk error *** edifloadlofig : ");  
				if (EDIFL_PTCON) {
                                	printf ("\n    Connector '%s' in instance '%s' of figure '%s' do not refer", 
						ediflpvt[-4].sval, ediflpvt[-2].sval, EDIFL_PTFIG->NAME); 
					printf ("\n    to an ARRAY construct or it is a bus with incompatible width than Signal Bus");
                                	exit (1);
				}
				else {
					printf ("\n    Connector '%s' not found on instance '%s'\n", ediflpvt[-4].sval, ediflpvt[-2].sval);	
					exit(1);
				} 
			}

                    }
}
                  } break;
case 71:
# line 611 "edi_lo.yac"
{ 

if (no_figure_to_load == 0) {
		    if (EDIFL_MODE == 'A') {
			EDIFL_PTCON = getlocon (EDIFL_PTFIG, ediflpvt[-1].sval);
			EDIFL_PTCON->SIG = EDIFL_PTSIG;
			if (TRACE_MODE == 'Y') {
				printf ("--- mbk --- edifloadlofig : signal %s on ",
				EDIFL_PTSIG->NAMECHAIN->DATA);
				printf ("connector %s\n", EDIFL_PTCON->NAME);
			}
			EDIFL_SIGTYPE = 'E';
		    }
}
		  } break;
case 72:
# line 627 "edi_lo.yac"
{ 
if (no_figure_to_load == 0) {
		    if (EDIFL_MODE == 'A') { 
                        EDIFL_PTINS = getloins (EDIFL_PTFIG, ediflpvt[-2].sval);
			EDIFL_PORTNAME = namealloc (ediflpvt[-4].sval);
			for (EDIFL_PTCON = EDIFL_PTINS->LOCON; EDIFL_PTCON;
			     EDIFL_PTCON = EDIFL_PTCON->NEXT) {
				if (EDIFL_PORTNAME == EDIFL_PTCON->NAME) {
					EDIFL_PTCON->SIG = EDIFL_PTSIG;
					if (TRACE_MODE == 'Y') {
						printf ("--- mbk --- edifloadlofig : ");
						printf ("signal %s", EDIFL_PTSIG->NAMECHAIN->DATA);
						printf (" on connector %s", EDIFL_PTCON->NAME);
						printf (" of instance %s", ediflpvt[-2].sval);
						printf (" of figure %s\n", EDIFL_PTINS->FIGNAME);
					}
					break;
				}
			}
			if (EDIFL_PTCON == NULL) {
				printf ("*** mbk *** edifloadlofig error : ");
				printf ("connector %s not found ", ediflpvt[-4].sval);
				printf (" in instance %s", ediflpvt[-2].sval);
				printf (" of figure %s\n", EDIFL_PTINS->FIGNAME);
				exit (1);
			}
		    }
}
		  } break;
case 73:
# line 657 "edi_lo.yac"
{

if (no_figure_to_load == 0) {
		    char 	port_name[100];

		    if (EDIFL_MODE == 'A') {
			sprintf(&port_name[0], "%s %d", ediflpvt[-3].sval, ediflpvt[-2].lval);
			EDIFL_PTCON = getlocon (EDIFL_PTFIG, port_name);
			EDIFL_PTCON->SIG = EDIFL_PTSIG;
			if (TRACE_MODE == 'Y') {
			   	printf ("--- mbk --- edifloadlofig : signal %s on ",
				EDIFL_PTSIG->NAMECHAIN->DATA);
				printf ("connector %s\n", EDIFL_PTCON->NAME);
			}
			EDIFL_SIGTYPE = 'E';
		    }
}
		  } break;
case 74:
# line 676 "edi_lo.yac"
{

if (no_figure_to_load == 0) {
		    char 	port_name[100];

		    if (EDIFL_MODE == 'A') {
                        EDIFL_PTINS = getloins (EDIFL_PTFIG, ediflpvt[-2].sval);
                        sprintf(&port_name[0], "%s %d", ediflpvt[-6].sval, ediflpvt[-5].lval);
                        EDIFL_PORTNAME = namealloc (&port_name[0]);
                        for (EDIFL_PTCON = EDIFL_PTINS->LOCON; EDIFL_PTCON;
                             EDIFL_PTCON = EDIFL_PTCON->NEXT) {
                                if (EDIFL_PORTNAME == EDIFL_PTCON->NAME) {
                                        EDIFL_PTCON->SIG = EDIFL_PTSIG;
                                        if (TRACE_MODE == 'Y') {
                                                printf ("--- mbk --- edifloadlofig : ");
                                                printf ("signal %s", EDIFL_PTSIG->NAMECHAIN->DATA);
                                                printf (" on connector %s", EDIFL_PTCON->NAME);
                                                printf (" of instance %s", ediflpvt[-2].sval);
                                                printf (" of figure %s\n", EDIFL_PTINS->FIGNAME);
                                        }
                                        break;
                                }
                        }
                        if (EDIFL_PTCON == NULL) {
                                printf ("*** mbk *** edifloadlofig error : ");
                                printf ("connector %s not found ", port_name);
                                printf (" in instance %s", ediflpvt[-2].sval);
                                printf (" of figure %s\n", EDIFL_PTINS->FIGNAME);
                                exit (1);
                        }
                    }
}
		  } break;
case 81:
# line 724 "edi_lo.yac"
{ 

if (no_locon_to_load == 0) {
			if ((EDIFL_MODE == 'A') || (EDIFL_PTFIG == EDIFL_LOFIG)) 
				addlocon (EDIFL_PTFIG, ediflpvt[-2].sval, NULL ,EDIFL_DIRECTION);
}
		  } break;
case 82:
# line 732 "edi_lo.yac"
{
if (no_locon_to_load == 0) {
                        int i;
                        char port_name[100];

			if (ediflpvt[-3].lval <= 0)
			  { 
			     printf("\n*** mbk error *** edifloadlofig : Array width must be > 0\n"); 
			     exit (1); 
			  }

                        if ((EDIFL_MODE == 'A') || (EDIFL_PTFIG == EDIFL_LOFIG)) 
			{
                           for (i=0; i < ediflpvt[-3].lval; i++) {
                                sprintf(&port_name[0], "%s %d", ediflpvt[-4].sval, i); 
                                addlocon (EDIFL_PTFIG, &port_name[0], NULL ,EDIFL_DIRECTION);
                           }
                        }   
}
                  } break;
case 87:
# line 763 "edi_lo.yac"
{ 
			EDIFL_DIRECTION = 'X'; 
		  } break;
case 88:
# line 767 "edi_lo.yac"
{ 
			EDIFL_DIRECTION = 'I'; 
		  } break;
case 89:
# line 771 "edi_lo.yac"
{ 
			EDIFL_DIRECTION = 'O'; 
		  } break;
case 94:
# line 785 "edi_lo.yac"
{ 
			strcpy(ediflval.sval, ediflpvt[-0].sval); 
		  } break;
case 95:
# line 789 "edi_lo.yac"
{ 
			sprintf(EDIFL_TMP, "%ld", ediflpvt[-0].lval); strcpy(ediflval.sval, EDIFL_TMP); 
		  } break;
case 96:
# line 793 "edi_lo.yac"
{
			strcpy(ediflval.sval, ediflpvt[-2].sval); 
		  } break;
case 97:
# line 797 "edi_lo.yac"
{
			strcpy(ediflval.sval, ediflpvt[-2].sval);
		  } break;
case 98:
# line 803 "edi_lo.yac"
{
			strcpy(ediflval.sval, ediflpvt[-1].sval); 
		  } break;
	}
	goto ediflstack;		/* reset registers in driver code */
}
