/************************************************************************
*       MBK : Driver alliance physic                                    *
*                                                                       *
*	version : 3.04					                                    *
*	date	: 31/07/92				                                    *
************************************************************************/

#include "generic_target.h"
#include MUT_H 
#include MPH_H 

#ident "@(#)Driver alliance physic v3.04 31/07/92 by Vincent POUILLEY"

#define TAILLE_CHAINE 64

/************************************************************************
*                  calculphfig_boundingbox()                            *
************************************************************************/

calculphfig_boundingbox(pfig,nbdes,xmin,ymin,xmax,ymax)
phfig_list * pfig;
long * nbdes, * xmin, * ymin, * xmax, * ymax;
{
	phcon_list * pcon;
	phseg_list * pseg;
	phref_list * pref;
	phins_list * pins;
	phvia_list * pvia;

	*xmin = pfig->XAB1;
	*ymin = pfig->YAB1;
	*xmax = pfig->XAB2;
	*ymax = pfig->YAB2;
	for(pcon = pfig->PHCON, *nbdes = 1; pcon != NULL; pcon = pcon->NEXT, (*nbdes) ++)
		{
		*xmin = (pcon->XCON - (pcon->WIDTH>>1) < *xmin) ? pcon->XCON - (pcon->WIDTH>>1) : *xmin;
		*ymin = (pcon->YCON - (pcon->WIDTH>>1) < *ymin) ? pcon->YCON - (pcon->WIDTH>>1) : *ymin;
		*xmax = (pcon->XCON + (pcon->WIDTH>>1) > *xmax) ? pcon->XCON + (pcon->WIDTH>>1) : *xmax;
		*ymax = (pcon->YCON + (pcon->WIDTH>>1) > *ymax) ? pcon->YCON + (pcon->WIDTH>>1) : *ymax;
		}
	for(pseg = pfig->PHSEG; pseg != NULL; pseg = pseg->NEXT, (*nbdes) ++)
		{
		if (pseg->X1 == pseg->X2)
			{
			*xmin = ((pseg->X1 - (pseg->WIDTH>>1)) < *xmin) ? pseg->X1 - (pseg->WIDTH>>1) : *xmin;
			*ymin = ((pseg->Y1 - SCALE_X) < *ymin) ? pseg->Y1 - SCALE_X : *ymin;
			*xmax = ((pseg->X2 + (pseg->WIDTH>>1)) > *xmax) ? pseg->X2 + (pseg->WIDTH>>1) : *xmax;
			*ymax = ((pseg->Y2 + SCALE_X) > *ymax) ? pseg->Y2 + SCALE_X : *ymax;
			}
		else
			{
			*xmin = ((pseg->X1 - SCALE_X) < *xmin) ? pseg->X1 - SCALE_X : *xmin;
			*ymin = ((pseg->Y1 - (pseg->WIDTH>>1)) < *ymin) ? pseg->Y1 - (pseg->WIDTH>>1) : *ymin;
			*xmax = ((pseg->X2 + SCALE_X) > *xmax) ? pseg->X2 + SCALE_X : *xmax;
			*ymax = ((pseg->Y2 + (pseg->WIDTH>>1)) > *ymax) ? pseg->Y2 + (pseg->WIDTH>>1) : *ymax;
			}
		}
	for(pvia = pfig->PHVIA; pvia != NULL; pvia = pvia->NEXT, (*nbdes) ++)
		{
		*xmin = (pvia->XVIA - SCALE_X < *xmin) ? pvia->XVIA - SCALE_X : *xmin;
		*ymin = (pvia->YVIA - SCALE_X < *ymin) ? pvia->YVIA - SCALE_X : *ymin;
		*xmax = (pvia->XVIA + SCALE_X > *xmax) ? pvia->XVIA + SCALE_X : *xmax;
		*ymax = (pvia->YVIA + SCALE_X > *ymax) ? pvia->YVIA + SCALE_X : *ymax;
		}
	for(pref = pfig->PHREF; pref != NULL; pref = pref->NEXT, (*nbdes) ++)
		{
		*xmin = (pref->XREF - SCALE_X < *xmin) ? pref->XREF - SCALE_X : *xmin;
		*ymin = (pref->YREF - SCALE_X < *ymin) ? pref->YREF - SCALE_X : *ymin;
		*xmax = (pref->XREF + SCALE_X > *xmax) ? pref->XREF + SCALE_X : *xmax;
		*ymax = (pref->YREF + SCALE_X > *ymax) ? pref->YREF + SCALE_X : *ymax;
		}
	for(pins = pfig->PHINS; pins != NULL; pins = pins->NEXT, (*nbdes) ++)
		{
		*xmin = (pins->XINS < *xmin) ? pins->XINS : *xmin;
		*ymin = (pins->YINS < *ymin) ? pins->YINS : *ymin;
		*xmax = (pins->XINS > *xmax) ? pins->XINS : *xmax;
		*ymax = (pins->YINS > *ymax) ? pins->YINS : *ymax;
		}
	*xmin -= SCALE_X;
	*ymin -= SCALE_X;
	*xmax += SCALE_X;
	*ymax += SCALE_X;
}		

/************************************************************************
*                  get_date()                                           *
************************************************************************/

static void get_date(date)
char * date;
{
time_t tim;
struct tm *rest;

	(void)time(&tim);
        rest=localtime(&tim);
	(void)sprintf(date,"%2d/%2d/%2d",rest->tm_mday,rest->tm_mon,rest->tm_year);
}

/************************************************************************
*                  alc_decodelayer()                                    *
************************************************************************/

char * alc_decodelayer(layer)
char layer;
{
	static char * alc_decode[LAST_LAYER + 1] =
		{ "CAISSON_N", "CAISSON_P", "DIFN", "DIFP", "DIFN", "DIFP",
		"NTRANS", "PTRANS", "POLY", "ALU1", "ALU2", "ALU3", "T_POLY",
		"T_ALU1", "T_ALU2", "TALU3" };

	if (layer < 0 || layer > LAST_LAYER && layer != ALU3 && layer != TALU3)
		{
		(void)fprintf(stderr, "\n*** mbk error ***");
		(void)fprintf(stderr, " Layer out of range for alc\n");
		return "NULL";
		}
	return alc_decode[layer];
}

/************************************************************************
*                  alc_decodevia()                                      *
************************************************************************/

char * alc_decodevia(type,aux)
int type;
char * aux;
{
	static char *alc_ndecode[9] = { "CONT_POLY", "CONT_VIA", "CONT_DIF_N", "CONT_DIF_P", "CONT_DIF_N", "CONT_DIF_P", "C_X_N", "C_X_P" };
	static char alc_decode[9] = { 0, 3, 1, 2, 1, 2, 4, 5 };

	if (type < 0 || type > 7)
		{
		(void)fprintf(stderr,"\n*** mbk error *** unknow via\n");
		EXIT(1);
		}
	*aux = alc_decode[type];
	return alc_ndecode[type];
}

/************************************************************************
*                  alc_decoderef()                                      *
************************************************************************/

char * alc_decoderef(figname,aux)
char * figname;
char * aux;
{
#define MAXREF 2
	static char * alc_decode[MAXREF] = { 
		"REF_REF", 
		"REF_CON", 
		};
/*
  fred petrot le 17/09/90 car cette exotique fonction n'existe pas dans
  la bibliotheque NCR.
*/
	static char * alc_decode2[MAXREF] = { 
		"ref_ref", 
		"ref_con", 
		};
	int i;

	for(i = 0; i < MAXREF; i++)
	{
		if (strncmp(figname, alc_decode[i],9) == 0)
			{
			*aux = i + 7;
			return alc_decode[i];
			}
		if (strncmp(figname, alc_decode2[i],9) == 0)
			{
			*aux = i + 7;
			return alc_decode[i];
			}
	}
	return NULL;
}

/************************************************************************
*                  alc_decodetransf()                                   *
************************************************************************/

char * alc_decodetransf(transf)
char transf;
{
	static char * alc_decode[8] = { "NOSYM", "ROT_P", "SYMXY", "ROT_M", "SYM_X", "SY_RM", "SYM_Y", "SY_RP" };

	if ((transf < 0) || (transf > 7))
		{
		(void)fprintf(stderr,"\n*** mbk error *** unknow transformation\n");
		return "NOSYM";
		}
	return alc_decode[transf];
}

/************************************************************************
*                  alcsavephfig()                                       *
************************************************************************/

void alcsavephfig(pfig)
phfig_list * pfig;
{
	phcon_list * pcon;
	phseg_list * pseg;
	phref_list * pref;
	phins_list * pins;
	phvia_list * pvia;
	FILE *in;
	char nomfic[TAILLE_CHAINE], nomp[TAILLE_CHAINE];
	char * string, jp_layer;
	long nbdes;
	long xmin,ymin,xmax,ymax,l;
	long j;
	char aux,sens;
	long orient;
	long i;

	if (alc_strtophtrs(pfig->NAME,&jp_layer,&j,&j))
		{
		(void)fprintf(stderr,"\n*** mbk error *** bad file name : %s\n",pfig->NAME);
		EXIT(1);
		}
	(void)sprintf(nomfic,"%s/%s.%s",WORK_LIB,pfig->NAME,OUT_PH);
	in=mbkfopen(pfig->NAME, OUT_PH, WRITE_TEXT);
	if(!in)
		{
		(void)fprintf(stderr,"\n*** mbk error *** can't open file : %s\n",nomfic);
		EXIT(1);
		}
	if (TRACE_MODE == 'Y')
		{
		(void)printf("\n--- mbk --- writing the file : %s\n",nomfic);
		}
	calculphfig_boundingbox(pfig,&nbdes,&xmin,&ymin,&xmax,&ymax);
	(void)fprintf(in,"V ALLIANCE 2.2 SETUP : 2\n");
	for(pcon = pfig->PHCON, i =0; pcon != NULL; pcon = pcon->NEXT, i++);
	(void)fprintf(in,"H %s,P,%d,%d,",pfig->NAME,i,nbdes);
	get_date(nomp);
	(void)fprintf(in,"%s,-1,PAS A JOUR,0,0,%d,%d,%d,%d,%d,%d\n", nomp, (xmax-xmin)/SCALE_X, (ymax-ymin)/SCALE_X, (pfig->XAB1 - xmin)/SCALE_X, (pfig->YAB1 - ymin)/SCALE_X,(pfig->XAB2 - pfig->XAB1)/SCALE_X, (pfig->YAB2 - pfig->YAB1)/SCALE_X);
	for(pcon = pfig->PHCON, j =0; pcon != NULL; pcon = pcon->NEXT, j++)
		{
		(void)fprintf(in,"C %d,%d,%d,%d,",j,(pcon->XCON - xmin)/SCALE_X,(pcon->YCON - ymin)/SCALE_X,pcon->WIDTH/SCALE_X);
		orient = pcon->ORIENT;
		switch(orient)
			{
			case NORTH :
				(void)fputs("NORD,",in);
				break;
			case SOUTH :
				(void)fputs("SUD,",in);
				break;
			case EAST :
				(void)fputs("EST,",in);
				break;
			case WEST :
				(void)fputs("OUEST,",in);
				break;
			}
		(void)fprintf(in,"%s,%s,INOUT,-1,FIN\n",alc_decodelayer(pcon->LAYER),pcon->NAME);
		}
	j++;
	for(pseg = pfig->PHSEG; pseg != NULL; pseg = pseg->NEXT, j++)
		{
		if (pseg->TYPE == HOR)
			{
			sens='H';
			l = (pseg->X2 - pseg->X1)/SCALE_X;
			}
		else
			{
			sens='V';
			l = (pseg->Y2 - pseg->Y1)/SCALE_X;
			}
		if ((pseg->LAYER == NTRANS) || (pseg->LAYER == PTRANS))
			{
			if (l < 4)
			  {
			  (void)fprintf(stderr, "\n*** mbk error *** lenght of transistor less than 4\n");
			  EXIT(1);
			  }
			(void)sprintf(nomp,"T%c_%d_%d", (pseg->LAYER == NTRANS)? 'N': 'P', l, pseg->WIDTH/SCALE_X);
			(void)fprintf(in,"T %d,%d,%d,%s,%s,%s,-1,FIN\n", j, (pseg->X1 - xmin)/SCALE_X, (pseg->Y1 - ymin)/SCALE_X, pseg->NAME == NULL?"*":pseg->NAME, nomp, (sens == 'H')? "ROT_P": "NOSYM");
			}
		else
			{
			(void)fprintf(in,"S %d,%d,%d,%d,%d,%c,%s,%s,-1,FIN\n", j, (pseg->X1 - xmin)/SCALE_X, (pseg->Y1 - ymin)/SCALE_X, l, pseg->WIDTH/SCALE_X, sens, alc_decodelayer(pseg->LAYER),(pseg->NAME == NULL)?"*":pseg->NAME);
			}
		}
	for(pvia = pfig->PHVIA; pvia != NULL; pvia = pvia->NEXT, j++)
		{
		string = alc_decodevia(pvia->TYPE,&aux);
		(void)fprintf(in,"M %d,%d,%d,*,%s,%d,-1,FIN\n", j, (pvia->XVIA - xmin)/SCALE_X, (pvia->YVIA - ymin)/SCALE_X, string, aux);
		}
	for(pref = pfig->PHREF; pref != NULL; pref = pref->NEXT, j++)
		{
		string = alc_decoderef(pref->FIGNAME,&aux);
		if (string == NULL)
			{
			(void)fprintf(stderr,"\n*** mbk error *** inconsistant reference : %s\n",pref->FIGNAME);
			(void)fprintf(in,"M %d,%d,%d,%s,REF,7,-1,FIN\n",j, (pref->XREF - xmin)/SCALE_X, (pref->YREF - ymin)/SCALE_X, pref->FIGNAME);
			}
		else
			{
			(void)fprintf(in,"M %d,%d,%d,%s,%s,%d,-1,FIN\n",j ,(pref->XREF - xmin)/SCALE_X, (pref->YREF - ymin)/SCALE_X, pref->NAME, string, aux);
			}
		}
	for(pins = pfig->PHINS; pins != NULL; pins = pins->NEXT, j++)
		{
		string = alc_decodetransf(pins->TRANSF);
		(void)fprintf(in,"I %d,%d,%d,%s,%s,%s,-1,FIN\n", j, (pins->XINS - xmin)/SCALE_X, (pins->YINS - ymin)/SCALE_X, pins->INSNAME, pins->FIGNAME, string);
		}
	(void)fputs("EOF\n",in);
	if (fclose(in) != 0)
		{
		(void)fprintf(stderr,"\n*** mbk error *** can't close file : %s\n",nomfic);
		EXIT(1);
		}
} /* savephfig */
