/******************************************************************************/
/*                                                                            */
/* This file is part of the sources of the masi-cao&vlsi cad tools            */
/*              version 2.0                                                   */
/*                                                                            */
/* version 1.0 was develloped by Edmond Janssen & Eric Playe, in june 1991,   */
/*             under the supervision of Frederic Petrot                       */
/*                                                                            */
/* version 2.0 is basically a version 1.0 extension written in august 1991    */
/*             by Frederic Petrot                                             */
/*                                                                            */
/* Please report the bugs at e-mail : cao-vlsi@masi.ibp.fr                    */
/*                                                                            */
/* File : ps.c                                                                */
/*                                                                            */
/******************************************************************************/
#include MUT_H
#include "ps.h"
static char Buffer[BUFSIZ];

void header(PS_file, Title, Creator, SuppliedProcSet, SuppliedFont)
FILE *PS_file;
char *Title;
char *Creator;
char *SuppliedProcSet;
char *SuppliedFont;
{
long int Time;

	time(&Time);
	fprintf(PS_file, "%%!PS-Adobe-%s\n", PS_version);
	fprintf(PS_file, "%%%%Title: %s\n", Title);
	fprintf(PS_file, "%%%%Creator: %s\n", Creator);
	fprintf(PS_file, "%%%%For: %s\n", getenv("LOGNAME"));
	fprintf(PS_file, "%%%%CreationDate: %s", ctime(&Time));
	fprintf(PS_file, "%%%%DocumentSuppliedProcSet: %s\n", SuppliedProcSet);
	fprintf(PS_file, "%%%%DocumentSuppliedFonts: %s\n", SuppliedFont);
}

void endheader(PS_file)
FILE *PS_file;
{
	fputs("%%EndComments\n\n", PS_file);
}

int prologue(PS_file, PS_dict_name)
FILE *PS_file;
char *PS_dict_name;
{
FILE *PS_dict;

	sprintf(Buffer, "%s/%s", PS_DICT_PATH, PS_dict_name);
	if (!(PS_dict = fopen(Buffer, "r")))
	   return 0;

	fputs("%%BeginProcSet: ", PS_file);
	fgets(Buffer, BUFSIZ, PS_dict);
	while (!feof(PS_dict)) {
		fputs(Buffer, PS_file);
		fgets(Buffer, BUFSIZ, PS_dict);
	}
	fputs("%%EndProcSet\n", PS_file);
	fputs("%%EndProlog\n\n", PS_file);
	fclose(PS_dict);

	return 1;
}

void setup(PS_file, SetUp)
FILE *PS_file;
char *SetUp;
{
	fputs("%%BeginSetup\n", PS_file);
	fputs(SetUp, PS_file);
	fputs("\n%%EndSetup\n\n", PS_file);
}

int includefont(PS_file, PS_font_name)
FILE *PS_file;
char *PS_font_name;
{
FILE *PS_font;

	sprintf(Buffer, "%s/%s", PS_DICT_PATH, PS_font_name);
	if (!(PS_font = fopen(Buffer, "r")))
	   return 0;

	fputs("%%BeginFont: ", PS_file);
	fgets(Buffer, BUFSIZ, PS_font);
	while (!feof(PS_font)) {
	   fputs(Buffer, PS_file);
	   fgets(Buffer, BUFSIZ, PS_font);
	}
	fputs("%%EndFont\n\n", PS_file);
	fclose(PS_font);
	return 1;
}

void trailer(PS_file)
FILE *PS_file;
{
	fputs("%%Trailer\n", PS_file);
	fputs("%%EndComments\n\n", PS_file);
}
