/******************************************************************************/
/*	                                                                           */
/* This file is part of the sources of the masi-cao&vlsi cad tools            */
/*	             version 2.0                                                   */
/*	                                                                           */
/*	version 1.0 was develloped by Edmond Janssen & Eric Playe, in june 1991,   */
/*	            under the supervision of Frederic Petrot                       */
/*	                                                                           */
/*	version 2.0 is basically a version 1.0 extension written in august 1991    */
/*	            by Frederic Petrot                                             */
/*	                                                                           */
/*	Please report the bugs at e-mail : cao-vlsi@masi.ibp.fr                    */
/*	                                                                           */
/*	File : mrgltypes.h                                                         */
/*	                                                                           */
/******************************************************************************/

typedef int lambda;
typedef int unit;

typedef struct of_point_link {
	struct of_point_link *NEXT;
	lambda		      X, Y;
	} point_link;

typedef struct of_points_chain {
	struct of_point_link *START, *END;
	} points_chain;

typedef struct of_path_link {
	struct of_path_link  *NEXT;
	struct of_point_link *PATH;
	} path_link;

typedef struct of_rect_link {
	struct of_rect_link *NEXT;
	lambda		     X0, Y0, X1, Y1;
	} rect_link;

typedef struct of_cluster {
	int	MERGED;
	unit	Iref, Jref;
	} cluster;
