/*-----------------------------------------------------*\
|                                                       |
|  Title   :   Structures and fonctions for RDS         |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :        Jacomme Ludovic                     |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                    Les constantes                     |
\------------------------------------------------------*/

#ifndef RDSLIB101
#define RDSLIB101

#  define TRUE  1
#  define FALSE 0
#  define ERROR 1
#  define OK    0


/*-----------------------------------------------------*\
|                         Mbk Type                      |
\------------------------------------------------------*/

#  define MBK_CONNECTOR 0
#  define MBK_SEGMENT   1
#  define MBK_CONTACT   2         
#  define MBK_REFERENCE 3
#  define MBK_VIA       4
#  define MBK_INSTANCE  5
#  define MBK_FIGURE    6
#  define MBK_UNKNOWN   7

#  define RDS_MAX_MBK_TYPE   MBK_UNKNOWN + 1

/*-----------------------------------------------------*\
|                      Extract Type                     |
\------------------------------------------------------*/

#  define RDS_NONE       0
#  define RDS_SEG_BANAL  1
#  define RDS_SEG_GRILLE 2        
#  define RDS_SEG_DRAIN  3
#  define RDS_SEG_SOURCE 4
#  define RDS_CON_EXTER  5
#  define RDS_CON_INTER  6
#  define RDS_REF_REF    7
#  define RDS_REF_CON    8
  
#  define RDS_MAX_EXTRACT    RDS_REF_CON + 1

/*-----------------------------------------------------*\
|           Transformations  pour les instances         |
\------------------------------------------------------*/

#  define RDS_NOSYM  0
#  define RDS_ROT_P  1
#  define RDS_SYMXY  2
#  define RDS_ROT_M  3
#  define RDS_SYM_X  4
#  define RDS_SY_RM  5
#  define RDS_SYM_Y  6
#  define RDS_SY_RP  7

#  define RDS_MAX_TRANSF    RDS_SY_RP + 1

/*-----------------------------------------------------*\
|             Les differents layers pour RDS            |
\------------------------------------------------------*/

#  define RDS_NWELL   0
#  define RDS_PWELL   1
#  define RDS_NDIF    2
#  define RDS_PDIF    3
#  define RDS_NTIE    4
#  define RDS_PTIE    5
#  define RDS_POLY    6
#  define RDS_GATE    7
#  define RDS_TPOLY   8
#  define RDS_CONT    9
#  define RDS_ALU1    10
#  define RDS_TALU1   11
#  define RDS_VIA1    12
#  define RDS_ALU2    13
#  define RDS_TALU2   14
#  define RDS_VIA2    15
#  define RDS_ALU3    16
#  define RDS_TALU3   17
#  define RDS_REF     18
#  define RDS_ABOX    19
#  define RDS_DEFAULT 20

#  define RDS_MAX_LAYER   RDS_DEFAULT + 1

/*-----------------------------------------------------*\
|                       Les types                       |
\------------------------------------------------------*/

  typedef unsigned char byte;
  typedef unsigned int  word;
  typedef unsigned char boolean;

  typedef struct rds_rectangle

  {
    struct rds_rectangle *next;
    long                  x;
    long                  y;
    long                  dx;
    long                  dy;
    void                 *mbk;

    union 
    {
      char                 *name;
      struct rds_rectangle *link;
    } u_rec;

    struct rds_rectangle *equi;
    void                 *user;
    char                  mbk_type;
    char                  layer;
    char                  flags;
    char                  extract_type;
  } rds_rec;


  typedef struct rds_instance

  {
    struct rds_instance  *next;
    char                 *mod_name;
    char                 *ins_name;
    void                 *mbk;
    long                  x;
    long                  y;
    char                  transf;
    struct rds_rectangle *layertab[ RDS_MAX_LAYER ];
    struct rds_rectangle *couronne[ RDS_MAX_LAYER ];
    void                 *user;
  } rds_ins;

 
  typedef struct rds_figure
 
  {
    struct rds_figure    *next;
    char                 *name;
    struct rds_rectangle *layertab[ RDS_MAX_LAYER ];
    struct rds_instance  *instance;
    void                 *mbk;
    char                  mode;
    char                  flag;
    char                  flagtab[ RDS_MAX_LAYER ];
    struct rds_rectangle *bboxtab[ RDS_MAX_LAYER ];
    void                 *translist;
    void                 *user;
  } rds_fig;
 
/*-----------------------------------------------------*\
|                 Les variables globales                |
\------------------------------------------------------*/

 extern rds_fig *HeadFigureRds;

/*-----------------------------------------------------*\
|                    Les fonctions                      |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|              Allocation d'une structure               |
\------------------------------------------------------*/

  extern char *RAZStruct();
 
/*-----------------------------------------------------*\
|           Les fonctions d'Allocation d'objets         |
\------------------------------------------------------*/

  extern rds_fig *AllocFigureRds();
  extern rds_ins *AllocInstanceRds();
  extern rds_rec *AllocRectangleRds();

/*-----------------------------------------------------*\
|          Les fonctions de Liberation d'objets         |
\------------------------------------------------------*/

  extern void FreeFigureRds();
  extern void FreeInstanceRds();
  extern void FreeRectangleRds();

/*-----------------------------------------------------*\
|           Les fonctions de Creation d'objets          |
\------------------------------------------------------*/

  extern rds_rec *AddRectangleInsRds();
  extern rds_rec *AddRectangleFigRds();
  extern rds_ins *AddInstanceRds();
  extern rds_fig *AddFigureRds();

/*-----------------------------------------------------*\
|          Les fonctions de Recherche d'objets          |
\------------------------------------------------------*/

  extern rds_fig *GetFigureRds();
  extern rds_rec *GetRectangleByPoint();

/*-----------------------------------------------------*\
|                 Les fonctions diverses                |
\------------------------------------------------------*/

   extern long GetBoundingBox();

/*-----------------------------------------------------*\
|          Les fonctions de Destruction d'objets        |
\------------------------------------------------------*/

  extern boolean DelRectangleInsRds();
  extern boolean DelRectangleFigRds();
  extern boolean DelInstanceRds();
  extern boolean DelFigureRds();

  extern void    DelListRectangleInsRds();
  extern void    DelListRectangleFigRds();
  extern void    DelListInstanceRds();
  extern void    DelListFigureRds();

/*-----------------------------------------------------*\
|      Les fonctions de Visualisation d'objets          |
\------------------------------------------------------*/

  extern void ViewRectangleRds();
  extern void ViewInstanceRds();
  extern void ViewFigureRds();

  extern long ViewListRectangleRds();
  extern void ViewListInstanceRds();
  extern void ViewListFigureRds();

#endif
