/*-----------------------------------------------------*\
|                                                       |
|  Title   :               LYNX                         |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :          Jacomme Ludovic                   |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                Les fichiers a inclure                 |
\------------------------------------------------------*/

#include MUT_H
#include MLO_H
#include MPH_H
#include RDS_H
#include MBKRDS_H
#include EXTRACT_H
#include <string.h>
#include <stdlib.h>

#include "extractor.h"
#include "lyerror.h"

# define LYNX_BUFFER_SIZE 256

/*-----------------------------------------------------*\
|                 Global variables                      |
\------------------------------------------------------*/

  chain_list *HeadLynxEqui = (chain_list *)NULL;

  char        LynxBuffer[ LYNX_BUFFER_SIZE ];

/*-----------------------------------------------------*\
|                      Presents                         |
\------------------------------------------------------*/

  void Presents()

  {
    fprintf( stdout, "\n\n");
    fprintf( stdout, "\t\t============================\n"   );
    fprintf( stdout, "\t\t @     @   @  @@   @  @   @ \n"   );
    fprintf( stdout, "\t\t @     @   @  @ @  @   @ @  \n"   );
    fprintf( stdout, "\t\t @      @ @   @  @ @    @   \n"   );
    fprintf( stdout, "\t\t @       @    @   @@   @ @  \n"   );
    fprintf( stdout, "\t\t @@@@@   @    @    @  @   @ \n"   );
    fprintf( stdout, "\t\t============================\n\n" );
    fprintf( stdout, "\t\t         Release 1.5\n" );
    fprintf( stdout, "\t\t        January  1993 \n" );
  }

/*-----------------------------------------------------*\
|                     ParseLynxEqui                     |
\------------------------------------------------------*/

  chain_list *ParseLynxEqui()

  {
    FILE *LynxFile;

    if ( ( LynxFile = fopen( "LYNX_EQUI", "r" ) ) == (FILE *)NULL )

      return( (chain_list *)NULL );

    while (  fgets( LynxBuffer, LYNX_BUFFER_SIZE, LynxFile ) != (char *)NULL )
    {
      LynxBuffer[ strlen( LynxBuffer ) - 1 ] = '\0';
      
      HeadLynxEqui = addchain( HeadLynxEqui, 
                               (void *)namealloc( LynxBuffer ) );
    }

    fclose( LynxFile ); 

    return( HeadLynxEqui );
  }

  

/*-----------------------------------------------------*\
|                        Main                           |
\------------------------------------------------------*/

  int main( argc, argv)

      int   argc;
      char *argv[];

  {
    char       *FigureName = NULL;
    char       *OutputName = NULL;
    char       *LynxEnv;
    char        CoreFloat  = FALSE;

    char        Core       = FALSE;
    char        Trace      = FALSE;
    char        Capa       = FALSE;
    char        Verbose    = FALSE;
    char        Flatten    = FALSE;
    char        Transistor = FALSE;

    long        Number;

    phfig_list *FigureMbk;
    rds_fig    *FigureRds;
    phfig_list *TraceFigureMbk;

    Presents();

    if ( argc < 2 ) TooFewParameters();

    for ( Number  = 1; 
          Number  < argc;
          Number++ ) 
    {
      if ( ! strcmp( argv[ Number ], "-k" )) Capa = TRUE;
      else 
      if ( ! strcmp( argv[ Number ], "-c" )) Core = TRUE;
      else 
      if ( ! strcmp( argv[ Number ], "-v" )) Verbose = TRUE;
      else 
      if ( ! strcmp( argv[ Number ], "-t" )) Transistor = TRUE;
      else 
      if ( ! strcmp( argv[ Number ], "-f" )) Flatten = TRUE;
      else
      if ( FigureName == NULL ) FigureName = argv[ Number ];
      else
      if ( OutputName == NULL ) OutputName = argv[ Number ];
      else
      IllegalOption( argv[ Number ] );
    }

    if ( FigureName == NULL ) IllegalFileName( argv[ Number - 1 ] );

    if ( OutputName == NULL ) OutputName = FigureName;

    if ( Transistor && Flatten ) IllegalCombination();

    mbkenv();
    
    if ( ( LynxEnv = getenv("LYNX_TRACE") ) != NULL )
    {
      Trace = LynxEnv[ 0 ] - '0';

      if ( Trace == 4 )
      {
        if ( ParseLynxEqui() == NULL ) Trace = FALSE;
      }

      if ( Trace > 4 ) Trace = FALSE;
    }

    fprintf( stdout, "\n\n\t---> Extracts figure %s\n", FigureName );

    FigureMbk = getphfig( FigureName, 'A' );

    if ( Flatten || Transistor ) 
    {
      if ( Verbose ) fprintf( stdout, "\n\t\t---> Flatten figure\n");
      rflattenphfig( FigureMbk, YES, ( Flatten ) ? YES : NO );
    }

    if ( Verbose ) fprintf( stdout, "\n\t\t---> Translate Mbk -> Rds\n");

    FigureRds = MbkRds( FigureMbk ); 

    if ( Trace == 1 ) ViewFigureRds( FigureRds );

    if ( Verbose )
    {
      fprintf( stdout, "\t\t---> Delete Mbk figure\n");
    }
    delphfig( FigureMbk->NAME ); 

    if ( Verbose ) 
    {
      fprintf( stdout, "\t\t---> Build windows\n");
    }
    Number = BuildFenceList( FigureRds );

    if ( Number == 0 ) ErrorMaskCounterNull();

    if ( Verbose )
    {
      fprintf( stdout, "\t\t<--- %d\n", Number );
      fprintf( stdout, "\n\t\t---> Rectangles    : %d", MaskCounterRds );
      fprintf( stdout, "\n\t\t---> Figure size   : ( %6d, %6d )", XMinRds, YMinRds );
      fprintf( stdout, "\n\t\t                     ( %6d, %6d )", XMaxRds, YMaxRds );
      fprintf( stdout, "\n\n\t\t---> Cut transistors\n");
    }
    Number = CutTransistorElbow( FigureRds, Core );

    if ( Number == -1 )

      ErrorCutTransistorElbow( Core );

    if ( Verbose )
    {
      fprintf( stdout, "\t\t<--- %d", Number );
      fprintf( stdout, "\n\t\t---> Chain equis\n");
    }
    Number = ChainEqui();

    if ( Trace == 2 ) 
    {
      TraceFigureMbk = addphfig( "trace_chain" );
      DumpAllEqui( TraceFigureMbk, FigureRds );
      savephfig( TraceFigureMbk );
      delphfig( TraceFigureMbk->NAME );
    }

    if ( Verbose ) 
    {
      fprintf( stdout, "\t\t<--- %d\n", Number);
      fprintf( stdout, "\t\t---> Delete windows\n");
    }
    DelFenceList();

    if ( Verbose )
    {
      fprintf( stdout, "\t\t---> Fusion equis\n");
    }
    Number = FusionEqui( FigureRds );
    
    if ( Trace == 3 ) 
    {
      TraceFigureMbk = addphfig( "trace_fusion" );
      DumpAllEqui( TraceFigureMbk, FigureRds );
      savephfig( TraceFigureMbk );
      delphfig( TraceFigureMbk->NAME );
    }

    if ( Verbose )
    {
      fprintf( stdout, "\t\t<--- %d\n", Number);
      fprintf( stdout, "\t\t---> Build signals\n");
    }

    Number = BuildLogicalSignal( FigureRds, Core, Capa, HeadLynxEqui );

    if ( Number < 0 )
    {
      Number = -Number;
      CoreFloat = TRUE;
    }

    if ( Verbose )
    {
      fprintf( stdout, "\t\t<--- %d\n", Number);
      fprintf( stdout, "\t\t---> Build instances\n");
    }
    Number = BuildLogicalInstance( FigureRds );

    if ( Verbose )
    {
      fprintf( stdout, "\t\t<--- %d\n", Number);
      fprintf( stdout, "\t\t---> Build transistors\n");
    }
    Number = BuildLogicalTransistor( FigureRds );

    if ( Verbose )
    {
      fprintf( stdout, "\t\t<--- %d\n", Number);
      fprintf( stdout, "\t\t---> Save netlist\n\n");
    }

    HeadLogicalFigure->NAME = namealloc( OutputName );

    DelFigureRds( FigureRds );

    VectorizeConnectors( HeadLogicalFigure );

    savelofig( HeadLogicalFigure );

    fprintf( stdout, "\t<--- done !\n\n");

    if ( CoreFloat ) GenerateCoreFloat();

    return ( OK );
  }

