/*-----------------------------------------------------*\
|                                                       |
|  Title   :       Fence Tools Box for Lynx             |
|                                                       |
|  Date    :            01/01/93                        |
|                                                       |
|  Author  :         Jacomme ludovic                    |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                Les fichiers a inclure                 |
\------------------------------------------------------*/

#include MUT_H
#include MLO_H
#include MPH_H
#include RDS_H
#include EXTRACT_H

#include <stdio.h>
#include <string.h>
#include <math.h>

/*-----------------------------------------------------*\
|               Les variables globales                  |
\------------------------------------------------------*/

#include "fencelayerenable.h"

 FenceList *HeadFence      = NULL;

 long       MaskCounterRds = 0;
 long       XMinRds        = 0;
 long       YMinRds        = 0;
 long       XMaxRds        = 0;
 long       YMaxRds        = 0;

 char       Buffer[ 256 ];

/*-----------------------------------------------------*\
|           Les fonctions d'Allocation d'objets         |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|           Allocation d'une Fenetre pour Lynx          |
\------------------------------------------------------*/

  FenceList *AllocFenceList( Number )

             long Number;
  {
    return ((FenceList *)RAZStruct( Number * sizeof( FenceList )));
  }

/*-----------------------------------------------------*\
|    Creation d'un lien Rectangle/Fenetre pour Lynx     |
\------------------------------------------------------*/

  void LinkFenceRectangle( Fence, Rectangle )

       FenceList *Fence;
       rds_rec   *Rectangle;
  {
    char        Layer;

    Layer = Rectangle->layer;

    Rectangle->user = (void *)addchain
                      ( 
                        (chain_list *)(Rectangle->user), 
                        (void       *)Fence 
                      );

    Fence->LayerTable[ Layer ] = addchain
                                 (
                                   Fence->LayerTable[ Layer ],
                                   (void       *)Rectangle
                                 );
  }

/*-----------------------------------------------------*\
|         Les fonctions de Liberation d'objets          |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|           Liberation d'une Chaine pour Lynx           |
\------------------------------------------------------*/

  void FreeFenceList()

  {
    mbkfree((char *) HeadFence);
  }

/*-----------------------------------------------------*\
|        Les fonctions de Destruction d'objets          |
\------------------------------------------------------*/
/*-----------------------------------------------------*\
|         Destruction d'une Liste de fenetres           |
\------------------------------------------------------*/

  void DelFenceList()

  {
    FenceList  *Fence;
    chain_list *FenceChain;
    chain_list *RectangleChain;
    rds_rec    *Rectangle;

    char       Layer;

    for ( Fence  = HeadFence;
          Fence != (FenceList *)NULL;
          Fence  = Fence->Next )
    {
      for ( Layer = 0; 
            Layer < MAX_FENCE_LAYER; 
            Layer++ )
      {
         FenceChain = Fence->LayerTable[ Layer ];

         while ( FenceChain != (chain_list *)NULL )
         {
           Rectangle       = (rds_rec    *)(FenceChain->DATA);
           RectangleChain  = (chain_list *)(Rectangle->user);
           Rectangle->user = NULL;
           FenceChain      = FenceChain->NEXT;

           freechain( RectangleChain );
         }
         freechain( Fence->LayerTable[ Layer ] );
      }
    }

    FreeFenceList();

    HeadFence = (FenceList *)NULL;
  }

/*-----------------------------------------------------*\
|           Les fonctions de verification               |
\------------------------------------------------------*/

  void VerifyFenceList( FigureRds )

       rds_fig *FigureRds;
  {
    rds_rec    *Rectangle;
    FenceList  *Fence;
    chain_list *ScanChain;
    chain_list *Chain;
    char        Layer;

    for ( Fence  = HeadFence;
          Fence != (FenceList *)NULL;
          Fence  = Fence->Next )
    {
      for ( Layer = NWELL;
            Layer < MAX_FENCE_LAYER;
            Layer++ )
      {
        for ( Chain  = Fence->LayerTable[ Layer ];
              Chain != (chain_list *)NULL;
              Chain  = Chain->NEXT )
        {
          if ( FenceLayerEnable [ Layer ] )
          { 
            Rectangle = (rds_rec *)Chain->DATA;

            for ( ScanChain  = (chain_list *)Rectangle->user;
                  ScanChain != (chain_list *)NULL;
                  ScanChain  = ScanChain->NEXT )
            {
              if ( (FenceList *)(ScanChain->DATA) == Fence ) break;
            }

            if ( ScanChain == (chain_list *) NULL ) 
            {
              printf("\nError Verify Fence List ");
              exit( ERROR );
            }
          }
          else 
          {
            printf("\nRectangle found in disable layer, ERROR");
            exit ( ERROR );
          }
        }
      }
    }

    for (  Layer  = RDS_NDIF;
           Layer  < MAX_FENCE_LAYER;
           Layer++ )
    {
      for ( Rectangle  = FigureRds->layertab[ Layer ];
            Rectangle != (rds_rec *)NULL;
            Rectangle  = Rectangle->next )
      {
        for ( Chain  = (chain_list *)Rectangle->user;
              Chain != (chain_list *)NULL;
              Chain  = Chain->NEXT )
        {
          for ( ScanChain  = ((FenceList *)Chain->DATA)->LayerTable[ Rectangle->layer ];
                ScanChain != (chain_list *)NULL;
                ScanChain  = ScanChain->NEXT )
          {
            if ( ScanChain->DATA == (void *)Rectangle ) break;
          }

          if ( ScanChain == (chain_list *)NULL ) 
          {
            printf("\nError Verify II Fence List ");
            exit( ERROR );
          }
        }
      }
    }

    printf("\nVerify Fence List OK ");
  }

/*-----------------------------------------------------*\
|        Les fonctions de Remplissage des fenetres      |
\------------------------------------------------------*/

  long BuildFenceList( FigureRds )

       rds_fig *FigureRds;
  {
    long        X1;
    long        X2;
    long        Y1;
    long        Y2;
    long        FenceX1;          
    long        FenceX2;          
    long        FenceY1;
    long        FenceY2;
    long        FenceSize;
    long        FenceNbX;
    long        FenceNbY;
    long        FenceNb;

    FenceList  *Fence;
    rds_ins    *Instance;
    rds_rec    *Rectangle;

    boolean     ComputeBound;
    char        Layer;
    long        Counter;

    MaskCounterRds = 0;
    ComputeBound   = TRUE;

    for ( Layer = RDS_NDIF;
          Layer < MAX_FENCE_LAYER; 
          Layer++ )
    {
      for ( Rectangle  = FigureRds->layertab[ Layer ];
            Rectangle != (rds_rec *)NULL;
            Rectangle  = Rectangle->next )
      {
        MaskCounterRds  = MaskCounterRds + 1;
        Rectangle->equi = (rds_rec *)NULL;
        Rectangle->user = (void    *)NULL;
        SetExtractNone( Rectangle->flags );

        X1 = Rectangle->x;
        X2 = X1 + Rectangle->dx;
        Y1 = Rectangle->y;
        Y2 = Y1 + Rectangle->dy;

        if ( ComputeBound ) 
        {
          ComputeBound = FALSE; 

          XMaxRds = X2;
          YMaxRds = Y2;
          XMinRds = X1;
          YMinRds = Y1;
        }
        else
        {
          if ( XMaxRds < X2 ) XMaxRds = X2;
          if ( YMaxRds < Y2 ) YMaxRds = Y2;
          if ( XMinRds > X1 ) XMinRds = X1;
          if ( YMinRds > Y1 ) YMinRds = Y1;
        }
      }
    }

    for ( Instance  = FigureRds->instance;
          Instance != (rds_ins *)NULL;
          Instance  = Instance->next )
    {
      for ( Layer = RDS_NDIF; 
            Layer < MAX_FENCE_LAYER; 
            Layer++ )
      {
        for ( Rectangle  = Instance->layertab[ Layer ];
              Rectangle != (rds_rec *)NULL;
              Rectangle  = Rectangle->next )
        {
          MaskCounterRds  = MaskCounterRds + 1;
          Rectangle->equi = (rds_rec *)NULL;
          Rectangle->user = (void    *)NULL;
          SetExtractNone( Rectangle->flags );

          if ( Rectangle->flags != EXTRACT_NONE ) exit( ERROR );

          X1 = Rectangle->x;
          X2 = X1 + Rectangle->dx;
          Y1 = Rectangle->y;
          Y2 = Y1 + Rectangle->dy;

          if ( ComputeBound ) 
          {
            ComputeBound = FALSE; 

            XMaxRds = X2;
            YMaxRds = Y2;
            XMinRds = X1;
            YMinRds = Y1;
          }
          else
          {
            if ( XMaxRds < X2 ) XMaxRds = X2;
            if ( YMaxRds < Y2 ) YMaxRds = Y2;
            if ( XMinRds > X1 ) XMinRds = X1;
            if ( YMinRds > Y1 ) YMinRds = Y1;
          }
        }
      }
    }

    if ( MaskCounterRds == 0 ) return( 0 );

    FenceSize = ( long )( sqrt (( double )( XMaxRds - XMinRds ) * 
                                ( double )( YMaxRds - YMinRds )) /
                          sqrt ( sqrt ( ( double )MaskCounterRds )));

    FenceNbX = 1 + ( XMaxRds - XMinRds ) / FenceSize;
    FenceNbY = 1 + ( YMaxRds - YMinRds ) / FenceSize;
    FenceNb  = FenceNbX * FenceNbY;

    HeadFence = AllocFenceList( FenceNb );
    
    for ( Counter = 0, 
          Fence   = HeadFence;
          Counter < FenceNb - 1;
          Fence   = Fence->Next,
          Counter++ )
    {
      Fence->Next = Fence + 1;
    }

    Fence->Next = (FenceList *)NULL;

    for ( Layer = RDS_NDIF; 
          Layer < MAX_FENCE_LAYER; 
          Layer++ )
    {
      if ( ! FenceLayerEnable[ Layer ] ) continue;

      for ( Rectangle  = FigureRds->layertab[ Layer ];
            Rectangle != (rds_rec *)NULL;
            Rectangle  = Rectangle->next )
      {
        for ( FenceY2  = ( YMaxRds - Rectangle->y                 ) / FenceSize,
              FenceY1  = ( YMaxRds - Rectangle->y - Rectangle->dy ) / FenceSize;
              FenceY1 <= FenceY2;
              FenceY1++ )
        {
          Fence = HeadFence + ( FenceY1 * FenceNbX );

          for ( FenceX1   = ( Rectangle->x                 - XMinRds ) / FenceSize,
                FenceX2   = ( Rectangle->x + Rectangle->dx - XMinRds ) / FenceSize;
                FenceX1  <= FenceX2 ;
                FenceX1++ )
          {
            LinkFenceRectangle
            ( 
              Fence + FenceX1,
              Rectangle
            );
          }
        }
      }
    }

    for ( Instance  = FigureRds->instance; 
          Instance != (rds_ins *)NULL;
          Instance  = Instance->next )
    {
      for ( Layer = RDS_NDIF; 
            Layer < MAX_FENCE_LAYER; 
            Layer++ )
      {
        if ( ! FenceLayerEnable[ Layer ] ) continue;

        for ( Rectangle  = Instance->layertab[ Layer ];
              Rectangle != (rds_rec *)NULL;
              Rectangle  = Rectangle->next )
        {
          for ( FenceY2  = ( YMaxRds - Rectangle->y                 ) / FenceSize,
                FenceY1  = ( YMaxRds - Rectangle->y - Rectangle->dy ) / FenceSize;
                FenceY1 <= FenceY2;
                FenceY1++ )
          {
            Fence = HeadFence + ( FenceY1 * FenceNbX );
  
            for ( FenceX1   = ( Rectangle->x                 - XMinRds ) / FenceSize,
                  FenceX2   = ( Rectangle->x + Rectangle->dx - XMinRds ) / FenceSize;
                  FenceX1  <= FenceX2;
                  FenceX1++ )
            {
              LinkFenceRectangle
              ( 
                Fence + FenceX1,
                Rectangle 
              );
            }
          }
        }
      }
    }
    
    return( FenceNb );
  }

