/*-----------------------------------------------------*\
|                                                       |
|  Title   :   Constants & Fonctions for Extract        |
|                                                       |
|  Date    :              01/01/93                      |
|                                                       |
|  Author  :           Jacomme Ludovic                  |
|                                                       |
\------------------------------------------------------*/

/*-----------------------------------------------------*\
|                    Les constantes                     |
\------------------------------------------------------*/

#ifndef EXTRACTDEF
#define EXTRACTDEF

#  define EXTRACT_BITS    ((char)3)
#  define EXTRACT_NONE    ((char)0)
#  define EXTRACT_TAG     ((char)1)
#  define EXTRACT_END     ((char)2)

/*-----------------------------------------------------*\
|                       Les Macros                      |
\------------------------------------------------------*/

#  define IsExtractEnd(X)          (((X) & EXTRACT_BITS ) == EXTRACT_END  )
#  define IsExtractTag(X)          (((X) & EXTRACT_BITS ) == EXTRACT_TAG  )
#  define IsExtractNone(X)         (((X) & EXTRACT_BITS ) == EXTRACT_NONE )

#  define SetExtractEnd(X)    ((X) = (((X) & ~EXTRACT_BITS ) | EXTRACT_END ))
#  define SetExtractTag(X)    ((X) = (((X) & ~EXTRACT_BITS ) | EXTRACT_TAG ))
#  define SetExtractNone(X)   ((X) = ((X) & ~EXTRACT_BITS ))

/*-----------------------------------------------------*\
|                  Les variables globales               |
\------------------------------------------------------*/

  extern rds_rec    *HeadChainEqui;

/*-----------------------------------------------------*\
|                      Les fonctions                    |
\------------------------------------------------------*/

  extern long        CutTransistorElbow();
  extern long        ChainEqui();
  extern long        FusionEqui();
  extern rds_rec    *Equipotential();
  extern long        ViewChainEqui();

#endif
