/***************************************************************/
/* module   : libpat_l.c                                       */
/* date     : 20/11/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/***************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <mut309.h>
#include <pat103.h>
#include "mem.h"
#include "hash.h"
#include "conv.h"
#include "label.h"
#include "libpat_l.h"
/*------------------------------------------------------------
 *      STRUCTURE PAT
 *------------------------------------------------------------*/
struct  paseq  *racine_paseq;
/*------------------------------------------------------------
 *      LABEL COURANT
 *------------------------------------------------------------*/
char           *GNP_LABEL;
/*------------------------------------------------------------
 *      NUMERO DE LIGNE COURANTE
 *------------------------------------------------------------*/
int             GNP_LIGNE_COURANTE = 0;
/*------------------------------------------------------------
 *      NUMERO DE PATTERN COURANT
 *------------------------------------------------------------*/
int             GNP_PATTERN_COURANT;
/*------------------------------------------------------------
 *      NUMERO DU DERNIER PATTERN CREE
 *------------------------------------------------------------*/
int             GNP_PATTERN_MAX;
/*------------------------------------------------------------
 *      TABLE DES PAIOLs
 *------------------------------------------------------------*/
struct paiol *tab_paiol[GNP_MAXTAB_PAIOL];
int      GNP_PAIOL_INDEX=0;
int      GNP_TAB_PAIOL_CREE;
/*------------------------------------------------------------
 *      OPTIONS DU PROGRAMME     
 *------------------------------------------------------------*/
short verbose;
short syntax;
/*------------------------------------------------------------
 *      TABLE DES IDENTIFICATEURS
 *------------------------------------------------------------*/
Tptab_ident tab_ident[GNP_MAXTAB_IDENT];
int     ind_tab_ident;

/*------------------------------------------------------------
 *      GESTION DES PARAMETRES A NOMBRE INDETERMINE
 *------------------------------------------------------------*/
char    *pile_param[GNP_MAXPILE_PARAM];
int      sp_pile_param ;
int      sp_file_param ;
FILE    *fp;
/*----------------------------------------------------------------*/
void Erreur(numero,chaine)
int numero;
char *chaine;
{
  printf("\nERROR NUMBER %d : %s\n",numero,chaine);
  exit (1);
}
/*--------------------------------------------------------------*/
char   *KillEsp (name)
char *name;
{
char *cpt= name;
int i,j = 0;
char tmp[30];
   for (i = strlen(name); i >0; i--) {
      if ( isspace (*cpt)==0 ) {
         tmp[j] = *cpt;
         j++;
      }
      cpt ++;
   }
   tmp[j] = '\0';
   strcpy (name,tmp);
   return (name);
}
/*----------------------------------------------------------------*/
void    CheckIdent (ident)
char *ident;
{
char  *cpt;
int i;
   cpt = ident;
   while ( isspace (*cpt) != 0 ) {
       cpt ++;
   }
      if (isalpha(*cpt++) == 0) {
           (void) fprintf(stdout,"Err: %s ",ident);
         Erreur (GNP_ERR18,"IDENT error not an identifier");
      }
   for (i = strlen(cpt); i >0; i--) {
      if (isalnum(*cpt) == 0)
        if ((*cpt != '_') && (*cpt != '.')){
           (void) fprintf(stdout,"Err: %s ",ident);
           Erreur (GNP_ERR19,"IDENT error not an identifier");
        }
  if (verbose == 1 )
  {
      if (isupper(*cpt))
         printf (" uppercases are checked as lowercases\n");
  }
      cpt ++;
   }
}
/*----------------------------------------------------------------*/
char CheckSeparate(chn_blk)
char *chn_blk;
{
   if (*chn_blk == ':') {
     chn_blk++;
     if  (strlen (chn_blk) ==1 ) {
       if (isdigit (*chn_blk))
          return (*chn_blk);
     }
     if  (strlen (chn_blk) == 0 )
          return ('0');
   }
   Erreur (GNP_ERR20,"SEPARATOR error in paiol declaration");
   return (*chn_blk);
}
/*----------------------------------------------------------------*/
void  SplitIdent (ident,chaine)
char *chaine;
char *ident;
{
char idtmp[30],reste[30], *cpt;
int i,j =0,k =0, flag1=0,flag2=0;
   cpt = ident;
   for (i = strlen(ident); i >0; i--) {
       if (flag1 == 0)
           if (isspace(*cpt) == 0) {
               flag2 = 1;
               idtmp[j] = *cpt;
               j++;
           }
           else {
               if (isspace(*cpt) != 0 && flag2 == 1)
                   flag1 = 1;
           }
       else {
            reste[k] = *cpt;
            k++;
       }
       cpt ++;
   }
   idtmp[j] = '\0';
   reste[k] = '\0';
   strcpy (chaine,reste);
   strcpy (ident,idtmp);
}
/*----------------------------------------------------------------*/
void TraiterChaine (event)
TEvent *event;
{
char *cpt;
int i=0,j=0,k=0,l=0,flag=0;
   cpt = event->field_ident;
   for (i = strlen(event->field_ident); i >0; i--) {
     switch (flag) {
      case 0: {
          if (isdigit(*cpt) ){
              event->decomp.gauche[j] = *cpt;
              j++;
          }
          if (isalpha (*cpt)) {
              event->decomp.alpha[k++] = *cpt;
              k++;
              flag = 1;
          }
          break;
      }
      case 1: {
          if (isalpha (*cpt)) {
              event->decomp.alpha[k] = *cpt;
              k++;
              flag = 1;
          }
          if (isspace (*cpt))
              flag = 2;
          break;
      }
      case 2: {
          if (isdigit(*cpt)) {
              event->decomp.droite[l] = *cpt;
              l++;
          }
          if (isalpha (*cpt)) {
             Erreur (GNP_ERR21,"VECTOR field descriptor error");
          }
          break;
      }
     }
     cpt++;
   }
   event->decomp.gauche[j] = '\0';
   event->decomp.alpha[k] = '\0';
   event->decomp.droite[l] = '\0';
}
/*----------------------------------------------------------------*/
void  CheckWidth (event)
TEvent *event;
{
int gauche=0, droite=0, lg_gauche=0, lg_droite=0, lg_alpha=0;
   lg_gauche = strlen (event->decomp.gauche);
   gauche    = lg_gauche ? atoi(event->decomp.gauche):0;
   lg_droite = strlen (event->decomp.droite);
   droite    = lg_droite ? atoi(event->decomp.droite):0;
   lg_alpha  = strlen (event->decomp.alpha);
   if ( ( lg_alpha  == 0 &&  lg_droite != 0 ) ||
        ( lg_alpha  != 0 &&  lg_droite == 0 ) ||
        ( lg_gauche == 0 && ( lg_alpha != 0   ||  lg_droite != 0) ) )
   {
          Erreur (GNP_ERR22,"VECTOR field descriptor error");
   }
   if ( (gauche < droite) && (( strcmp (event->decomp.alpha,"DOWNTO")==0) ||
                              ( strcmp (event->decomp.alpha,"downto")==0)   ))
   {
       Erreur (GNP_ERR23,"VECTOR field descriptor error");
   }
   if ( (droite < gauche) && ((strcmp (event->decomp.alpha,"TO")==0) ||
                              (strcmp (event->decomp.alpha,"to")==0)   ))
   {
       Erreur (GNP_ERR24,"VECTOR field descriptor error");
   }
}
/*----------------------------------------------------------------*
 *                 CreatePagrp                                    *
 * les parametres ne sont pas verifies dans la fonction           *
 * la fonction cree un pagrp                                      *
 *    met a jour la structure paseq, les tables de hachage        *
 *    cree une entree supplementaire dans la table des            *
 *      identificateurs retourne l'index correspondant            *
 * ou genere une erreur (exit) en cas d'anomalie                  *
 *----------------------------------------------------------------*/
void CreatePagrp(ident,length,sens,type_vecteur)
char *ident;
int length,sens;
short type_vecteur;
{
int index;
elt *tmp_elt;
struct pagrp *tmp_pagrp;
     index = GNP_PAIOL_INDEX - length;
     if (index < 0 ) {
         Erreur (GNP_ERR30,"PAGRP length doesnt match");
     }
     if (ind_tab_ident >= GNP_MAXTAB_IDENT) {
         Erreur (GNP_ERR31,"PAGRP too mutch declared identifiers");
     }
     tmp_elt = SymbAlloc(ident,hash_pagrp);
     tmp_pagrp = pat_addpagrp(racine_pagrp,
                              tmp_elt->name,
                              length,
                              index);
     if (tmp_pagrp == NULL) {
         Erreur (GNP_ERR32," PAGRP memory failled");
     }
     tmp_pagrp->FLAG = type_vecteur;
     tmp_elt->num_index = ind_tab_ident;
     tmp_elt->sens = sens;
     tab_ident[ind_tab_ident].duplicate  =ind_tab_ident;
     tab_ident[ind_tab_ident].pointeur =(void *)tmp_pagrp;
     ind_tab_ident++;
     racine_pagrp = tmp_pagrp;
}
/*----------------------------------------------------------------*
 *                 DupPaiol                                       *
 * les parametres ne sont pas verifies dans la fonction           *
 * le paiol doit etre deja declare (ExisteIdent...)               *
 * la fonction duplique le paiol identifie par son nom            *
 *    met a jour le format de representation                      *
 *    met a jour la structure paseq                               *
 *    ne cree pas d'entree supplementaire dans la table des       *
 *      identificateurs                                           *
 * ou genere une erreur (exit) en cas d'anomalie                  *
 *----------------------------------------------------------------*/

void DupPaiol (duplicate,format,param_effectif,param_virtuel,i_o,blk)
char format;
char *param_effectif;
char *param_virtuel;
char i_o, blk;
{
elt *tmp_elt_effectif;
elt *tmp_elt_virtuel;
struct paiol *tmp_racine;
     tmp_elt_virtuel = SymbAlloc (param_virtuel,hash_paiol);
     if (duplicate == GNP_NO_DUPLICATE)
	  tmp_elt_effectif = SymbAlloc(param_effectif,hash_paiol);
     else
          tmp_elt_effectif = ExisteIdent (param_effectif,hash_paiol);
     if (duplicate != tmp_elt_effectif->num_index) {
	Erreur (GNP_ERR33,"DupPaiol error unconstistent paiol references");
     }
     tmp_racine = pat_addpaiol(racine_paiol,
                              tmp_elt_effectif->name,
                              format,
                              i_o,
                              (char)((int)blk - (int)'0'));
     if (tmp_racine == NULL) {
         Erreur(GNP_ERR34," DuplicatePaiol memory failled");
     }
     if (ind_tab_ident >= GNP_MAXTAB_IDENT) {
         Erreur (GNP_ERR35,"too mutch declared iditentifiers");
     }
     tmp_elt_virtuel->num_index = ind_tab_ident;
     if (duplicate != GNP_NO_DUPLICATE) {
         tab_ident[ind_tab_ident].duplicate = tab_ident[duplicate].duplicate;
         tab_ident[duplicate].duplicate = ind_tab_ident;
     }
     else {
         tmp_elt_effectif->num_index = ind_tab_ident;
         tab_ident[ind_tab_ident].duplicate = ind_tab_ident;
     }
     tab_ident[ind_tab_ident].num_paiol = GNP_PAIOL_INDEX;
     GNP_PAIOL_INDEX ++;
     tab_ident[ind_tab_ident].pointeur =(void *)tmp_racine;
     ind_tab_ident ++;
     racine_paiol = tmp_racine;
}
/*----------------------------------------------------------------*
 *                 CreatePaiol                                    *
 * les parametres ne sont pas verifies dans la fonction           *
 * le paiol doit etre deja declare (ExisteIdent...)               *
 * le nom du paiol  est alloue (SymbAlloc...) par CreatePaiol     *
 * la fonction duplique le paiol identifie par son nom            *
 *    met a jour le format de representation                      *
 *    met a jour la structure paseq                               *
 *    cree une entree supplementaire dans la table des            *
 *      identificateurs                                           *
 * ou genere une erreur (exit) en cas d'anomalie                  *
 *----------------------------------------------------------------*/
void CreatePaiol (format,ident,mode,blk)
char format;
char *ident;
char mode,blk;
{
elt *tmp_elt;
struct paiol *tmp_paiol;
     if (ind_tab_ident >= GNP_MAXTAB_IDENT) {
         Erreur (GNP_ERR36,"too mutch declared iditentifiers");
     }
     tmp_elt = SymbAlloc(ident,hash_paiol);
     tmp_paiol = pat_addpaiol(racine_paiol,
                              tmp_elt->name,
                              format,
                              mode,
                              (char)((int)blk - (int)'0'));
     if (tmp_paiol == NULL) {
         Erreur (GNP_ERR59," CreatePaiol memory failled");
     }
     tmp_elt->num_index = ind_tab_ident;
     tab_ident[ind_tab_ident].duplicate = ind_tab_ident;
     tab_ident[ind_tab_ident].num_paiol = GNP_PAIOL_INDEX;
     GNP_PAIOL_INDEX++;
     tab_ident[ind_tab_ident].pointeur =(void *)tmp_paiol;
     ind_tab_ident ++;
     racine_paiol = tmp_paiol;
}
/*----------------------------------------------------------------*/
void CheckBlank (blank)
int blank;
{
   if ((blank >= GNP_MIN_BLANK ) && (blank <= GNP_MAX_BLANK)) {
     un_port.blk  =   (char)(blank + (int)'0');
     return;
   }
  Erreur (GNP_ERR61,"DimensionBlank ERROR");
}
/*-----------------------------------------------------------------*/
void    CheckFormat (format)
char *format;
{
    format = KillEsp (format);
    if (strlen (format) > 1 ) {
        Erreur (GNP_ERR62,"FORMAT error string too long");
    }
    switch (*format)
    {
         case 'x': case 'X': {
            format = GNP_HEXA;
            break;
         }
         case 'o': case 'O': {
            format = GNP_OCTAL;
            break;
         }
         case 'b': case 'B': {
            format = GNP_BINAIRE;
            break;
         }
         default: {
             Erreur (GNP_ERR63,"CheckFormat error");
         }
    }
    un_port.format = *format;
    return;
}
/*-----------------------------------------------------------------*/
void CheckTypeDeclar (type)
char *type;
{
    type = KillEsp (type);
    if (strlen (type) > 1 ) {
        Erreur (GNP_ERR64,"TYPE error string too long");
    }
    switch (*type)
    {
    case 'o': case 'O': {
       type = GNP_TYPE_OUT;
       break;
    }
    case 'I': case 'i': {
       type = GNP_TYPE_IN;
       break;
    }
    case 'T': case 't': {
       type = GNP_TYPE_INOUT;
       break;
    }
    case 'S': case 's': {
       type = GNP_TYPE_SIGNAL;
       break;
    }
    case 'R': case 'r': {
       type = GNP_TYPE_REGISTER;
       break;
    }
    default:{
           Erreur (GNP_ERR65,"MODE error");
    }
    }
    un_port.type = *type;
    return;
}
/*-----------------------------------------------------------------*/
void CheckEnd (end)
int end;
{
   if (end == GNP_END_ARG)
      return;
   Erreur (GNP_ERR66,"END error expected end of argument list");
}
/*-----------------------------------------------------------------*/
void  ClearPort()
{
int i;
   for (i = GNP_MAX_PARAM -1; i >= 0; i --)
       un_port.id_param[i] = NULL;
   un_port.group_name = NULL;
   un_port.dim = 0;
   un_port.sens = 0;
   un_port.borne_g = 0;
   un_port.borne_d = 0;
   un_port.blk = '\0';
   un_port.format = '\0';
   un_port.type = '\0';
   return;
}
/*-----------------------------------------------------------------*/
void FileInPort (ident)
char *ident;
{
   if ( sp_pile_param < GNP_MAX_PARAM )  {
      un_port.id_param[sp_pile_param] = (char*)namealloc(ident);
      sp_pile_param ++;
      return;
   }
   Erreur (GNP_ERR67,"MAX PARAMETERS exceeded");
}
/*-----------------------------------------------------------------*/
void CheckNotDeclared (ident)
char *ident;
{
      if  ( FindIdent (ident,hash_paiol) != -1) {
          Erreur (GNP_ERR68,"PORT duplicate declared identifier");
      }
      if  ( FindIdent (ident,hash_pagrp) != -1) {
          Erreur (GNP_ERR69,"PORT yet declared identifier as a pagrp");
      }
      return;
}
/*-----------------------------------------------------------------*/
char *FileOutPort()
{
   if ( sp_file_param >= sp_pile_param ) {
      Erreur (GNP_ERR70,"UNCONSISTENT FileOut parameters");
  }
  return ( un_port.id_param[sp_file_param++] ) ;
}
/*-----------------------------------------------------------------*/
void PutInArray(ident)
char *ident;
{
   un_port.group_name = (char*)namealloc(ident);
   return;
}
/*-----------------------------------------------------------------*/
void FileInArray()
{
char *tmp;
   tmp = Allouer(strlen(un_port.group_name) + 1);
   strcpy(tmp,un_port.group_name);
   if (un_port.dim == GNP_DIM_UN) {
   tmp = Conv(un_port.borne_g);
   }

   strcpy(un_port.group_name,tmp);
   FileInPort(un_port.group_name );
   return;
}
/*-----------------------------------------------------------------*/
void SaveGroupName(group_name)
char *group_name;
{
     un_port.group_name = (char*)namealloc (group_name);
}
/*-----------------------------------------------------------------*/
void CreerEvent()
{
/*
 * cree une structure event, l'initialise et la chaine dans la structure un_affect
 */
TEvent *tmp_event;
   tmp_event = (TEvent *)Allouer(sizeof(TEvent));
   tmp_event->next = un_affect.event;
   un_affect.event = tmp_event;
   *tmp_event->param = NULL;
   *tmp_event->field_ident = NULL;
   *tmp_event->decomp.gauche = NULL;
   *tmp_event->decomp.droite = NULL;
   *tmp_event->decomp.alpha = NULL;
}
/*--------------------------------------------------------------*/
void  DimensionVecteur(gauche,sens,droite)
int gauche,sens,droite;
{
  if ((gauche > droite) && (sens == GNP_SENS_DOWN)) {
     un_port.borne_d = droite + GNP_SENS_DOWN;
     un_port.borne_g = gauche;
     un_port.dim     = un_port.borne_g - un_port.borne_d;
     un_port.sens    = GNP_SENS_DOWN;
     return;
  }
  if ((gauche < droite) && (sens == GNP_SENS_UP)) {
     un_port.borne_d = droite + GNP_SENS_UP;
     un_port.borne_g = gauche;
     un_port.dim     = un_port.borne_d - un_port.borne_g;
     un_port.sens    = GNP_SENS_UP;
     return;
  }
  Erreur (GNP_ERR60,"DimensionVecteur ERROR");
}
/*-----------------------------------------------------------------*/
void EmpileParam(param)
char *param;
{
    if ( sp_pile_param >= GNP_MAXPILE_PARAM )
    {
        Erreur(GNP_ERR90,"pile des parametres pleine");
    }
    pile_param[sp_pile_param] = param ;
    sp_pile_param ++;
}
/*----------------------------------------------------------------*/
char *DepileParam()
{
    sp_pile_param --;
    if ( sp_pile_param  < 0 )
    {
        Erreur(GNP_ERR91,"pile des parametres vide");
    }
    return ( pile_param[sp_pile_param] ) ;
  }
/*----------------------------------------------------------------*/
char *DefileParam()
{
    if (  sp_file_param > sp_pile_param )
    {
        Erreur(GNP_ERR92,"pile des parametres vide");
    }
    sp_file_param ++ ;
    return ( pile_param[sp_file_param -1] ) ;
}
/*----------------------------------------------------------------*/
struct paevt *FusionPaevt (tmp_event,lst_event)
/* la liste lst_event doit etre triee par ordre croissant */
/* racine_event doit etre positionne sur le paevt du papat en cours de creation */
/* la fusion verifie que le meme signal n'est pas affecte deux fois */
/* l'unicite de label doit etre teste en fin de cette procedure */
/* en verifiant que ou GNP_LABEL est vide;- > on ne fait rien 
                    ou le champs LABEL est vide -> il faut l'afecter avec GNP_LABEL
                    si les 2 ne sont pas vides -> erreur
*/
struct paevt *lst_event;
struct paevt *tmp_event;
{
   if (tmp_event == NULL) 
   {
     return(lst_event);
   }
   if (lst_event == NULL) 
   {
     return(tmp_event);
   }
   /* les 2 sont non vides */
   if (tmp_event->INDEX < lst_event->INDEX) 
   {
      tmp_event->NEXT = FusionPaevt (tmp_event->NEXT,lst_event);
      return (tmp_event);
   }
   if (lst_event->INDEX < tmp_event->INDEX) 
   {
      lst_event->NEXT = FusionPaevt (tmp_event,lst_event->NEXT);
      return (lst_event);
  }
  Erreur (GNP_ERR38,"FUSION PAEVT error multiple paevt assignment");
  return (lst_event);  /* pour supprimer le warning */
}
/*----------------------------------------------------------------*/
struct paini *FusionPaini (tmp_ini,lst_ini)
/* la liste lst_ini doit etre triee par ordre croissant */
/* l'unicite de label doit etre teste en fin de cette procedure */
/* en verifiant que ou GNP_LABEL est vide;- > on ne fait rien 
                    ou le champs LABEL est vide -> il faut l'afecter avec GNP_LABEL
                    si les 2 ne sont pas vides -> erreur
*/
struct paini *lst_ini;
struct paini *tmp_ini;
{
   if (tmp_ini == NULL) 
   {
     return(lst_ini);
   }
   if (lst_ini == NULL) 
   {
     return(tmp_ini);
   }
   /* les 2 sont non vides */
   if (strcmp (lst_ini->NAME,tmp_ini->NAME) < 0) 
   {
      tmp_ini->NEXT = FusionPaini (tmp_ini->NEXT,lst_ini);
      return (tmp_ini);
   }
   if (strcmp (tmp_ini->NAME,lst_ini->NAME) < 0) 
   {
      lst_ini->NEXT = FusionPaini (tmp_ini,lst_ini->NEXT);
      return (lst_ini);
  }
  Erreur (GNP_ERR39,"FUSION PAINI error multiple paevt assignment");
  return (lst_ini);  /* pour supprimer le warning */
}
/*----------------------------------------------------------------*/

/***********************************************/
/* si il existe un paini alors :               */
/* s'il n'y a pas de label associe au papat    */
/* alors erreur                                */
/***********************************************/

void CheckInitLabel(tmp_ini,tmp_pap,numpatt)
 struct paini *tmp_ini;
 struct papat *tmp_pap;
 int numpatt;
 {
  if ( tmp_ini != NULL ) 
      {
        if ( strcmp(tmp_pap->LABEL,"\0") == 0 )
          { 
            (void) fprintf(stdout,"Err:Pattern %d",numpatt);
            Erreur(GNP_ERR95,"Error INIT with no LABEL");
          }
      }
 }

/*----------------------------------------------------------------*/
void CreatePapat (lst_event,lst_ini)
/* le numero de pattern est considere comme absolu */
/* les listes sont creees par les fonctions pat_addpaxxx */
struct paevt *lst_event;
struct paini *lst_ini;
{
struct papat *tmp_papat;
struct papat *fils_papat;
struct papat *pere_papat;
char         *tmp_label = "reservation de trente deux cars ";
char         *tmp_number = "reservation de trente deux cars ";
   tmp_papat = NULL;
   if ( strlen(GNP_LABEL) !=0 )
   {
     strcpy (tmp_label,GNP_LABEL); 
     sprintf (tmp_number,"%d",GNP_PATTERN_COURANT);	
     strcat (tmp_label,"_");
     strcat (tmp_label,tmp_number);
   }
   else
   {
     strcpy (tmp_label,"\0"); 
   }

/* recherche de l'emplacement du papat dans la liste des papat */
   if (racine_papat == NULL) {
      racine_papat = pat_addpapat(racine_papat,tmp_label,GNP_PATTERN_COURANT);
      if (racine_papat == NULL) {
          Erreur(GNP_ERR40," CreatePapat memory failled");
      }
      racine_papat->PAEVT = lst_event;
      racine_papat->PAINI = lst_ini;
/*!!*/  CheckInitLabel(racine_papat->PAINI,racine_papat,GNP_PATTERN_COURANT);
   }
   else {
      pere_papat = racine_papat;
      fils_papat = racine_papat;
      while ((fils_papat != NULL) && (fils_papat->LINE > GNP_PATTERN_COURANT)) {
         pere_papat = fils_papat;
         fils_papat = fils_papat->NEXT;
      }
/* pere_papat est toujours plus grand ou egal a GNP_PATTERN_COURANT */
      if (pere_papat->LINE == GNP_PATTERN_COURANT) {
          pere_papat = AddLabel(pere_papat,tmp_label);
          pere_papat->PAEVT = FusionPaevt (lst_event,pere_papat->PAEVT);
          pere_papat->PAINI = FusionPaini (lst_ini,pere_papat->PAINI);
/*!!*/  CheckInitLabel(pere_papat->PAINI,pere_papat,pere_papat->LINE);
      }
      else {
/* pere_papat est strictement plus grand que GNP_PATTERN_COURANT */
         if (fils_papat == NULL) {
             tmp_papat = pat_addpapat(tmp_papat,tmp_label,GNP_PATTERN_COURANT);
             if (tmp_papat == NULL) {
                 Erreur(GNP_ERR41,"CreatePapat memory failled");
             }
             tmp_papat->PAEVT = lst_event;
             tmp_papat->PAINI = lst_ini;
             pere_papat->NEXT = tmp_papat;
/*!!*/  CheckInitLabel(tmp_papat->PAINI,tmp_papat,GNP_PATTERN_COURANT);
         }
         else {
/* le fils est soit inferieur soit plus petit que GNP_PATTERN_COURANT */
            if (fils_papat->LINE < GNP_PATTERN_COURANT) {
/* le fils est inferieur il faut creer un papat et le chainer entre le pere et el fils */
                tmp_papat = pat_addpapat(tmp_papat,tmp_label,GNP_PATTERN_COURANT);
                if (tmp_papat == NULL) {
                    Erreur(GNP_ERR42,"CreatePapat memory failled");
                }
                tmp_papat->PAEVT = lst_event;
                tmp_papat->PAINI = lst_ini;
                tmp_papat->NEXT = fils_papat;
                if (pere_papat != fils_papat)
                    pere_papat->NEXT = tmp_papat;
                else
                    racine_papat = tmp_papat;
/*!!*/  CheckInitLabel(tmp_papat->PAINI,tmp_papat,GNP_PATTERN_COURANT);
          
            }
            else 
            {
/* le fils est egal a GNP_PATTERN_COURANT il faut les fusionner */
              fils_papat = AddLabel(fils_papat,tmp_label);
              fils_papat->PAEVT = FusionPaevt (lst_event,fils_papat->PAEVT);
              fils_papat->PAINI = FusionPaini (lst_ini,fils_papat->PAINI);
/*!!*/  CheckInitLabel(fils_papat->PAINI,fils_papat,fils_papat->LINE);
            }
         }
      }
   }
   CreateLabel ("\0");
}
/*----------------------------------------------------------------*/
struct paevt *CreatePaevt(tete_paevt,num_ident,valeur)
struct paevt *tete_paevt;
int num_ident;
char valeur;
/*
 * les noms doivent etre des noms de paiol valides,
 * les valeurs doivent etre des valeurs valides en fonction dy type de paiol
 * ( in out in-out registre signal)
 */
{
struct paevt *tmp_paevt;
  tmp_paevt = NULL;
  tmp_paevt = pat_addpaevt(tmp_paevt,tab_ident[num_ident].num_paiol,valeur);
  if (tmp_paevt == NULL) {
      Erreur (GNP_ERR43,"CREATEPAEVT memory failled");
  }
  tete_paevt = FusionPaevt(tete_paevt,tmp_paevt);
  return (tete_paevt);
}
/*--------------------------------------------------------------*/
char *FormatOutputValue (value,nb_car,sens)
char *value;
int nb_car, sens;
{
char *valeur = value;
int lg,i;
char *res  = "reservation de trente deux cars reservation de trente deux cars ";
char tmp[64];

   if (GNP_INTERRO == (char)*valeur)
   { /* suppression du point d'interrogation genere par CONVCMP */	
     *valeur ++;
   }

   if (( *valeur == '0') && (strlen (valeur) > 1))
   {
     *valeur++;
   }

   switch (*valeur){
     case 'b': case 'B': {
        *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': { strcat (res,"-");  break; }
                           case '1': { strcat (res,"+");  break; }
                           case '*': { strcat (res,"*");  break; }
                           default : {
                                Erreur (GNP_ERR44,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     case 'o': case 'O': {
        *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': { strcat (res,"---");  break; }
                           case '1': { strcat (res,"--+");  break; }
                           case '2': { strcat (res,"-+-");  break; }
                           case '3': { strcat (res,"-++");  break; }
                           case '4': { strcat (res,"+--");  break; }
                           case '5': { strcat (res,"+-+");  break; }
                           case '6': { strcat (res,"++-");  break; }
                           case '7': { strcat (res,"+++");  break; }
                           case '*': { strcat (res,"***");  break; }
                           default : {
                                Erreur (GNP_ERR45,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     case 'x': case 'X': {
           *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': { strcat (res,"----"); break; }
                           case '1': { strcat (res,"---+"); break; }
                           case '2': { strcat (res,"--+-"); break; }
                           case '3': { strcat (res,"--++"); break; }
                           case '4': { strcat (res,"-+--"); break; }
                           case '5': { strcat (res,"-+-+"); break; }
                           case '6': { strcat (res,"-++-"); break; }
                           case '7': { strcat (res,"-+++"); break; }
                           case '8': { strcat (res,"+---"); break; }
                           case '9': { strcat (res,"+--+"); break; }
                 case 'A': case 'a': { strcat (res,"+-+-"); break; }
                 case 'B': case 'b': { strcat (res,"+-++"); break; }
                 case 'C': case 'c': { strcat (res,"++--"); break; }
                 case 'D': case 'd': { strcat (res,"++-+"); break; }
                 case 'E': case 'e': { strcat (res,"+++-"); break; }
                 case 'F': case 'f': { strcat (res,"++++"); break; }
                           case '*': { strcat (res,"****"); break; }
                           default : {
                                Erreur (GNP_ERR46,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     default:
     {
        unsigned long aux_val;
        int           code_err,j,jj;
        char          result[64];
      
        code_err = sscanf(valeur,"%lu",&aux_val);  
        if ( code_err == -1 ) 
        {
          Erreur (GNP_ERR46,"AFFECT/INIT value syntax error");        
        }
        strcpy(result,"");
        do
         {
           if ( (aux_val % 2) == 0 ) strcat(result,"-");
           else                      strcat(result,"+");
           aux_val = aux_val / 2; 
         } 
        while (aux_val != 0);

        jj = strlen(result);
        for (j=jj;j>0;j--)
          {
             res[jj-j] = result[j - 1];
          }
      res[jj]='\0';
     }
     
   }
/* nb-car: 1 minimum,
   sens  : -1 = vers la droite 1 = vers la gauche
*/
/* ajuster la longueur de la chaine en moins */
   lg = strlen (res);
   if (lg > nb_car) 
   {
     if (verbose == 1)
     {
       printf ("FORMAT VALUE too large value: MSB are truncated\n");
     }
     for (i = 0; i< (lg - nb_car) ; i++)
          *res++;
   }
/* ajuster la longueur de la chaine en + avec des 0 */
   if (lg < nb_car) {
      for (i = 0 ; i < (nb_car - lg) ; i ++) {
         tmp[i] = '-';
      }
      for (i = i ; i < nb_car ; i ++) {
         tmp[i] = *res;
         *res++;
      }
      tmp[i] = '\0';
      strcpy (res,(char *)tmp);
   }
   if (sens == GNP_UP) {
/* inverser la chaine */
      for (i = nb_car-1 ; i >=0 ; i--) {
          tmp[i] = *res;
          *res++;
      }
      tmp[nb_car] = '\0';
      strcpy (res,(char *)tmp);
   }
   strcpy (value,res);
   return (value);
 }
/*--------------------------------------------------------*/
char *FormatInOutValue (value,nb_car,sens)
char *value;
int nb_car, sens;
{
char *valeur = value;
char *res  = "reservation de trente deux cars reservation de trente deux cars ";
char tmp[64];
   if ( *valeur == '?' ) /* cas comparaison en sortie */
     {
        res = FormatOutputValue(valeur,nb_car,sens);
     }
   else
        res = FormatInputOrStarValue(valeur,nb_car,sens);

   return (res);
}
/*----------------------------------------------------------------*/
void CheckPattern (pattern)
char *pattern;
{
int lg,i;
     pattern = KillEsp (pattern);
     lg = strlen (pattern);
     if ( lg == 0) {
         Erreur(GNP_ERR47,"PATTERN NUMBER syntax error");
       }
     if ( (*pattern != '+') && (isdigit(*pattern )== 0) )  {
         Erreur(GNP_ERR48,"PATTERN NUMBER syntax error");
       }
     for (i = 1; i< lg ; i++) {
        pattern ++;
	if ( isdigit(*pattern)  == 0  ) {
         Erreur(GNP_ERR49,"PATTERN NUMBER syntax error");
         }
     }
}
/*----------------------------------------------------------------*/
void MajPatternCourant(pattern)
char *pattern;
{
int relatif = 0, valeur;
     if(*pattern == '+') {
         relatif = 1;
         pattern++;
     }
     valeur = atoi (pattern);
     GNP_PATTERN_COURANT = (GNP_PATTERN_COURANT * relatif) + valeur;
}
/*----------------------------------------------------------------*/
struct paini *CreatePaini (lst_paini,name,valeur)
struct paini *lst_paini;
char * name;
char valeur;
{
struct paini *tmp_paini;
  tmp_paini = NULL;
  tmp_paini = pat_addpaini( tmp_paini,name,valeur);
  if (tmp_paini == NULL) {
      Erreur (GNP_ERR50,"CREATEPAINI memory failled");
  }
  tmp_paini->NEXT = lst_paini;
  return (tmp_paini);
}
/*----------------------------------------------------------------*/
void CreateTabPaiol()
{
struct paiol *tmp_paiol;
   racine_paiol = (struct paiol*) reverse((void*)racine_paiol);
   tmp_paiol = pat_crtpaiol(racine_paiol);
   if (tmp_paiol == NULL) {
      Erreur (GNP_ERR51,"CREATE_TAB_PAIOL memory failled");
   }
   racine_paiol = tmp_paiol;
}
/*----------------------------------------------------------------*/


char *FormatInputOrStarValue (value,nb_car,sens)
char *value;
int nb_car, sens;
{
char *valeur = value;
int lg,i;
char *res  = "reservation de trente deux cars reservation de trente deux cars ";
char tmp[64];

int FLG_INP = 0;/*flag a un si un element du nombre est un entier */
int FLG_STR  = 0;/* flag a un si un element est '*' */
/*2 flags a un =>nombre compose de 'entiers' et '*':erreur */

   if (( *valeur == '0') && (strlen (valeur) > 1))
   {
     *valeur++;
   }

   switch (*valeur){
     case 'b': case 'B': {
        *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': {FLG_INP=1; strcat (res,"0");  break; }
                           case '1': {FLG_INP=1; strcat (res,"1");  break; }
                           case '*': {FLG_STR=1; strcat (res,"*");  break; }
                           default : {
                                Erreur (GNP_ERR52,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     case 'o': case 'O': {
        *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': {FLG_INP=1; strcat (res,"000");  break; }
                           case '1': {FLG_INP=1; strcat (res,"001");  break; }
                           case '2': {FLG_INP=1; strcat (res,"010");  break; }
                           case '3': {FLG_INP=1; strcat (res,"011");  break; }
                           case '4': {FLG_INP=1; strcat (res,"100");  break; }
                           case '5': {FLG_INP=1; strcat (res,"101");  break; }
                           case '6': {FLG_INP=1; strcat (res,"110");  break; }
                           case '7': {FLG_INP=1; strcat (res,"111");  break; }
                           case '*': {FLG_STR=1; strcat (res,"***");  break; }
                           default : {
                                Erreur (GNP_ERR53,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     case 'x': case 'X': {
           *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': {FLG_INP=1; strcat (res,"0000"); break; }
                           case '1': {FLG_INP=1; strcat (res,"0001"); break; }
                           case '2': {FLG_INP=1; strcat (res,"0010"); break; }
                           case '3': {FLG_INP=1; strcat (res,"0011"); break; }
                           case '4': {FLG_INP=1; strcat (res,"0100"); break; }
                           case '5': {FLG_INP=1; strcat (res,"0101"); break; }
                           case '6': {FLG_INP=1; strcat (res,"0110"); break; }
                           case '7': {FLG_INP=1; strcat (res,"0111"); break; }
                           case '8': {FLG_INP=1; strcat (res,"1000"); break; }
                           case '9': {FLG_INP=1; strcat (res,"1001"); break; }
                 case 'A': case 'a': {FLG_INP=1; strcat (res,"1010"); break; }
                 case 'B': case 'b': {FLG_INP=1; strcat (res,"1011"); break; }
                 case 'C': case 'c': {FLG_INP=1; strcat (res,"1100"); break; }
                 case 'D': case 'd': {FLG_INP=1; strcat (res,"1101"); break; }
                 case 'E': case 'e': {FLG_INP=1; strcat (res,"1110"); break; }
                 case 'F': case 'f': {FLG_INP=1; strcat (res,"1111"); break; }
                           case '*': {FLG_STR=1; strcat (res,"****"); break; }
                           default : {
                                Erreur (GNP_ERR54,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     default:
     {
        unsigned long aux_val;
        int           code_err,j,jj;
        char          result[64];
      
        code_err = sscanf(value,"%lu",&aux_val);  
        if ( code_err == -1 ) Erreur (GNP_ERR46,"AFFECT/INIT value syntax error");        
        strcpy(result,"");
        do
         {
           if ( (aux_val % 2) == 0 ) strcat(result,"0");
           else                      strcat(result,"1");
           aux_val = aux_val / 2; 
         } 
        while (aux_val != 0);

        jj = strlen(result);
        for (j=jj;j>0;j--)
          {
             res[jj-j] = result[j - 1];
          }
      res[jj]='\0';
     }
   }

   if ( FLG_INP && FLG_STR ) Erreur (GNP_ERR94,"AFFECT/INIT value syntax error");






/* nb-car: 1 minimum,
   sens  : -1 = vers la droite 1 = vers la gauche
*/
/* ajuster la longueur de la chaine en moins */
   lg = strlen (res);
   if (lg > nb_car) 
   {
     if (verbose == 1)
     {
       printf ("FORMAT VALUE too large value: MSB are truncated\n");
     }
     for (i = 0; i< (lg - nb_car) ; i++)
           *res++;
   }
/* ajuster la longueur de la chaine en + avec des 0 */
   if (lg < nb_car) {
      for (i = 0 ; i < (nb_car - lg) ; i ++) {
         tmp[i] = '0';
      }
      for (i = i ; i < nb_car ; i ++) {
         tmp[i] = *res;
         *res++;
      }
      tmp[i] = '\0';
      strcpy (res,(char *)tmp);
   }
   if (sens == GNP_UP) {
/* inverser la chaine */
      for (i = nb_car-1 ; i >=0 ; i--) {
          tmp[i] = *res;
          *res++;
      }
      tmp[nb_car] = '\0';
      strcpy (res,(char *)tmp);
   }
   strcpy (value,res);
   return (value);
}


/*----------------------------------------------------------------*/
char *FormatInputValue (value,nb_car,sens)
char *value;
int nb_car, sens;
{
char *valeur = value;
int lg,i;
char *res  = "reservation de trente deux cars reservation de trente deux cars ";
char tmp[64];

   if ( *valeur == '?' ) 
   {
     Erreur (GNP_ERR52,"AFFECT/INIT value syntax error");   
   }

   if (( *valeur == '0') && (strlen (valeur) > 1))
   {
     *valeur++;
   }

   switch (*valeur)
   {
     case 'b': case 'B': 
     {
        *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) 
        {
            switch (*valeur) 
            {
                           case '0': { strcat (res,"0");  break; }
                           case '1': { strcat (res,"1");  break; }
                           default : 
                           {
                                Erreur (GNP_ERR52,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     case 'o': case 'O': {
        *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': { strcat (res,"000");  break; }
                           case '1': { strcat (res,"001");  break; }
                           case '2': { strcat (res,"010");  break; }
                           case '3': { strcat (res,"011");  break; }
                           case '4': { strcat (res,"100");  break; }
                           case '5': { strcat (res,"101");  break; }
                           case '6': { strcat (res,"110");  break; }
                           case '7': { strcat (res,"111");  break; }
                           default : {
                                Erreur (GNP_ERR53,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     case 'x': case 'X': {
           *valeur++;
        lg = strlen (valeur);
        strcpy (res,"\0");
        for (i = 0 ; i < lg ; i++) {
            switch (*valeur) {
                           case '0': { strcat (res,"0000"); break; }
                           case '1': { strcat (res,"0001"); break; }
                           case '2': { strcat (res,"0010"); break; }
                           case '3': { strcat (res,"0011"); break; }
                           case '4': { strcat (res,"0100"); break; }
                           case '5': { strcat (res,"0101"); break; }
                           case '6': { strcat (res,"0110"); break; }
                           case '7': { strcat (res,"0111"); break; }
                           case '8': { strcat (res,"1000"); break; }
                           case '9': { strcat (res,"1001"); break; }
                 case 'A': case 'a': { strcat (res,"1010"); break; }
                 case 'B': case 'b': { strcat (res,"1011"); break; }
                 case 'C': case 'c': { strcat (res,"1100"); break; }
                 case 'D': case 'd': { strcat (res,"1101"); break; }
                 case 'E': case 'e': { strcat (res,"1110"); break; }
                 case 'F': case 'f': { strcat (res,"1111"); break; }
                           default : {
                                Erreur (GNP_ERR54,"AFFECT/INIT value syntax error");
                           }
            }
            *valeur++;
        }
        break;
     }
     default:
     {
        unsigned long aux_val;
        int           code_err,j,jj;
        char          result[64];
      
        code_err = sscanf(value,"%lu",&aux_val);  
        if ( code_err == -1 ) Erreur (GNP_ERR46,"AFFECT/INIT value syntax error");        
        strcpy(result,"");
        do
         {
           if ( (aux_val % 2) == 0 ) strcat(result,"0");
           else                      strcat(result,"1");
           aux_val = aux_val / 2; 
         } 
        while (aux_val != 0);

        jj = strlen(result);
        for (j=jj;j>0;j--)
          {
             res[jj-j] = result[j - 1];
          }
      res[jj]='\0';
     }
   }
/* nb-car: 1 minimum,
   sens  : -1 = vers la droite 1 = vers la gauche
*/
/* ajuster la longueur de la chaine en moins */
   lg = strlen (res);
   if (lg > nb_car) 
   {
     if (verbose == 1)
     {
       printf ("FORMAT VALUE too large value: MSB are truncated\n");
     }
     for (i = 0; i< (lg - nb_car) ; i++)
           *res++;
   }
/* ajuster la longueur de la chaine en + avec des 0 */
   if (lg < nb_car) {
      for (i = 0 ; i < (nb_car - lg) ; i ++) {
         tmp[i] = '0';
      }
      for (i = i ; i < nb_car ; i ++) {
         tmp[i] = *res;
         *res++;
      }
      tmp[i] = '\0';
      strcpy (res,(char *)tmp);
   }
   if (sens == GNP_UP) {
/* inverser la chaine */
      for (i = nb_car-1 ; i >=0 ; i--) {
          tmp[i] = *res;
          *res++;
      }
      tmp[nb_car] = '\0';
      strcpy (res,(char *)tmp);
   }
   strcpy (value,res);
   return (value);
}

/*----------------------------------------------------------------*/
void MajNumeroComment()
{
struct papat *tmp_papat;
struct pacom *tmp_pacom;
int nbligne = GNP_LIGNE_COURANTE +1; /* pour begin */

   tmp_papat = racine_papat;
   tmp_pacom = racine_pacom;
   while (( tmp_papat != NULL) && (tmp_pacom != NULL))
   {
      if (tmp_papat->LINE < tmp_pacom->POSITION)
      {
          nbligne++;
      }
      else
      {
              tmp_pacom->POSITION = tmp_pacom->POSITION + nbligne;
              nbligne =1;
              tmp_pacom = tmp_pacom->NEXT;
      }
      tmp_papat = tmp_papat->NEXT;
   }
}

