/*****************************************/
/* module : genpat.h                     */
/*****************************************/

#include <stdio.h>
extern FILE *yyin;
extern int yylineno;
/*-----------------------------------------------------------------*/
#define GNP_NO_TYPE        0  /* absence de type de variable de la struct varloc  */
#define GNP_TYPE_INT       1  /* type les  variables entieres de la struct varloc */
#define GNP_TYPE_CHAR      2  /* type les  variables char de la struct varloc     */
#define GNP_TYPE_CHAINE    3  /* type les  variables chaines de la struct varloc  */
#define GNP_TYPE_CONST     4  /* type les  constantes dans la struct varloc       */
                              /* les constantes sont chainees en fin de la liste  */
                              /* des variables dans chaque process                */

#define GNP_I_LABEL        1  /*  */
#define GNP_I_COMMENT      2  /*  */
#define GNP_I_ACTION       3  /*  */
#define GNP_I_AFFECT       4  /*  */
#define GNP_I_INIT         5  /*  */
#define GNP_I_PROCESS      6  /*  */
#define GNP_I_JMP          7  /*  */
#define GNP_I_JC           8  /*  */
#define GNP_I_JSR          9  /*  */
#define GNP_I_CONV        10  /*  */
#define GNP_I_VARLOC      11  /*  */
#define GNP_I_PLUS        12  /*  */
#define GNP_I_MOINS       13  /*  */
#define GNP_I_MULT        14  /*  */
#define GNP_I_DIV         15  /*  */
#define GNP_I_MOD         16  /*  */
#define GNP_I_ANDB        17  /*  */
#define GNP_I_ORB         18  /*  */
#define GNP_I_OUX         19  /*  */
#define GNP_I_LSL         20  /*  */
#define GNP_I_LSR         21  /*  */
#define GNP_I_COMPL       22  /*  */
#define GNP_I_OPPOSE      23  /*  */
#define GNP_I_NOT         24  /*  */
#define GNP_I_ORL         25  /*  */
#define GNP_I_ANDL        26  /*  */
#define GNP_I_INF         27  /*  */
#define GNP_I_SUP         28  /*  */
#define GNP_I_INFEQ       29  /*  */
#define GNP_I_SUPEQ       30  /*  */
#define GNP_I_DIFF        31  /*  */
#define GNP_I_EQUAL       32  /*  */
#define GNP_I_VARAFFECT   33  /*  */
#define GNP_I_IMMEDIAT    34  /*  */
#define GNP_I_RTS         35  /*  */
#define GNP_I_INT_PATTERN 36  /*  */
#define GNP_I_STR_PATTERN 37  /*  */
#define GNP_I_STR_EVENT   38  /*  */
#define GNP_I_IN_EVENT    39  /*  */
#define GNP_I_OUT_EVENT   40  /*  */
#define GNP_I_IDENT_EVENT 41  /*  */
#define GNP_I_SUITE_EVENT 42  /*  */
#define GNP_I_TO_EVENT    43  /*  */
#define GNP_I_DOWN_EVENT  44  /*  */
#define GNP_I_IMMED_EVENT 45  /*  */
#define GNP_I_NOP         46  /*  */
/*-----------------------------------------------------------------*/
#define GNP_DEFSFX "pat" /* suffixe par defaut si VH_PATSFX n'est pas definie dans l'environnement */
#define GNP_LENSFX 15 /* longueur plus du mou pour le suffixe du fichier de sortie */
#define GNP_VERBOSE "-v"  /*option pour lister les warnings */
#define GNP_SYNTAX  "-s"  /*option pour ne pas generer le fichier de sortie */
/*-----------------------------------------------------------------*/
extern char     *GNP_PAT;
extern TProcess *RACINE;
extern TProcess *PROCESS;
extern TVarloc  *CONSTANTES;
/*-----------------------------------------------------------------*/
extern yyparse();
extern void yyerror();
extern void StructInit();
extern void CreateProcess();
extern void CreeConstante();
extern void PutIdentConstante();
extern void PutStrConstante();
extern void CompteParam();
extern void IncremArg();
extern void InitVarloc();
extern void PutIdentVarloc();
extern void PutTypeVarloc ();
extern void ChangeProcess();
extern void EncodeEntier();
extern void EncodeChaine();
extern void EncodeProcess();
extern void EncodeVarloc();
extern void EncodeStrConst();
extern void CheckTypeVar();
extern int  GenFlag();
extern void PushFlag();
extern int  PopFlag();
extern void DeclarFlag();
extern void Interp();
extern void Interpreteur();
extern void EmpileFlag();

