/***************************************************************/
/* module genpat.c                                             */
/* date     : 20/11/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/***************************************************************/

#ident "@(#)GENPAT ver 2.0 Fev. 03 1993"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <malloc.h>
#include <varargs.h>
#include <pat103.h>
#include "mem.h"
#include "hash.h"
#include "libpat_l.h"
#include "conv.h"
#include "comment.h"
#include "label.h"
#include "action.h"
#include "init.h"
#include "affect.h"
#include "genpat.h"

TDeclar   un_port;
TAffect   un_affect;
TProcess *RACINE = NULL;
TProcess *PROCESS = NULL;
TVarloc  *CONSTANTES = NULL;
unsigned long       pilexec[MAXEXEC];
int       sommetexec = 0;
char     *GNP_PAT;
/*
extern    short verbose;
extern    short syntax;
*/


/*--------------------------------------------------------------*/
void yyerror(s)
  char *s;
{
 printf ("\nErreur Langage ligne %d : %s\n",yylineno,s);
 exit(1);
}
/*--------------------------------------------------------------*/
void StructInit()
{
    InitHash (hash_paiol);
    InitHash (hash_pagrp);
    InitHash (hash_ident);

  /*\
   initialisation du suffixe de fichier de sortie
  \*/
    GNP_PAT = Allouer (MAXTYPECHAR + 1 + GNP_LENSFX);
    strcpy(GNP_PAT,".");
    if (getenv ("VH_PATSFX"))
    {
      strcat (GNP_PAT,getenv("VH_PATSFX")); 
    }
    else
    {
      strcat (GNP_PAT,GNP_DEFSFX);
    }
}
/*--------------------------------------------------------------*/
void CreateProcess(ident)
char *ident;
{
struct StProcess *tmp_process;
  tmp_process =(TProcess *)Allouer (sizeof (struct StProcess));
  tmp_process->name = LocalAlloc(ident,hash_ident);
  tmp_process->next = NULL;
  tmp_process->pere = NULL;
  tmp_process->instretour = MAXINST;
  tmp_process->nb_param = 0;
  tmp_process->nb_arg = 0;
  tmp_process->sommetvarloc = 0;
  tmp_process->sommetinstr = 0;
  tmp_process->debcode = 0;
  tmp_process->cptflag = 0;
  tmp_process->sommetflag = 0;
  if (RACINE == NULL)
      RACINE = tmp_process;
  else {
      tmp_process->next = RACINE;
      RACINE = tmp_process;
  }
  PROCESS = tmp_process;
}
/*--------------------------------------------------------------*/
void CreeConstante(ident)
char *ident;
{
/*
 * cree un varloc de type constante
 * dans la pile des GNP_CONSTANTE
 */
struct StVarloc *tmp_const;
  tmp_const =(TVarloc *)Allouer (sizeof (struct StVarloc));
  tmp_const->name = ident;
  tmp_const->type = GNP_NO_TYPE;
  tmp_const->valeur.chaine = NULL;
  tmp_const->valeur.entier = 0;
  tmp_const->next = CONSTANTES;
  CONSTANTES = tmp_const;
}
/*--------------------------------------------------------------*/
void PutStrConstante(valeur)
char *valeur;
{
/* range la valeur (creee par lex) dans le champs chaine de la varloc courante du process courant
 * le type est positionne precedement par la grammaire
 */
  CONSTANTES->valeur.chaine = valeur;
  CONSTANTES->type = GNP_TYPE_CHAINE;
 }
/*-----------------------------------------------------------------*/
void IncremArg()
{
   PROCESS->nb_arg++;
}
/*--------------------------------------------------------------*/
void EncodeChaine(chaine)
char *chaine;
{
    PROCESS->instr[PROCESS->sommetinstr].pointeur = chaine;
    PROCESS->sommetinstr++;
}
/*----------------------------------------------------------------*/
void EncodeEntier(entier)
int entier;
{
   if (PROCESS->sommetinstr >= MAXINST) Erreur(GNP_ERR1,"overflow instructions");
   /* creation de l'instruction dans la pile de code */
   PROCESS->instr[PROCESS->sommetinstr].entier = entier;
   PROCESS->sommetinstr++;
}
/*-----------------------------------------------------------------*/
int FindVarloc(ident)
char *ident;
{
int i = 0;
   /* recherche de l'identificateur */
   while (i <= PROCESS->sommetvarloc && strcmp(ident,PROCESS->varloc[i].name)!= 0)
     i ++;
   if (i >= PROCESS->sommetvarloc )
   {
     Erreur(GNP_ERR2,"ident not found");
   }
    return (i);
}
/*-----------------------------------------------------------------*/
void EncodeVarloc(ident)
char *ident;
{
int i;
   i = FindVarloc(ident);
   PROCESS->instr[PROCESS->sommetinstr].pointeur = PROCESS->varloc[i].name;
   PROCESS->sommetinstr++;
}
/*--------------------------------------------------------------*/
void EncodeStrConst(ident)
char *ident;
{
TVarloc *tmpvarloc;
/* recherche de l'identificateur dans les variables globales */
   tmpvarloc = CONSTANTES;
   while ((tmpvarloc != NULL) && (strcmp(ident,tmpvarloc->name)!= 0))
      tmpvarloc = tmpvarloc->next;
   if ((tmpvarloc == NULL) || (tmpvarloc->type != GNP_TYPE_CHAINE))
       Erreur(GNP_ERR3,"ident not found or type not matched");
/* on a trouve la constante de type chaine on empile sa valeur dans la pile de code */
   EncodeChaine(tmpvarloc->valeur.chaine);
}
/*-----------------------------------------------------------------*/
void EncodeProcess(ident)
char *ident;
{
TProcess *tmp_process;
/* recherche du process par son nom */
   tmp_process = RACINE;
   while ((tmp_process != NULL) && (strcmp(ident,tmp_process->name)!= 0))
     tmp_process = tmp_process->next;
   if ( tmp_process == NULL )  Erreur(GNP_ERR4,"process not found");
/* sauvegarde de l'environnement de retour */
/* verification du nombre de parametres passe */
   if (PROCESS->nb_arg != tmp_process->nb_param)
      Erreur (GNP_ERR5,"parameter count error");
/* mise a jour du nombre de parametres passes pour un prochain appel */
   PROCESS->nb_arg = 0;
/* initialisation de l'environnement de l'appele */
   PROCESS->instr[PROCESS->sommetinstr].pointeur = (char *)tmp_process;
   PROCESS->sommetinstr++;
}
/*-----------------------------------------------------------------*/
void CheckTypeVar(ident,type)
char *ident;
int type;
{
int i = 0;
   for(i=0;i<MAXVAR;i++)
     {
     if(PROCESS->varloc[i].name != NULL)
       {
       if(strcmp(ident,PROCESS->varloc[i].name) == 0)
         break;
       }
     else
       {
/*
       (void)fprintf(stdout,"err:%s ",ident);
*/
       Erreur(GNP_ERR2,"ident not found ");
       }
     }
   if ((i == MAXVAR) || PROCESS->varloc[i].type != type)
      Erreur(GNP_ERR6,"type not matched");
}
/*--------------------------------------------------------------*/
void  CompteParam ()
{
/* compte tous les parametres du process courant
 * et met a jour le champ nb_param du process courant
 */
   PROCESS->nb_param = PROCESS->sommetvarloc;
}
/*--------------------------------------------------------------*/
void PutIdentVarloc(ident)
char *ident;
{
int i = 0;
   if (PROCESS->sommetvarloc >= MAXPARAM) Erreur (GNP_ERR7,"overflow ident");
   /*
    * recherche de l'identificateur
    * ident a ete cree par lex
    */
   while (i < PROCESS->sommetvarloc && strcmp(ident,PROCESS->varloc[i].name)!= 0)
     i ++;
   if (i < PROCESS->sommetvarloc ) Erreur(GNP_ERR8,"duplicate ident");
   /* creation d'un element */
   /* empilage de la chaine dans la pileparam */
   PROCESS->varloc[PROCESS->sommetvarloc].name = ident;
   PROCESS->varloc[PROCESS->sommetvarloc].type = GNP_NO_TYPE;
   PROCESS->sommetvarloc++;
}
/*--------------------------------------------------------------*/
void PutTypeVarloc (ident,type)
char *ident;
int type;
{
/*
 * initialise le champ type du varloc dont le nom est ident du process courant
 * avec le type
 */
int i = 0;
   while (i <= PROCESS->sommetvarloc)
   {
      if ( PROCESS->varloc[i].name == NULL)
      {
        Erreur (GNP_ERR96,"too mutch formal variables");
      }
      if ( ! ( strcmp(PROCESS->varloc[i].name,ident )) )
      {
         if (PROCESS->varloc[i].type == GNP_NO_TYPE) 
         {
            PROCESS->varloc[i].type = type;
            i = PROCESS->sommetvarloc; /* sortie de la boucle */
         }
         else
            Erreur(GNP_ERR9,"duplicate type");
      }
      i++;
   }
}
/*--------------------------------------------------------------*/
int GenFlag()
 {
   if(PROCESS->cptflag >= MAXFLAG) Erreur (GNP_ERR10,"overflow loops table increase MAXFLAG cste");
   return (PROCESS->cptflag++);
 }
/*-----------------------------------------------------------------*/
void PushFlag(l)
 int l ;
 {
   if (PROCESS->sommetflag >= MAXFLAG) Erreur(GNP_ERR11,"overflow pile execution");
   PROCESS->pileflag[PROCESS->sommetflag] = l;
   PROCESS->sommetflag++;
 }
/*-----------------------------------------------------------------*/
int PopFlag()
{
   if (PROCESS->sommetflag <= 0) Erreur(GNP_ERR12,"underflow pile execution");
   PROCESS->sommetflag --;
   return(PROCESS->pileflag[PROCESS->sommetflag]);
}
/*-----------------------------------------------------------------*/
void DeclarFlag(lab)
 int lab;
 {
  if(lab >= MAXFLAG) Erreur (GNP_ERR13,"overflow loops table increase MAXFLAG cste");
  PROCESS->tabflag[lab] = PROCESS->sommetinstr;
 }
/*-----------------------------------------------------------------*/
void Interp()
{
int  instcour = PROCESS->debcode;

#ifdef DEBUG
int j= 0,i = 0;printf("\n");
#endif

  while (instcour < PROCESS->sommetinstr)
     {
#ifdef DEBUG
  printf ("%d:%d\t",instcour,PROCESS->instr[instcour].entier);
  i++;
  if(i>8)
    {
     printf("\n");
     i=0;
    }
  j++;
#endif
     switch (PROCESS->instr[instcour].entier) {
       case GNP_I_LABEL : {
            instcour++;
            CreateLabel(PROCESS->instr[instcour].pointeur);
            instcour++;
            break;
       }
       case GNP_I_COMMENT : {
            instcour++;
            CreateComment(PROCESS->instr[instcour].pointeur);
            instcour++;
            break;
       }
       case GNP_I_ACTION : {
            instcour++;
            CheckAction(PROCESS->instr[instcour].pointeur);
            CreateAction(PROCESS->instr[instcour].pointeur);
            instcour++;
            break;
       }
       case GNP_I_AFFECT : {
            instcour ++;
            Affect();
            break;
       }
       case GNP_I_INIT : {
            instcour ++;
            Init();
            break;
       }
       case GNP_I_VARLOC : {
         int i;
            instcour++;
            i = FindVarloc(PROCESS->instr[instcour].pointeur);
/* ici il faudrait traiter le cas des types de variables */
	    pilexec[sommetexec] = PROCESS->varloc[i].valeur.entier;
            sommetexec++;
            instcour++;
            break;
       }
       case GNP_I_IMMEDIAT : {
            instcour++;
	    pilexec[sommetexec] = PROCESS->instr[instcour].entier;
            sommetexec++;
            instcour++;
            break;
       }
       case GNP_I_VARAFFECT : {
         int i;
            instcour++;
            i = FindVarloc(PROCESS->instr[instcour].pointeur);
            sommetexec--;
	    PROCESS->varloc[i].valeur.entier = pilexec[sommetexec ];
            instcour++;
            break;
       }
       case GNP_I_STR_PATTERN : {
            instcour++;
	    strcpy(un_affect.num_pattern,PROCESS->instr[instcour].pointeur);
            instcour++;
            break;
       }
       case GNP_I_INT_PATTERN : {
	    instcour ++;
            sommetexec--;
	    strcpy(un_affect.num_pattern,Conv(pilexec[sommetexec]));
            break;
       }
       case GNP_I_STR_EVENT : {
            instcour++;
	    strcpy(un_affect.event->value,PROCESS->instr[instcour].pointeur);
            instcour++;
            break;
       }
       case GNP_I_IN_EVENT : {
	    instcour ++;
            sommetexec--;
	    strcpy(un_affect.event->value,Conv(pilexec[sommetexec]));
            break;
       }
       case GNP_I_OUT_EVENT : {
	    instcour ++;
            sommetexec--;
	    strcpy(un_affect.event->value,"?");
	    strcat(un_affect.event->value,Conv(pilexec[sommetexec]));
            break;
       }
       case GNP_I_IDENT_EVENT : {
            instcour++;
            CreerEvent();
	    strcpy(un_affect.event->param,PROCESS->instr[instcour].pointeur);
            instcour++;
            break;
       }
       case GNP_I_SUITE_EVENT : {
            instcour++;
	    strcat(un_affect.event->param," ");
            strcat(un_affect.event->param,Conv(PROCESS->instr[instcour].entier));
            instcour++;
            break;
       }
       case GNP_I_TO_EVENT : {
	    instcour ++;
	    strcat(un_affect.event->param," ");
            strcat(un_affect.event->param,"TO");
            break;
       }
       case GNP_I_DOWN_EVENT : {
	    instcour ++;
	    strcat(un_affect.event->param," ");
            strcat(un_affect.event->param,"DOWNTO");
            break;
       }
       case GNP_I_NOP : {
	    instcour ++;
            break;
       }
       case GNP_I_JC : {
	    instcour ++;
            sommetexec--;
	    if (pilexec[sommetexec])  /* continue en sequence */
	       instcour ++;
            else                        /* sauter a l'instruction pointee par le flag */
	       instcour = PROCESS->tabflag[PROCESS->instr[instcour].entier];
            break;
       }
       case GNP_I_JMP : {
            instcour ++;
	    instcour = PROCESS->tabflag[PROCESS->instr[instcour].entier];
            break;
       }
       case GNP_I_JSR : {
         TProcess *tmp_process;
         int i;
	 /* rechreche du process fils */
            tmp_process = (TProcess*)PROCESS->instr[instcour +1].pointeur;
            if (tmp_process->pere != NULL) Erreur (GNP_ERR14,"interleave function call");
            tmp_process->pere = PROCESS;
            tmp_process->instretour = instcour + 2;
         /* passage des parametres ils sont en sommet de pilexec */
            for(i = tmp_process->nb_param -1; i >= 0; i--)
            {  
               sommetexec--;
               tmp_process->varloc[i].valeur.entier = pilexec[sommetexec];
            }
            PROCESS = tmp_process;
	    instcour = PROCESS->debcode;
            break;
       }
       case GNP_I_RTS : {
         TProcess *tmp_process;
            tmp_process = PROCESS;
	    instcour = PROCESS->instretour;
            PROCESS->instretour = 0;
            PROCESS = PROCESS->pere;
            tmp_process->pere = NULL;
            break;
       }
       case GNP_I_PLUS : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]+
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_MOINS : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec-1]-
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_MULT : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]*
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_DIV : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]/
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_MOD : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]%
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_ANDB : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]&
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_ORB : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]|
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_OUX : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec - 1] = pilexec[sommetexec -1]^
				        pilexec[sommetexec];
            break;
       }
       case GNP_I_LSL : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]<<
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_LSR : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]>>
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_COMPL : {
	    instcour ++;
	    pilexec[sommetexec -1] = ~pilexec[sommetexec -1];
            break;
       }
       case GNP_I_OPPOSE : {
	    instcour ++;
	    pilexec[sommetexec -1] = -pilexec[sommetexec -1];
            break;
       }
       case GNP_I_NOT : {
	    instcour ++;
	    pilexec[sommetexec -1] = !pilexec[sommetexec -1];
            break;
       }
       case GNP_I_ORL : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]||
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_ANDL : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]&&
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_INF : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]<
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_SUP : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]>
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_INFEQ : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]<=
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_SUPEQ : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]>=
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_DIFF : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]!=
				       pilexec[sommetexec];
            break;
       }
       case GNP_I_EQUAL : {
	    instcour ++;
            sommetexec--;
	    pilexec[sommetexec -1] = pilexec[sommetexec -1]==
				       pilexec[sommetexec];
            break;
       }
       default: Erreur(GNP_ERR15,"code instruction erreur");
     }
  }
}
/*-----------------------------------------------------------------*/
void Interpreteur()
{

   if ( syntax == 1)
   {
     printf ("\ncorrect syntax you can generate the output file\n");
     printf ("bye\n\n");
     exit(0);
   }
   
   PROCESS = RACINE;
   printf("\n");
   Interp();
   printf("\nCompiled with no Errors, output file generated...\n");
}
/*-----------------------------------------------------------------*/
void Banner ()
{
  printf ( "                                                    \n");
  printf ( "                                                    \n");
  printf ( "                                                    \n");
  printf ( "    @@@     @@@@@   @   @    @@@@      @    @@@@@   \n");
  printf ( "   @   @    @       @@  @    @   @    @ @     @     \n");
  printf ( "   @        @       @ @ @    @   @   @   @    @     \n");
  printf ( "   @  @@    @@@@@   @ @ @    @@@@    @@@@@    @     \n");
  printf ( "   @   @    @       @  @@    @       @   @    @     \n");
  printf ( "    @@@     @@@@@   @   @    @       @   @    @ (c) \n");
  printf(  "                                                     \n");
  printf(  "                   VERSION V2.0                      \n");
  printf(  "                                                     \n");
  printf(  "                   ALLIANCE VLSI CAD                 \n");
  printf(  "   (GEN)eneration (P)rocedurale de p(AT)terns de test\n");
  printf(  "   (c) copyright 1992 Laboratory UPMC/MASI/CAO-VLSI  \n");
  printf(  "                  all rights reserved                \n");
  printf(  "             e-mail : cao-vlsi@masi.ibp.fr           \n");
  printf ( "                                                    \n");
  printf ( "                                                    \n");
  printf ( "                                                    \n");
}

/*-----------------------------------------------------------------*/
void CallError()
  {
      Banner ();
      printf("syntaxe : genpat <file_name> [%s] [%s]\n",GNP_VERBOSE,GNP_SYNTAX);
      printf("\n\t%s Verbose", GNP_VERBOSE);
      printf("\n\t%s checks syntax, does'nt generate output file\n\n",GNP_SYNTAX);
      exit(1);
  }
/*-----------------------------------------------------------------*/
void main(argc,argv)
  int argc;
  char *argv[];
{

  verbose = 0;
  syntax  = 0;

  switch ( argc)
  {
    case 2:
    {
      break;
    }
    case 3:
    {
      if (strcmp (argv[2],GNP_SYNTAX) == 0)
      {
        syntax  = 1;
      }
      else
      {
        if (strcmp (argv[2],GNP_VERBOSE) == 0)
        {
          verbose = 1;
        }
        else
        {
        CallError();
        }
      }
      break;
    }
    case 4:
    {
      if (    (strcmp (argv[2],GNP_SYNTAX) == 0)
           || (strcmp (argv[3],GNP_SYNTAX) == 0) )
      {
        syntax  = 1;
      }
      else
      {	
        CallError();
      }
      break;
    }
    default:
    {
      CallError();
    }
  }
  Banner ();
  yyin = fopen (argv[1],"r");

  if (yyin == NULL)
  {
    Erreur(GNP_ERR16,"file not found");
  }

  argc = yyparse();
  fclose(yyin);

#ifdef STRUCT
     pat_debug(racine_paseq,"paseq");
#endif
exit(0);
};


