/***************************************************************/
/* module   : affect.c                                         */
/* date     : 20/11/92                                         */
/* auteurs  : RENAUD & VENOT                                   */
/***************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <varargs.h>
#include <pat103.h>
#include "mem.h"
#include "hash.h"
#include "libpat_l.h"
#include "affect.h"

/*----------------------------------------------------------------*/
void Affect()
{
extern TAffect un_affect;
TEvent *tmp_event;
char    *value       = " reservation de 20   reservation de 20  ";
int      dim = 0,num_ident,sens,i;
struct paevt *tmp_paevt;

    if ( GNP_TAB_PAIOL_CREE ==  GNP_INACTIF) {
       CreateTabPaiol();
       GNP_TAB_PAIOL_CREE = GNP_ACTIF;
    }
    tmp_paevt = NULL;
    CheckPattern (un_affect.num_pattern);
    MajPatternCourant(un_affect.num_pattern);
    while ( un_affect.event != NULL) {
       SplitIdent (un_affect.event->param,
                   un_affect.event->field_ident);
       CheckIdent (un_affect.event->param);
       if (strlen (un_affect.event->field_ident) != 0) {
          TraiterChaine (un_affect.event);
          CheckWidth (un_affect.event);
          if (strlen (un_affect.event->decomp.alpha) != 0) {
               Erreur (GNP_ERR55,"AFFECT expected a group name or paiol name\n");
          }
          else {
             if (strlen (un_affect.event->decomp.gauche) != 0) {
                strcat(un_affect.event->param," ");
                strcat(un_affect.event->param,un_affect.event->decomp.gauche);
             }
          }
       }
       num_ident = FindIdent (un_affect.event->param,hash_paiol);
       if ( num_ident != -1) {
         switch (
             ((struct paiol *)tab_ident[num_ident].pointeur)->MODE) {
           case 'R': case 'S': case 'O': {
             value = FormatOutputValue (un_affect.event->value,1,GNP_UP);
             break;
           }
           case 'I': {
             value = FormatInputValue (un_affect.event->value,1,GNP_UP);
             break;
           }

           case 'T': {
             value = FormatInOutValue (un_affect.event->value,1,GNP_UP);
             break;
           }
           default: {
               Erreur (GNP_ERR56,"unconsistent internal structures\n");
           }
         }
         tmp_paevt = CreatePaevt (tmp_paevt,num_ident,*value);
       }
       else {
         num_ident = FindIdent (un_affect.event->param,hash_pagrp);
         if  ( num_ident == -1) {
             (void) fprintf(stdout,"Err: %s ",un_affect.event->param);
             Erreur (GNP_ERR57,"AFFECT not yet declared identifier\n");
         }
         else {
           sens = ExisteIdent(un_affect.event->param,hash_pagrp)-> sens;
           dim = ((struct pagrp *)tab_ident[num_ident].pointeur)->LENGTH;
           switch (
               ((struct paiol *)tab_ident[num_ident -1].pointeur)->MODE) {
             case 'R': case 'S': case 'O':{
               value = FormatOutputValue (un_affect.event->value,dim,sens);
               break;
             }
             case 'I': {
               value = FormatInputValue (un_affect.event->value,dim,sens);
               break;
             }
             case 'T': {
               value = FormatInOutValue (un_affect.event->value,dim,sens);
               break;
             }
             default: {
                 Erreur (GNP_ERR58,"unconsistent internal structures\n");
             }
           }
           for (i = dim; i > 0; i-- )  {
              tmp_paevt = CreatePaevt (tmp_paevt,num_ident -i,*value);
              *value++;
           }
         }
       }
       tmp_event = un_affect.event;
       un_affect.event = un_affect.event->next;
       free(tmp_event);
    }
    CreatePapat (tmp_paevt,NULL);
    GNP_PATTERN_COURANT ++;
}



