/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : memory.c                                                    */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include"declar.h"

static chain_list * paralBleed();

/****************************************************************************
 *                         fonction test_latch();                           *
 ****************************************************************************/

  /*----------------------------------------------------------*
   |   teste si deux cones reboucles sont un latch            |
   |   entree : un pointeur de cone reboucle avec un autre    |
   |   sortie : 0 rien detecte,                               |
   |            1 bascule detectee                            |
   |            2 bleeder detecte                             |
   |            3 latch detecte                               |
   *----------------------------------------------------------*/

int test_latch(pt_cone,dualBoucle,pt_fig)

cone_list      *pt_cone;
desafig_list   *pt_fig; 
int            *dualBoucle;

{
list_list      *input,
               *output;

cone_list      *dual_cone,
	       *autre_cone;



   for (input = (list_list *) pt_cone->INCONE; input; input = input->NEXT)
   {
      for (output = (list_list *) pt_cone->OUTCONE; output; output = output->NEXT)
      {
         if ((output->DATA == input->DATA) &&	/* cones reboucles  */
          ((output->TYPE & LOOP)!=LOOP) &&
          ((input ->TYPE & LOOP)!=LOOP) &&
          ((input ->TYPE & EXT )!=EXT) )
         {
         long  outype;

         outype = (long) ((cone_list *) output->DATA)->TYPE;

         /*-----------------------------------------*
          | Les deux cones reboucles sont duaux     |
          *-----------------------------------------*/
            if (((outype & DUAL) == DUAL) && ((pt_cone->TYPE & DUAL) == DUAL))
            {
            int test ;
            test=test_ms(pt_cone,(cone_list*)output->DATA,pt_fig);

               if(test==2) 
               {
               dsbWarning(1,"test_latch",pt_cone->NAME,NULL,0);
               (*dualBoucle)++;
               }

               if(test==3)
               {
               dsbWarning(2,"test_latch",pt_cone->NAME,NULL,0);
               (*dualBoucle)++;
               }

               if(test==0)
               {
               dsbWarning(3,"test_latch",pt_cone->NAME,NULL,0);
               (*dualBoucle)++;
               }

            continue;
            }

         /*-----------------------------------------*
          | Un des deux cones reboucles est dual    |
          *-----------------------------------------*/
            if (((outype & DUAL) == DUAL) || ((pt_cone->TYPE & DUAL) == DUAL))
            {
            int test = 0;

               if ((pt_cone->TYPE & DUAL) == DUAL)
               {
               dual_cone = pt_cone;
               autre_cone = (cone_list *) output->DATA;
               }
               else
               {
               dual_cone = (cone_list *) output->DATA;
               autre_cone = pt_cone;
               }

               if ((test = detect_inv(dual_cone)) == 1)
               {
                  /* le dual est 1 inverseur  */
                  if ((test = test_reboucl(autre_cone, dual_cone,pt_fig)) == 3)
                  {
                  /* latch */
                  return(3); 
                  }
                  if (test == 2)
                  {
                  /* bleeder */
                  continue ;
                  }
                  /*----
                  if(testCnet3(autre_cone,dual_cone,pt_fig)==3) 
                  {
                  return(3);
                  }
                  ----*/
               continue ;
               }		/* finif le dual est un inverseur   */

               else
               {
               /* le dual n'est pas un inverseur   */
                  if ((test = test_reboucl(autre_cone, dual_cone,pt_fig)) == 2)
                  {
                  /* bleeder */
                  continue ;
                  }

                  if (test == 3)
                  {
                  /* latch */
                  return(3); 
                  }

                  /*----
                  if(testCnet3(autre_cone,dual_cone,pt_fig)==3) 
                  {
                  return(3);
                  }
                  -----*/
               /* rien detecte */
               continue ;
               }		/* finif le dual n'est pas un inverseur */
            }		/* finif 1 des deux est dual    */

         /*--------------------------------------------*
          | Aucun des deux cones reboucles n'est dual  |
          *--------------------------------------------*/
            else
            {
            /* aucun des deux cones reboucles n'est dual  */
            int test;
               if((test=test_ms(pt_cone,(cone_list*)output->DATA,pt_fig))==3)
               {
               return(3); 
               }

               if(test==2)
               {
               continue ;
               }

               /*----------------
               if(testCnet3(pt_cone,(cone_list*)output->DATA,pt_fig)==3)
               {
               return(3);
               }
               ----------------*/
            continue ;
            }
         }			/* finif cones reboucles  */
      }			/* end balayage outcone   */
   }				/* end balayage incone    */
}				/* end function           */



/****************************************************************************
 *                         fonction mark_inout();                           *
 ****************************************************************************/

     /*----------------------------------------------------*
      |  marque LOOP l INCONE du cone latch visant le cone |
      |  de rebouclage et l'OUTCONE du cone de rebouclage  |
      |  visant le cone Latch.                             |
      |                                                    |
      |  entree : autre_cone (le Latch)                    |
      |         : dual_cone (le cone de rebouclage)        |
      |                                                    |
      |  sortie : neant                                    |
      *----------------------------------------------------*/

void mark_inout(autre_cone, dual_cone)

cone_list      *dual_cone,
               *autre_cone;
{
    list_list      *pt_list;


    for (pt_list = (list_list *) dual_cone->OUTCONE; pt_list; pt_list = pt_list->NEXT)
    {
	if (autre_cone == (cone_list *) pt_list->DATA)
	{
	    pt_list->TYPE |= LOOP;
	    break;
	}
    }
    if (pt_list==NULL) 
    {
    dsbBug(7,"mark_inout",autre_cone->NAME,dual_cone->NAME,0);
    }

    for (pt_list = (list_list *) autre_cone->INCONE; pt_list; pt_list = pt_list->NEXT)
    {
	if (dual_cone == (cone_list *) pt_list->DATA)
	{
	    pt_list->TYPE |= LOOP;
	    break;
	}
    }
    if (pt_list==NULL) 
    {
    dsbBug(8,"mark_inout",dual_cone->NAME,autre_cone->NAME,0);
    }
}


/****************************************************************************
 *                         fonction detect_inv();                           *
 ****************************************************************************/

    /*------------------------------------------*
     |  Teste si un cone est un inverseur       |
     |  Entree : un pointeur de cone            |
     |  Sortie : 1 si le cone est un inverseur  |
     |           0 dans le cas contraire        |
     *------------------------------------------*/
 
int detect_inv(pt_cone)
cone_list      *pt_cone;
{
    link_list      *pt_link0,
                   *pt_link1;
    list_list      *pt_list0,
                   *pt_list1,
                   *pt_tmp;


    if (((pt_list0 = (list_list *) pt_cone->PATH) == NULL) || ((pt_list1 = (list_list *) pt_list0->NEXT) == NULL))
    {
	return (0);		/* moins de deux chemins  */
    }

    if (pt_list1->NEXT != NULL)
    {
	return (0);		/* plus de deux chemins  */
    }

    if (((pt_list0->TYPE) & VDD) == VDD)
    {
	pt_tmp = pt_list0;
	pt_list0 = pt_list1;
	pt_list1 = pt_tmp;
    }

    pt_link0 = (link_list *) pt_list0->DATA;
    pt_link1 = (link_list *) pt_list1->DATA;
    if ((pt_link0->NEXT != NULL) || (pt_link1->NEXT != NULL))
    {
	return (0);		/* plus d'un maillon par chemin  */
    }

    if (((pt_list0->TYPE & VSS) == VSS) && ((pt_list1->TYPE & VDD) == VDD))
    {
	if (pt_link0->TRANS->GRID->SIG == pt_link1->TRANS->GRID->SIG)
	    return (1);
	else
	{
	    return (0);
	}
    }
    else
    {
	return (0);
    }
}


/****************************************************************************
 *                         fonction test_reboucl();                         *
 ****************************************************************************/

   /*---------------------------------------------------------------* 
    | Detecte et marque les latch,bleeders...                       | 
    | entree: cr_cone, contient(?) un inverseur de contre reaction  | 
    |                  ou un bleeder.                               | 
    |         pt_cone, un cone dual.                                | 
    | sortie: 3 si cr_cone contient un inverseur attaque par        | 
    |                  le cone dual                                 | 
    |         2 si cr_cone contient un bleeder attaque par le dual  | 
    |         0 si rien n'est detecte                               | 
    *---------------------------------------------------------------*/
 
int test_reboucl(cr_cone, pt_cone,pt_fig)
cone_list      *cr_cone,
               *pt_cone;
desafig_list   *pt_fig;
{
    list_list      *pt_list0,
                   *pt_list1;
    link_list      *pt_link0,
                   *pt_link1;

   for (pt_list0 = (list_list *) cr_cone->PATH;
         pt_list0 != NULL ;
         pt_list0 = pt_list0->NEXT)
   {
   pt_link0 = (link_list *) pt_list0->DATA;
      if (pt_cone == (cone_list *) pt_link0->TRANS->GRID)
      {
      /* le maillon est attaque par le dual_cone   */

         if ((pt_link0->NEXT == NULL) 
            && (( pt_list0->TYPE & TPINVSS) != TPINVSS) 
            && (( pt_list0->TYPE & TNINVDD) != TNINVDD) 
            && ((pt_list0->TYPE & EXT) != EXT))
         {
         /* un seul maillon,chemin non degrade,de type vdd ou vss  */
         chain_list     *pt_chain;
         chain_list     *chainParal;

            for (pt_list1 = pt_list0->NEXT; pt_list1; pt_list1 = pt_list1->NEXT)
            {
            pt_link1 = (link_list *) pt_list1->DATA;
               if (pt_cone == (cone_list *) pt_link1->TRANS->GRID)
               {
                  if ((pt_link1->NEXT == NULL) 
                     && ((pt_list1->TYPE & EXT) != EXT) 
                     && ((pt_list0->TYPE & pt_list1->TYPE) != VDD) 
                     && ((pt_list0->TYPE & pt_list1->TYPE) != VSS) 
                     && ((pt_list1->TYPE & TPINVSS) != TPINVSS)
                     && ((pt_list1->TYPE & TNINVDD) != TNINVDD))
                  {
                  /* latch detecte  */
                  pt_chain = addchain(NULL, (void *) pt_list0 );
                  pt_chain = addchain(pt_chain, (void *) pt_list1 );
                  cr_cone->USER = addptype(cr_cone->USER, BLEEDER, (void *) pt_chain);
                  cr_cone->TYPE|=LATCH;
                  pt_list0->TYPE |= BLEEDER;
                  pt_list1->TYPE |= BLEEDER;
                  /*-------------------------
                  mark_inout(cr_cone,pt_cone);
                  -------------------------*/
                  paralBleed(cr_cone); 
                  marq_incone(cr_cone);
                  pt_fig->REG=addchain(pt_fig->REG,(void*)cr_cone);
                  return (3);
                  }
               }   /* finif */
            }   /* finfor imbrique   */
            /*------------------------------------------* 
             | un maillon unique attaque par pt_cone    | 
             | mais pas de latch   donc bleeder         | 
             *------------------------------------------*/
         cr_cone->TYPE|=BLEEDER;
         pt_list0->TYPE |= BLEEDER;
         pt_chain = addchain(NULL, (void *) pt_list0);
         cr_cone->USER = addptype(cr_cone->USER,BLEEDER, (void *) pt_chain);

         pt_chain=addchain(NULL,((void*)((link_list*)pt_list0->DATA)->TRANS));
         chainParal=paralBleed(cr_cone);
         pt_chain=append(pt_chain,chainParal);
         fx_chem1(pt_chain,cr_cone,pt_cone,pt_fig);
         pt_chain=delchain(pt_chain,pt_chain);
         mark_inout(cr_cone,pt_cone);
         /*------------------------
         return (2);
         ------------------------*/
         marq_incone(cr_cone);
         }   /* finif un seul maillon etc...  */
      }   /* finif maillon attaque par dual_cone  */
   }   /* finfor chemins  */
return (0);
}				/* finfunct       */


/****************************************************************************
 *                         fonction test_loop();                            *
 ****************************************************************************/

       /*--------------------------------------------------------* 
        |     teste les boucles sur deux cones en tenant compte  | 
        |     du TYPE LOOP                                       | 
        *--------------------------------------------------------*/

int test_loop(ptcone)
cone_list * ptcone;
{
list_list * incone=NULL;
list_list * outcone=NULL;
int loopErr = 0 ;

   for(incone=ptcone->INCONE;incone;incone=incone->NEXT)
   {
      for (outcone=ptcone->OUTCONE;outcone;outcone=outcone->NEXT)
      {
         if (  ( outcone->DATA==incone->DATA ) && 
               ((incone->TYPE & LOOP)!=LOOP)   && 
               ((outcone->TYPE & LOOP) != LOOP ) && 
               ((incone->TYPE & EXT) != EXT)      )
         {
         loopErr++;
         dsbError(4,"test_loop",ptcone->NAME,ptcone->INDEX,(((cone_list *)outcone->DATA)->NAME),((cone_list*)outcone->DATA)->INDEX);
       /*  affich_inetout(ptcone); */
         }
      }
   }
return(loopErr);
}


/****************************************************************************
 *                         fonction type_com_lat();                         *
 ****************************************************************************/

   /*-----------------------------------------------------------*
    | Type COMMAND le permier maillon de chaque chemin des      |
    | cones Latch                                               |
    *-----------------------------------------------------------*/

void type_com_lat(cone)
cone_list * cone;
{
list_list * path = NULL;

   for (path=cone->PATH;path != NULL;path=path->NEXT)
   {
   cone_list * in = NULL;
   list_list * incone = NULL;

      if ((path->TYPE & BLEEDER)==BLEEDER) continue;

   in=((cone_list *) ((link_list*)path->DATA)->TRANS->GRID);

      for (incone=cone->INCONE; incone != NULL; incone=incone->NEXT)
      {
         if ((incone->TYPE & LOOP)==LOOP) continue;
         if (incone->DATA==(char*)in) 
         {
         (incone->TYPE)|=COMMAND;
         break;
         }
      }

      if (incone==NULL) 
      {
      dsbBug(11,"type_com_lat",cone->NAME,NULL,0);
      }
   }
}

      


/****************************************************************************
 *                         fonction affich_inetout();                       *
 ****************************************************************************/

     /*---------------------------------------------------*
      |  Affiche les INCONE et OUTCONE  d'un cone         |
      |  (utilise en fait pour debugger test_latch!!)     |
      *---------------------------------------------------*/

void affich_inetout(ptcone)
cone_list *ptcone;
{
list_list *ptin;
list_list *ptout;
printf("Liste des incones:\n");
   for(ptin=ptcone->INCONE;ptin;ptin=ptin->NEXT)
   {
   if((ptin->TYPE & CONE_TYPE)==CONE_TYPE)
    printf("incone;(%d)%s\n",((cone_list*)ptin->DATA)->INDEX,((cone_list*)ptin->DATA)->NAME);
   }
printf("Liste des outcones:\n");
   for(ptout=ptcone->OUTCONE;ptout;ptout=ptout->NEXT)
   {
   if((ptout->TYPE & CONE_TYPE)==CONE_TYPE)
   printf("outcone:(%d)%s\n",((cone_list*)ptout->DATA)->INDEX,((cone_list*)ptout->DATA)->NAME);
  }
}



/****************************************************************************
 *                         fonction test_ms();                              *
 ****************************************************************************/

       /*----------------------------------------* 
        | Detecte et marque les latchs           | 
        | dont les deux cones ne sont pas        | 
        | duaux.                                 | 
        | entree: 2 pointeurs de cones           | 
        |         le pointeur de la figure desa  | 
        | sortie: 3 si un latch est detecte      | 
        |         2 si un bleeder est detecte    | 
        |         0 dans le cas contraire        | 
        *----------------------------------------*/

int test_ms(pt_cone0,pt_cone1,pt_fig)

cone_list *pt_cone0,
          *pt_cone1;
desafig_list *pt_fig;

{
list_list *pt_list0,
          *pt_list1,
          *pt_list2,
          *pt_list3;

link_list *pt_link0,
          *pt_link1,
          *pt_link2,
          *pt_link3;



for(pt_list0=(list_list*)pt_cone0->PATH;pt_list0;pt_list0=pt_list0->NEXT)
   {
   pt_link0=(link_list*)pt_list0->DATA;
   if      ( (pt_cone1==(cone_list*)pt_link0->TRANS->GRID) 
           &&(pt_link0->NEXT==NULL) 
           &&((pt_list0->TYPE & TPINVSS) != TPINVSS)  
           &&((pt_list0->TYPE & TNINVDD) != TNINVDD)  
           &&((pt_list0->TYPE & EXT) != EXT) )
      {
      for(pt_list1=pt_list0->NEXT;pt_list1;pt_list1=pt_list1->NEXT)
         {
         pt_link1=(link_list*)pt_list1->DATA;
         if    ( (pt_cone1==(cone_list*)pt_link1->TRANS->GRID) 
               &&(pt_link1->NEXT==NULL) 
               &&((pt_list1->TYPE & TNINVDD) != TNINVDD) 
               &&((pt_list1->TYPE & TPINVSS) != TPINVSS) 
               &&((pt_list1->TYPE & EXT) != EXT) 
               &&((pt_list0->TYPE & pt_list1->TYPE) != VDD) 
               &&((pt_list0->TYPE & pt_list1->TYPE) != VSS)  )
            {
            for(pt_list2=(list_list*)pt_cone1->PATH;pt_list2;pt_list2=pt_list2->NEXT)
               {
               pt_link2=(link_list*)pt_list2->DATA;
               if   ( (pt_cone0==(cone_list*)pt_link2->TRANS->GRID) 
                    &&(pt_link2->NEXT==NULL) 
                    &&((pt_list2->TYPE & TPINVSS) != TPINVSS)  
                    &&((pt_list2->TYPE & TNINVDD) != TNINVDD)  
                    &&((pt_list2->TYPE & EXT) != EXT) )
                  {
                  chain_list *pt_chain;
                  chain_list * chainParal ;
                  for(pt_list3=pt_list2->NEXT;pt_list3;pt_list3=pt_list3->NEXT)
                     {
                     pt_link3=(link_list*)pt_list3->DATA;
                     if ( (pt_cone0==(cone_list*)pt_link3->TRANS->GRID) 
                        &&(pt_link3->NEXT==NULL) 
                        &&((pt_list3->TYPE & TNINVDD) != TNINVDD) 
                        &&((pt_list3->TYPE & TPINVSS) != TPINVSS) 
                        &&((pt_list3->TYPE & EXT) != EXT) 
                        &&((pt_list3->TYPE & pt_list2->TYPE) != VDD) 
                        &&((pt_list3->TYPE & pt_list2->TYPE) != VSS)  )
                        {
                        /* latch detecte  */
                        list_list * list_tmp0,
                                  * list_tmp1;
                        lotrs_list  *pt_trans0,
                                    *pt_trans1;
                        list_tmp0=((pt_list0->TYPE&VDD)==VDD ? pt_list0:pt_list1);
                        list_tmp1=((pt_list2->TYPE&VDD)==VDD ? pt_list2:pt_list3);

                        pt_trans0=((link_list*)list_tmp0->DATA)->TRANS;
                        pt_trans1=((link_list*)list_tmp1->DATA)->TRANS;

                        if ((float)(pt_trans0->WIDTH/pt_trans0->LENGTH) >  (float)(pt_trans1->WIDTH/pt_trans1->LENGTH) )
                           {
                           /* c'est le cone qui a l'inverseur le plus faible
                           qui est le latch    */
                           pt_cone1->TYPE |= LATCH;
                           pt_chain=addchain(NULL,(void*)pt_list2);
                           pt_chain=addchain(pt_chain,(void*)pt_list3);
                           pt_cone1->USER=addptype(pt_cone1->USER,BLEEDER,(void*)pt_chain);
                           pt_list2->TYPE|=BLEEDER;
                           pt_list3->TYPE|=BLEEDER;
                           mark_inout(pt_cone1,pt_cone0);
                           paralBleed(pt_cone1);
                           pt_fig->REG=addchain(pt_fig->REG,(void*)pt_cone1);
                           return(3);
                           }
                        else if ((float)(pt_trans0->WIDTH/pt_trans0->LENGTH) < (float)(pt_trans1->WIDTH/pt_trans1->LENGTH) )
                           {
                           /* c'est le cone qui a l'inverseur le plus faible
                           qui est le latch    */
                           pt_cone0->TYPE |= LATCH;
                           pt_chain=addchain(NULL,(void*)pt_list0);
                           pt_chain=addchain(pt_chain,(void*)pt_list1);
                           pt_cone0->USER=addptype(pt_cone0->USER,BLEEDER,(void*)pt_chain);
                           pt_list0->TYPE|=BLEEDER;
                           pt_list1->TYPE|=BLEEDER;
                           paralBleed(pt_cone0);
                           mark_inout(pt_cone0,pt_cone1);
                           pt_fig->REG=addchain(pt_fig->REG,(void*)pt_cone0);
                           return(3);
                           }
                        else 
                           {
                           /* Point Memorisant */

                           pt_cone0->TYPE |= MEMORY;
                           pt_cone1->TYPE |= MEMORY;

                           pt_list0->TYPE|=BLEEDER;
                           pt_list1->TYPE|=BLEEDER;
                           pt_list2->TYPE|=BLEEDER;
                           pt_list3->TYPE|=BLEEDER;

                           pt_chain=addchain(NULL,(void*)pt_list0);
                           pt_chain=addchain(pt_chain,(void*)pt_list1);
                           pt_cone0->USER=addptype(pt_cone0->USER,BLEEDER,(void*)pt_chain);
                           pt_chain=addchain(NULL,(void*)pt_list2);
                           pt_chain=addchain(pt_chain,(void*)pt_list3);
                           pt_cone1->USER=addptype(pt_cone1->USER,BLEEDER,(void*)pt_chain);
                           pt_fig->REG=addchain(pt_fig->REG,(void*)pt_cone0);
                           pt_fig->REG=addchain(pt_fig->REG,(void*)pt_cone1);

                           /*---------------------------
                           mark_inout(pt_cone0,pt_cone1);
                           mark_inout(pt_cone1,pt_cone0);
                           ----------------------------*/
                           marq_incone(pt_cone0);
                           marq_incone(pt_cone1);

                           pt_cone0->USER=addptype(pt_cone0->USER,MEMORY,(void*)pt_cone1);
                           pt_cone1->USER=addptype(pt_cone1->USER,MEMORY,(void*)pt_cone0);

                           return(3);
                           }
                        }     /* finif latch detecte  */ 
                     }        /* fin balayage 2 sur pt_cone 1 */ 
                  pt_cone1->TYPE|=BLEEDER;
                  pt_list2->TYPE|=BLEEDER;
                  pt_chain=addchain(NULL,(void*)pt_list2);
                  pt_cone1->USER=addptype(pt_cone1->USER,BLEEDER,(void*)pt_chain);
                  pt_chain=addchain(NULL,((void*)((link_list*)pt_list2->DATA)->TRANS));
                  chainParal=paralBleed(pt_cone1);
                  pt_chain=append(pt_chain,chainParal);
                  fx_chem1(pt_chain,pt_cone1,pt_cone0,pt_fig);
                  pt_chain=delchain(pt_chain,pt_chain);
                  /*------------------------------------------
                  mark_inout(pt_cone1,pt_cone0);
                  -------------------------------------------*/
                  marq_incone(pt_cone1);
                  return(2);   
                  }           /* finif inv 2 suspecte   */    
               }              /* fin balayage 1 sur pt_cone 1 */     
            return(0);        /* inverseur 2 non trouvable    */
            }       /* finif pt_cone0 contient 1 inv attaque par pt_cone1*/
         }          /* fin balayage 2 sur pt_cone0 */
      return(0);    /* inverseur 1 non trouve      */
      }              /* finif inverseur suspecte dans pt_cone0 */
   }                    /* fin balayage 1 sur pt_cone0   */
return(0);           /* inverseur 1 non trouvable     */
}                    /* finfonction  */



/****************************************************************************
 *                         fonction fx_chem1();                             *
 ****************************************************************************/

      /*---------------------------------------------------------* 
       | void fx_chem1                                           | 
       | Marque les fx_chem1 du aux  bleeders et aux latch       | 
       | Les chemins ne sont pas supprimes                       | 
       | Entree : l'input du bleeder ou du maillon CR            | 
       |          le pointeur de figure desa                     | 
       |          le transistor constituant le bleeder ou CR     | 
       | Sortie : Neant                                          | 
       *---------------------------------------------------------*/

void  fx_chem1 (ptchain,ptconelb,ptcone,ptfig)
chain_list * ptchain;  /* chaine de transistors constituant les branches bleeder */ 
cone_list *ptcone;     /* l'input du latch ou du bleeder */
cone_list *ptconelb;   /* le cone latch ou bleeder */
desafig_list *ptfig;

{
cone_list * ptconei = NULL;
list_list * ptouti = NULL;
int flag;


   for (ptouti=ptcone->OUTCONE;ptouti;ptouti=ptouti->NEXT)
   {
   /* pour chaque cone qu'attaque le cone de rebouclage */
   list_list  * ptlist  = NULL;
   locon_list * ptconct = NULL;
   list_list  * ptpath  = NULL;
   flag = 0;
      if (( ptouti->TYPE & CONE_TYPE)==CONE_TYPE)
      ptconei=(cone_list*)ptouti->DATA;
      else /* outcone de type connecteur */
      {
      ptype_list * ptuser ;
      ptconct=(locon_list*)ptouti->DATA;
      ptuser=getptype(ptconct->USER,(short)EXT);
      ptconei=(cone_list*)ptuser->DATA;
      }
      if(ptconei==ptconelb) continue ;
      
            for(ptpath=ptconei->PATH;ptpath;ptpath=ptpath->NEXT)
            {
            link_list * ptlink;
               for(ptlink=(link_list*)ptpath->DATA;ptlink;ptlink=ptlink->NEXT)
               {
                  if ( ((ptlink->TYPE & TP)==TP)||((ptlink->TYPE & TN)==TN) )
                  {
                  chain_list * ptchain0;
                     for(ptchain0=ptchain;ptchain0;ptchain0=ptchain0->NEXT)
                     {
                        if((char*)ptlink->TRANS==(char *)ptchain0->DATA)
                        {
                        (ptpath->TYPE)|=BLEEDER;
                        flag=1;
                        /* on marque LOOP l'outcone de ptcone qui pointe ptconei */
            /*            marq_outcone(ptcone,ptconei);*/
                        }
                     }
                  }
               }   /* fin balayage maillon */
            }   /* fin balayage chemin */
      if (flag==1) 
      {
      /* on marque LOOP les incones en trop du conei dus aux faux chemins */
      marq_incone(ptconei);
      }
   } /* fin balayage cones */
} /* fin fonction */



/****************************************************************************
 *                         fonction marq_incone();                          *
 ****************************************************************************/

      /*------------------------------------------------------*
       | Marque les incone de ptcone dus aux chemins BLEEDER  |
       | si ils n'apparaissent pas dans d'autres chemins      |
       | fonctionnels                                         | 
       | on en profite pour marquer l'outcone de incone qui   |
       | pointe sur ptcone                                    |
       *------------------------------------------------------*/

void marq_incone(ptcone)
cone_list * ptcone;
{
list_list * ptpath;
chain_list * ptchain = NULL; /* liste des incone qui devront etre supprimes */  
int in_fonc=0;


   for(ptpath=ptcone->PATH;ptpath;ptpath=ptpath->NEXT)
   {
    /*--------------------------------------------*/
    /* on cherche les incones des chemins BLEEDER */
    /*--------------------------------------------*/
      if((ptpath->TYPE & BLEEDER)==BLEEDER)
      {
      /* si chemin non fonctionnel  */
      link_list * ptmail;
         for(ptmail=(link_list*)ptpath->DATA;ptmail;ptmail=ptmail->NEXT)
         {
            if ( ((ptmail->TYPE & TN)==TN)||((ptmail->TYPE & TP)==TP) )
            {
            /*----------------------------------------------*/
            /* incone de type cone                          */
            /*----------------------------------------------*/
            char  * incone;
            list_list * ptpath1;
            incone=((char*)(ptmail->TRANS->GRID));
            in_fonc=0;
            /*---------------------------------------------*/
            /* on cherche si l'incone est present dans un  */
            /*     chemin non marque BLEEDER               */
            /*---------------------------------------------*/
               for (ptpath1=ptcone->PATH;ptpath1;ptpath1=ptpath1->NEXT)
               {
                  if ( (ptpath1->TYPE & BLEEDER)!=BLEEDER)
                  {
                  link_list * ptmail1;
                     for(ptmail1=(link_list*)ptpath1->DATA;ptmail1;ptmail1=ptmail1->NEXT)
                     {
                     char * ptcone1;
                        if ( ((ptmail1->TYPE & TN)==TN)||((ptmail1->TYPE & TP)==TP) )
                        {
                        ptcone1=(char*)ptmail1->TRANS->GRID;
                           if(ptcone1==incone) 
                           {
                           /*----------------------------------------*/
                           /* l'incone du au chemin non fonc         */
                           /* est retrouve dans un chemin fonctionnel */
                           /*----------------------------------------*/
                           in_fonc=1;
                           break;
                           } 
                        }
                     } /* finfor maillon de chemin fonc */
                  }    /* finif chemin fonc             */
                  if (in_fonc==1) break;
               }       /* finfor chemin fonc(?)  */

            /*-------------------------------------------------------------*/
            /* si a l'issue du balayage des chemins fonc l'incone          */
            /* du a un faux chemin n'a pas ete trouve, on le marque LOOP   */
            /*-------------------------------------------------------------*/

               if (in_fonc==0) 
               {
               list_list * in=NULL;
                  for (in=ptcone->INCONE;in;in=in->NEXT)
                  {
                     if ( incone==(char*)(in->DATA) ) 
                     {
                     (in->TYPE) |= LOOP ; 
                     marq_outcone((cone_list*)incone,ptcone);
                     break;
                     }
                  }

                  if (in==NULL) 
                  {
                  dsbBug(9,"marq_incone",ptcone->NAME,NULL,0);
                  }
                  
               }
            }   /* finif mail tp ou tn */
            else
            {
            /*----------------------------------------------*/
            /* incone de type connecteur                    */
            /*----------------------------------------------*/
            char       * connect = NULL;
            list_list  * ptpath2 = NULL;
            in_fonc = 0;
            connect=(char*)ptmail->TRANS;
               for (ptpath2=ptcone->PATH;ptpath2;ptpath2=ptpath2->NEXT)
               {
                  if ( ((ptpath2->TYPE & BLEEDER)!=BLEEDER) &&
                       ((ptpath2->TYPE & EXT)==EXT)    )
                  {
                  link_list *ptmail2 = NULL;
                     for (ptmail2=(link_list*)ptpath2->DATA;ptmail2->NEXT;ptmail2=ptmail2->NEXT);
                     if (connect==(char*)ptmail2->TRANS) 
                     {
                     in_fonc=1;
                     break;
                     }
                  }
               }

               if (in_fonc==0)
               {
               list_list *in = NULL;
                  for (in=ptcone->INCONE;in;in=in->NEXT)
                  {
                     if (connect==(char*)in->DATA)
                     {
                     in->TYPE |= LOOP;
                     break;
                     }
                  }
               }
            }
         } /* finfor maillon de faux chemin  */ 
      } /* finif chemin non fonc    */
   }    /* finfor chemin */
}


/****************************************************************************
 *                         fonction marq_outcone();                         *
 ****************************************************************************/

     /*---------------------------------------------------------*
      |  marq_outcone : marque LOOP l'outcone pointe par output | 
      |  du cone pointe par ptcone                              |
      *---------------------------------------------------------*/

void marq_outcone(ptcone,output)
cone_list * ptcone;
cone_list * output;
{
list_list * ptout=NULL;

   for (ptout=ptcone->OUTCONE;ptout;ptout=ptout->NEXT)
   {
      if ( ptout->DATA==((char*)output) )
      {
      (ptout->TYPE)|= LOOP;
      break;
      }
   }

   if (ptout==NULL) 
   {
   dsbBug(10,"marq_outcone",ptcone->NAME,NULL,0);
   }
}
   
      

/****************************************************************************
 *                         fonction del_listincone();                       *
 ****************************************************************************/

      /*--------------------------------------------------------* 
       | supprime dans la liste des incones ,les incones        | 
       |  contenus dans la chaine pointee par ptchain           | 
       *--------------------------------------------------------*/

list_list * del_listincone (ptlist,ptchain)
list_list *ptlist;
chain_list * ptchain;
{
chain_list * pt1=NULL;


   if ( (ptlist==NULL)||(ptchain==NULL) )
   {
   dsbBug(1,"del_listincone",NULL,NULL,0);
   }

   for (pt1=ptchain;pt1;pt1=pt1->NEXT)
   {
   ptlist=rmv_list(ptlist,pt1->DATA);
   }
return(ptlist);
}



/****************************************************************************
 *                         fonction affich_link();                          *
 ****************************************************************************/

void affich_link(ptlink,ptlist,ptcone)
link_list * ptlink;
list_list * ptlist;
cone_list * ptcone;
{
   if (ptlink->NEXT != NULL) fprintf(DESB_ERR_FILE,"  Next Link Non Null \n");
   if (ptcone != (cone_list*)ptlink->TRANS->GRID) 
   {
   fprintf(DESB_ERR_FILE,"  Grilles  %s -LV- %s \n",ptcone->NAME,(cone_list*)(ptlink->TRANS->GRID)->NAME);
   }
   if ( (ptlist->TYPE & TPINVSS) == TPINVSS)  fprintf(DESB_ERR_FILE,"  Degrade bas \n");
   if ( (ptlist->TYPE & TNINVDD) == TNINVDD)  fprintf(DESB_ERR_FILE,"  Degrade haut \n");
   if ( (ptlist->TYPE & EXT) == EXT) fprintf(DESB_ERR_FILE,"  Externe \n");
fprintf(DESB_ERR_FILE,"\n");
} 
 
/****************************************************************************
 *                         fonction testCnet3                               *
 ****************************************************************************/
/*--------------------------------------------------------------------------+
| Detecte si les deux cones reboucles fournis en entree constituent un      |
| latch de type CNET3                                                       |
| Le cone non dual doit contenir deux branches de type differents de deux   |
| maillons chacunes. le premier maillon de chacune doit etre de type differ |
|                                                                           |
| Entree: qcCone Le cone non Dual                                           |
|         dlCone Le cone Dual                                               |
|         fig Le pointeur sur la figure Desb                                |
|                                                                           |
| Retour: 3  Le latch est detecte                                           |
|         -1 Pas de latch detecte                                           |
+--------------------------------------------------------------------------*/
static short testCnet3(qcCone,dlCone,fig)
cone_list * qcCone ;
cone_list * dlCone ;
desafig_list *fig   ;
{
list_list * path = NULL ;
link_list * link = NULL ;
list_list * tabPath[3] ;
link_list * tabLink[3] ;
short       idxTab = 0 ;
short       nbLink = 0 ;
long        typePath = 0 ;
long        typeLink = 0 ;
chain_list * chain = NULL ;

   for(path=qcCone->PATH;path!=NULL;path=path->NEXT)
   {
   nbLink=0;

      if((path->TYPE & BLEEDER)==BLEEDER) continue ;
      if((path->TYPE & EXT)==EXT) continue ;

      for(link=(link_list*)path->DATA; link->NEXT!=NULL; link=link->NEXT)
      nbLink++; 
      if(nbLink>1) continue ;

      if((cone_list*)link->TRANS->GRID != dlCone) continue ;

      if(idxTab==2) return(-1) ;

   tabLink[idxTab]=link ;
   tabPath[idxTab]=path ;
   idxTab++;
   }

typePath = (tabPath[0])->TYPE | (tabPath[1])->TYPE ; 
typeLink = (tabLink[0])->TYPE | (tabLink[1])->TYPE ;

   if((typePath & VDD)!=VDD) return(-1);
   if((typePath & VSS)!=VSS) return(-1);
   if((typePath & TNINVDD)==TNINVDD) return(-1);
   if((typePath & TPINVSS)==TPINVSS) return(-1);

(tabPath[0])->TYPE |= BLEEDER ;
(tabPath[1])->TYPE |= BLEEDER ;
chain=addchain(NULL,(void*)tabPath[0]);
chain=addchain(chain,(void*)tabPath[1]);
qcCone->USER=addptype(qcCone->USER,BLEEDER,(void*)chain);
qcCone->TYPE |= LATCH ;
fig->REG = addchain(fig->REG,(void*)qcCone);
marq_incone(qcCone);
return(3);
}

/****************************************************************************
 *                         fonction paralBleed                              *
 ****************************************************************************/
/*--------------------------------------------------------------------------+
| Entree un cone latch ou Bleeder                                           |
| Sortie NULL aucune branche Bleeder parallele n'a ete trouvee              |
|        La liste des transistors // constituant la contre reaction        |
*--------------------------------------------------------------------------*/
static chain_list * paralBleed(cone)
cone_list * cone ;
{
ptype_list * user ;
chain_list * chain ;
list_list * path0;
list_list * path1;
link_list * link0;
link_list * link1;
chain_list * chainRes= NULL ;
chain_list * chainPath=NULL ;

user = getptype(cone->USER,BLEEDER);
   if(user==NULL)
   {
   dsbBug(12,"paralBleed",cone->NAME,"BLEEDER",0);
   }

chain=(chain_list*)user->DATA ;

   for(chain=(chain_list*)user->DATA;
       chain != NULL ;
       chain = chain->NEXT)
   {
   path0=(list_list*)chain->DATA;
   link0=(link_list*)path0->DATA;
      for(path1=cone->PATH;path1!=NULL;path1=path1->NEXT)
      {
         if((path1->TYPE & BLEEDER)==BLEEDER) continue ;
      link1=(link_list*)path1->DATA;

         if(link1->NEXT!=NULL) continue ;
         if((link0->TYPE & link1->TYPE & (TN|TP)) == (long)0) continue ;
         if((path0->TYPE & path1->TYPE & (VDD|VSS))==(long)0) continue ;
         if(link0->TRANS->GRID!=link1->TRANS->GRID) continue ;
      path1->TYPE |= BLEEDER ;
      chainPath=addchain(chainPath,(void*)path1);
      chainRes=addchain(chainRes,(void*)link1->TRANS);
      }
   }
   if(chainRes!=NULL) 
   user->DATA=(void*)append((chain_list*)user->DATA,chainPath);
   
return(chainRes);
}
            
        
/****************************************************************************
 *                         fonction dsbMasterSlave();                       *
 ****************************************************************************/
/*--------------------------------------------------------------------------+
| test si le cone detecte LATCH fait partie d'une maitre esclave sclib      |
| il s'agit de deux latch dont l'un crache dans l'autre a travers un invrs  |
| la commande du deuxieme (slave) est inverse du maitre. ceci es fait a     |
| l'aide exclusivement d'un inverseur drive par la commande du maitre       |
| 
| On regarde si on est sur le slave. si oui, on cher l'incone de l'incone   |
| data su slave. on verifie que les deux commandes sont inverse l'une de    |
| l'autre a travers un inverseur                                            |
+--------------------------------------------------------------------------*/
short dsbMasterSlave(cone)
cone_list * cone ;
{
list_list * in ;
list_list * inData;
list_list * inComSlv = NULL;
list_list * inComMst = NULL;
cone_list * incone ;
cone_list * mastCone ;
cone_list * inutilCone ;
int nbIn = 0 ;
int nbComMst = 0  ;
int nbComSlv = 0  ;

   /* On compte les entrees du slave */
   for(in = cone->INCONE ; in!=NULL;in=in->NEXT) 
   {
   nbIn++ ;
      if((in->TYPE & COMMAND)!=COMMAND) 
      {
      inData = in ;
      }
      else
      {
      inComSlv=in ;
      nbComSlv++;
      }
   }
   if(nbComSlv != 1 ) return(-1) ;
   if(nbIn != 2)        return(-1);
   if((inData->TYPE & CONE_TYPE)!=CONE_TYPE)    return(-1);
   if((inComSlv->TYPE & CONE_TYPE)!=CONE_TYPE)  return(-1) ; 

incone=(cone_list*)inData->DATA ;        /* incone est la sortie du maitre ? */
   if(detect_inv(incone)==0) return(-1); /* incone doit etre un inverseur  */  

inutilCone=incone ;     /* on sauve le noeud entre sortie maitre et entree 
                           inverseur entree slave  pour le vbe           */
in=incone->INCONE;      /* entree de l'inverseur de sortie du maitre */
   if((in->TYPE & CONE_TYPE)!=CONE_TYPE) return(-1);

incone = (cone_list*) in->DATA ; /* incone est il le maitre */
   if((incone->TYPE & LATCH) != LATCH) return(-1);
   
   /* On compte les entrees du Master */
   for(in=incone->INCONE; in!=NULL;in=in->NEXT)
   {
      if((in->TYPE & COMMAND)==COMMAND) 
      {
      inComMst=in ;
      nbComMst++;
      }
   }
   if(nbComMst != 1) return(-1) ;

mastCone=incone;

incone=(cone_list*)inComSlv->DATA ;       /* cone commande du slave */
   if(detect_inv(incone)==0) return(-1) ; /* comSlv n'est pas 1 inverseur */
in=incone->INCONE;                        /* entree de l'inverseur        */

   /* L'entree de l'inverseur et la commande du master doivent etre =     */
   if( ((void*)in->DATA)!=((void*)inComMst->DATA) ) return(-1) ;

incone->TYPE |= INUTIL ;
inutilCone->TYPE |= INUTIL ;
cone->TYPE |= SLAVE ;
mastCone->TYPE |= MAST ;
cone->USER=addptype(cone->USER,MAST,(void*)mastCone);
mastCone->USER=addptype(mastCone->USER,SLAVE,(void*)cone);
return(0);
}

