/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : desa_util.c                                                 */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "declar.h"

short dsbgetArg() ;

/****************************************************************************
 *                         fonction add_cone();                             *
 ****************************************************************************/

                         /* creation d'un cone */

cone_list *add_cone( headcone , ptsig )

cone_list	 *headcone ;
losig_list 	*ptsig ;

{
cone_list	*ptcone = NULL ;

ptcone=dsbGetFreeCone();

ptcone->NEXT 	= headcone ;
ptcone->PATH    = NULL ;
ptcone->INCONE  = NULL ;
ptcone->OUTCONE = NULL ;
ptcone->INDEX   = ( long )( ptsig->INDEX ) ;
ptcone->X1      = 0L ;
ptcone->X2      = 0L ;
ptcone->Y1      = 0L ;
ptcone->Y2      = 0L ;
ptcone->TYPE    = ( long )0 ;
ptcone->NAME    = "?" ;
ptcone->USER    = NULL ;

return( ptcone ) ;
}


/****************************************************************************
 *                         fonction get_cone();                             *
 ****************************************************************************/

                  /* obtention d'un cone par son index */

cone_list *get_cone( pt_desafig , index )

desafig_list	*pt_desafig ;
long			index ;

{
cone_list	*ptcone = NULL ;

if ( DESB_TRACE_MODE >= DESB_TRACE ) ( void )printf( "TRA_dsb get_cone \n" ) ;

/* parcours des cones */
   for ( ptcone = pt_desafig->CONE ; ptcone != NULL ; ptcone = ptcone->NEXT )
   {
      if ( ptcone->INDEX == index )
      {
      break ;
      }
   }
return( ptcone ) ;
}

/****************************************************************************
 *                         fonction add_list();                             *
 ****************************************************************************/

                     /* creation d'un element list */

list_list *add_list( headlist , data , type )

list_list	*headlist ;
char 		*data ;
long  		type ;

{
list_list	*ptlist = NULL ;

/* ptlist 	= ( list_list * ) mbkalloc( sizeof( list_list ) ) ;*/
ptlist		= dsbGetFreeList();
ptlist->NEXT 	= headlist ;
ptlist->TYPE    = type ;
ptlist->DATA    = data ;
ptlist->USER    = NULL ;
return( ptlist ) ;
}

/****************************************************************************
 *                         fonction del_path();                             *
 ****************************************************************************/
                /* destruction d'un chemin  != del_list */

int	del_path( pt_cone , pt_del )
cone_list	*pt_cone ;
list_list	*pt_del ;
{
link_list	*pt_link = NULL ;
link_list	*pt_nextlink = NULL ;
list_list	*pt_path = NULL ;
int			resultat = 0 ;


   /* on detruit les maillons */
   for ( pt_link = ( link_list * )pt_del->DATA ; pt_link != NULL ; pt_link = pt_nextlink )
   {
   pt_nextlink = pt_link->NEXT ;
   dsbFreeLink(  pt_link ) ;
   }

   /* on detruit la branche */
   if( pt_del == pt_cone->PATH )
   {
   /* si c'est la premiere */
   pt_cone->PATH = pt_del->NEXT ;
   dsbFreeList(  pt_del ) ;
   resultat = 1 ;
   }
   else 
   {
      for( pt_path = pt_cone->PATH ; pt_path != NULL ; pt_path = pt_path->NEXT )
      {
         /* pour chaque branche */
         if( pt_path->NEXT == pt_del ) 
         {
         pt_path->NEXT = pt_path->NEXT->NEXT ;
         dsbFreeList( pt_del ) ;
         resultat = 1 ;
         break ;
         }
      }
   }
return( resultat ) ;
}

	
/****************************************************************************
 *                         fonction append_list();                          *
 ****************************************************************************/

                      /* chainage de deux listes */

list_list	*append_list( pt1 , pt2 )
list_list	*pt1 ;
list_list	*pt2 ;
{
list_list 	*pt = NULL ;


   if ( pt1 == NULL )
   {
   return( pt2 ) ;
   }
   else
   {
      for ( pt = pt1 ; pt->NEXT !=  NULL ; pt = pt->NEXT )
      {
      }
   pt->NEXT = pt2 ;
   return( pt1 ) ;
   }
}



/****************************************************************************
 *                         fonction add_link();                             *
 ****************************************************************************/

                         /* ajout d'un maillon */

link_list 	*add_link( pt_branche , type , pointeur , capa )

link_list	*pt_branche ;
long 	type ;
long	capa ;
char    *pointeur ;

{
link_list	*pt_link = NULL ;
ptype_list      *ptuser=NULL;
 

 pt_link		= dsbGetFreeLink(); 
pt_link->NEXT  	= pt_branche ;
pt_link->CAPA  	= capa ;
pt_link->TYPE  	= type ;
pt_link->TRANS  =  (trans_list *)pointeur ;
pt_link->USER  	= NULL ;

return( pt_link ) ;

}


/****************************************************************************
 *                         fonction aff_bin();                              *
 ****************************************************************************/

                        /* affichage en binaire */

void  aff_bin( vchar )

char vchar ;
{
if ( ( (vchar) & ((char)(0x80)) ) == ((char)(0x80)) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( (vchar) & ((char)(0x40)) ) == ((char)(0x40)) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( vchar & (char)(0x20) ) == (char)(0x20) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( vchar & (char)(0x10) ) == (char)(0x10) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( vchar & (char)(0x08) ) == (char)(0x08) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( vchar & (char)(0x04) ) == (char)(0x04) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( vchar & (char)(0x02) ) == (char)(0x02) ) ( void )putchar('1');
else ( void )putchar('0') ;
if ( ( vchar & (char)(0x01) ) == (char)(0x01) ) ( void )putchar('1');
else ( void )putchar('0') ;
( void )putchar('\n');
}


/****************************************************************************
 *                         fonction getchain();                             *
 ****************************************************************************/

              /* obtention d'un element chain par la donnee */

chain_list	*getchain( pthead , ptdata )

chain_list	*pthead ;
char		*ptdata ;

{
chain_list	*pt = NULL ;


   for ( pt = pthead ; pt != NULL ; pt = pt->NEXT )
   {
      if ( (char*)pt->DATA == ptdata ) 
      break ;
   }
return( pt ) ;
}


/****************************************************************************
 *                         fonction rmchain();                              *
 ****************************************************************************/

      /* destruction d'un element chain par la donnee != delchain */

chain_list *rmchain( pt_head , pt_data )

chain_list	*pt_head ;
char		*pt_data ;

{
chain_list	*pt 	 = NULL ;
chain_list	*pt_prev = NULL ;


   if ( ( pt_head == NULL ) || ( pt_data == NULL ) )
   {
   dsbBug(1,"rmchai",NULL,NULL,0);
   }

   else if ( pt_data == (char*)pt_head->DATA )
   {
   pt = pt_head->NEXT ;
   pt_head->NEXT = NULL ;
   freechain( pt_head ) ;
   return( pt ) ;
   }

   else
   {
      for( pt = pt_head ; pt ; pt = pt->NEXT )
      {
         if ( (char*)pt->DATA == pt_data ) 
         break ;
      pt_prev = pt ;
      }
      if ( pt != NULL )
      {
      pt_prev->NEXT = pt->NEXT ;
      pt->NEXT = NULL ;
      freechain( pt ) ;
      return( pt_head ) ;
      }
      else
      {
      return( pt_head ) ;  /* non trouve */
      }
   }
return( NULL ) ;
}


/****************************************************************************
 *                         fonction del_cone();                             *
 ****************************************************************************/

int del_cone( pt_desafig , pt_cone )

desafig_list	*pt_desafig ;
cone_list		*pt_cone ;

{
cone_list	*pt		= NULL ;
cone_list	*pt_prev	= NULL ;

   for ( pt = pt_desafig->CONE ; pt != NULL ; pt = pt->NEXT )
   {
      if ( pt == pt_cone )   break ;
   pt_prev = pt ;
   }

   if ( pt == NULL )	return( 0 ) ;
   else if ( pt == pt_desafig->CONE ) 	pt_desafig->CONE = pt->NEXT ;
   else	pt_prev->NEXT = pt->NEXT ;

dsbFreeCone(pt) ;

return( 1 ) ;
}  



/****************************************************************************
 *                         fonction rmv_list();                             *
 ****************************************************************************/

               /* destruction d'une list par la donnee */

list_list * rmv_list (ptlist,ptdata)
list_list *ptlist;
char * ptdata;
{
list_list * pt1=NULL;
list_list * ptprev=NULL;
cone_list * ptcone;


   if( ((char*)ptlist->DATA)==ptdata ) 
   {
   list_list * pttmp;
   pttmp = ptlist->NEXT;
   dsbFreeList(ptlist);
   return(pttmp);
   }

ptprev=ptlist;

   for(pt1=ptlist->NEXT;pt1;pt1=pt1->NEXT)
   {
      if( ((char *)(pt1->DATA))==ptdata)
      {
      ptprev->NEXT=pt1->NEXT;
      dsbFreeList (pt1);
      return(ptlist);
      }
   ptprev=ptprev->NEXT;
   }
/* DATA non trouve dans la liste */
return(ptlist);
}
      

/****************************************************************************
 *                         fonction compact();                              *
 ****************************************************************************/

           /* supprime les datas redondants dans un chainlist */

chain_list * compact(headchain)
chain_list * headchain;
{
chain_list * pt1;

   if(headchain==NULL) 
   {
   dsbBug(1,"compact",NULL,NULL,0);
   }

   for(pt1=headchain;pt1;pt1=pt1->NEXT)
   {
   chain_list * pt2;
      for(pt2=pt1->NEXT;pt2;pt2=pt2->NEXT)
      {
         if(pt2->DATA==pt1->DATA) headchain=delchain(pt2);
      }
   }
return(headchain);
}


/****************************************************************************
 *                         fonction freeliste();                            *
 ****************************************************************************/

         /*  Supprime tous les elements d une liste de list* */

void freeliste(pt_liste)
list_list * pt_liste;
{
list_list * pt     = NULL;
list_list * nextpt = NULL;

   if(pt_liste == NULL) 
   {
   (void) printf("!!! free_liste !!! : Pointeur de liste NULL\n");
   exit(-1);
   }

   for (pt=pt_liste;pt;pt=nextpt)
   {
      if ((nextpt=pt->NEXT) != NULL)
      {
      dsbFreeList ( pt );
      }
   }
}


/****************************************************************************
 *                         fonction vide_cone();                            *
 ****************************************************************************/

                  /* vide tous les champs d un cone */

short vide_cone(cone)
cone_list *cone;
{
list_list *in,
          *out,
          *innext,
          *outnext,
          *path,
          *pathNext;
ptype_list *user;


  /*-----------------------------------------*
   *  on detruit tous les chemins            *
   *-----------------------------------------*/
   while(cone->PATH != NULL)
   {
   int test;
   test=del_path(cone,cone->PATH); 
   }

  /*-----------------------------------------*
   *  on detruit tous INCONES                *
   *-----------------------------------------*/
   for (in=cone->INCONE;in != NULL;in =innext)
   {
   innext=in->NEXT;
   dsbFreeList(in);
   }
cone->INCONE=NULL;

  /*-----------------------------------------*
   *  on detruit tous OUTCONES               *
   *-----------------------------------------*/
   for (out=cone->OUTCONE; out != NULL; out=outnext)
   {
   outnext=out->NEXT;
   dsbFreeList(out);
   }
cone->OUTCONE=NULL;
   
delptype(cone->USER,(short)EXT);

user=getptype(cone->USER,(short)SWITCH); 
   if ((user != NULL) && (user->DATA != NULL))
   {
   chain_list *chain;
      for (chain=(chain_list*)user->DATA;chain != NULL; chain=chain->NEXT)
      {
      freechain((chain_list *)chain->DATA);
      }
   freechain(user->DATA);
   }

user=getptype(cone->USER,(short)PATH_PARA); 
   if ((user != NULL) && (user->DATA != NULL))
   {
   chain_list *chain;
      for (chain=(chain_list*)user->DATA;chain != NULL; chain=chain->NEXT)
      {
      freechain((chain_list *)chain->DATA);
      }
   freechain(user->DATA);
   }

user=getptype(cone->USER,(short)BLEEDER); 
   if ((user != NULL) && (user->DATA != NULL))
   {
   freechain((chain_list *)user->DATA);
   }
cone->USER= NULL;
}

      
      


/****************************************************************************
 *                         fonction test_chainin();                         *
 ****************************************************************************/
         /*----------------------------------------------------------------*
          | test l'inclusion de la chaine pointee par ptchar               |
          | dans la chaine pointee par nom                                 |
          |      entree : nom et ptchar;                                   |
          |      sortie : 1 si oui;                                        |
          |               0 si non;                                        |
          *----------------------------------------------------------------*/
int test_chainin(nom,ptchar)
char * nom   ;
char * ptchar;
{
char * pt1 = NULL;
char * pt2 = NULL;
char * pt3 = NULL;

   if((ptchar==NULL)||(nom==NULL)) 
   {
   dsbBug(1,"test_chainin",NULL,NULL,0);
   }

pt3=ptchar;

   for(pt1=nom;(*pt1)!='\0';pt1++)
   {
   pt3=ptchar;
      for(pt2=pt1;( ((*pt2)!='\0') && ((*pt3)!='\0') && (*pt2==*pt3) );pt3++,pt2++);
      if(*pt3=='\0') return (1);
   }
return(0);
}



/****************************************************************************
 *                         fonction test_si_sig();                           *
 ****************************************************************************/
short test_si_sig(ptsig)
losig_list *ptsig ;
{
ptype_list * user ;
user = getptype(ptsig->USER,DSB_VAL_S);
   if(user==NULL)
   {
   dsbBug(2,"test_si_sig",get_name(ptsig),"DSB_VAL_S",0);
   }
   else 
   {
   return((short)user->DATA);
   }
}

/****************************************************************************
 *                         fonction addval_s();                           *
 ****************************************************************************/
void addVal_s(fig)
lofig_list * fig ;
{
chain_list *ptchain ;
losig_list *sig ;

   for(sig=fig->LOSIG;sig!=NULL;sig=sig->NEXT)
   {
   short res = -1 ;
   short i = 0;
      for(ptchain = sig->NAMECHAIN ; ptchain ; ptchain = ptchain->NEXT)
      {
      i = test_si(ptchain->DATA,'s') ;
         if (i > res) res = i;
      }
   sig->USER=addptype(sig->USER,DSB_VAL_S,(void*)res);
   }
}

/****************************************************************************
 *                         fonction addval_l();                           *
 ****************************************************************************/
void addVal_l(fig)
lofig_list * fig ;
{
chain_list *ptchain ;
losig_list *sig ;

   for(sig=fig->LOSIG;sig!=NULL;sig=sig->NEXT)
   {
   short res = -1 ;
   short i = 0;
   char * name ;
   name = get_name(sig);

   i |= test_lchainin(name,"_l1") ;
   i |= test_lchainin(name,"_l2") ;
   i |= test_lchainin(name,"_l1n") ;
   i |= test_lchainin(name,"_l2n") ;
   res=((i != 0) ? 1:0) ;
   sig->USER=addptype(sig->USER,DSB_VAL_L,(void*)res);
   }
}


/****************************************************************************
 *                         fonction test_s();                               *
 ****************************************************************************/

   /*------------------------------------------------------------------*
    |   teste pour tous les alias d'un signal s'il contient `_s        |
    |   renvoie  1 si oui                                              |
    |            0 si non                                              |
    *------------------------------------------------------------------*/

short test_s(ptsig)
losig_list *ptsig ;
{
chain_list *ptchain ;
short i = 0;

for(ptchain = ptsig->NAMECHAIN ; ptchain ; ptchain = ptchain->NEXT)
    {
    i |= test_s_name(ptchain->DATA) ;
    }
return((i != 0) ? 1:0) ;
}



/****************************************************************************
 *                         fonction test_l();                               *
 ****************************************************************************/
   /*------------------------------------------------------------------*
    |   teste si le nom de plus haut niveau d un signal contient les   |
    |   chaines "l1\0" "l1[" etc ...                                   |
    |   renvoie  1 si oui                                              |
    |            0 si non                                              |
    *------------------------------------------------------------------*/
short test_l(ptsig)
losig_list *ptsig ;
{
chain_list *ptchain ;
short i = 0;
ptype_list * user ;
user=getptype(ptsig->USER,DSB_VAL_L);
   if(user==NULL)
   {
   dsbBug(2,"test_l",get_name(ptsig),"DSB_VAL_L",0);
   }
   else return((short)user->DATA);
}

/****************************************************************************
 *                         fonction test_s_name();                          *
 ****************************************************************************/

      /*-------------------------------------------------------*
       |  teste la presence de _s dans une chaine de caractere |
       |  renvoie 1 si oui                                     |
       |          0 si non                                     |
       *-------------------------------------------------------*/
short test_s_name(nom)
char *nom;
{
int i;
  for(i=0;nom[i]!='\0';i++)
  {
    if (nom[i]=='_')
       {
       i++;         
       if (nom[i]=='s')  return(1);
       else i--;
       }
  }
return(0);
}



/****************************************************************************
 *                         fonction test_si();                              *
 ****************************************************************************/

    /*-------------------------------------------------------*
     |  Teste la presence de "_si" 0<i<N dans un char*       |
     |                                                       |
     |  Renvoie: 0 si i n'est pas present mais "_s\0" l'est  |
     |           (i+1) si "_si\0" est present                |
     |          -1 si "_s\0" n'est pas trouve                |
     |  Exemple:                                             |
     |          "toto_s"   =>   0                            |
     |          "toto_s[..]=>   0                            |
     |          "toto_s_t  =>  -1                            |
     |          "toto_s3   =>   4                            |
     |          "toto_s23  =>  -1                            |
     *-------------------------------------------------------*/
short test_si(nom,car)
char *nom;
char car ;
{
char * pch;

  for(pch=nom;*pch!='\0';pch++)
  {
    if (*pch=='_')
    {
    pch++ ;         
       if (*pch==car)  
       {
       pch++ ;
          if( (*pch=='\0') || (*pch==' ') ) return(0);
          else if ((*pch>='0')&&(*pch<='9'))
          {
          pch++;
             if ( (*pch=='\0')||(*pch==' ') ) return(*(--pch)-'0'+1);
          pch--;
          }
       pch--;
       } 
    pch-- ;
    }
  }
return(-1);
}

 /***************************************************************************
 *                         fonction test_li();                              *
 ***************************************************************************/
 /*-------------------------------------------------------------------------*
 | Cf test_si pour le comentaire. Remplacer 's' par 'l'                     |
 *-------------------------------------------------------------------------*/
short test_li(nom)
char *nom;
{
char * pch;

  for(pch=nom;*pch!='\0';pch++)
  {
    if (*pch=='_')
    {
    pch++ ;         
       if (*pch=='s')  
       {
       pch++ ;
          if(*pch=='\0') return(0);
          else if ((*pch>='0')&&(*pch<='9'))
          {
          pch++;
             if (*pch=='\0') return(*(--pch)-'0'+1);
          pch--;
          }
       pch--;
       } 
    pch-- ;
    }
  }
return(-1);
}

/****************************************************************************
 *                         fonction rmvLoopIn();                            *
 ****************************************************************************/
short rmvLoopIn(cone)
cone_list * cone ;
{
list_list * in ;

   if(cone->INCONE==NULL) return(0);

   for(in=cone->INCONE; in != NULL; )
   {
      if(in->NEXT != NULL)
      {
         if((((in->NEXT)->TYPE) & LOOP)==LOOP)
         {
         list_list * ptr ;
         ptr=in->NEXT;
         in->NEXT=in->NEXT->NEXT;
         dsbFreeList(ptr);
         continue ;
         }
         else
         {
         in=in->NEXT;
         continue ;
         }
      }
      else break; 
   }

   if (((cone->INCONE->TYPE)&LOOP)==LOOP) 
   {
   list_list * ptr = cone->INCONE ;
   cone->INCONE = cone->INCONE->NEXT ;
   dsbFreeList(ptr);
   }
}

/****************************************************************************
 *                         fonction rmvLoopOut();                           *
 ****************************************************************************/
short rmvLoopOut(cone)
cone_list * cone ;
{
list_list * out ;

   if(cone->OUTCONE==NULL) return(0);

   for(out=cone->OUTCONE; out != NULL; )
   {
      if(out->NEXT != NULL)
      {
         if((((out->NEXT)->TYPE) & LOOP)==LOOP)
         {
         list_list * ptr;
         ptr=out->NEXT;
         out->NEXT=out->NEXT->NEXT;
         dsbFreeList(ptr);
         continue ;
         }
         else
         {
         out=out->NEXT;
         continue ;
         }
      }
      else break ;
   }

   if (((cone->OUTCONE->TYPE)&LOOP)==LOOP) 
   {
   list_list * ptr = cone->OUTCONE ;
   cone->OUTCONE = cone->OUTCONE->NEXT ;
   dsbFreeList(ptr);
   }
}


/****************************************************************************
 *                         fonction rmvBleedPath();                         *
 ****************************************************************************/

short rmvBleedPath(cone)
cone_list * cone ;
{
list_list * path = NULL ;
list_list * pathNext = NULL ;
ptype_list * user=NULL ;
chain_list * blpath=NULL;

   if(cone->PATH == NULL) return(0);

user=getptype(cone->USER,BLEEDER);

   if(user!=NULL) blpath=(chain_list*)user->DATA;

   for(path=cone->PATH;path != NULL;path=pathNext)
   {
      if((path->TYPE & BLEEDER)==BLEEDER)
      {
      list_list * ptr ;
      chain_list * chain;

         if(blpath!=NULL)
         {
            for(chain=blpath; chain != NULL;chain=chain->NEXT)
            {
               if(path==(list_list*)chain->DATA) break;
            }

            /*---------------------------------------------------+
            | On regarde si c'est une branche de contre reaction |
            +---------------------------------------------------*/
            if(chain==NULL)
            {
            pathNext=path->NEXT ;
            del_path(cone,path);
            continue ;
            }
            else
            {
            pathNext=path->NEXT ;
            continue ;
            }
         }
         else
         {
         pathNext=path->NEXT ;
         del_path(cone,path);
         continue;
         }
      }
      else
      {
      pathNext=path->NEXT ;
      continue ;
      }
   }
}
   
   


/****************************************************************************
 *                         fonction test_lchainin();                        *
 ****************************************************************************/
int test_lchainin(nom,ptchar)
char * nom   ;
char * ptchar;
{
char * pt1 = NULL;
char * pt2 = NULL;
char * pt3 = NULL;
char * pt4 = NULL;
char * buff = NULL;

   if((ptchar==NULL)||(nom==NULL)) 
   {
   dsbBug(1,"test_lchainin",NULL,NULL,0);
   }

buff=(char*)mbkalloc(strlen(nom)+1);
strcpy(buff,nom);

   /*-----------------------------------------*/
   /* On va jusqu'au blanc ou a la fin du nom */
   /*-----------------------------------------*/
   for(pt4=buff;(*pt4!=' ')&&(*pt4!='\0');pt4++);
*pt4='\0';
  
   /*-------------------------------------------------------------+
   |  On cherche le motif ptchar dans buff                        |
   |  On doit arriver a la fin de buff et de ptchar en meme temps |
   +-------------------------------------------------------------*/
   for(pt1=buff;(*pt1)!='\0';pt1++)
   {
   pt3=ptchar;
      for(pt2=pt1;( ((*pt2)!='\0') && ((*pt3)!='\0') && (*pt2==*pt3) );pt3++,pt2++);
      if((*pt3=='\0')&&(*pt2=='\0')) return (1);
   }
free(buff);
return(0);
}

/****************************************************************************
 *                         fonction GetVectName();                          *
 ****************************************************************************/
/*-------------------------------------------------------------------------+
| remplace toto_23 ('_'= espace ) par toto[23]                             |
+-------------------------------------------------------------------------*/
char *GetVectName(name)
char * name;
{
char buff[200];
char * res ;
char * car=name ;
int i = 0 ;

   while(*car != '\0')
   {
      if (*car != ' ')
      {
      buff[i++] = *car++ ;
      }
      else
      {
      buff[i++]='[';
      car++;
         while( (*car>='0')&&(*car<='9') ) 
         {
         buff[i++] = *car++;
         }
      buff[i++]=']';
      }
   }

buff[i]='\0';
res=(char*)mbkalloc(strlen(buff)+1);
strcpy(res,buff);
return(res);
}
         

/****************************************************************************
 *                         fonction dsbGetArg();                            *
 ****************************************************************************/
/*--------------------------------------------*/
/* OPTION PAR DEFAUT PARIS VI                 */
/*--------------------------------------------*/
#ifdef PARIS6   
short dsbGetArg(argc,argv)
int argc ;
char *argv[] ;
{
int i ;
short fileExist = 0 ;

   if(argc<2) return(-1);

   for(i=1 ; i < argc ; i++)
   {
      /*----------------------------+
      | Traitement des options      |
      +----------------------------*/
      if(*(argv[i])=='-')
      {
      char * car ;
         /*--------------------------+
         | prise en compte des "-s"  |
         +--------------------------*/
         if(optionIdent(argv[i],"-h")!=NULL)
         {
         DSB_HELP_S++ ; 
         continue ;
         }
         /*----------------------+
         |  Profondeur pour FCF  |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-p="))!=NULL)
         {
         char * pt ;
            for(pt=car ; *pt != '\0' ; pt++)
               if((*pt<'0')&&(*pt>'9')) return(-1);
         DSB_PROF=atoi(car);
            if(DSB_PROF==0) DSB_USE_FCF = 0 ;
         continue ;
         }
         /*----------------------+
         | vectorisation du vbe  |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-v"))!=NULL)
         {
         DSB_VECTORISE=1;
         continue ;
         }
         /*----------------------+
         | lecture du inf        |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-i"))!=NULL)
         {
         DSB_INF=1;
         continue ;
         }
         /*----------------------+
         | netlist hierarchique  |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-nh"))!=NULL)
         {
         DSB_HIERAR=1;
         continue ;
         }
         else  return(-1);
      }
      if(fileExist == 0)
      {
      strcpy(VBE_NAME,argv[i]);
      strcpy(DSB_FIGNAME,argv[i]);
      }
      else strcpy(VBE_NAME,argv[i]);
   fileExist++;
   }

   if((fileExist==0)||(fileExist>2))
   return(-1);

return(0);
}
#endif PARIS6

/*--------------------------------------------*/
/* OPTION PAR DEFAUT DISTRIB                  */
/*--------------------------------------------*/
#ifdef DISTRIB   
short dsbGetArg(argc,argv)
int argc ;
char *argv[] ;
{
int i ;
short fileExist = 0 ;

   if(argc<2) return(-1);

   for(i=1 ; i < argc ; i++)
   {
      /*----------------------------+
      | Traitement des options      |
      +----------------------------*/
      if(*(argv[i])=='-')
      {
      char * car ;
         /*--------------------------+
         | prise en compte des "-s"  |
         +--------------------------*/
         if(optionIdent(argv[i],"-h")!=NULL)
         {
         DSB_HELP_S++ ; 
         continue ;
         }
         /*----------------------+
         |  Profondeur pour FCF  |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-p="))!=NULL)
         {
         char * pt ;
            for(pt=car ; *pt != '\0' ; pt++)
               if((*pt<'0')&&(*pt>'9')) return(-1);
         DSB_PROF=atoi(car);
            if(DSB_PROF==0) DSB_USE_FCF = 0 ;
         continue ;
         }
         /*----------------------+
         | vectorisation du vbe  |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-v"))!=NULL)
         {
         DSB_VECTORISE=1;
         continue ;
         }
         /*----------------------+
         | lecture du inf        |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-i"))!=NULL)
         {
         DSB_INF=1;
         continue ;
         }
         else  return(-1);
      }

      if(fileExist == 0)
      {
      strcpy(VBE_NAME,argv[i]);
      strcpy(DSB_FIGNAME,argv[i]);
      }
      else strcpy(VBE_NAME,argv[i]);
   fileExist++;
   }

   if((fileExist==0)||(fileExist>=2))
   return(-1);

return(0);
}
#endif DISTRIB


/*--------------------------------------------*/
#ifdef BULL /*    OPTIONS PAR DEFAUT BULL     */
/*--------------------------------------------*/
short dsbGetArg(argc,argv)
int argc ;
char *argv[] ;
{
int i ;
short fileExist = 0 ;

   if(argc<2) return(-1);

   for(i=1 ; i < argc ; i++)
   {
      /*----------------------------+
      | Traitement des options      |
      +----------------------------*/
      if(*(argv[i])=='-')
      {
      char * car ;
         /*--------------------------+
         | prise en compte des "-s"  |
         +--------------------------*/
         if(optionIdent(argv[i],"-nh")!=NULL)
         {
         DSB_HELP_S=0 ; 
         continue ;
         }

         /*----------------------+
         |  Profondeur pour FCF  |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-p="))!=NULL)
         {
         char * pt ;
            for(pt=car ; *pt != '\0' ; pt++)
               if((*pt<'0')&&(*pt>'9')) return(-1);
         DSB_PROF=atoi(car);
         continue ;
         }
         /*----------------------+
         | anihilation de foconf |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-f"))!=NULL)
         {
         DSB_USE_FCF = 1 ;
         continue ;
         }
         /*----------------------+
         | lecture du inf        |
         +----------------------*/
         else if ((car=optionIdent(argv[i],"-i"))!=NULL)
         {
         DSB_INF=1;
         continue ;
         }
         else return(-1);
      }

   strcpy(DSB_FIGNAME,argv[i]);
   fileExist++;
   }

   if((fileExist==0)||(fileExist>=2))
   return(-1);

return(0);
}
#endif BULL
   
/****************************************************************************
 *                         fonction optionIdent();                          *
 ****************************************************************************/
/*--------------------------------------------------+
| cherche chaine en debut de name.                  |
| Entree: name et chaine;                           |
| sortie: pointeur sur name tronque de chaine       |
|         NULL si chaine n'est pas trouve dans name |
+--------------------------------------------------*/
static char * optionIdent(name,chaine)
char* name ;
char* chaine ;
{
int i = 0 ;

   for(i=0;(name[i]!='\0') && (chaine[i]!='\0');i++)
   {
      if(name[i]!=chaine[i]) break ;
   }

  if(chaine[i] !='\0') return(NULL);
  else return(&name[i]);
}

/****************************************************************************
 *                         fonction debugUserConeType();                    *
 ****************************************************************************/
void * debugUserConeType(conect)
locon_list * conect ;
{
ptype_list * user ;
cone_list * cone  ;

printf("debugUserConeType sur '%s'\n",conect->NAME);
fflush(stdout);

user=getptype(conect->USER,CONE_TYPE);

   if(user==NULL) printf("user = NULL\n") ;
   else 
   {
   chain_list * chain = NULL ;
      for(chain=(chain_list *) user->DATA ;
                chain!=NULL; chain=chain->NEXT)
      {
      cone=(cone_list*)chain->DATA;
      printf("cone = '%s'\n",cone->NAME);
      }
   }
fflush(stdout);
}



/****************************************************************************
 *                         fonction point();                                *
 ****************************************************************************/
void point( ) 
{
( void )signal( SIGALRM , SIG_DFL ) ;
( void )fflush( stdout ) ;
( void )putchar( '.' ) ;
( void )fflush( stdout ) ;
( void )signal( SIGALRM , point ) ;
( void )alarm( 5 ) ;
}

/****************************************************************************
 *                         fonction affich_desb();                          *
 ****************************************************************************/
void dsbBaniere()
{
printf("\n\n\n\n\n\n\n\n\n\n");
printf("\t   @@@@@@@@@@        @@@@@@@@@@@      @@@@@@@@@@@      @@@@@@@@@    \n");
printf("\t   @@@@@@@@@@@       @@@@@@@@@@@      @@@@@@@@@@@      @@@@@@@@@@   \n");
printf("\t   @@@      @@@      @@@              @@@              @@@     @@@  \n");
printf("\t   @@@      @@@      @@@              @@@              @@@     @@@  \n");
printf("\t   @@@      @@@      @@@@@@@@@        @@@@@@@@@@@      @@@@@@@@@@  \n");
printf("\t   @@@      @@@      @@@@@@@@@        @@@@@@@@@@@      @@@@@@@@@@  \n");
printf("\t   @@@      @@@      @@@                      @@@      @@@     @@@  \n");
printf("\t   @@@      @@@      @@@                      @@@      @@@     @@@  \n");
printf("\t   @@@@@@@@@@@       @@@@@@@@@@@      @@@@@@@@@@@      @@@@@@@@@@  \n");
printf("\t   @@@@@@@@@@        @@@@@@@@@@@      @@@@@@@@@@@      @@@@@@@@@   \n");
printf("\n");
#ifdef BULL
   {
   printf("\t\t\t");

#ifndef PHASE2 
printf("        BULL PHASE I Release\n");
#endif

#ifdef PHASE2
printf("       BULL PHASE II Release\n");
#endif

   }
#endif
printf("\t\t\t            Version %s\n",DESB_VERSION);
printf("\t\t\t            %s\n",DATE_VERSION);
printf("\t\t\t    (c)copyright  MASI CAO & VLSI \n") ;
printf("\t\t\t  support: e-mail cao-vlsi@masi.ibp.fr \n");
printf("\n\n\n\n\n");
}

