/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : d2vutil.c                                                   */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "head.h"

static char * motifInName();
static short testJokSubst();
static char * subElt();
static char * jokSubst();
static void   addAssert();

vect_list * D2V_VECT_LIST = NULL ;


/****************************************************************************
 *                         fonction d2vAddVectName();                       *
 ****************************************************************************/
          /*---------------------------------------------+
          | ajoute le vecteur dans la liste              |
          |                                              |
          | Entree : name, un char *                     |
          |          type, le type du cone correspondant |
          |                                              |
          | Retour : 0 le vecteur est ajoute             |
          |         -1 le nom n'est pas un nom vectorise |
          +---------------------------------------------*/
short d2vAddVectName(name,type)
char * name ;
{
int index ;

   if(D2V_VECTORISE == 0) return(-1);

index=getIdxIfVect(name);

   if(index >= 0)
   {
   stockVectName(nameOfVect(name),index,type);
   return(0);
   }
return(-1);
}

/****************************************************************************
 *                         fonction getIdxIfVect();                         *
 ****************************************************************************/
          /*---------------------------------------------------+
          | Teste si le nom est un nom vectorise : Presence de |
          | la sequence '(i)' avec i un entier >=0             |
          |                                                    |
          | Entree : nom, un char*                             |
          |                                                    |
          | Retour : -1 Pas de vecteur detecte                 |
          |          -2 ERREUR                                 |
          |           i l'index du vecteur                     |
          +---------------------------------------------------*/
static int getIdxIfVect(name)
char * name ;
{
char   buff[5] ;
char * ptbuff = buff ;
char * pt=name ;

   for(pt=name;*pt != '\0';pt++)
   {
      if(*pt=='(') break ;
   }

   if(*pt=='\0') return(-1);
   else pt++;

   while(*pt !='\0')
   {
      if(*pt==')') break ;
      else if((*pt>'9')||(*pt<'0')) return(-2); /*erreur*/

   *ptbuff= *pt ;
   ptbuff++;
   pt++;
   }
   
   if(*pt != ')') return(-2);
   else *ptbuff='\0';

return(atoi(buff));
}

/****************************************************************************
 *                         fonction nameOfVect();                           *
 ****************************************************************************/
          /*--------------------------------------------------------+
          | Retourne le nom vectorise tronque de sa partie indexage |
          |                                                         |
          | Entree : name, un char*                                 |
          |                                                         |
          | Retour : Un char *                                      |
          +--------------------------------------------------------*/
static char * nameOfVect(name) 
char * name ;
{
char buff[200];
char *pbuff = buff ;
char * pt=name ;

   while(*pt !='\0')
   {
   *pbuff= *pt;
      if(*pt=='(') break ;
   pt++;
   pbuff++;
   }
   
   if(*pt == '\0') return(NULL);

*pbuff='\0';
return(namealloc(buff));
}

/****************************************************************************
 *                         fonction stokVectName();                         *
 ****************************************************************************/
             /*------------------------------------------+
             | Mise a jour de la structure vect :        |
             | recuperation de la structure vect puis    |
             | mise a jour de ses champs                 |
             +------------------------------------------*/
static void stockVectName(name,index,type)
char * name ;
int  index ;
long type ;
{
vect_list * vect = NULL ;

vect = nameToVectList(name,type);
   if(index > vect->MAXIDX) vect->MAXIDX=index ;
   if(index < vect->MINIDX) vect->MINIDX=index ;

   if(vect->TYPE!=type)
   {
   d2vFatalError(1,NULL,vect->NAME,NULL,0);
   }
vect->COUNT++;
}

/****************************************************************************
 *                         fonction nameToVectList();                       *
 ****************************************************************************/
      /*------------------------------------------------------+
      | Retourne le vect_list correspondant a name ou cree et |
      | ajoute un nouveau vect a la liste                     |
      +------------------------------------------------------*/
static vect_list * nameToVectList(name,type)
char * name ;
long type ;
{
vect_list * vect ;

   for(vect=D2V_VECT_LIST;vect!=NULL;vect=vect->NEXT)
   {
      if(name==vect->NAME) return(vect) ;
   }

   vect=addVectList(name,type);

return(vect);
}
   
/****************************************************************************
 *                         fonction addVectList();                          *
 ****************************************************************************/
static vect_list * addVectList(name,type)
char * name ;
long type ;
{
vect_list * vect ;

vect=(vect_list*)mbkalloc(sizeof(vect_list));
vect->NAME=name;
vect->MINIDX = 99999 ;
vect->MAXIDX = -1    ;
vect->COUNT = 0 ;
vect->TYPE = type ;
vect->NEXT = D2V_VECT_LIST ;
D2V_VECT_LIST=vect;

return(vect);
}

/****************************************************************************
 *                         fonction affichVect();                           *
 ****************************************************************************/
void d2vAffichVectList()
{
vect_list * vect ;
   for(vect=D2V_VECT_LIST;vect!=NULL;vect=vect->NEXT)
   {
   printf("SIGNAL %s : BIT_VECTOR(%d TO %d)\n",vect->NAME,vect->MINIDX,vect->MAXIDX);
   fflush(stdout);
   }
}


/****************************************************************************
 *                         fonction d2vFreeVectList();                      *
 ****************************************************************************/
void d2vFreeVectList()
{
vect_list *vect = D2V_VECT_LIST ;

   while(vect !=NULL)
   {
   vect_list * save = vect ;
   vect = vect->NEXT ;
   free(save);
   }
D2V_VECT_LIST = NULL;
}

/****************************************************************************
 *                         fonction motifInName();                          *
 ****************************************************************************/
 /*----------------------------------------------------------------*
  | test l'inclusion de la chaine pointee par motif               |
  | dans la chaine pointee par nom                                 |
  |   entree : nom et motif;                                      |
  |   sortie : NUll si non trouve                                    |
  |            char * pt sur le caractere suivant le motif dans name |
  *----------------------------------------------------------------*/
static char * motifInName(nom,motif)
char * nom   ;
char * motif;
{
char * pt1 = NULL;
char * pt2 = NULL;
char * pt3 = NULL;

   if((motif==NULL)||(nom==NULL)) 
   {
   d2vFatalError(5,"motifInName",NULL,NULL,0);
   }

   for(pt1=nom;(*pt1)!='\0';pt1++)
   {
   pt3=motif;
      for(pt2=pt1;( ((*pt2)!='\0') && ((*pt3)!='\0') && (*pt2==*pt3) );pt3++,pt2++);
      if(*pt3=='\0') return (pt2);
   }
return(NULL);
}

/****************************************************************************
 *                         fonction testJokSubst();                         *
 ****************************************************************************/
/*--------------------------------------------------------------------------+
| Teste si pt_name respecte les conditions de substitution prevues dans     |
| ptSub;                                                                    |
| entree : ptName - Le nom devant eventuellement etre substitue             |
|          ptSub  - La chaine de caratere contenant les jokers '*'          |
| Sortie : 0        Substitution possible                                   |
|         -1        Pas de correspondance                                   |
+--------------------------------------------------------------------------*/
static short testJokSubst(ptName,ptSub)
char * ptName ;
char * ptSub ;
{
char * name = ptName ;
char * sub = ptSub ;
char * pt ;

   if(*sub!=INF_JOK) 
   {
      while(*sub == *name) 
      {
      sub++  ;
      name++ ;
      }
      if(*sub!=INF_JOK) return(-1);
   sub=ptSub ;
   name=ptName ;
   }

   if(sub[strlen(sub)]!=INF_JOK)
   {
   short i = strlen(sub) ;
   short j = strlen(name);
      while(sub[i]==name[j])
      {
      j--;
      i--;
      }
      if(sub[i]!=INF_JOK) return(-1) ;
   }

   while(*sub!='\0')
   {
   char * motif ;
      if(*sub==INF_JOK) sub++ ;
      if(*sub=='\0') return (0) ;
   motif=subElt(sub,&sub,INF_JOK);
   name=motifInName(name,motif);
   free(motif);
      if(name==NULL) return(-1) ;
   }
return(0);   
}


/****************************************************************************
 *                         fonction jokSubst();                             *
 ****************************************************************************/
static char * jokSubst(name,subMotif,subName)
char * name ;
char * subMotif  ;
char * subName   ;
{
char * res ;
char   buff[100];
short test ;


strcpy(buff,name);

   while(*subMotif!='\0')
   {
   char * motif1 ;
   char * motif2 ;
      if(*subMotif==INF_JOK)
      {
      subMotif++;
      subName++ ;
      }
      if((*subMotif=='\0')&&(*subName=='\0'))
      {
      break ;
      }
      else if ((*subMotif=='\0')&&(*subName!='\0'))
      {
      strcat(buff,subName);
      break ;
      }
      else if ((*subMotif!='\0')&&(*subName=='\0'))
      {
      motif1=subElt(subMotif,&subMotif,INF_JOK);
      buff[strlen(buff)-strlen(motif1)]='\0';
      break ;
      }
      else 
      {
      motif1=subElt(subMotif,&subMotif,INF_JOK);
      motif2=subElt(subName,&subName,INF_JOK);
      name=motifInName(name,motif1);
      buff[(strlen(buff)-strlen(name)-strlen(motif1))]='\0' ;
      strcat(buff,motif2);
      strcat(buff,name);
      }
   }

res = (char*) malloc (strlen(buff)+1);
strcpy (res,buff);
return(res);
}

/****************************************************************************
 *                         fonction subElt();                               *
 ****************************************************************************/
static char * subElt (sub,addSub,jok)
char * sub ;
char ** addSub ;
char   jok ;
{
char buff[100] ;
char * res=buff ;

   while((*sub!=jok)&&(*sub!='\0'))
   {
   *res++ = *sub++ ;
   (*addSub)++;
   }

*res='\0' ;

res=(char*)malloc(strlen(buff)+1);
strcpy(res,buff);
return(res);
}


/****************************************************************************
 *                         fonction d2vJokSubstName();                      *
 ****************************************************************************/
char * d2vJokSubstName(name,orig,dest)
char * name ,
     * orig ,
     * dest ;
{
char * pt = orig ;
int test ;

   while(*pt!='\0')
   {
      if(*pt==INF_JOK) break ;
   pt++;
   }

   if(*pt=='\0') return(NULL);

test = testJokSubst(name,orig); 

   if(test==-1) return(NULL) ;

return(jokSubst(name,orig,dest));
}

/****************************************************************************
 *                         fonction d2vGenAssert();                         *
 ****************************************************************************/
void d2vGenAssert(fic)
FILE * fic ;
{
   if(INF_MUXU != NULL)
   addAssert(fic,INF_MUXU,D2V_MUXU);
   if(INF_MUXD != NULL)
   addAssert(fic,INF_MUXD,D2V_MUXD);
   if(INF_CMPU != NULL)
   addAssert(fic,INF_CMPU,D2V_CMPU);
   if(INF_CMPD != NULL)
   addAssert(fic,INF_CMPD,D2V_CMPD);
}


/****************************************************************************
 *                         fonction addAssert();                            *
 ****************************************************************************/
 /*-------------------------------------------------------------------------+
 | Rajoute dans le ficher vbe de sortie un assert pour chaque contrainte    |
 | exprimee dans le fichier d'information                                   |
 +-------------------------------------------------------------------------*/
static void addAssert(fic,liste,type)
FILE * fic ;         /* le fichier vbe de sortie de desb         */
chain_list * liste ;  /* une liste de liste de noms de connecteurs */
int type ;            /* type de la contrainte mux, cmp ...       */
{
chain_list * chaine ;
chain_list * ch1 ;
chain_list * ch2 ;
char  oper[10] ;
char  value[10];
char  totOper[10] ;
char  totValue[10];

   if((type==D2V_MUXU)||(type==D2V_CMPU))
   {
   strcpy(oper,"AND");
   strcpy(value,"0");
   }
   if((type==D2V_MUXD)||(type==D2V_CMPD))
   {
   strcpy(oper,"OR");
   strcpy(value,"1");
   }
   if(type==D2V_CMPU)
   {
   strcpy(totOper,"OR");
   strcpy(totValue,"1");
   }
   if(type==D2V_CMPD)
   {
   strcpy(totOper,"AND");
   strcpy(totValue,"0");
   }

   for(chaine=liste;chaine!=NULL;chaine=chaine->NEXT)
   {
      for(ch1=(chain_list *)chaine->DATA;ch1!=NULL;ch1=ch1->NEXT)
      {
         for(ch2=ch1->NEXT;ch2!=NULL;ch2=ch2->NEXT)
         {
         fprintf(fic,"\nASSERT ( %s %s %s = '%s' )\n",
                     (char*)ch1->DATA,
                     oper,
                     (char*)ch2->DATA,
                     value);
         fprintf(fic,"REPORT \"%s %s %s != %s \"\n",
                    (char*) ch1->DATA ,
                    oper ,
                    (char*) ch2->DATA ,
                    value );
         fprintf(fic,"SEVERITY WARNING ;\n");
         }
      }

      if ((type == D2V_CMPU)||(type == D2V_CMPD))
      {
      fprintf(fic,"\nASSERT (");

         for(ch1=(chain_list*)chaine->DATA;ch1!=NULL;ch1=ch1->NEXT)
         {
         fprintf(fic," %s",(char*)ch1->DATA);

            if(ch1->NEXT != NULL)
            fprintf(fic," %s",totOper); 
             
         }
      fprintf(fic," = '%s' )\n",totValue);

      fprintf(fic,"REPORT \"");
         for(ch1=(chain_list*)chaine->DATA;ch1!=NULL;ch1=ch1->NEXT)
         {
         fprintf(fic," %s",(char*)ch1->DATA);
            if(ch1->NEXT != NULL)
            fprintf(fic," %s",totOper); 
         }
      fprintf(fic," != %s \"\n",totValue);
      fprintf(fic,"SEVERITY WARNING ;\n");
      }
   }
}
        
/****************************************************************************
 *                         fonction NextCheminom();                         *
 ****************************************************************************/
static int nextSepar(nom)
char * nom;
{
char * courant;
   for(courant=nom; *courant != '\0' ; courant++)
      if (*courant == SEPAR) return(0);
return(-1);
}

/****************************************************************************
 *                         fonction d2vVectName();                         *
 ****************************************************************************/
char * d2vVectName ( name )
char * name ;
{
char * pt ; 

   for(pt=name ;*pt != '\0' ;pt++)
   {
      if(nextSepar(pt)==0)
      {
         while (*pt != SEPAR ) pt++ ;
      continue ;
      }
      else 
      {
      char * pt2 ;
         for(pt2 = pt ; *pt2 != '\0' ; pt2++) 
         {
            if(*pt2 == '[' ) *pt2='(' ;
            if(*pt2 == ']' ) *pt2=')' ;
         }
      }
   }
return(namealloc(name));
}
      
   

