
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: bvl_util.c						*/
/* date		: Jan 18 1993						*/
/* version	: v106							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* description	: This file contains some utility functions :		*/
/*		  bvl_error  , bvl_y_error, bvl_toolbug, bvl_message,	*/
/*									*/
/* ###--------------------------------------------------------------### */
	
#include <stdio.h>
#include <string.h>
#include <mut309.h>
#include <beh104.h>
#include <log120.h>
#include "bvl_utype.h"
#include "bvl_util.h"
#include "bvl_utdef.h"

/* ###--------------------------------------------------------------### */
/*  function : addent							*/
/* ###--------------------------------------------------------------### */
static struct dct_entry *addent (head , key)

struct dct_entry *head;
char             *key;

  {
  struct dct_entry *entry;
  int               i;

  if (BVL_DCEHED == NULL)
    {
    BVL_DCEHED = (struct dct_entry *)
                 mbkalloc (sizeof(struct dct_entry) * BVL_ALODFN);

    entry = BVL_DCEHED;
    for (i=1 ; i<BVL_ALODFN ; i++)
      {
      entry->next = entry + 1;
      entry++;
      }
    entry->next = NULL;
    }

  entry       = BVL_DCEHED;
  BVL_DCEHED  = BVL_DCEHED->next;

  entry->next = head;
  entry->data = NULL;
  entry->key  = key;

  return (entry);
  }

/* ###--------------------------------------------------------------### */
/*  function : addrcd							*/
/* ###--------------------------------------------------------------### */
static struct dct_recrd *addrcd (head , key)

struct dct_recrd *head;
char             *key;

  {
  struct dct_recrd *recrd;
  int               i;

  if (BVL_DCRHED == NULL)
    {
    BVL_DCRHED = (struct dct_recrd *)
                 mbkalloc (sizeof(struct dct_recrd) * BVL_ALODFN);

    recrd = BVL_DCRHED;
    for (i=1 ; i<BVL_ALODFN ; i++)
      {
      recrd->next = recrd + 1;
      recrd++;
      }
    recrd->next = NULL;
    }

  recrd           = BVL_DCRHED;
  BVL_DCRHED      = BVL_DCRHED->next;

  recrd->next     = head;
  recrd->fd0_val  = 0;
  recrd->fd1_val  = 0;
  recrd->fd2_val  = 0;
  recrd->fd3_val  = 0;
  recrd->fd4_val  = 0;
  recrd->fd5_val  = 0;
  recrd->fd6_val  = 0;
  recrd->pnt_val  = 0;
  recrd->key      = key;

  return (recrd);
  }

/* ###--------------------------------------------------------------### */
/*  function : initab							*/
/* ###--------------------------------------------------------------### */
static struct dct_entry **initab ()

  {
  struct dct_entry **head;
  int                i;

  head = (struct dct_entry **)
         mbkalloc (sizeof(struct dct_entry *) * BVL_HSZDFN);

  for (i=0 ; i<BVL_HSZDFN ; i++)
    head[i] = NULL;

  return (head);
  }

/* ###--------------------------------------------------------------### */
/*  function : addtab							*/
/* ###--------------------------------------------------------------### */
static void addtab (head,key_str,ctx_str,field,valu)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;
int                field;
int                valu;

  {
  int               found = 0;
  int               index;
  struct dct_entry *entry_pnt;
  struct dct_recrd *recrd_pnt;

  index     = (int) key_str % BVL_HSZDFN;
  entry_pnt = head[index];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 0)
    {
    head[index] = addent (head[index],key_str); 
    entry_pnt = head[index]; 
    }

  found = 0;
  recrd_pnt = entry_pnt->data;
  while (recrd_pnt != NULL)
    {
    if (recrd_pnt->key == ctx_str)
      {
      found = 1;
      break;
      }
    recrd_pnt = recrd_pnt->next;
    }

  if (found == 0)
    {
    entry_pnt->data = addrcd (entry_pnt->data,ctx_str); 
    recrd_pnt       = entry_pnt->data ;
    }

  switch (field)
    {
    case 0 :
      recrd_pnt->fd0_val = valu;
      break;
    case 1 :
      recrd_pnt->fd1_val = valu;
      break;
    case 2 :
      recrd_pnt->fd2_val = valu;
      break;
    case 3 :
      recrd_pnt->fd3_val = valu;
      break;
    case 4 :
      recrd_pnt->fd4_val = valu;
      break;
    case 5 :
      recrd_pnt->fd5_val = valu;
      break;
    case 6 :
      recrd_pnt->fd6_val = valu;
      break;
    case 7 :
      recrd_pnt->pnt_val = valu;
      break;
    }

  }

/* ###--------------------------------------------------------------### */
/*  function : chktab							*/
/* ###--------------------------------------------------------------### */
static int chktab (head,key_str,ctx_str,field)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;
int                field;

  {
  int               found = 0;
  int               valu = 0;
  struct dct_entry *entry_pnt;
  struct dct_recrd *recrd_pnt;

  entry_pnt = head [(int)key_str % BVL_HSZDFN];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 1)
    {
    found = 0;
    recrd_pnt = entry_pnt->data;
    while (recrd_pnt != NULL)
      {
      if (recrd_pnt->key == ctx_str)
        {
        found = 1;
        break;
        }
      recrd_pnt = recrd_pnt->next;
      }
    if (found == 1)
      {
      switch (field)
        {
        case 0 :
          valu = recrd_pnt->fd0_val;
          break;
        case 1 :
          valu = recrd_pnt->fd1_val;
          break;
        case 2 :
          valu = recrd_pnt->fd2_val;
          break;
        case 3 :
          valu = recrd_pnt->fd3_val;
          break;
        case 4 :
          valu = recrd_pnt->fd4_val;
          break;
        case 5 :
          valu = recrd_pnt->fd5_val;
          break;
        case 6 :
          valu = recrd_pnt->fd6_val;
          break;
        case 7 :
          valu = recrd_pnt->pnt_val;
          break;
        }
      }
    }

  return (valu);
  }

/* ###--------------------------------------------------------------### */
/*  function : fretab							*/
/* ###--------------------------------------------------------------### */
static void fretab (pt_hash)

struct dct_entry **pt_hash;
  {
  struct dct_entry *pt_entry;
  struct dct_entry *pt_nxtentry;
  struct dct_recrd *pt_record;
  int               i;

  if (pt_hash != NULL)
    {
    for (i=0 ; i<BVL_HSZDFN ; i++)
      {
      if ((pt_entry = pt_hash[i]) != NULL)
        {
        while (pt_entry != NULL)
          {
          pt_record = pt_entry->data;

          while (pt_record->next != NULL)
            pt_record = pt_record->next;

          pt_record->next = BVL_DCRHED;
          BVL_DCRHED      = pt_entry->data;

          pt_nxtentry     = pt_entry->next;
          pt_entry->next  = BVL_DCEHED;
          BVL_DCEHED      = pt_entry;
          pt_entry        = pt_nxtentry;
          }
        }
      }
    free (pt_hash);
    }
  }

/* ###--------------------------------------------------------------### */
/*  function : bvl_toolbug						*/
/* ###--------------------------------------------------------------### */
void bvl_toolbug (code,str1,str2,nbr1)

int   code;
char *str1;
char *str2;
int   nbr1;

  {
  (void) fprintf (stderr,"Fatal error %d executing `%s`: ", code,str1);
  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"unknown operator\n");
      break;
    case 2:
      (void) fprintf (stderr,"cannot create empty atom\n");
      break;
    case 3:
      (void) fprintf (stderr,"cannot build NOT of empty expression\n");
      break;
    case 4:
      (void) fprintf (stderr,"cannot combine empty expressions\n");
      break;
    case 5:
      (void) fprintf (stderr,"cannot find terminal\n");
      break;
    case 6:
      (void) fprintf (stderr,"cannot make BDD of empty expression\n");
      break;
    case 7:
      (void) fprintf (stderr,"unknown type `%c` for IO `%s`\n",nbr1,str2);
      break;
    case 8:
      (void) fprintf (stderr,"illegal signal value : hex `%x`\n",nbr1);
      break;
    case 9:
      (void) fprintf (stderr,"unknown mode `%c` for IO `%s`\n",nbr1,str2);
      break;
    case 10:
      (void) fprintf (stderr,"decompiler called on empty befig\n");
      break;
    case 12:
      (void) fprintf (stderr,"illegal user value '%c' for IO\n",nbr1);
      break;
    case 13 :
      (void) fprintf (stderr,"cannot find model of `%s`\n",str2);
      break;
    case 14 :
      (void) fprintf (stderr,"cannot convert empty expression\n");
      break;
    case 15 :
      (void) fprintf (stderr,"illegal bit string value : `%c`\n",nbr1);
      break;
    case 16 :
      (void) fprintf (stderr,"the same expression cannot be used twice\n");
      break;
    case 17 :
      (void) fprintf (stderr,"unknown base specifier : `%c`\n",nbr1);
      break;
    case 18:
      (void) fprintf (stderr,"unknown mode `%c` for port `%s`\n",nbr1,str2);
      break;
    case 19:
      (void) fprintf (stderr,"empty guard expression: `%s`\n",str2);
      break;
    case 20:
      (void) fprintf (stderr,"empty waveform expression: `%s`\n",str2);
      break;
    case 21:
      (void) fprintf (stderr,"cannot find structural level\n");
      break;
    case 22:
      (void) fprintf (stderr,"`%s` : `%c` unknown resolution function\n",str2,nbr1);
      break;
    }
  exit (1);
  }

/* ###--------------------------------------------------------------### */
/*  function : bvl_message						*/
/* ###--------------------------------------------------------------### */
void bvl_message (code,str1,nmb1)

int   code;
char *str1;
int   nmb1;

  {
  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"Usage : asimut <root> [<pattern> <result_file>] [-option]\n");
      (void) fprintf (stderr,"or      asimut -help\n");
      break;
    case 2:
      (void) fprintf (stdout,"Initializing ...\n");
      break;
    case 3:
      (void) fprintf (stdout,"Compiling `%s` (Behaviour) ...\n",str1);
      break;
    case 4:
      (void) fprintf (stdout,"Compiling `%s` (Structural) ...\n\n",str1);
      break;
    case 5:
      (void) fprintf (stdout,"Searching `%s` ...\n",str1);
      break;
    case 8:
      (void) fprintf (stdout,"Compiling `%s` (Pattern) ...\n\n",str1);
      break;
    case 9:
      (void) fprintf (stdout,"Linking ...\n");
      break;
    case 10:
      (void) fprintf (stdout,"###----- processing pattern %d -----###\n",nmb1);
      break;
    case 11:
      (void) fprintf (stdout,"Decompiling ...\n");
      break;
    case 12:
      (void) fprintf (stdout,"Generating the file '%s' ...\n",str1);
      break;
    case 13:
      (void) fprintf (stdout,"Saving '%s' in a vhdl file (vbe)\n",str1);
      break;
    case 14:
      (void) fprintf (stdout,"File '%s' has been generated.\n",str1);
      break;
    case 15:
      (void) fprintf (stdout,"Making Bdd ...\n\n");
      break;
    case 16:
      (void) fprintf (stdout,"Restoring ...\n\n");
      break;
    default:
      (void) fprintf (stderr,"bvl_message : code %d unknown.\n",code);
    }
  }

/* ###--------------------------------------------------------------### */
/*  function : bvl_error						*/
/* ###--------------------------------------------------------------### */

void bvl_error (code, str1)

int   code;
char *str1;

  {
  BVL_ERRFLG++;
  if (code < 100)
    (void)fprintf (stderr,"`%s` Error %d line %d :",BVL_CURFIL,code,BVL_LINNUM);
  else
    {
    if (code < 200)
      (void)fprintf (stderr,"Error %d :",code);
    }

  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"`%s` is incompatible with the entity name\n",str1);
      break;
    case 2:
      (void) fprintf (stderr,"bad entity declaration\n");
      break;
    case 3:
      (void) fprintf (stderr,"bad port clause declaration\n");
      break;
    case 4:
      (void) fprintf (stderr,"port `%s` already declared\n",str1);
      break;
    case 5:
      (void) fprintf (stderr,"illegal port declaration (mode, type, kind)\n");
      break;
    case 6:
      (void) fprintf (stderr,"bad port declaration\n");
      break;
    case 7:
      (void) fprintf (stderr,"`%s` is incompatible with the architecture name\n",str1);
      break;
    case 8:
      (void) fprintf (stderr,"bad architecture declaration\n");
      break;
    case 9:
      (void) fprintf (stderr,"illegal declaration\n");
      break;
    case 10:
      (void) fprintf (stderr,"signal `%s` already declared\n",str1);
      break;
    case 11:
      (void) fprintf (stderr,"illegal signal declaration (type, kind)\n");
      break;
    case 17:
      (void) fprintf (stderr,"`%s` unknown port or signal\n",str1);
      break;
    case 18:
      (void) fprintf (stderr,"illegal concurrent statement\n");
      break;
    case 19:
      (void) fprintf (stderr,"label `%s` already used\n",str1);
      break;
    case 20:
      (void) fprintf (stderr,"`%s` is incompatible with the block's label\n",str1);
      break;
    case 21:
      (void) fprintf (stderr,"input port `%s` cannot be assigned\n",str1);
      break;
    case 22:
      (void) fprintf (stderr,"unguarded signal `%s` assigned by guarded assignment\n",str1);
      break;
    case 23:
      (void) fprintf (stderr,"guarded signal `%s` assigned by unguarded assignment\n",str1);
      break;
    case 25:
      (void) fprintf (stderr,"some choices missing in the selected signal assignment\n");
      break;
    case 26:
      (void) fprintf (stderr,"output port `%s` cannot be read\n",str1);
      break;
    case 28:
      (void) fprintf (stderr,"duplicate choice in selected signal assignment\n");
      break;
    case 30:
      (void) fprintf (stderr,"illegal use of OTHERS in selected signal assignment\n");
      break;
    case 32:
      (void) fprintf (stderr,"null array not supported\n");
      break;
    case 33:
      (void) fprintf (stderr,"incompatible constraint and type\n");
      break;
    case 35:
      (void) fprintf (stderr,"illegal assignment of `%s` (widths mismatch)\n",str1);
      break;
    case 36:
      (void) fprintf (stderr,"signal `%s` used out of declared range\n",str1);
      break;
    case 38:
      (void) fprintf (stderr,"width or/and type mismatch\n");
      break;
    case 39:
      (void) fprintf (stderr,"signal `%s` assigned more than once\n",str1);
      break;
    case 40:
      (void) fprintf (stderr,"signal `%s` never assigned\n",str1);
      break;

    case 68:
      (void) fprintf (stderr,"BEPOR type is unknown\n");
      break;
    case 73:
      (void) fprintf (stderr,"`%s` is not a bit string litteral\n",str1);
      break;
    case 74:
      (void) fprintf (stderr,"bad generic declaration\n");
      break;
    case 75:
      (void) fprintf (stderr,"bad generic element\n");
      break;
    case 76:
      (void) fprintf (stderr,"`%s`: when expression must be a constant\n",str1);
      break;
    case 77:
      (void) fprintf (stderr,"illegal generic declaration (type, kind)\n");
      break;
    case 78:
      (void) fprintf (stderr,"illegal constant declaration (type, kind)\n");
      break;
    case 79:
      (void) fprintf (stderr,"illegal use of attribute STABLE on `%s`\n",str1);
      break;

    case 100:
      (void) fprintf (stderr,"cannot find `%s`\n",str1);
      break;
    case 107:
      (void) fprintf (stderr,"Cannot open result file\n");
      break;
    case 112:
      (void) fprintf (stderr,"multiple driver on guarded signal `%s`\n",str1);
      break;

    default:
      (void) fprintf (stderr,"syntax error\n");
      break;
    }

  if (BVL_ERRFLG > BVL_MXRDFN)
    {
    (void) fprintf (stderr,"Too many errors. Cannot continue further more\n");
    (void) fprintf (stderr,"\n		Have a nice day...\n");
    exit (1);
    }

  }

/* ###--------------------------------------------------------------### */
/*  function : bvl_y_error						*/
/* ###--------------------------------------------------------------### */
void bvl_y_error (str)

char *str;
  {
  BVL_ERRFLG++;
  (void)fprintf (stderr,"`%s` Error line %d : %s\n",BVL_CURFIL,BVL_LINNUM,str);
  }

/* ###--------------------------------------------------------------### */
/*  function : bvl_vhdlname						*/
/* ###--------------------------------------------------------------### */
char *bvl_vhdlname (name)

char *name;

  {
  char                     *new_name;
  char                     *prv_name;
  char                     *tmp_name;
  char                      buffer[200];
  int                       i,j,flag,number;
  static struct dct_entry **namtab=NULL;

  if (namtab == NULL)
    namtab = initab ();

  tmp_name = namealloc (name);
  new_name = (char *) chktab (namtab,tmp_name,NULL,BVL_PNTDFN);

  if (chktab (namtab,tmp_name,NULL,BVL_NAMDFN) == 0)
    {
    i = 0;
    j = 0;
    number = 0;
    flag = 1;
    while (tmp_name[i] != '\0')
      {
      buffer[j] = tmp_name[i];
      if ( ((tmp_name[i] >= 'a') && (tmp_name[i] <= 'z')) ||
           ((tmp_name[i] >= 'A') && (tmp_name[i] <= 'Z')) ||
           ((tmp_name[i] >= '0') && (tmp_name[i] <= '9') && (i != 0)))
        flag = 0;
      else
        {
        if (flag == 1)
          buffer[j++] = 'v';
        buffer[j] = '_';
        flag = 1;
        }
      i++;
      j++;
      }
    if (buffer[j-1] == '_')
      buffer[j++] = '0';
    buffer[j] = '\0';
    new_name = namealloc (buffer);

    prv_name = new_name;
    while (chktab (namtab,new_name,NULL,BVL_NEWDFN) != 0)
      {
      new_name = prv_name;
      sprintf (buffer,"%s_%d",new_name,number++);
      prv_name = new_name;
      new_name = namealloc (buffer);
      }
    addtab (namtab,new_name,NULL,BVL_NEWDFN,1);
    addtab (namtab,tmp_name,NULL,BVL_PNTDFN,(int)new_name);
    addtab (namtab,tmp_name,NULL,BVL_NAMDFN,1);
    }

  return (new_name);
  }

/* ###--------------------------------------------------------------### */
/*  function : bvl_vectorize						*/
/*  content  : put parenthesis for bused signals			*/
/* ###--------------------------------------------------------------### */
char *bvl_vectorize(name)

char *name;
  {
  char *blank_space;
  char *blank_space2;
  char *new_name;
  char name_tmp2[200];
  char *name_tmp;
  char *vhdl_name;

  name_tmp = (char *)mbkalloc(strlen(name) + 1);
  strcpy(name_tmp,name);
  blank_space = strchr(name_tmp,' ');
  if(blank_space != NULL)
    {
    vhdl_name = (char *)mbkalloc(strlen(name) + 1);
    strcpy(vhdl_name,name);
    blank_space2 = strchr(vhdl_name,' ');
    *blank_space2 = '\0';
    *blank_space  = '(';
    (void)sprintf(name_tmp2,"%s%s)",bvl_vhdlname(vhdl_name),blank_space);
    new_name = (char *)mbkalloc(strlen(name_tmp2) + 1);
    strcpy(new_name,name_tmp2);
    return(new_name);
    }
  else
    {
    if(strchr(name,'\'') != NULL)  /* For 'stable */
      return(name);
    else
      return(bvl_vhdlname(name));
    }
  }
  
/* ###--------------------------------------------------------------### */
/*  function : bvl_vectnam                                              */
/*  analyze a list of signal and return the bounds of the vectorised	*/
/*    signals, if they occure.						*/
/* ###--------------------------------------------------------------### */
void *bvl_vectnam(pt_list,left,right,name,type)
          
void *pt_list;
int *left, *right;  
char **name;        
char type;		/* If type = 0 bepor_list, type = 1 bebux_list	*/        
			/* If type = 2 bereg_list, type = 3 beaux_list	*/        
                 
  {      
  char *blank_space;
  char *sig_name;
  char name_tmp[200];
  char number[200]; 
  bepor_list *ptpor;
  bebux_list *ptbux;
  beaux_list *ptaux;
  bereg_list *ptreg;
  char END = 0;     
  char *mode;
                    
  /* Case bepor_list */
  if(type==0)
    {               
    ptpor = (bepor_list *)pt_list;
      *left = *right = -1;
      sig_name = ptpor->NAME;
      *name = (char*)mbkalloc(strlen(sig_name) + 1);
      strcpy(*name,sig_name);
      blank_space = strchr(*name,' ');
      if (blank_space != NULL)
        {           
        strcpy(number,blank_space);
        *left = atoi(number);
        *right = *left;
        *blank_space = '\0';
        }           
                    
      while(!END)   
        {
        if(ptpor->NEXT != NULL)
          {
          strcpy(name_tmp,(ptpor->NEXT)->NAME);
          blank_space = strchr(name_tmp,' ');
          if(blank_space!=NULL)
            {
            strcpy(number,blank_space);
            *blank_space = '\0';
            if(!strcmp(*name,name_tmp))
              {     
              *right = atoi(number);
              ptpor = ptpor->NEXT;
              }     
            else    
              END = 1;
            }
          else      
            END = 1;
          }         
        else
          END = 1;
      }
    return(ptpor);
    }
              
  /*case bebux_list */
  if(type==1)
    {     
    ptbux = (bebux_list *)pt_list;
    /* Extract the name and number of an element */
    *left = *right = -1;
    sig_name = ptbux->NAME;
    *name = (char *)mbkalloc(strlen(sig_name) + 1);
    strcpy(*name,sig_name);
    blank_space = strchr(*name,' ');
    if (blank_space != NULL)
      {        
      strcpy(number,blank_space);
      *right = atoi(number);
      *left = *right;
      *blank_space = '\0';
      }
                    
    while(END != 1) 
      {
      if(ptbux->NEXT != NULL)
        {           
        strcpy(name_tmp,ptbux->NEXT->NAME);
        blank_space = strchr(name_tmp,' ');
        if(blank_space!=NULL)
          {         
          strcpy(number,blank_space);
          *blank_space = '\0';
          if(!strcmp(*name,name_tmp))
            {       
            *right = atoi(number);
            ptbux = ptbux->NEXT;
            }
          else   
            END = 1;
          }         
        else
          END = 1;  
        }           
      else          
        END = 1;
      }                    
    return(ptbux);  
    }               

  /*case bereg_list */
  if(type==2)
    {     
    ptreg = (bereg_list *)pt_list;
    /* Extract the name and number of an element */
    *left = *right = -1;
    sig_name = ptreg->NAME;
    *name = (char *)mbkalloc(strlen(sig_name) + 1);
    strcpy(*name,sig_name);
    blank_space = strchr(*name,' ');
    if (blank_space != NULL)
      {        
      strcpy(number,blank_space);
      *right = atoi(number);
      *left = *right;
      *blank_space = '\0';
      }
                    
    while(END != 1) 
      {
      if(ptreg->NEXT != NULL)
        {           
        strcpy(name_tmp,ptreg->NEXT->NAME);
        blank_space = strchr(name_tmp,' ');
        if(blank_space!=NULL)
          {         
          strcpy(number,blank_space);
          *blank_space = '\0';
          if(!strcmp(*name,name_tmp))
            {       
            *right = atoi(number);
            ptreg = ptreg->NEXT;
            }
          else   
            END = 1;
          }         
        else
          END = 1;  
        }           
      else          
        END = 1;
      }                    
    return(ptreg);  
    }               

  /*case beaux_list */
  if(type==3)
    {     
    ptaux = (beaux_list *)pt_list;
    /* Extract the name and number of an element */
    *left = *right = -1;
    sig_name = ptaux->NAME;
    *name = (char *)mbkalloc(strlen(sig_name) + 1);
    strcpy(*name,sig_name);
    blank_space = strchr(*name,' ');
    if (blank_space != NULL)
      {        
      strcpy(number,blank_space);
      *right = atoi(number);
      *left = *right;
      *blank_space = '\0';
      }
                    
    while(END != 1) 
      {
      if(ptaux->NEXT != NULL)
        {           
        strcpy(name_tmp,ptaux->NEXT->NAME);
        blank_space = strchr(name_tmp,' ');
        if(blank_space!=NULL)
          {         
          strcpy(number,blank_space);
          *blank_space = '\0';
          if(!strcmp(*name,name_tmp))
            {       
            *right = atoi(number);
            ptaux = ptaux->NEXT;
            }
          else   
            END = 1;
          }         
        else
          END = 1;  
        }           
      else          
        END = 1;
      }                    
    return(ptaux);  
    }               
  }            

/* ###--------------------------------------------------------------### */
/*  function : bvl_printabl						*/
/*  content  : put a \n for a better presentation of an abl		*/
/* ###--------------------------------------------------------------### */
char *bvl_printabl(chaine)
char *chaine;
  {
  char *chaine_tmp = NULL;
  char *blanc = NULL;

  chaine_tmp = chaine;
  while(strlen(chaine_tmp)>60)
    {
    chaine_tmp = &chaine_tmp[60];
    blanc = strchr(chaine_tmp,' ');
    if(blanc != NULL)
      {
      *blanc = '\n';
      chaine_tmp = blanc;
      }
    }
  return(chaine);
  }
    
/* ###--------------------------------------------------------------### */
/*  function : bvl_abl2str						*/
/* ###--------------------------------------------------------------### */
char *bvl_abl2str (expr,chaine,taille)

struct chain *expr;
char         *chaine;
int          *taille;

  {

  char        *oper;
  extern char *operToChar ();

  if (expr->NEXT == NULL)
   {
   if (*taille < strlen(chaine)+50)		/* re-allocation */
     {
     *taille = *taille + 100;
     chaine = (char *) realloc(chaine,*taille);
     }

   if ((expr->DATA == (void *)namealloc("'0'")) ||
       (expr->DATA == (void *)namealloc("'1'")) ||
       (expr->DATA == (void *)namealloc("'d'")) ||
       (expr->DATA == (void *)namealloc("'D'")))
      strcat (chaine,expr->DATA);
   else
      strcat (chaine,bvl_vectorize(expr->DATA));
   return (chaine);
   }
  else
    {
    oper = operToChar((short)((chain_list *)expr->DATA)->DATA);

    if (!strcmp(oper,"not"))
      {
      strcat(chaine,"not (");
      chaine = bvl_abl2str (expr->NEXT->DATA,chaine,taille);
      strcat(chaine,")");
      return(chaine);
      }
    else if (!strcmp(oper,"stable"))
      {
      strcat(chaine,(char *)(((struct chain*)((expr->NEXT)->DATA))->DATA));
      strcat(chaine,"'STABLE");
      return(chaine);
      }
    else
      {
      strcat(chaine,"(");
      while (expr = expr->NEXT)
        {
        chaine = bvl_abl2str (expr->DATA,chaine,taille);
        if (expr->NEXT)
          {
          strcat (chaine," ");
          strcat (chaine,oper);
          strcat (chaine," ");
          }
        }
      strcat(chaine,")");
      return(chaine);
      }
    }
  }
