
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_rmvbereg.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_rmvbereg						*/
/* description	: delete a BEREG structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree, beh_frebiabl, beh_frebinode			*/
/* ###--------------------------------------------------------------### */

struct bereg *beh_rmvbereg (listbereg, beregname, mode)

struct bereg *listbereg;	/* list of bereg containing the object	*/
char         *beregname;	/* name of the BEREG to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct bereg  headreg;
  struct bereg *ptlastreg;
  struct bereg *ptbereg;

  if (listbereg != NULL)
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headreg.NEXT = listbereg;
    ptbereg      = &headreg;
    while ((ptbereg != NULL) && (ptbereg->NAME != beregname))
      {
      ptlastreg = ptbereg;
      ptbereg   = ptbereg->NEXT;
      }

    if (ptbereg != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if ((ptbereg->BIABL != NULL) || (ptbereg->BINODE != NULL))
          (void) fprintf (stderr,"BEH_warning : bereg `%s` not empty\n",
                          beregname);
        }
      else
        {
        beh_frebiabl  (ptbereg->BIABL);
        beh_frebinode (ptbereg->BINODE);
        }

      ptlastreg->NEXT = ptbereg->NEXT;
      mbkfree (ptbereg);
      }

    listbereg = headreg.NEXT;
    }

  return(listbereg);
  }
