
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebegen.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebegen						*/
/* description	: delete a list of BEGEN structures and all objects	*/
/*		  pointed by any os BEGENs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebegen (listbegen)

struct begen *listbegen;	/* list of begen to be deleted		*/

  {
  struct begen *ptbegen;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbegen != NULL)
    {
    mbkfree (listbegen->VALUE);

    ptbegen   = listbegen;
    listbegen = listbegen->NEXT;
    mbkfree (ptbegen);
    }

  }
