
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebebux.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebebux						*/
/* description	: delete a list of BEBUX structures and all objects	*/
/*		  pointed by any os BEBUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebebux (listbebux)

struct bebux *listbebux;	/* list of bebux to be deleted		*/

  {
  struct bebux *ptbebux;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbebux != NULL)
    {
    beh_frebiabl  (listbebux->BIABL);
    beh_frebinode (listbebux->BINODE);

    ptbebux   = listbebux;
    listbebux = listbebux->NEXT;
    mbkfree (ptbebux);
    }

  }
