
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_addbiabl.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_addbiabl						*/
/* description	: create a BIABL structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct biabl *beh_addbiabl (lastbiabl, label, condition, value)

char         *label;		/* block's label			*/
struct biabl *lastbiabl;	/* pointer on the last biabl structure	*/
struct chain *condition;	/* guard expression (ABL)		*/
struct chain *value;		/* value expression (ABL)		*/

  {
  struct biabl  *ptbiabl;

  ptbiabl         = (struct biabl *) mbkalloc (sizeof(struct biabl));
  label           = namealloc (label);

  ptbiabl->LABEL  = label;
  ptbiabl->CNDABL = condition;
  ptbiabl->VALABL = value;
  ptbiabl->USER   = NULL;
  ptbiabl->NEXT   = lastbiabl;

  return (ptbiabl);
  }
