
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_addbefig.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_addbefig						*/
/* description	: create an empty BEFIG structure at the top of the list*/
/*		  The BEH_HEDFIG list is not modified.			*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct befig *beh_addbefig (lastbefig, name)

struct befig *lastbefig;	/* pointer on the last befig structure	*/
char         *name;		/* figure's name			*/

  {
  struct befig *ptfig;

  name          = namealloc (name);

  ptfig         = (struct befig *) mbkalloc (sizeof(struct befig));
  ptfig->NAME   = name;
  ptfig->BEREG  = NULL;
  ptfig->BEMSG  = NULL;
  ptfig->BERIN  = NULL;
  ptfig->BEOUT  = NULL;
  ptfig->BEBUS  = NULL;
  ptfig->BEAUX  = NULL;
  ptfig->BEDLY  = NULL;
  ptfig->BEBUX  = NULL;
  ptfig->BEPOR  = NULL;
  ptfig->CIRCUI = NULL;
  ptfig->USER   = NULL;
  ptfig->ERRFLG = 0;
  ptfig->TYPE   = 0;
  ptfig->NEXT   = lastbefig;

  return (ptfig);
  }
