#include <fcntl.h>
#include <string.h>

/*#define DEBUG_G vrai*/
#ifdef DEBUG_G
FILE *fdbg;
#define DEBUG_G_DEVICE "/dev/tty03"
#endif

#define NORES	3
#define TIME_OUT 300
#define NB_RETRY 20

#define FCT_NOR	0
#define FCT_RET	1

#define NON_EMET	0
#define EMET		1

char	paquet, last_paquet;

/***********************************************************/
/*                                                         */
/*   Fonction de dialogue avec le PC                       */
/*                                                         */
/***********************************************************/
calc_checksum(string)
char	*string;
{
	int	i, chks;

	for (chks = i = 0; string[i] != '\0'; i++)
		chks ^= string[i];
	chks = (chks & 0x3f) + 32;
	if (chks == '#')
		return('a');
	if (chks == '@')
		return('b');
	return(chks);
}


inc_paquet(nb)
char	*nb;
{
	if (*nb == 'Z')
		*nb = 'A';
	else
		(*nb)++;
}


char	*emet_fct(type, str_emet)
int	type;
char	*str_emet;
{
	int	nb_emis, i, j, flag;
	char	recus, string[TAILLE_MES];
	char fct;
	int etat = EMET;

	fct = str_emet[strlen(str_emet)-1];
	sprintf(string, "\033%s%c\000", str_emet, paquet);
	i = strlen(string);
	string[i] = calc_checksum(string);
	string[i+1] = '\0';
	for (nb_emis = 0; nb_emis < NB_RETRY; nb_emis++) {
		if (etat == EMET) {
#ifdef DEBUG_G
fprintf (fdbg,"  E%s", string + 1);
#endif
			printf("%s\n", string);
		}
		if (type == FCT_RET) {
#ifdef DEBUG_G
fprintf (fdbg,"[RET]  ");
#endif
			string[0] = getchar();
			if ((string[0] == '|') || (string[0] == last_paquet))
				{
				getchar();
				continue;
				}
			if (string[0] == 27) {
#ifdef DEBUG_G
fprintf (fdbg,"  R");
#endif
				string[1] = getchar();
				if (string[1] == '{') {
#ifdef DEBUG_G
fprintf (fdbg,"{");
#endif
					for (j = 2; (string[j] = getchar()) != '}'; j++)
						;
					string[++j] = getchar();
					string[j+1] = '\0';
#ifdef DEBUG_G
fprintf (fdbg,"%s",&(string[2]));
#endif
					if (string[j] == paquet) {
						i = getchar();
#ifdef DEBUG_G
fprintf (fdbg,"%c   ", i);
#endif
						if (i == calc_checksum(string)) {
							last_paquet = paquet;
							inc_paquet(&paquet);
							i = getchar (); /* lecture du RC */
#ifdef DEBUG_G
fprintf (fdbg,"\n", i);
#endif
							strcpy (str_emet, string + 2);
							return(str_emet);
						}
					} /* if paquet */
				} /* if { */
			} else {
			    if (string[0] == 10) {
					puts("Aborting Alliance on RC (ret)\n");
					if (fct != 'f') {
						gemappl_exit ();
					}
					exit(0);
				}
			}
		} else {
/* fonction sans retour de parametre */
#ifdef DEBUG_G
fprintf (fdbg,"[NOR]  ");
#endif
/* mise en non bloquant du read */
			flag = fcntl(0, F_GETFL, 0);
			flag |= O_NDELAY;
			fcntl(0, F_SETFL, flag);
			i = 0;
			for (j = 0; j < TIME_OUT; j++)
				if (read(0, &i, 1) == 1)
					break;
/* remise en bloquant du read */
			flag &= ~O_NDELAY;
			fcntl(0, F_SETFL, flag);
			if (j >= TIME_OUT) {
				etat = EMET;
				continue;
/*				puts("Aborting Alliance on Time out\n");
				exit(1);*/
			}
			i /= 16777216;
#ifdef DEBUG_G
fprintf (fdbg,"  R%c  ", i);
#endif
			if (i == 10) {
				puts("Aborting Alliance on RC (nor)\n");
				if (fct != 'f') {
					gemappl_exit ();
				}
				exit(1);
			}
			if (i == last_paquet)
				{
				getchar();
				etat = NON_EMET;
				continue;
				}
			if (i == '|')
				{
				getchar();
				continue;
				}
			if (i == 27)
				{
				while(getchar() != '\n');
				etat = NON_EMET;
				continue;
				}
			if (i == paquet) {
				last_paquet = paquet;
				inc_paquet(&paquet);
				i = getchar (); /* lecture du RC */
#ifdef DEBUG_G
fprintf (fdbg,"\n", i);
#endif
				return(NULL);
			}
		} /* else FCT_NOR */
	} /* for nb_emis */
	printf ("Aborting Alliance on too many retries\n");
	exit (1);
}


/***********************************************************/
/*                                                         */
/*   Fonctions de vdincr                                   */
/*                                                         */
/***********************************************************/

/*  Fonction avec retour de valeur */

/***********************************************************/
/*                                                         */
/*                    gemappl_init                         */
/*                                                         */
/* Envoi de parametre : NEANT                              */
/*                                                         */
/* Retour de parametre :                                   */
/*            1)  RESOLX(NORES)                            */
/**/
/**/
/**/
/**/
/***********************************************************/
gemappl_init()
{
	char	str_emet[TAILLE_MES];
	char	*str_ret, *ptemp, *paux;
	
	paquet = 'A';
	last_paquet = 'Z';
#ifdef DEBUG_G
fdbg = fopen (DEBUG_G_DEVICE, "w");
#endif
	do
	 {
		puts("Alliance v2.2 NCR en attente de l'emulateur graphique (GR) sur le PC\n");
		puts("==> Pour le charger, taper successivement les touches: ");
		puts("        [Alt]+[X]   [Y]    pour quitter procomm, puis");
		puts("        [G]  [R]  [ENTER]  pour lancer l'emulateur graphique.\n");
		puts("==> Pour abandonner Alliance, taper:");
		puts("        [Q]  [ENTER]\n");
		gets(str_emet);
		if ((str_emet[0]=='q')||(str_emet[0]=='Q')) {
			printf ("Abandon d'alliance\n");
			exit (1);
		}
	} while (strcmp(str_emet, "<o>GROK<o>") != 0);
	printf("~");
	strcpy(str_emet, "A");
	str_ret = emet_fct(FCT_RET, str_emet);
	paux = strchr(str_ret, ',');
	*paux = '\0';
	RESOLX(NORES) = atoi(str_ret);
	ptemp = paux + 1;
	paux = strchr(ptemp, ',');
	*paux = '\0';
	RESOLY(NORES) = atoi(ptemp);
	ptemp = paux + 1;
	paux = strchr(ptemp, ',');
	*paux = '\0';
	HTEXT = atoi(ptemp);
	ptemp = paux + 1;
	paux = strchr(ptemp, '}');
	*paux = '\0';
	LTEXT = atoi(ptemp);
}


/***********************************************************/
/*                                                         */
/*                    vdirq_locator                        */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  x                                        */
/*            2)  y                                        */
/*                                                         */
/* Retour de parametre :                                   */
/*            1)  xf                                       */
/*            2)  yf                                       */
/*            3)  term                                     */
/*                            */
/***********************************************************/
vdirq_locator(handle, x, y, xf, yf, term)
cnat handle, x, y, *xf, *yf, *term;
{
	char	str_emet[TAILLE_MES];
	char	*str_ret, *ptemp, *paux;

	sprintf(str_emet, "{%d,%d}B", x, y);
	str_ret = emet_fct(FCT_RET, str_emet);
	paux = strchr(str_ret, ',');
	*paux = '\0';
	*xf = atoi(str_ret);
	ptemp = paux + 1;
	paux = strchr(ptemp, ',');
	*paux = '\0';
	*yf = atoi(ptemp);
	ptemp = paux + 1;
	paux = strchr(ptemp, '}');
	*paux = '\0';
	*term = atoi(ptemp);
}


/***********************************************************/
/*                                                         */
/*                    vdism_locator                        */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  x                                        */
/*            2)  y                                        */
/*                                                         */
/* Retour de parametre :                                   */
/*            1)  xa                                       */
/*            2)  ya                                       */
/*            3)  term                                     */
/*                            */
/***********************************************************/
vdism_locator(handle, x, y, xa, ya, term)
int	handle, x, y, *xa, *ya;
int	*term;
{
	char	str_emet[TAILLE_MES];
	char	*str_ret, *ptemp, *paux;

	sprintf(str_emet, "{%d,%d}C", x, y);
	str_ret = emet_fct(FCT_RET, str_emet);
	paux = strchr(str_ret, ',');
	*paux = '\0';
	*xa = atoi(str_ret);
	ptemp = paux + 1;
	paux = strchr(ptemp, ',');
	*paux = '\0';
	*ya = atoi(ptemp);
	ptemp = paux + 1;
	paux = strchr(ptemp, '}');
	*paux = '\0';
	*term = atoi(ptemp);
}


/***********************************************************/
/*                                                         */
/*                    vdi_get_pixel                        */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  x                                        */
/*            2)  y                                        */
/*                                                         */
/* Retour de parametre :                                   */
/*            1)  return()                                 */
/*                                                         */
/***********************************************************/
vdi_get_pixel(handle, x, y)
cnat handle, x, y;
{
	char	str_emet[TAILLE_MES];
	char	*str_ret, *paux;

	sprintf(str_emet, "{%d,%d}D", x, y);
	str_ret = emet_fct(FCT_RET, str_emet);
	paux = strchr(str_ret, '}');
	*paux = '\0';
	return(atoi(str_ret));
}


/***********************************************************/
/*                                                         */
/*                    gemCrawcin                           */
/*                                                         */
/* Envoi de parametre : NEANT                              */
/*                                                         */
/* Retour de parametre :                                   */
/*            1)  return()                                 */
/*                                                         */
/***********************************************************/
gemCrawcin()
{
	char	str_emet[TAILLE_MES];
	char	*str_ret, *paux;

	strcpy(str_emet, "E");
	str_ret = emet_fct(FCT_RET, str_emet);
	paux = strchr(str_ret, '}');
	*paux = '\0';
	return(atoi(str_ret));
}


/*  Fonction sans retour de valeur */

/***********************************************************/
/*                                                         */
/*                    vdisf_color                          */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  cl                                       */
/*                                                         */
/***********************************************************/
vdisf_color(handle, cl)
int	handle, cl;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d}a", cl);
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdi_bar                              */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  pxy[0]                                   */
/*            2)  pxy[1]                                   */
/*            3)  pxy[2]                                   */
/*            4)  pxy[3]                                   */
/*                                                         */
/***********************************************************/
vdi_bar(handle, pxy)
cnat handle, *pxy;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d,%d,%d,%d}b", pxy[0], pxy[1], pxy[2], pxy[3]);
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdisf_style                          */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  no                                       */
/*                                                         */
/***********************************************************/
vdisf_style(handle, no)
cnat handle, no;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d}c", no);
	emet_fct(FCT_NOR, str_emet);
}


vdis_color()
{
}


vdiswr_mode(handle, mode)
cnat handle, mode;
{
}


/***********************************************************/
/*                                                         */
/*                    vdisf_interior                       */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  style                                    */
/*                                                         */
/***********************************************************/
vdisf_interior(handle, style)
cnat handle, style;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d}d", style);
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    gemgraf_mouse                        */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  nb                                       */
/*                                                         */
/***********************************************************/
gemgraf_mouse(nb, ty)
cnat nb, *ty;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d}e", nb);
	emet_fct(FCT_NOR, str_emet);
}


gemgraf_handle(i, j, k, l)
cnat *i, *j, *k, *l;
{
	return(1);
}


/***********************************************************/
/*                                                         */
/*                    gemGetrez                            */
/*                                                         */
/* Fonction non envoyee au PC                              */
/*                                                         */
/***********************************************************/
gemGetrez()
{
	return(NORES);
}


/***********************************************************/
/*                                                         */
/*                    gemappl_exit                         */
/*                                                         */
/* Envoi de parametre : NEANT                              */
/*                                                         */
/***********************************************************/
gemappl_exit()
{
	char	str_emet[TAILLE_MES];

	strcpy(str_emet, "f");
	emet_fct(FCT_NOR, str_emet);
#ifdef DEBUG_G
fclose (fdbg);
#endif
}


vdi_clswk(handle)
cnat handle;
{
}


vdist_point()
{
}


/***********************************************************/
/*                                                         */
/*                    vdist_color                          */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  cl                                       */
/*                                                         */
/***********************************************************/
vdist_color(handle, cl)
int	handle, cl;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d}g", cl);
	emet_fct(FCT_NOR, str_emet);
}


vdisin_mode()
{
}


/***********************************************************/
/*                                                         */
/*                    vdi_gtext                            */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  x                                        */
/*            2)  str                                      */
/*            3)  y                                        */
/*                                                         */
/***********************************************************/
vdi_gtext(handle, x, y, str)
int	handle, x, y;
char	*str;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d,'%s',%d}h", x, str, y); /* la chaine de caratere est passee entre deux virgule pour eviter les ambiguitees */
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdi_rfbox                            */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  pxy[0]                                   */
/*            2)  pxy[1]                                   */
/*            3)  pxy[2]                                   */
/*            4)  pxy[3]                                   */
/*                                                         */
/***********************************************************/
vdi_rfbox(handle, pxy)
int	handle, *pxy;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d,%d,%d,%d}i", pxy[0], pxy[1], pxy[2], pxy[3]);
	emet_fct(FCT_NOR, str_emet);
}


vdirq_string()
{
}


gemgraf_rubbox()
{
}


gemCursconf(i, j)
cnat i, j;
{
}


/***********************************************************/
/*                                                         */
/*                    vdi_clrwk                            */
/*                                                         */
/* Envoi de parametre : NEANT                              */
/*                                                         */
/***********************************************************/
vdi_clrwk(handle)
int	handle;
{
	char	str_emet[TAILLE_MES];

	strcpy(str_emet, "j");
	emet_fct(FCT_NOR, str_emet);
}


vdi_opnwk(wi, handle, wo)
cnat *wi, *handle, *wo;
{
}


vdisf_perimeter()
{
}


/***********************************************************/
/*                                                         */
/*                    vdisl_color                          */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  in                                       */
/*                                                         */
/***********************************************************/
vdisl_color(handle, in)
int	handle, in;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d}k", in);
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdi_pline                            */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  count                                    */
/*            2)  pxy[0]                                   */
/*            3)  pxy[1]                                   */
/*            4)  pxy[2]                                   */
/*            5)  pxy[3]                                   */
/*            6)  ...  (suivant la valeur de count)        */
/*                                                         */
/***********************************************************/
vdi_pline(handle, count, pxy)
int	handle, count, *pxy;
{
	char	str_emet[TAILLE_MES];
	cnat i;

	sprintf(str_emet, "{%d,%d,%d", count, pxy[0], pxy[1]);
	for (i = 1; i < count; i++)
		sprintf(str_emet, "%s,%d,%d", str_emet, pxy[2*i], pxy[2*i+1]);
	strcat(str_emet, "}l");
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdi_coul                             */
/*                                                         */
/* Envoi de parametre : NEANT                              */
/*                                                         */
/***********************************************************/
vdi_coul(handle)
cnat handle;
{
	char	str_emet[TAILLE_MES];

	strcpy(str_emet, "m");
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdi_show_c                           */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  x                                        */
/*            2)  y                                        */
/*                                                         */
/***********************************************************/
vdi_show_c(handle, x, y)
cnat handle, x, y;
{
	char	str_emet[TAILLE_MES];

	sprintf(str_emet, "{%d,%d}n", x, y);
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    show_souris                          */
/*                                                         */
/* Envoi de parametre :  NEANT                             */
/*                                                         */
/***********************************************************/
show_souris()
{
	char	str_emet[TAILLE_MES];

	strcpy(str_emet, "o");
	emet_fct(FCT_NOR, str_emet);
}


/***********************************************************/
/*                                                         */
/*                    vdi_hide_c                           */
/*                                                         */
/* Envoi de parametre :  NEANT                             */
/*                                                         */
/***********************************************************/
vdi_hide_c(handle)
cnat handle;
{
	char	str_emet[TAILLE_MES];

	strcpy(str_emet, "p");
	emet_fct(FCT_NOR, str_emet);
}

/***********************************************************/
/*                                                         */
/*                    grille                               */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  graph.xo                                 */
/*            2)  graph.yo                                 */
/*            3)  graph.dx                                 */
/*            4)  graph.dy                                 */
/*            5)  graph.res                                */
/*            6)  y0ecran                                  */
/*                                                         */
/***********************************************************/
grille()
{
	char str_emet[TAILLE_MES];

	sprintf(str_emet,"{%d,%d,%d,%d,%d,%d}q",graph.xo,graph.yo,graph.dx,graph.dy,graph.res,y0ecran);
	emet_fct(FCT_NOR, str_emet);
}

/***********************************************************/
/*                                                         */
/*                    vdi_dxinfo                           */
/*                                                         */
/* Envoi de parametre :                                    */
/*            1)  x                                        */
/*            2)  fichier                                  */
/*            3)  y                                        */
/*            4)  nbd                                      */
/*            5)  dx                                       */
/*            6)  nomfct                                   */
/*            7)  indic                                    */
/*            8)  dy                                       */
/*                                                         */
/***********************************************************/
vdi_dxinfo(fichier,x,y,nbd,dx,dy,nomfct,indic,cl)
char * fichier;
cnat x,y,nbd,dx,dy;
char * nomfct, * indic;
{
	char str_emet[TAILLE_MES];

	sprintf(str_emet,"{%d,'%s',%d,%d,%d,'%s','%s',%d,%d}r",x,fichier,y,nbd,dx,nomfct,indic,dy,cl);
	emet_fct(FCT_NOR, str_emet);
}

vdist_alignment(handle, mode1, mode2, t, y)
cnat handle, mode1, mode2, *t, *y;
{
}


/***********************************************************/
/*                                                         */
/*                    vdi_term                             */
/*                                                         */
/* Fonction non envoyee au PC                              */
/*                                                         */
/***********************************************************/
vdi_term()
{
	fin();
	sys_fin();
}


/***********************************************************/
/*                                                         */
/*                    vdi_grap                             */
/*                                                         */
/* Fonction non envoyee au PC                              */
/*                                                         */
/***********************************************************/
vdi_grap()
{
	init();
	daffiche(LNDES(fbuf1), 0);
	informe();
}


/******************************************************************************/
/*                                g_souris                                    */
/* but : attend qu'un bouton de la souris soit presse, analyse le deplacement */
/* parametre :                                                                */
/*   flag : g_souris stocke dans ce parametre la zone de l'ecran cliquee      */
/*   stat : si != 0 indique la deuxieme saisie pour une fonction (permet de   */
/*          remettre a jour les dx et dy de la zone info du bas)              */
/******************************************************************************/
/*  Envoi de parametre a la fonction vdi_gsouris sur le PC :                  */
/*			1)  xmire                                                         */
/*			2)  ymire                                                         */
/*			3)  gsourisdx                                                     */
/*			4)  gsourisdy                                                     */
/*			5)  xfen                                                          */
/*			6)  yfen                                                          */
/*			7)  graph.res                                                     */
/*			8)  zoom                                                          */
/*			9)  fichier                                                       */
/*			10) nb de descripteur dans la BD                                  */
/*			11) nom fct                                                       */
/*			12) indic                                                         */
/*			13) couleur                                                       */
/******************************************************************************/
/*  retour de parametre de la fonction vdi_gsouris sur le PC :                */
/*			1)  x                                                             */
/*			2)  y                                                             */
/*			3)  term                                                          */
/******************************************************************************/
g_souris(flag,stat,indic)
cnat *flag,stat;
char * indic;
{
	cnat x1,x2,y1,y2,term;
	uchar flg;
	char str_emet[TAILLE_MES];
	char	*str_ret, *ptemp, *paux;

	gemgraf_mouse(CGRAF,&term);
	term=0;
	*flag=0;
	c_rel(xmire,ymire,&x1,&y1);
	x2=x1;y2=y1;
	if (stat)
		{
			gsourisdx=xmire;
			gsourisdy=ymire;
		}
	vdi_show_c(graph.handle,x1>>1,y1>>1);
	if (acc_souris)
		{
		sprintf(str_emet,"{%d,%d,%d,%d,%d,%d,%d,%d,'%s',%d,'%s','%s',%d}F",xmire,ymire,gsourisdx,gsourisdy,xfen,yfen,graph.res,zoom,fichier,LNDES(fbuf1),(dfonc!= -1)?((menus+dmenu)->options[dfonc])+1:"",indic,config->teinte[INFO]);
		str_ret = emet_fct(FCT_RET, str_emet);
		paux = strchr(str_ret, ',');
		*paux = '\0';
		x2 = atoi(str_ret);
		ptemp = paux + 1;
		paux = strchr(ptemp, ',');
		*paux = '\0';
		y2 = atoi(ptemp);
		ptemp = paux + 1;
		paux = strchr(ptemp, '}');
		*paux = '\0';
		term = atoi(ptemp);
		x2 <<= 1;
		y2 <<= 1;
		ch=(char)term;
		if (!zoom)
			{
				x2 = (lnat)((x2 + (graph.res>>1)) / graph.res) * graph.res;
				y2 = y0ecran - ((lnat)((y0ecran - y2 + (graph.res>>1)) / graph.res) * graph.res);
			}
		xmire=(lnat)(((x2-graph.xo)<<zoom)/(graph.res>>1))+xfen;
		if (xmire<0l)
		xmire=xfen;
		if (y2<=graph.dy)
			ymire=(lnat)(((graph.yo-y2)<<zoom)/(graph.res>>1))+yfen;
		else
			ymire=yfen;
		if (ymire<0l)
			ymire=yfen;
		if ((ch=='1')||(ch=='2')||(ch=='3'))
			{
				ch = (ch == '1')?'2':(ch == '2')?'1':'3';
				if (ch=='2') 
					if (y2>graph.yo)
						{
							ch='3';
							return(0);
						}
				if (y2<=graph.yo-graph.dy+16)
					*flag=6;
				else
					if (x2<=graph.xo)
						*flag=4;
					else
						if (x2>=graph.xo+graph.dx)
							*flag=5;
						else
							if (y2>=graph.yo)
								*flag=7; 
							else
								*flag=0;
			} /* if */
		}
	else
		{
		while(1)
			{
			flg=0;
			clavier1(x1,y1,&x2,&y2,&term);
			ch=(char)term;
			if ((x1!=x2)||(y1!=y2))
				flg=1;
			x1=x2;y1=y2;
			if ((ch==0x20)||(ch==0x21)||(ch==0x22))
				{
					ch+=0x11;
					ch = (ch == '1')?'2':(ch == '2')?'1':'3';
					if (ch=='2') 
						if (y2>graph.yo)
							{
								ch='3';
								return(0);
							}
					if (y2<=graph.yo-graph.dy+16)
						*flag=6;
					else
						if (x2<=graph.xo)
							*flag=4;
						else
							if (x2>=graph.xo+graph.dx)
								*flag=5;
							else
								if (y2>=graph.yo)
									*flag=7; 
								else
									*flag=0;
				} /* if */
			if (flg)
				{
					if (!zoom)
						{
							x2 = (lnat)((x2 + (graph.res>>1)) / graph.res) * graph.res;
							y2 = y0ecran - ((lnat)((y0ecran - y2 + (graph.res>>1)) / graph.res) * graph.res);
						}
					xmire=(lnat)(((x2-graph.xo)<<zoom)/(graph.res>>1))+xfen;
					if (xmire<0l)
						xmire=xfen;
					if (y2<=graph.dy)
						ymire=(lnat)(((graph.yo-y2)<<zoom)/(graph.res>>1))+yfen;
					else
						ymire=yfen;
					if (ymire<0l)
						ymire=yfen;
					if (!(acc_souris))
						vdi_show_c(graph.handle,x1>>1,y1>>1);
					dxinfo(xmire-gsourisdx,ymire-gsourisdy,indic);
					show_souris();
				} /* if */
			if (ch>=0x31)
				{
					vdi_hide_c(graph.handle);
					break;
				}
		} /* while */
	}
	return(0);
} /* g_souris */

