
#include <usercore.h>   /*le fichier suncore obligatoire*/
/*****************************************************************************/
/*                   Declarations des variables et Definitions               */
/*****************************************************************************/
#define SOLID 1 /*redefinition du type SOLID, car il existe sous suncore*/
#define NORES 4

int cg2dd();
struct vwsurf surface;/*la surface de visualisation*/

static  short ptrg_bits[]={
        0x4000,0x6000,0x7000,0x7800,
	0x7c00,0x7e00,0x7f00,0x7f80,
	0x7f00,0x7c00,0x4c00,0x0600,
	0x0600,0x0300,0x0300,0x0000};
			 

static  short croix_bits[]={
        0x0000,0x0180,0x0180,0x0180,
        0x0180,0x0180,0x0180,0x7FFE,
        0x7FFE,0x0180,0x0180,0x0180,
        0x0180,0x0180,0x0180,0x0000};

static  short main_bits[]={
				0x0040,
				0x00B0,
				0x01A8,
				0x02A8,
				0x02AC,
				0x02AA,
				0x52AA,
				0x4AAA,
				0x4AAA,
				0x260A,
				0x2402,
				0x1002,
				0x1004,
				0x0C08,
				0x07F8,
                                0x03D0};
				

static  short sablier_bits[]={
       	0x7FFE,0x4002,0x200C,0x1A38,
        0x0FF0,0x07E0,0x03C0,0x0180,
	0x0180,0x0240,0x0520,0x0810,
        0x1108,0x23C4,0x47E2,0x7FFE};
 
struct  suncore_raster cursor;/*le curseur*/
struct  suncore_raster stockeur;
static  float blue_array[16],red_array[16],green_array[16];
/*static  char   data[13];*/
static  cnat   vdigsl[16],wi,he,nb=0,indic=0,deltaX_croix,deltaY_croix,
               couleur_courante;

#define VPERI  vdigsl[0]
#define VPLEIN vdigsl[1]
#define VFCOL  vdigsl[2]
#define VWI    vdigsl[3]
#define VHE    vdigsl[4]
#define VXO    vdigsl[5]
#define VYO    vdigsl[6]
#define XC     vdigsl[7]
#define YC     vdigsl[8]
#define CURS   vdigsl[9]


/***************************************************************************/
/*                  Fonctions d'initialisation  de la surface              */
/***************************************************************************/
init_surface(surf,ddname)/*reinitialise a la surface par defaut*/
    struct vwsurf *surf; /*cela sert quand on revient de VI,CAT etc...*/
    int (*ddname)();
{
 sprintf(surf->screenname,"%s","");
 sprintf(surf->windowname,"%s","");
 surf->windowfd=0;
 surf->dd=ddname;
 surf->instance=0;
 surf->cmapsize=0;
 sprintf(surf->cmapname,"%s","");
 surf->flags=0;
 surf->ptr=0;
}/*fin init_surface*/

/*--------------------------------------------------------------------------*/ 
gemappl_init()
{
 struct vwsurf surface1 ;

 init_surface(&surface1,cg2dd);   /*(re)initialisation de la surface de visu*/ 
 surface=surface1;        /*on met la surface (globale) a la nouvelle valeur*/
 indic=0;             /*reinitialisation de l'indicateur de segment RETAINED*/

 HTEXT=32;         /*declarations necessaires a ALLIANCE*/
 LTEXT=18;

 RESOLX(NORES)=1004;/*noter qu'on a 16 pixels de moins aussi bien en hauteur*/
 RESOLY(NORES)=748;/*qu'en largeur, sinon le curseur sort de l'ecran=>erreur*/

 initialize_core(DYNAMICA,SYNCHRONOUS,TWOD);
 initialize_view_surface(&surface,FALSE);

 initialize_device(LOCATOR,1); /*definitions des outils ES necessaires*/
 initialize_device(KEYBOARD,1);
 initialize_device(BUTTON,1);
 initialize_device(BUTTON,2);
 initialize_device(BUTTON,3);
 set_echo(KEYBOARD,1,1);/*les caracteres lus doivent etre repercutes a l'ecran*/
 set_echo(LOCATOR,1,0);  
 set_echo_surface(LOCATOR,1,&surface);     /*repercuter l'echo sur la surface*/ 
 set_echo_surface(KEYBOARD,1,&surface);
 select_view_surface(&surface);
 set_viewport_2(0.0,1.0,0.0,0.75);/*definition des coordonnees NDC*/
 set_window(0.0,1023.0,0.0,767.0);/*definition des coordonnees en Pixels*/
}/*fin gemappl_init*/

/***************************************************************************/
/*                  Fonction de sortie (du systeme graphique)              */
/***************************************************************************/
gemappl_exit()
{
 terminate_device(LOCATOR,1);
 terminate_device(KEYBOARD,1);
 terminate_device(BUTTON,1);
 terminate_device(BUTTON,2);
 terminate_device(BUTTON,3);
 deselect_view_surface(&surface);
 terminate_core();
}/*fin gemappl_exit*/

/***************************************************************************/
/*                  Fonction d'initialisation de la table des couleurs     */
/***************************************************************************/
vdi_coul()
{

 blue_array[BLANC]= 1.0;  green_array[BLANC]= 1.0;  red_array[BLANC]= 1.0;
 blue_array[NOIR]=  0.0;  green_array[NOIR]=  0.0;  red_array[NOIR]=  0.0;
 blue_array[JAUNE]= 0.0;  green_array[JAUNE]= 1.0;  red_array[JAUNE]= 1.0;
 blue_array[ROUGE]= 0.0;  green_array[ROUGE]= 0.0;  red_array[ROUGE]= 0.75;
 blue_array[CROUGE]=0.0;  green_array[CROUGE]=0.0;  red_array[CROUGE]=1.0;
 blue_array[BLEU]=  0.75; green_array[BLEU]=  0.0;  red_array[BLEU]=  0.0;
 blue_array[CBLEU]= 1.0;  green_array[CBLEU]= 0.0;  red_array[CBLEU]= 0.0;
 blue_array[VERT]=  0.0;  green_array[VERT]=  0.75; red_array[VERT]=  0.0;
 blue_array[CVERT]= 0.0;  green_array[CVERT]= 1.0;  red_array[CVERT]= 0.0;
 blue_array[GRIS]=  0.5;  green_array[GRIS]=  0.5;  red_array[GRIS]=  0.5;
 blue_array[MAGEN]= 0.5;  green_array[MAGEN]= 0.0;  red_array[MAGEN]= 0.5;
 blue_array[ROSE]=  1.0;  green_array[ROSE]=  0.25; red_array[ROSE]=  1.0;
 blue_array[CYAN]=  1.0;  green_array[CYAN]=  1.0;  red_array[CYAN]=  0.0;
 blue_array[FCYAN]= 1.0;  green_array[FCYAN]= 0.25; red_array[FCYAN]= 0.0;
 blue_array[ORANGE]=0.0;  green_array[ORANGE]=0.5;  red_array[ORANGE]=1.0;
 blue_array[BRUN]=  0.0;  green_array[BRUN]=  0.25; red_array[BRUN]=  1.0;
 
 define_color_indices(&surface,0,15,red_array,green_array,blue_array);
}/*fin vdi_coul*/

/***************************************************************************/
/*     Fonction d'initialisation  de la couleur du rectangle a tracer      */
/***************************************************************************/
vdisf_color(handle,cl) /*couleur du rectangle a tracer*/
    cnat handle,cl;
{
 couleur_courante=cl; 
 set_line_index(cl);/*si c'est du polyline*/
 set_fill_index(cl);/*cl est compris entre 0 et 255 (0 et 15 pour nous)*/
}/*fin vdisf_color*/

/***************************************************************************/
/*  Fonction d'initialisation de la couleur de la ligne a tracer           */
/***************************************************************************/
vdisl_color(handle,cl) /*couleur de la ligne a tracer*/
     cnat handle,cl;
{
 couleur_courante=cl; 
 set_line_index(cl);   /*cl est compris entre 0 et 255 (0 et 15 pour nous) */
}/*fin vdis_color*/

/***************************************************************************/
/*     Fonction d'initialisation  du style de l'interieur du rectangle     */
/***************************************************************************/
vdisf_interior(handle,style) /*style de l'interieur des polygones*/
      cnat	 handle,style;
{
 /*un seul style disponible pour suncore PLAIN*/
 if (style==HOLLOW) VPLEIN=0;        /*HOLLOW n'est pas un style de suncore*/
 else { VPLEIN=1;
      set_polygon_interior_style(PLAIN);
      }
}/*fin vdisf_interior*/

/***************************************************************************/
/*              Fonction de tracer de rectangle plein ou creux             */
/***************************************************************************/
vdi_bar(handle,pxy)   /*trace le rectangle plein ou creux*/
    cnat handle,*pxy; /* pxy contient les 2 points de references */
                      /*pxy[0]=x0,pxy[1]=y0,pxy[2]=x1,pxy[3]=y1*/
{
 cnat y1,y2;                 /*NB pxy[i] en pixels*/
 float x_array[5],y_array[5];/* 5 car polyline demarre a la position courante*/

 y1=RESOLY(NORES)-1-pxy[1];  /*conversion des coordonnees verticales*/
 y2=RESOLY(NORES)-1-pxy[3];  /*pour avoir le coin haut gauche en reference*/

 x_array[0]=x_array[3]=(float)pxy[0];
 y_array[0]=y_array[1]=(float)y1; /*garder y1 et y2, on peut repasser ici*/
 x_array[1]=x_array[2]=(float)pxy[2];
 y_array[2]=y_array[3]=(float)y2;

 create_temporary_segment();  /*zone ou on dessine, n'est pas accessible apres*/
                              /*fermeture, ne peut pas etre rafraichie*/ 
 if (VPLEIN==1) polygon_abs_2(x_array,y_array,4);/*trace du rectangle plein*/
    else
       {
        x_array[1]--;
        x_array[2]--;
        y_array[0]++;
        y_array[1]++;
        move_abs_2(x_array[0],y_array[0]);
        x_array[4]=x_array[0];
        y_array[4]=y_array[0];/*le point supplementaire*/ 
        polyline_abs_2(x_array+1,y_array+1,4);/*trace du rectangle vide*/
       }

 close_temporary_segment();
}/*fin vdi_bar*/

/***************************************************************************/ 
/*   Fonction de tracage d'une fenetre et de son cadre                     */
/***************************************************************************/
vdi_rfbox(handle,pxy) /*dessine une fenetre,puis son cadre*/
    cnat handle,*pxy; /*qv vdi_bar pour la signification des formats*/
{
 cnat tempete;

 tempete=VPLEIN;

 vdisf_color(0,NOIR);/*le fond en noir*/
 vdisf_interior(0,PLAIN);/*en plein*/
 VPLEIN=1;
 vdi_bar(0,pxy);
 
 vdisf_color(0,BLANC);
 vdisf_interior(0,HOLLOW); 
 VPLEIN=0;/*vide car le cadre seulement est voulu*/
 set_linewidth(0.0);
 vdi_bar(0,pxy);
  
 VPLEIN=tempete;
}/*fin vdi_rfbox*/

/***************************************************************************/
/*                Fonction pour tracer  plusieurs lignes                   */
/***************************************************************************/
vdi_pline(handle,count,pxy)
    cnat handle,count,*pxy;/*qv vdi_bar pour la signification des formats*/
{
 cnat x[16],y[16],i;
 float x_array[16],y_array[16];

 if (count>16) return(1);/*pas de trace de plus de 16 lignes*/
 for (i=0;i<count;i++)
     {
      x[i]=pxy[2*i];
      y[i]=RESOLY(NORES)-1-pxy[2*i+1];
      x_array[i]=(float)x[i];
      y_array[i]=(float)y[i];
     }
 create_temporary_segment();
 move_abs_2(x_array[0],y_array[0]);/*positionnement obligatoire*/
 polyline_abs_2(x_array+1,y_array+1,count-1);
 close_temporary_segment();
 return(0);
}/*fin de vdi_pline*/

/***************************************************************************/
/*      Fonction d'initialisation du style de la ligne a tracer            */
/***************************************************************************/
vdisf_style(device,style) /*style d'une ligne*/
      cnat device,style;
{return(0);
}/*fin vdisf_style*/

/***************************************************************************/
/*                  Fonction d'initialisation du mode de tracer            */
/***************************************************************************/
vdiswr_mode(device,mode) /*operations pour dessiner ou ecrire*/
       cnat device,mode;
{
 /*trois modes possibles XORROP,ORROP et NORMAL
 set_rasterop(NORMAL);*/
}/*fin vdiswr_modes*/

/***************************************************************************/
/*              Fonction de tracer de texte en x,y donnes en pixels        */
/***************************************************************************/
vdi_gtext(handle,x,y,str) /*ecrit la chaine str en x,y donnes en pixels*/
    cnat handle,x,y;
    char *str;
{
 float x1,y1;
 char stringue[80];
 cnat i;

 for(i=0;i<strlen(str);i++)
     stringue[i]=0x7F;
stringue[strlen(str)]='\0';
 
 x1=(float)x;
 y1=(float)(RESOLY(NORES)-y+(HTEXT/2)+3);
 move_abs_2(x1,y1);/*on place le curseur*/
 
 create_temporary_segment();                             
 set_text_index(NOIR);
 set_rasterop(NORMAL);
 text(stringue);
 set_text_index(couleur_courante);
 set_rasterop(NORMAL);
 text(str);
 close_temporary_segment();
}/*fin vdi_gtext*/

/***************************************************************************/
/*       Fonction d'initialisation de la couleur du texte a tracer         */
/***************************************************************************/
vdist_color(handle,cl) /*selectionne la couleur cl pour le texte*/
      cnat handle,cl;
{
 float width,heigh;

 couleur_courante=cl; 
 width=(float)LTEXT;
 heigh=(float)HTEXT;
 set_font(SYMBOLS);
 set_charsize(width,heigh);
 set_text_index(cl);
}/*fin vdist_color*/

/***************************************************************************/
/*      Fonction d'initialisation  des curseurs                            */
/***************************************************************************/
gemgraf_mouse(nbi,txy) /*initialise le curseur,nbi=numero curseur */
        cnat nbi,*txy; /*nbi=choix du type de curseur,txy ne sert ici a rien*/
{
 wi=VWI=16;
 he=VHE=16;
 cursor.width=wi;
 cursor.height=he;
 cursor.depth=1;
 allocate_raster(&cursor);
 deltaX_croix=deltaY_croix=0;

 switch (nbi)
        {
         case CMENU:
                    cursor.bits=ptrg_bits;
                    break;

         case CGRAF:
                    cursor.bits=croix_bits; 
                    deltaX_croix=4;
                    deltaY_croix=8;
                    break;
        
         case CTEMP:
                    cursor.bits=sablier_bits; 
                    break;

         case  CKEYB:
                     cursor.bits=main_bits;
                     break;
         }/*fin switch*/
CURS=nbi;
}/*fin gemgraf_mouse*/

/***************************************************************************/  
/*    Fonction d'acquisition des coordonnees de la souris et des boutons   */
/***************************************************************************/
vdism_locator(handle,x,y,xar,yar,term)
      cnat handle,x,y,*xar,*yar,*term;
{

 float xf,yf,xt,yt,xa,ya;
 lnat termf= 0,termdeb,length,xdeb,ydeb;
 
 (*xar)=x;
 (*yar)=y;

y=RESOLY(NORES)-y-1;/*conversion des coordonnees verticales*/
xdeb=x;             /*initialisation pour la boucle while*/
ydeb=y;             /*idem*/
termdeb=termf;      /*idem*/
await_any_button_get_locator_2(0,1,&termf,&xt,&yt);
map_ndc_to_world_2(xt,yt,&xf,&yf);/*de NDC en pixels*/
/*(*xar)=x+(cnat)xf-XC;
(*yar)=y+(cnat)yf-YC;
XC=(cnat)xf;
YC=(cnat)yf;*/
(*xar)=(cnat)xf;
(*yar)=(cnat)yf;
if ((*xar)<0) (*xar)=0;
if ((*yar)<0) (*yar)=0;
if ((*xar)>=RESOLX(NORES)) (*xar)=RESOLX(NORES)-1;
if ((*yar)>=RESOLY(NORES)) (*yar)=RESOLY(NORES)-1;
(*yar)=RESOLY(NORES)-(*yar)-1;
switch(termf)
	{
	case 1: *term= 32;break;
	case 2: *term= 34;break;
	case 3: *term= 33;break;
	}
}/*fin vdism_locator*/

/***************************************************************************/  
/*    Fonction bouclant tant qu'aucun bouton de la souris n'est clique     */
/***************************************************************************/
vdirq_locator(handle,x,y,xar,yar,term)
      cnat handle,x,y,*xar,*yar,*term;
{
 cnat xt=x,yt=y; /*variables auxilliaires*/

 /*float xf,yf;
 lnat ybis;
*/
 
 (*xar)=x;
 (*yar)=y;
 (*term)=31;

 while ((*term)==31)
       {
	vdi_show_c(handle,*xar,*yar);
        vdism_locator(handle,xt,yt,xar,yar,term);/*xar,yar sont des adresses*/
        xt= *xar;
        yt= *yar;
       }
(*yar)+=HTEXT;
vdi_hide_c(handle);
}/*fin vdirq_locator*/

/***************************************************************************/
/*                  Fonction captant un caractere au clavier               */
/***************************************************************************/
 char gemCrawcin()
{
 static char c[80];/*on definit un tableau de 2 dont seul le 1er importe*/
 cnat length=1;

 while (length!=0)
   await_keyboard(0,1,c,&length); /*0 microsecondes pour l'instant*/
length=0;
 
 while (length==0)
   await_keyboard(0,1,c,&length); /*0 microsecondes pour l'instant*/
 if (c[0]==0x0d) return('\n');
 if (c[0]>0x7f) return(0x20);else return(c[0]);
}/*fin gemCrawcin*/

/****************************************************************************/
vdi_show_c(handle,x,y) /*fonction faisant apparaitre le curseur*/
 cnat handle,x,y;
{
 float xt,yt,xf,yf;
 cnat term;

 if (!indic) vdi_hide_c(handle);
 if ((CURS==CMENU)||(CURS==CGRAF))
 {
 set_echo(LOCATOR,1,1);
 return(0);
 }
 set_echo(LOCATOR,1,0);
 delete_retained_segment(2);
 y=RESOLY(NORES)-1-y;
 if ((x-deltaX_croix)<=0)x=deltaX_croix;
 if ((y-deltaY_croix)<=0)y=deltaY_croix;
 move_abs_2((float)(x-deltaX_croix),(float)(y-deltaY_croix));
    /*positionnement dans la surface,delta _croix var.glob*/

 create_retained_segment(2);
 set_fill_index(BLANC); 
 set_rasterop(XORROP);
 put_raster(&cursor);
 close_retained_segment(2);
 set_segment_visibility(2,TRUE);
 indic=0;
 set_rasterop(NORMAL);
}/*fin vdi_show_c*/

/****************************************************************************/
vdi_hide_c()  /*fonction faisant disparaitre le curseur*/
{
 set_echo(LOCATOR,1,0);
 if (indic)
            {
	return(0);
            }
 delete_retained_segment(2);
 create_retained_segment(2);
 set_fill_index(BLANC); 
 set_rasterop(XORROP);
 put_raster(&cursor);
 close_retained_segment(2);
 set_segment_visibility(2,FALSE);
 set_rasterop(NORMAL);
 indic=1;  /*il n'y a plus de segment a effacer mais il existe en memoire*/
}/*fin vdi_hide_c*/

/****************************************************************************/
vdi_clrwk(handle)  /*fonction d'effacement d'ecran*/
    int handle;
{
 cnat pxy[4],temp;

 temp=VPLEIN;
 pxy[0]=0;/*qv vdi_bar pour la signification des formats*/
 pxy[1]=0;
 pxy[2]=RESOLX(NORES)-1;
 pxy[3]=RESOLY(NORES)-1;/*les coordonnees de la fenetre graphique*/
 vdisf_interior(handle,PLAIN);/*le style plein de suncore*/
 vdisf_color(handle,NOIR);/*le NOIR pour effacer*/
 VPLEIN=1;/*on specifie un tracer plein pour vdi_bar*/
 vdi_bar(handle,pxy);
 VPLEIN=temp;
}/*fin vdi_clrwk*/

/****************************************************************************/
vdi_grap()
{
 lnat nbd;

 init();
 nbd = LNDES(fbuf1);
 daffiche(nbd,0);
}/*fin vdi_grap*/

/****************************************************************************/
vdi_term()
{
 fin();
 sys_fin(); 
}/*fin vdi_term*/

vdi_get_pixel()
	{
	}

/****************************************************************************/
/*                  Fonctions autres                                        */
/****************************************************************************/
vdi_clswk()
{
}
/*--------------------------------------------------------------------------*/

vdist_point()
{
}
/*--------------------------------------------------------------------------*/

vdisin_mode()
{
}
/*--------------------------------------------------------------------------*/

vdirq_string()
{
}
/*--------------------------------------------------------------------------*/

vdi_opnwk()
{
}
/*--------------------------------------------------------------------------*/

vdisf_perimeter()
{
}
/*--------------------------------------------------------------------------*/

vdist_alignment()
{
}
/*--------------------------------------------------------------------------*/

vdi_show()
{
}
/*--------------------------------------------------------------------------*/

vdi_hide()
{
}
/*--------------------------------------------------------------------------*/

gemgraf_handle()
{
return(1);
}
/*--------------------------------------------------------------------------*/

gemCursconf()
{
}
/*--------------------------------------------------------------------------*/

gemgraf_rubbox()
{
}
/*--------------------------------------------------------------------------*/

vdis_color()
{
}
/*--------------------------------------------------------------------------*/

gemGetrez()
{
return(NORES);
}
/*****************************************************************************/ 
