;	Static Name Aliases
;
	TITLE   RS232.ASM
	NAME    RS232

	.286p
R_TEXT	SEGMENT  WORD PUBLIC 'CODE'
R_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME  CS: R_TEXT, DS: DGROUP, SS: DGROUP
EXTRN	__acrtused:ABS
EXTRN	__bios_serialcom:FAR
EXTRN	_inp:FAR
EXTRN	_outp:FAR
EXTRN	__dos_getvect:FAR
EXTRN	__dos_setvect:FAR

_DATA      SEGMENT
_RS232_OldVect		DD	00H
_RS232_FinBufRecv	DW	00H
_RS232_DebBufRecv	DW	00H
_RS232_BufRecv		DB	4097 DUP(0)
_DATA      ENDS

R_TEXT      SEGMENT
	ASSUME	CS: R_TEXT


;**************************************************************************
_RS232_NewInterrupt	PROC FAR
	pusha	
	push	ds
	push	es
	mov	bp,sp
	mov	ax,DGROUP
	mov	ds,ax
	ASSUME DS: DGROUP
	cld	
; met DTR a OFF
	mov	dx,1020
	mov	al,8
	out	dx,al
; lit l'etat du modem
	mov	dx,1022
	in	al,dx
; lit l'etat de la ligne
	mov	dx,1021
	in	al,dx
; pourquoi a-t-on ete appele ?
	test	al,1
	je	$I282
; Stockage du caractere recu
	mov	dx,1016
	in	al,dx
	mov	bx,_RS232_FinBufRecv
	sub	cx,cx
	mov	BYTE PTR _RS232_BufRecv[bx],al
	inc	WORD PTR _RS232_FinBufRecv
	and	BYTE PTR _RS232_FinBufRecv+1,15
$I282:
; buffer plein ?
	mov	ax,_RS232_FinBufRecv
	add	ax,50
	and	ah,15
	cmp	ax,_RS232_DebBufRecv
	jne	$I283
; arret du 8259
	mov	dx,33
	in	al,dx
	or	al,16
	out	dx,al
	jmp	SHORT $I284
$I283:
; sinon met DTR a ON
	mov	dx,1020
	mov	al,15
	out	dx,al
; lit l'etat du modem
	mov	dx,1022
	in	al,dx
$I284:
; envoie EOI au 8259
	mov	dx,32
	mov	al,100
	out	dx,al
; fin d'IT
	pop	es
	pop	ds
	ASSUME DS: DGROUP
	popa	
	iret	
_RS232_NewInterrupt	ENDP


;**************************************************************************
	PUBLIC	_RS232_InstallIntr
_RS232_InstallIntr	PROC FAR
	enter	WORD PTR 2,0
	push	0
	push	250
	push	0
	call	FAR PTR __bios_serialcom
	add	sp,6
	cli
	mov	WORD PTR _RS232_DebBufRecv,0
	mov	WORD PTR _RS232_FinBufRecv,0
; on change le diviseur pour atteindre 19200 non accessible par BIOS
; met DLAB a 1
	mov	dx,1019
	in	al,dx
	or	al,128
	out	dx,al
; charge diviseur (12=9600, 6=19200, 3=38400...)
	mov	dx,1016
	mov	al,6
	out	dx,al
	mov	dx,1017
	mov	al,0
	out	dx,al
; met DLAB a 0
	mov	dx,1019
	in	al,dx
	and	al,127
	out	dx,al
; sauvegarde de l'ancien vecteur
	push	12
	call	FAR PTR __dos_getvect
	add	sp,2
	mov	WORD PTR _RS232_OldVect,ax
	mov	WORD PTR _RS232_OldVect+2,dx
; mise en place de notre vecteur
	push	SEG _RS232_NewInterrupt
	push	OFFSET _RS232_NewInterrupt
	push	12
	call	FAR PTR __dos_setvect
	add	sp,6
; mise en service du 8259
	mov	dx,33
	in	al,dx
	and	al,239
	out	dx,al
; met DLAB a 0
	mov	dx,1019
	in	al,dx
	and	al,127
	out	dx,al
; flush buffer
	mov	dx,1016
	in	al,dx
; met le 8250 en marche
	mov	dx,1017
	mov	al,1
	out	dx,al
; retour a la normale
	sti
	leave	
	ret	
	nop	
_RS232_InstallIntr	ENDP


;**************************************************************************
	PUBLIC	_RS232_DesinstIntr
_RS232_DesinstIntr	PROC FAR
	enter	WORD PTR 2,0
	cli
; met DTR a ON
	mov	dx,1020
	mov	al,15
	out	dx,al
; lit l'etat du modem
	mov	dx,1022
	in	al,dx
; met DTR a OFF
	mov	dx,1020
	mov	al,8
	out	dx,al
; lit l'etat du modem
	mov	dx,1022
	in	al,dx
; envoie EOI au 8259
	mov	dx,32
	mov	al,100
	out	dx,al
; lit l'etat de la ligne
	mov	dx,1021
	in	al,dx
; arret du 8259
	mov	dx,33
	in	al,dx
	or	al,16
	out	dx,al
; arret du 8250
	mov	dx,1017
	mov	al,0
	out	dx,al
; restaure l'ancien vecteur
	push	WORD PTR _RS232_OldVect+2
	push	WORD PTR _RS232_OldVect
	push	12
	call	FAR PTR __dos_setvect
	add	sp,6
; met DTR a ON
	mov	dx,1020
	mov	al,15
	out	dx,al
; lit l'etat du modem
	mov	dx,1022
	in	al,dx
	sti
	leave	
	ret	
_RS232_DesinstIntr	ENDP

;**************************************************************************
	PUBLIC	_RS232_GetChar
_RS232_GetChar	PROC FAR
	enter	WORD PTR 2,0
	mov	ax,_RS232_FinBufRecv
	cmp	_RS232_DebBufRecv,ax
	jne	$I294
; Pas de caracteres dans le buffer
; mise en service du 8259
	mov	dx,33
	in	al,dx
	and	al,239
	out	dx,al
; met DTR a ON
	mov	dx,1020
	mov	al,15
	out	dx,al
; lit l'etat du modem
	mov	dx,1022
	in	al,dx
; return (EOF)
	mov	ax,-1
	leave	
	ret	
$I294:
; il y a au moins un caractere dans le buffer
	cli
	mov	bx,_RS232_DebBufRecv
	mov	al,BYTE PTR _RS232_BufRecv[bx]
	inc	WORD PTR _RS232_DebBufRecv
	and	BYTE PTR _RS232_DebBufRecv+1,15
	sti
	sub	ah,ah
	leave	
	ret	
	nop	
_RS232_GetChar	ENDP

;**************************************************************************
	PUBLIC	_RS232_PutChar
_RS232_PutChar	PROC FAR
	enter	WORD PTR 0,0
	mov	dx,0
	mov	ax,WORD PTR [bp+6]
	mov	ah,1
	int	20
	test	ax,-32768
	je	$I300
; return (EOF)
	mov	ax,-1
	leave	
	ret	
	nop	
$I300:
; return (0)
	sub	ax,ax
	leave	
	ret	
_RS232_PutChar	ENDP

;**************************************************************************
R_TEXT	ENDS
END
