# include "include.h"
# include "zeus.h"
# include "edeclar.h"
# include "ndefine.h"
# include "stat.h"


lnat p0,p3;
lnat m,cptes;
lnat *pext,*pint;
static char * des[100];
lnat max;
cnat rot,sflag,rflag;
lnat p2,clef,*net;
lnat *tab_capa,*tab_unit;
lnat nbcap;
lnat capa_buffer[NBNIV];

FILE *in2;

/*---------------------------------------------------------------*/

sequen()  /*    parcours sequentiel du fichier a traiter         */
          /*    de la fin vers le debut                          */
  {

   lnat nb_es,nbd;
   cnat er;
   cnat p;
   char type;

   /* initialisation */
   er=0;
   vu('+');
   if (rflag) rflag=0;
        else
        {
        vu('+');
        if(er=charger(fbuf1,(char *)(net[p0]))) return(1);
        vu('-');
   status = LSTAT(fbuf1);
   if (clef & EQP)
        {
   NSTAT(EQUI,return(128);)
   NSTAT(ZOOP,return(512);)
        }
        }
   nbd = LNDES(fbuf1);
   p=nbd-1;
   nb_es=0;

   /* parcours sequentiel */

	while(p>=0)
		{
		if ((TES__(fbuf1,p)) && (clef & EQP))
			{
			if (clef & SIMUL)
				{
				if (dest_ES(p))
					{
					ESEG_(fbuf1,p);
					}
				else
					nb_es++;
				}
			else
				nb_es++;
			}
		if ((TES__(fbuf1,p)) && (clef & EQP))
			{
			if (TENTR(fbuf1,p))
				nb_es+= MENT;
			if (TSORT(fbuf1,p))
				nb_es+= MSOR;
			}
		else
			{
			if ((TBLOC(fbuf1,p)) && (TLL__(fbuf1,p,0)) && (sflag<5))
				{
				empiler(p,nb_es);
				nb_es=0;
				}
			else
				if ((TTRAN(fbuf1,p)) && (TLL__(fbuf1,p,0)) && (sflag<5))
					{
					empiler(p,nb_es);
					nb_es=0;
					}
			}
		p--;
		}
	vu('-');
	return(er);
}

/*--------------------------------------------------------------*/

empiler(p,es)  /* empilage d'un fils:  -p pointe sur le fils    */
               /*                      -es nombre de ES du fils */
cnat p;
lnat es;

  {
   lnat i,xp,yp;
   uchar op;

   xp=p0+1;    /*   recherche dans la netlist des coordonnees   */
   if (clef & NLEX) xp++; /* du pere en tenant compte de la cle */
   yp=xp+1;
   if (clef & EQP)
      {
       for(i=(es & MASK);i>0;i--)
          net[p3--]= -1; /* reservation d'espace pour chaque ES */
       net[p3--]=es;     /* empilage du nombre d'ES             */
      }
   if (clef & STNOM) net[p3--]=0;
   if (clef & DXDY)
        {
        net[p3--] = LDY__(fbuf1,p);
        net[p3--] = LDX__(fbuf1,p);
        }
   if (clef & XY)
      {
        op = LOPGE(fbuf1,p);
        alccalcul_coord(net[xp],net[yp],p);
        net[p3--]=(lnat)opgeo_comp(op,rot);
        net[p3--] = LY___(fbuf1,p);
        net[p3--] = LX___(fbuf1,p);
      }
   if (clef & NLEX) net[p3--]=net[1+p0]+1; /* niveau lexico     */
   net[p3--] = LBUBL(fbuf1,p);/* nom fonctionnel (nom de fichier)    */
  }

/*--------------------------------------------------------------*/

depiler() /*          depilage d'un bloc                        */

  {
   lnat i,p4,p;
   cnat er;

   er=0;
   if (p0 > OFS -1)  /*    est-ce la racine ?                   */
      if (!(clef & NETT) || (sflag))  /*  nettoyage dynamique   */
   /* de la netlist les briques non simulables sont ecrasees    */
      {
      if (!(clef & DELBS) || ((clef & DELBS) && (sflag<=5)))
      {
   /* initialisation */

   if (clef & NLEX) p0++; 
   if (clef & XY)
      p0+=2;
   if (clef & DXDY) p0+=2;
   if (clef & OPGEO) p0++;
   if (clef & STNOM) net[++p0]=sflag;
   if (clef & EQP)
      p0+=(net[++p0] & MASK);
     }
     else p0--;
     }
     else p0--;
   p4 = ++p0;  /*  p4 pointeur sur emplacement libre dans la    */
               /*  netlist .                                    */
  
   /* depilage */
   net[p4++]=net[++p3]; /*  depilage du nom de fichier          */
   if (clef & NLEX )
       net[p4++]=net[++p3]; /* depilage du niveau lexico        */
   if (clef & XY)
      {
       net[p4++]=net[++p3]; /*  depilage de x puis de y         */
       net[p4++]=net[++p3];
       rot=net[++p3]; /* depilage de l'op geometrique dans la   */
                      /* variable globale rot.                  */
       if (clef & OPGEO) net[p4++]=rot;
      }
   if (clef & DXDY)
        {
        net[p4++]=net[++p3];
        net[p4++]=net[++p3];
        }
   if (clef & STNOM) net[p4++]=net[++p3];
   if (clef & EQP)
      {
       p3++;
       net[p4++]=net[p3]; /* depilage du nombre de ES           */
       p=(net[p3] & MASK); /* separation du nombre de ES et du  */
                           /* du nombre d'entrees               */
       for(i=0;i<p;i++)
          net[p4++]=net[++p3]; /* depilage des numeros d'equi   */      
       }
    if (p4>p3) er=2; /* recouvrement de la pile par la netlist? */
    return(er);

   }
/*--------------------------------------------------------------*/

ninit(nom)  /* initialisation de la netlist                      */

char nom[];

  {
lnat nb_es,i,nbd;
char temp[TAILLE_CHAINE];
cnat er;
cnat p;

   rflag=1;
   p3=p2;  /*  initialisation du pointeur de pile               */
   p0=(lnat)(OFS -1); /*  initialisation du pointeur sur la netlist     */
   tab_unit=(lnat *)net[2];
   tab_capa=(lnat *)net[1];
   nbcap=net[3];
   nb_es=0;
   if (clef & CAPA) clef&=~( SIMUL );
   if (clef & STNOM) in2=fopen(FICNOM,ETE);
    /* pas de destruction d'ES lorsque l'on utilise la clef CAPA*/
   net[OFSNEQ]=m=0; /* initialisation du compteur d'equi        */
   if (clef & SIMUL) if (er=charge_catal(ESINT,des)) return(er);
   /*  chargement de la table des ES particulieres              */
   p=0;
   nbd = LNDES(fbuf1);
   net[OFSPAS]=1;
   if ( clef & EQP)
      {
   while(p<nbd) /* parcours du fichier a la recherche des */
                      /* ES de la racine.                       */
        {
         if (NES__(fbuf1,p))
				break;
         if (!(clef & SIMUL) || !(dest_ES(p)))
            {
         if (clef & STNOM) {
                            strcpy(temp+1,LNOME(fbuf1,p));
                            if (TENTR(fbuf1,p))
										temp[0]='I';
                            if (TSORT(fbuf1,p))
										temp[0]='O';
                            if (TSERV(fbuf1,p))
										temp[0]='X';
                            fprintf(in2,"%s\n",temp);
                           }
         nb_es++;
         if (TENTR(fbuf1,p))
				nb_es+= MENT;
         if (TSORT(fbuf1,p))
				nb_es+= MSOR;
            }
         p++;
        }
   for(i=0;i<(nb_es & MASK);i++)
      net[p3--]=  ++m; /* attribution de numero d'equi aux ES   */
   net[p3--]=cptes=nb_es; /* de la racine et stockage dans la pile    */
     }
   if (clef & STNOM) {
                      net[p3--]=0;
                      net[OFSPAS]++;
                     }
   if (clef & DXDY)
        {
	i = LABI_(fbuf1);
	if(i < 0)
		{
	        net[p3--] = LENVY(fbuf1);
	        net[p3--] = LENVX(fbuf1);
		}
	else
		{
		net[p3--] = LDY__(fbuf1,i);
		net[p3--] = LDX__(fbuf1,i);
		}
        net[OFSPAS]+=2;
        }
   if (clef & XY)
      {
       net[OFSPAS]+=2;
       if (clef & OPGEO) net[OFSPAS]++;
       net[p3--]=rot=GNOP; /* initialisation et empilage de l'op   */
	i = LABI_(fbuf1); /* geometrique puis de y et x      */
	if(i < 0)
		{
		net[p3--]=net[p3--]=0;
		}
	else
		{
		net[p3--] = LY___(fbuf1,i);
		net[p3--] = LX___(fbuf1,i);
		}
      }
   if (clef & NLEX)
      {
       net[OFSPAS]++;
      net[p3--]=0;  /* empilage du niveau lexico                */
      }
   net[p3--]=(lnat)nom; /* empilage du nom de la racine       */
   net[OFSOFS]=OFS;
   net[OFSNBL]=0;
   net[OFSCLE]=clef;
   if (clef & EQP) net[OFSPAS]++;
   if(er=charge_catal(acc_ncatal,catal)) return(er);
   /*  chargement du fichier des blocs simulables               */
   if ((sflag=type_simul((char *)net[p3+1]))<5)
       sflag=(clef & NRAC) ? 0:2;
   return(0);
  }
    
alccalcul_coord (xpere,ypere,q)
        lnat xpere,ypere ;
        cnat q;


        {  lnat temp,temp1,temp2;
          switch (rot) 
                {
                  case 2 : /* pas doperation geometrique */
                           break ;
                  case 3 : /* rotation plus */
                           temp = LX___(fbuf1,q);
                           temp1 = LYDY_(fbuf1,q);
                           temp2 = LENVY(fbuf1);
                           recsymb(fbuf1,q,temp2-temp1,temp,-1l,-1l);
                           break ;
                  case 4 : /* rotation moins */
                           temp = LY___(fbuf1,q);
                           temp1 = LXDX_(fbuf1,q);
                           temp2 = LENVX(fbuf1);
                           recsymb(fbuf1,q,temp,temp2-temp1,-1l,-1l);
                           break ;
                  case 5 : /* symetrie % axe des X */
                           temp1 = LYDY_(fbuf1,q);
                           temp2 = LENVY(fbuf1);
                           recsymb(fbuf1,q,-1l,temp2-temp1,-1l,-1l);
                           break ;
                  case 6 : /* symetrie % axe des Y */
                           temp1 = LXDX_(fbuf1,q);
                           temp2 = LENVX(fbuf1);
                           recsymb(fbuf1,q,temp2-temp1,-1l,-1l,-1l);
                           break ;
                  case 7 : /* symetrie % O */
                           temp1 = LXDX_(fbuf1,q);
                           temp2 = LENVX(fbuf1);
                           recsymb(fbuf1,q,temp2-temp1,-1l,-1l,-1l);
                           temp1 = LYDY_(fbuf1,q);
                           temp2 = LENVY(fbuf1);
                           recsymb(fbuf1,q,-1l,temp2-temp1,-1l,-1l);
                           break ;
                  case 8 : /* rotation plus puis symetrie /Y */
                           temp = LX___(fbuf1,q);
                           temp1 = LY___(fbuf1,q);
                           recsymb(fbuf1,q,temp1,temp,-1l,-1l);
                           break ;
                  case 9 : /* rotation moins puis symetrie /Y */
                           temp1 = LXDX_(fbuf1,q);
                           temp2 = LENVX(fbuf1);
                           recsymb(fbuf1,q,-1l,temp2-temp1,-1l,-1l);
                           temp1 = LYDY_(fbuf1,q);
                           temp2 = LENVY(fbuf1);
                           recsymb(fbuf1,q,temp2-temp1,-1l,-1l,-1l);
                           break ;
                 default : break ;
                }
                temp = LX___(fbuf1,q);
                temp1 = LY___(fbuf1,q);
                recsymb(fbuf1,q,temp+xpere,temp1+ypere,-1l,-1l);
                /* les coordonnees du descripteur ajoutees a celles du bloc */
                /* auquel il appartient donnent les coordonnees par rapport */
                /* au fichier pere */
        } /* fin de alccalcul_coord */


controle()  /* coordonne les operations de gestion de pile avec */
            /* celles de recherche dans la base de donnees      */

  {

   cnat er;

   er=0;
   while(p3<p2) /* tant que la pile n'est pas vide              */
        {
         vu('+');
         if(er=depiler()) return(er);
	 vu('-');
         if (clef & BRIQ) break;
         vu('+');
         if (sflag !=2) sflag=type_simul((char *)net[p0]);
            else sflag=3;
    if (!(clef & NETT) || (sflag)) net[OFSNBL]++;
    if ((clef & DELBS) && (sflag>5)) net[OFSNBL]--;
    if (sflag<=5)
       if (er=sequen()) return(er);
          else
         if (clef & EQP) 
            if(er=parcours_chain()) return(er);
         if ((clef & CAPA) && (sflag>5))
            if (er=fcapa()) return(er);
     vu('-');
      }
   net[OFSNEQ]=m;
   sflag=type_simul((char *)net[p0]);
   if (((clef & NETT) && (sflag<5)) || ((clef & DELBS)&&(sflag>5))) 
      {
       net[OFSFIN]=p0;
      }
       else {
   net[OFSFIN]=p0+net[OFSPAS];
   if (clef & STNOM) net[net[OFSFIN]-2]=sflag;
   if (clef & EQP) net[OFSFIN]+=(net[net[OFSFIN]-1] & MASK);
            }
   return(er);
  }
/*--------------------------------------------------------------*/

parcours_chain () /* parcours du chainage                       */

        { cnat p,pec,q,pf;
          cnat er;
          lnat nbd;
         
          vu('+');
          pec = LDEBU(fbuf1);
          p=q = pec ;
          nbd = LNDES(fbuf1);
          pf=nbd-1;
                while ( p != -1 ) /* tant que l' on est pas a  */
                                   /* la fin du chainage.       */
                   {
                    if ((q<0)||(q>pf)) return(32);
                    if ((clef & CAPA) && (sflag<5))
                       ncapa(0,0l,0l,1l); /* initialise l'extracteur*/
                                      /* de capa.               */
                        pint[0]=pext[0]=0;
         /* pint[0] et pext[0] contiennent le nombre de ES      */
         /* internes et externes rencontrees sur une equi       */
                        do
                           {
                             if (TES__(fbuf1,p))
											{
                                  if (TLL__(fbuf1,p,0))
												pext[++pext[0]]=(lnat)p;
                                  if (TLL__(fbuf1,p,1))
												pint[++pint[0]]=(lnat)p;
											}
                             q=p;
                             if ((clef & CAPA) && (sflag<5))
                             ncapa(&fbuf1[p],0l,0l,2l); /* transmission d'un*/
                     /* descripteur vers l'extracteur de capa.  */
                             p = LCHAI(fbuf1,p);
                             if (TFEQU(fbuf1,q))
										break;
                           }
                        while (1);
                        vu('+');
                        if(er=calcul_equip()) return(er) ;
                        vu('-');
                    }
          vu('-');
          return(0);
        }
/*--------------------------------------------------------------*/

nrepere(p,ep,no) /* calcul du numero de bloc et du numero de ES  */
                /* qui correspond au descripteur pointe par p   */
lnat p;
lnat *ep,*no;

  {
   
   *ep=0;
   while(p >=0)
        /* recherche d'un descripteur de bloc pour calculer le  */
        /* numero d'ordre de l'ES pointee par p.                */
        {
          if (TBLOC(fbuf1,p))
				break;
          if (TES__(fbuf1,p))
				(*ep)++;
          /* il faut tenir compte des ES qui ont ete supprimees */
         p--;
        }
        *no=0;
        while(p>=0) /* calcul du numero de bloc              */
             {
              if (TBLOC(fbuf1,p))
					(*no)++;
              p--;
             }
  }
/*--------------------------------------------------------------*/

lnat plus_petit()  /* dans le cas ou il y aurait plusieurs ES        */
              /* externes.il faut determiner le plus petit      */
              /* numero d'equi.                                 */

    {
     lnat i,ep,no,min,max;

     i=pext[0];
     min=m;
     max=0;
     while(i)
         {
          nrepere(pext[i],&ep,&no);
          ep+=p0+net[OFSPAS]-1;
          if (net[ep]<min) min=net[ep]; /* plus petit           */
          pext[i]=net[ep]; /* remplace le pointeur par le       */
                           /* numero d'equi correspondant dans  */
                           /* le tableau pext.                  */
          if (net[ep]>max) max=net[ep]; /* plus grand.          */
          i--;
         }
   vu('+');
 if (min != max) backtrack(min); /* 2 ES au moins ont des   */
   vu('-');
  /* numeros d'equi differents.il faut donc renumeroter les  */
     /* equipotentielles existentes.                            */
     return(min);
    }
/*--------------------------------------------------------------*/

calcul_equip() /* traitement d'une equipotentielle: calcul du   */
               /* numero d'equi globale et report sur les ES    */
               /* internes.                                     */
     {
   
      lnat i,num_equip,q,ep,no,s;
      cnat er;
    
      if (pext[0]==0 && pint[0]==0) return(0);
      if (pext[0]==0) /* equipotentielle interne nouveau no     */
         num_equip= ++m;
         else /* equipotentielle externe recherche du no        */
         num_equip=plus_petit();
      if (num_equip== -1l) return(64);
      i=pint[0];
      while(i) /* pour toutes les ES des fils                   */
           {
            vu('+');
            nrepere(pint[i],&ep,&no);
            vu('-');
            q=p3+1;
            while(no) /* positionnement dans la pile sur le     */
                      /* bloc et l'ES concernes.                */
                 {
            q+=net[OFSPAS]-1;
            if ((clef & XY) && !(clef & OPGEO)) q++;
            s=q;
            q+=(net[q] & MASK)+1;
            no--;
           }
       i--;
       if (ep>(net[s] & MASK)) return(64);
       net[s+ep]=num_equip; /* affectation d'un numero d'equi   */
    }
    if ((clef & CAPA) && (sflag<5)) 
        if (er=ncapa(0,(lnat)num_equip,0l,3l)) return(er);
    /* transmission du numero d'equi vers l'extracteur de capa   */
    return(0);
 }
/*--------------------------------------------------------------*/

backtrack(mi) /* renumerotation  des equipotentielles.          */
              /* - mi numero d'equi que l'on veut affecter      */
lnat mi;
  {
   lnat i,j,p,k;
 
   for(i=1;i<pext[0];i++) /* classement par ordre decroissant   */
      {                   /* des numeros d'equi a traiter.      */
        for(j=i;j<pext[0]+1;j++)
           {
            if (pext[i]>pext[j])
               {
                p=pext[i];
                pext[i]=pext[j];
                pext[j]=p;
               }
           }
      }
      i=pext[0];
      p=0;
      while((k=pext[i--])>mi)
          {
           if (p!=k)
              {
           back1(mi,OFS+net[OFSPAS],p0+net[OFSPAS]+1,k);
           /* renumerotation dans la netlist.                   */
           back1(mi,p3+1+net[OFSPAS],p2,k);
           /* renumerotation dans la pile.                      */
           if ((clef & CAPA) && (sflag<5)) ncapa(0,(lnat)mi,(lnat)k,4l);
           /* indication de backtrack pour l'extracteur de capa */
           m--;
              }
           p=k;
          }
   }
/*--------------------------------------------------------------*/

back1(mi,deb,fin,k) /* - mi equi de reference                   */
                    /* - deb et fin limites de la zone          */
                    /* - k equi a detruire                      */
  lnat mi,deb,fin;
  lnat k;

  {
   lnat j,p;
   lnat alpha;
   char flag;

   flag=0;
   if ((p3<deb) && (clef & XY) && !(clef & OPGEO)) 
      {
       flag++; /* dans la pile il faut tenir compte de la place */
       deb++;  /* occupee par l'op geometrique.                 */
      }
   p=deb;
   while (p<fin) /* parcours de la zone a renumeroter.          */
     {
      for(j=0;j<(net[p-1] & MASK);j++)
         {
           alpha=p+j;
          if (net[alpha]==k) net[alpha]=mi; /* fusion.          */
          if (net[alpha]>k) net[alpha]--; /* tassement.         */
         }
       p+=j+net[OFSPAS]+flag;
      }
   }
/*--------------------------------------------------------------*/

alcnerreur(er)

cnat er;

  {
   if (er & 1)
	{erreur(76,(char *)(net[p0]));
#ifndef V_EXTERNE
	m_valid();
#endif
	}
   if (er & 2) erreur(59,"");
   if (er & 4) printf(" Tableau de capacite trop petit.\n");
   if (er & 8) erreur(57,"");
   if (er & 16) erreur(56,"");
   if (er & 32)
	{erreur(58,(char *)(net[p0]));
#ifndef V_EXTERNE
	m_valid();
#endif
	}
   if (er & 64)
	{erreur(87,(char *)(net[p0]));
#ifndef V_EXTERNE
	m_valid();
#endif
	}
   if (er & 128)
	{ erreur(92,(char *)(net[p0]));
#ifndef V_EXTERNE
	m_valid();
#endif
	}
   if (er & 512)
	{ erreur(93,(char *)(net[p0]));
#ifndef V_EXTERNE
	m_valid();
#endif
	}
   if (er & 1024)
	{ erreur(94,(char *)(net[p0]));
#ifndef V_EXTERNE
	m_valid();
#endif
	}
  }
/*--------------------------------------------------------------*/

netlist(a,b,ne,c) /* point d'entree.                          */

lnat a,b;
lnat *ne;
char *c;

  {
   cnat er;
   char * nom;
	lnat i,inom;
   
   erreur(12,"");
   pext=(lnat *)fpil;
   pint=(lnat *)fpil2;
   net=ne;
   p2=a;
   clef=b;
   nom = LNOMP(c);
   vu('r');
   vu('+');
   if(er=ninit(nom)) {alcnerreur(er);return(1);}
   vu('+');
   if(er=controle()) {alcnerreur(er);return(1);}
   vu('-');
   if (clef & STNOM) {stnom();fclose(in2);}
   vu('-');
   in2=fopen("NETLIST",EBI);
	inom=net[OFSOFS];
	fwrite(ne,sizeof(lnat),(int)inom,in2);
	while(inom < ne[0])
		{
			fprintf(in2,"%s\n",(char *)ne[inom]);
			i = inom+1;
			if ((ne[OFSCLE] & EQP)==EQP)
				inom+=ne[OFSPAS]+(ne[inom+ne[OFSPAS]-1]&MASK);
			else
				inom+=ne[OFSPAS];
			fwrite(ne+i,sizeof(lnat),(int)(inom-i),in2);
		}
   fclose(in2);
   return(0);
  }
/*--------------------------------------------------------------*/



/*      FONCTION NON REPEREE    */
dest_ES(n)
cnat n;
{
	lnat i;
	cnat emit;
	char * n1;
	char * n2;

	n1 = LNOME(fbuf1,n);
	n2 = (char *)namealloc(n1);
	emit=((clef & SIMU2)== SIMU2)? 0:1;
	for(i=(lnat)des[0];i>0;i--)
		if (n2==des[i])
			return(emit);
	return(emit-1);
}

/*--------------------------------------------------------------*/

motd(fp,bam)  /* lecture d'un mot dans un fichier ASCII.     */
FILE *fp;
char *bam;
     {
      char c,u;
  
      u=0;
      while((c=getc(fp))!=0x0a)
           bam[u++]=c;
     bam[u]='\0';
    }
/*--------------------------------------------------------------*/

fcapa()
   {
    lnat i,s,s1;
    cnat er;

    er=ncapa(0,(lnat)net[p0],0l,5l); /* charger le fichier .capa relatif a la BS */
    if (er) return(er);
    s=p0+net[OFSPAS];
    s1=net[s-1] & MASK;
    for(i=0;i<s1;i++)
       ncapa(0,(lnat)net[s+i],i,6l);
    return(0);
   }
/*--------------------------------------------------------------*/



/* AUTEURS : Gripon , Favart , Gouraud  Maitrise Peri9          */
/* FONCTION CALCUL CAPACITE */

ncapa (ptr_rect, n1, n2, code)
desc *ptr_rect ;
lnat n1, n2, code ;

{ 
        cnat ind, col, tail ;
        FILE *fp ;
        char ch [100] ;
        char nom [TAILLE_CHAINE] ;
        lnat capa_unit ;
        lnat *cap_es;
        
        switch ((cnat)code) {
        case 1 : /* Debut d'equipotentialite */
                for (ind = 0 ; ind <= tab_unit[0] ; ind ++) 
                        capa_buffer[ind] = 0 ;
                break ;
        case 2 : /* Calcul equipotentialite intermediaire */
                /* Recherche capacite unitaire en fonction du type du masque */
                if (ptr_rect->ll == 0) {
                   capa_unit = tab_unit [ptr_rect->opniv + 1] ;
                        /* Ajout de la capacite */
                   capa_buffer[0] += ptr_rect->l * ptr_rect->w * capa_unit ;
                        /* ajout capacite partielle au niveau considere */
                   capa_buffer[(ptr_rect->opniv)+1] += ptr_rect->l * ptr_rect->w * capa_unit ;
                }
                break ;
        case 3 : /* Fin calcul d'equipotentialite */
                if (n1 > nbcap) return(4);
                for (ind = 0; ind <= tab_unit[0]; ind ++)
                      tab_capa[(n1-1)*(tab_unit[0]+1)+ind] += capa_buffer[ind] ;
                if (n1 > max) max = n1 ;
                break;
        case 4 : /* Detection backtrack */
                for (ind = 0; ind <= tab_unit[0]; ind ++)
                      tab_capa[(n1-1)*(tab_unit[0]+1)+ind] += tab_capa[(n2-1)*(tab_unit[0]+1)+ind] ;
                /* Tassement table */
                for ( col = n2 ; col < max ; col++ )
                   for (ind = 0; ind <= tab_unit[0]; ind ++) 
                      tab_capa[(col-1)*(tab_unit[0]+1)+ind] = tab_capa[col*(tab_unit[0]+1)+ind];
                for (ind = 0; ind <= tab_unit[0]; ind ++)
                   tab_capa [(max-1)*(tab_unit[0]+1)+ind] = 0;
                max--;
                break;
        case 5 : /* chargement fichier */
                strcpy(nom,(char *)n1);
                strcat(nom,".CAPA");
                if (charg_EScap(nom,&cap_es)) return(8);
                break;
        case 6 : /* recherche de la capacite dans le fichier et ajout de la capa
                                                                   dans tab_capa [no eq] */
                for(ind=0;ind<=tab_unit[0];ind++)
                   tab_capa[(n1-1)*(tab_unit[0]+1)+ind]+=cap_es[(tab_unit[0]+1)*n2+ind];
                break;
        }
return(0);
}

stnom()
{
	char * nkm;
	lnat i;
	cnat p;
	lnat cd,iop;
	char temp[TAILLE_CHAINE];

#ifdef PC
	lnat xxxx[100];
#else
	lnat * xxxx;
	xxxx = (lnat *)ALLOC(acc_nbcatal * sizeof(lnat));
#endif

	cptes&= MASK;

	xxxx[0] = (lnat)catal[0];

	for(i=1;i<=(lnat)catal[0];i++)
		{
			vu('+');
			nkm = catal[i];
			if(charger(fbuf1,nkm))
				xxxx[i]= -1;
			else
				{
					xxxx[i] = cptes;

					p=0;
					while(1)
						{
							if (NES__(fbuf1,p))
								break;
							if ((!(clef & SIMUL))||(!(dest_ES(p))))
								{
									strcpy(temp+1,LNOME(fbuf1,p));
									if (TENTR(fbuf1,p))
										temp[0]='I';
									if (TSORT(fbuf1,p))
										temp[0]='O';
									if (TSERV(fbuf1,p))
										temp[0]='X';
									fprintf(in2,"%s\n",temp);
									cptes++;
								}
							p++;
						}
					vu('-');
				} /* else */
		} /* for */
	net[OFSNES]=cptes;
	cd=net[OFSOFS]+net[OFSPAS]-2;
	for(i=net[OFSNBL];i>0;i--)
		{
			iop=net[cd];
			if (iop>5)
				net[cd]=xxxx[iop-5];
			else
				if (i==net[OFSNBL])
					net[cd]=0;
				else
					net[cd]= -1;
			cd+=(net[cd+1]&MASK)+net[OFSPAS];
		}
#ifndef PC
	free(xxxx);
#endif
} /* stnom */
    

/*****************************************************************************/
/*   routine charg_EScap(nom,ptab) : - nom est un nom de fichier de valeurs  */
/*                                     des capacites des entrees/sorties d'un*/
/*                                     fichier EMILIEC .                     */
/*                                     NB:ce nom est celui du fichier EMILIEC*/
/*                                     correspondant,suffixe par ".CAPA" .   */
/*                                 - ptab est un pointeur sur un pointeur de */
/*                                   tableau .                               */
/*      Role : lit un fichier des valeurs des capacites des entrees/sorties  */
/*             d'un fichier EMILIEC et charge ces valeurs dans le tableau    */
/*             dont le pointeur est passe en parametre .                     */
/*             NB: la routine alloue l'espace memoire necessaire au tableau. */
/*                                                                           */
/*      Structure du fichier d'entree : exemple :                            */
/*
	16pfichier: TP000.CAPA                         technologie:   MHS  0p
 nombre_de_niveaux_de_masque: 9
 nombre_d'entree/sorties: 3
entree/sortie: GRILP          capacite:(upf/lambda2) 12
                                capa_niveau0: 0
                                capa_niveau1: 0
                                capa_niveau2: 0
                                capa_niveau3: 12
                                capa_niveau4: 0
                                capa_niveau5: 0
                                capa_niveau6: 0
                                capa_niveau7: 0
                                capa_niveau8: 0
entree/sortie: SOURC          capacite:(upf/lambda2) 4
                                capa_niveau0: 0
                                capa_niveau1: 0
                                capa_niveau2: 4
                                capa_niveau3: 0
                                capa_niveau4: 0
                                capa_niveau5: 0
                                capa_niveau6: 0
                                capa_niveau7: 0
                                capa_niveau8: 0
entree/sortie: DRAIN          capacite:(upf/lambda2) 4
                                capa_niveau0: 0
                                capa_niveau1: 0
                                capa_niveau2: 4
                                capa_niveau3: 0
                                capa_niveau4: 0
                                capa_niveau5: 0
                                capa_niveau6: 0
                                capa_niveau7: 0
                                capa_niveau8: 0
*/

/*       Structure du tableau en sortie :                                    */
/*           Le tableau (de nbre d'E/S * nbre de niveaux elements) , contient*/
/*           les valeurs des capacites (en binaire , format entier) dans le  */
/*           meme ordre que celui du fichier,qui est aussi l'ordre du fichier*/
/*           EMILIEC correspondant .                                         */
/*                                                                           */
/*      NB1: Le nombre de niveaux de masque est parametre de la technologie  */
/*           utilisee . Il vient des fichiers de valeurs de capacites unitai-*/
/*           res par niveau . Exemple :                                      */
/*
nombre_de_niveaux_de_masque: 9
niveau0: capacite_unitaire(upf/l2): 1
niveau1: capacite_unitaire(upf/l2): 1
niveau2: capacite_unitaire(upf/l2): 1
niveau3: capacite_unitaire(upf/l2): 1
niveau4: capacite_unitaire(upf/l2): 1
niveau5: capacite_unitaire(upf/l2): 1
niveau6: capacite_unitaire(upf/l2): 1
niveau7: capacite_unitaire(upf/l2): 1
niveau8: capacite_unitaire(upf/l2): 1
*/

/*      NB2: Le fichier d'entree doit respecter les contraintes suivantes :  */
/*          - un ou plusieurs blancs (ou tabulations) entre les chaines de   */
/*            caracteres , dont l'ordre doit rester celui de l'exemple .     */
/*            L'utilisateur peut editer ce fichier , mais uniquement pour    */
/*            modifier les valeurs des capacites . Cela implique que les     */
/*            fichiers "xxxxx.CAPA" ne doivent etre crees que par programme. */
/*                                                                           */
/*****************************************************************************/
charg_EScap(nom,ptab)
   char nom[] ;
   lnat **ptab ;
        {
        char chan[TAILLE_CHAINE] ;
                /* variable poubelle */
        lnat tail , nb_niv , j , i ;
        FILE *in ;

        in=fopen(nom,"r") ;
        if ( !in )  return(1) ;
        fscanf(in,"%s %s %s %s %s",chan,chan,chan,chan,chan) ;
                /* on saute la premiere ligne */
        fscanf(in,"%s %d",chan,&nb_niv) ;
                /* lecture du nombre de niveaux de masque */
        fscanf(in,"%s %d",chan,&tail) ;
                /* lecture du nombred'entrees/sorties */
        *ptab = (lnat *) malloc(tail*(nb_niv+1)*(sizeof(lnat))) ;
        i=0 ;
        do {
           fscanf(in,"%s %s %s %d",chan,chan,chan,&((*ptab)[i*(nb_niv+1)])) ;
           for ( j=1 ; j<=nb_niv ; j++ )
                fscanf(in,"%s %d",chan,&((*ptab)[(i*(nb_niv+1))+j])) ;
           i++;
                /* pour toutes les entrees/sorties , on stocke la valeur */
                /* des capacites (globale et partielles) dans le tableau */
           } while (i<tail) ;
        fclose(in) ;
        }
