typedef short index;				/* index dans un tableau ou depl. dans une zone */
typedef short hexa;					/* quatre chiffres hexadecimaux */
typedef long  lnat;					/* entier sur 4 octets */
typedef int   cnat;					/* entier sur 2 octets */
typedef unsigned char uchar;		/* octet non signe*/

/****************** OPERATIONS ******************************************/

#define GNOP		0x02			/* pas d'operation  */
#define GRPLUS		0x03			/* rotation plus */
#define GRMOINS		0x04			/* rotation moins */
#define GSYMX		0x05			/* symetrie X  */
#define GSYMY		0x06			/* symetrie Y  */
#define GSYMO		0x07			/* symetrie par rapport a 0 */
#define GRPSY		0x08			/* rotation + suivie de sym/y */
#define GRMSY		0x09			/* rotation - suivie de sym/y */
#define SENSH		0x40			/* sens Horizontal (1) ou vertical (0) */
 
/************** NIVEAUX DE MASQUE (g_union.g_niveau) *********************/
#define GCONT		0x00			/* masque de contact */
#define GVIA		0x01			/* masque de via */
#define GALU1		0x02			/* masque de aluminium */
#define GALU2		0x03			/* masque d'alu2  */
#define GPOLY		0x04			/* masque de poly */
#define GDIFN		0x05			/* masque de diffusion */
#define GDIFP		0x06			/* masque de diffusion */
#define TRSPPOLY	0x07			/* transparence poly */
#define TRSPALU1	0x08			/* transparence alu1 */
#define TRSPALU2	0x09			/* transparence alu2 */
#define GCAISN		0x0a			/* masque de caisson P*/
#define GCAISP		0x0b			/* masque de caisson N*/
#define GNULL		0x0c			/* masque nul */
 
#define SALU1		0x00
#define SVIAX		0x01
#define SALU2		0x02
#define SPATH1		0x03
#define SPATH2		0x04
#define SVIAY		0x07
#define ABBOX		0x0b			/* masque d'abutment box */

/******************** BITS DE LA CLE **************************************/

#define explom		0x80			/* explicitation, logical zoom */
#define visu		0x40			/* visualisation, display */
#define ins_fig		0x20			/* bloc ou motif, cell or wire */
#define cont_surfa	0x10			/* contour ou surface */
#define body		0x08			/* body */
#define fin_equi	0x04			/* fin de l'equipotentelle  */
#define entree		0x02			/* entree */
#define sortie		0x01			/* sortie */

/******************** BIT DE L'ETAT  *************************************/

#define nor_alm		0x80			/* normal ou alumer                  */
#define explop		0x40			/* bit d'explicitation partielle */

/******************** ORIENTATION DES CONNECTEURS (2 bits de poids fort de ll) ************************/

#define ORIENT		0xc0
#define NORD		0x00
#define SUD			0x40
#define EST			0x80
#define OUEST		0xc0
 
/***************** EN TETE DE FICHIER ***************************************/

typedef struct entet
{
	char * nom_propre;				/* ascii */
	union un_deb					/* debut du chainage equip (mem et disque) */
		{
			struct st_desc *e_debequi;
			lnat e_debrelat;
		} e_deb ;
	lnat abindex;				/* index d'abutment box*/
	lnat e_dx;
	lnat e_dy;
	lnat e_nbdesc;
	lnat date;						/* date fichier */
	lnat status;					/* sauvegarde du status */
} entete;

/*********** DESCRIPTEUR DE BLOC OU RECTANGLE *****************************/

typedef struct st_desc
{
	char cle;						/* cles fourre tout */
	char etat;						/* bit 7: illumination; autres bits reserves */
	char ll;						/* niveau lexicographique (nbre de parentheses fermees)*/
	char opniv;						/* op geo pour un bloc, niv de masque pour un rectangle */
	union nom_numES
		{
			 char * nom_propre;		/* si bloc, ascii */
			 union u_num_ES
				{
					lnat num_ES;	/* numero d'E/S */
					char * nom_ES;	/* nom d'E/S */
				} num_ES;			/* si rectangle, nom (ou numero) d'E/S entre sous forme ascii;
										ce nom est local au bloc designe par l'en-tete;
										le numero est compris entre 0 et 255 */
		} nom_num;
	union un_chain					/* chainage equipotentielles (mem et disque) */
		{
			struct st_desc *equi;	/* descripteur suivant */
			lnat adr_relat;
		} chain;
	union un_fonction
		{
			union nom_numEQ			/* numero equipotentielle connectee  */
				{
					lnat num_equip;	/* numero equipotentielle */
					char * nom_equip;/*  nom equipotentielle */
				} num_equip;
			union nom_behav			/* model comportemental  */
				{					/*nom fichier */
					lnat num_behav;
					char * nom_behav;
				} nom_behav;
		} fonction;
	lnat x, y, l, w;				/* coordonnees de l'objet */
} desc;
