/************************************************************************/
/* programme: GR.C	Auteur: G.-E. D.	Date: 24 sept 90	*/
/*									*/
/* Emulateur GRaphique pour alliance sur PC terminal de NCR             */
/************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <graph.h>
#include "RS232.H"

/* #define DEBUG_G vrai */

#define	cnat	int
int	texatt[2];
int	reso[2][10];
#define RESOLX(p)      reso[0][p]
#define RESOLY(p)      reso[1][p]
#define HTEXT  texatt[0]
#define LTEXT  texatt[1]
#define NORES	3

#define NAK '|'
#define TRUE 1
#define MAXPARAM 25
cnat	pn[MAXPARAM];
char	ps[MAXPARAM][100];
int	nbp = 0;
int	fct = 0;
char	lastreponse[160];
int	numpqt = 'A', lastnumpqt = 'Z';
int	chk;
#define ATT_ESC 1
#define ATT_FCT_OU_PAR 2
#define ATT_NUM_PQT 3
#define ATT_CHKSUM 4
#define ATT_FCT	5
#define ATT_NOMBRE 6
#define ATT_CHAINE 7
int	mode = ATT_ESC;

int calc_checksum (char str[]);
/************************************************************************/
int calc_checksum (char str[]) {
	int i, chks;
	
	for (chks=i=0 ; str[i] ; i++) {
		chks ^= str[i];
	};
	chks = (chks & 0x3F) + 32;
	if (chks == '#') {
		return ('a');
	}
	if (chks == '@') {
		return ('b');
	}
	return (chks);
};

int inc_paquet (int *pqt);
/************************************************************************/
int inc_paquet (int *pqt) {
	if (*pqt >= 'Z') {
		*pqt = 'A';
	} else {
		(*pqt)++;
	};
	return (*pqt);
}

void execute ();
/************************************************************************/
/* Appel de la fonction VDI sur PC demandee par le NCR                  */
/************************************************************************/
void execute () {
	int i;
	int ret;

	switch (fct) {
				 /* Fonctions avec retour de parametres */
				 /* ----------------------------------- */
		case 'A' : {
			gemappl_init ();
			nbp = 4;
			for (i=0 ; i<nbp ; i++) {
				strcpy (ps[i], "%%VIDE%%");
			}
			pn[0] = RESOLX (NORES);
			pn[1] = RESOLY (NORES);
			pn[2] = HTEXT;
			pn[3] = LTEXT;
			break;
		};
		case 'B' : {
			pn[2] = pn[3] = pn[4] = 0;
			vdirq_locator (i,pn[0],pn[1],&pn[2],&pn[3],&pn[4]);
			nbp = 3;
			for (i=0 ; i<nbp ; i++) {
				strcpy (ps[i], "%%VIDE%%");
			}
			pn[0]=pn[2];
			pn[1]=pn[3];
			pn[2]=pn[4];
			break;
		};
		case 'C' : {
			pn[2] = pn[3] = pn[4] = 0;
			vdism_locator (i,pn[0],pn[1],&pn[2],&pn[3],&pn[4]);
			nbp = 3;
			for (i=0 ; i<nbp ; i++) {
				strcpy (ps[i], "%%VIDE%%");
			}
			pn[0]=pn[2];
			pn[1]=pn[3];
			pn[2]=pn[4];
			break;
		};
		case 'D' : {
			ret = vdi_get_pixel (i, pn[0], pn[1]);
			nbp = 1;
			for (i=0 ; i<nbp ; i++) {
				strcpy (ps[i], "%%VIDE%%");
			}
			pn[0] = ret;
			break;
		};
		case 'E' : {
			ret = gemCrawcin ();
			nbp = 1;
			for (i=0 ; i<nbp ; i++) {
				strcpy (ps[i], "%%VIDE%%");
			}
			pn[0] = ret;
			break;
		};
				 /* Fonctions sans retour de parametres */
				 /* ----------------------------------- */
		case 'a' : {
			vdisf_color (i, pn[0]);
			break;
		};
		case 'b' : {
			vdi_bar (i, pn);
			break;
		};
		case 'c' : {
			vdisf_style (i, pn[0]);
			break;
		};
		case 'd' : {
			vdisf_interior (i, pn[0]);
			break;
		};
		case 'e' : {
			gemgraf_mouse (pn[0], i);
			break;
		};
		case 'f' : {
			gemappl_exit ();
			break;
		};
		case 'g' : {
			vdist_color (i, pn[0]);
			break;
		};
		case 'h' : {
			vdi_gtext (i, pn[0], pn[2], ps[1]);
			break;
		};
		case 'i' : {
			vdi_rfbox (i, pn);
			break;
		};
		case 'j' : {
			vdi_clrwk ();
			break;
		};
		case 'k' : {
			vdisl_color (i, pn[0]);
			break;
		};
		case 'l' : {
			vdi_pline (i, pn[0], &pn[1]);
			break;
		};
		case 'm' : {
			vdi_coul ();
			break;
		};
		case 'n' : {
			vdi_show_c (i, pn[0], pn[1]);
			break;
		};
		case 'o' : {
			show_souris ();
			break;
		};
		case 'p' : {
			vdi_hide_c ();
			break;
		};
		case 'q' : {
			grille (pn[0], pn[1], pn[2], pn[3], pn[4], pn[5]);
			break;
		};
		case 'r' : {
			vdi_dxinfo (ps[1], pn[0], pn[2], pn[3], pn[4], pn[7], ps[5], ps[6]);
			break;
		};
	};
}

void verif_trame ();
/************************************************************************/
/* Verifie le cheksum de la trame recue					*/
/************************************************************************/
void verif_trame () {
	char trame[500];
	int i;

	if (nbp > 0) {
		sprintf (trame, "\033{\000");
		for (i=0 ; i<nbp ; i++) {
			if (i != 0) {
				sprintf (trame, "%s,\000", trame);
			};
			if (strcmp (ps[i], "%%VIDE%%") == 0) {
				sprintf (trame, "%s%d\000", trame, pn[i]);
			} else {
				sprintf (trame, "%s'%s\000", trame, ps[i]);
			}
		};
 		sprintf (trame, "%s}%c%c\000", trame, fct, numpqt);
	} else {
		sprintf (trame, "\033%c%c\000", fct, numpqt);
	}
	i = calc_checksum (trame);
	if (i != chk) {
#ifdef DEBUG_G
printf ("  NAKC trame=%s", trame);
#endif
		RS232_PutChar (NAK);
		RS232_PutChar ('\n');
		return;
	}
	if (numpqt == lastnumpqt) {
		RS232_PutStr (lastreponse);
		return;
	}
	inc_paquet (&lastnumpqt);
	if (numpqt != lastnumpqt) {
		printf ("GR: ERREUR: desynchronisation: n=%d, l=%d\n",
		numpqt, lastnumpqt);
		gemappl_exit ();
	}
	if (fct & 32) {
#ifdef DEBUG_G
printf ("  E%c ", numpqt);
#endif
		RS232_Putchar (numpqt);
		RS232_PutChar ('\n');
		sprintf (lastreponse, "%c\n", numpqt);
		lastnumpqt = numpqt;
		execute ();
	} else {
		execute ();
		sprintf (trame, "\033{");
		for (i=0 ; i<nbp ; i++) {
			if (i != 0) {
				sprintf (trame, "%s,", trame);
			};
			if (strcmp (ps[i], "%%VIDE%%") == 0) {
				sprintf (trame, "%s%d", trame, pn[i]);
			} else {
				sprintf (trame, "%s'%s", trame, ps[i]);
			}
		};
 		sprintf (trame, "%s}%c", trame, numpqt);
		chk = calc_checksum (trame);
		sprintf (trame, "%s%c\n", trame, chk);
#ifdef DEBUG_G
printf ("  E%s ", &(trame[1]));
#endif
		RS232_PutStr (trame);
		strcpy (lastreponse, trame);
		lastnumpqt = numpqt;
	};
}

void recoit_param ();
/************************************************************************/
/* Recoit des parametres separes par ; sortie sur } ou incoherence      */
/************************************************************************/
void recoit_param () {
	int	pasfini = TRUE;
	int	carrecu = 0;
	char	buffer[160];
	int	indbuf = 0;
	int	negatif = 1;

	while (pasfini) {
		carrecu = RS232_GetChar ();
		switch (carrecu) {
			case EOF : {
				break;
			};
			case 27 : {
#ifdef DEBUG_G
printf ("  R");
#endif
				for (nbp=MAXPARAM ; nbp ; nbp--) {
					strcpy (ps[nbp-1], "%%VIDE%%");
					pn[nbp-1] = EOF;
				}
				mode = ATT_FCT_OU_PAR;
				return;
			};
			case '-' : {
				if (mode != ATT_CHAINE) {
					negatif = -1;
				};
				break;
			};
			case '0' :
			case '1' :
			case '2' :
			case '3' :
			case '4' :
			case '5' :
			case '6' :
			case '7' :
			case '8' :
			case '9' : {
#ifdef DEBUG_G
printf ("%c", carrecu);
#endif
				if ( (mode == ATT_FCT) ||
				     (mode == ATT_NOMBRE) ) {
					mode = ATT_NOMBRE;
					buffer [indbuf++] = carrecu;
				} else {
#ifdef DEBUG_G
printf ("  NAKN ");
#endif
					RS232_PutChar (NAK);
					RS232_PutChar ('\n');
					return;
				};
				break;
			};
			case '\'' : {
#ifdef DEBUG_G
printf ("\'");
#endif
				mode = ATT_CHAINE;
				do {
					carrecu = RS232_GetChar ();
#ifdef DEBUG_G
printf ("%c", carrecu);
#endif
					if (carrecu == 27) {
						for (nbp=MAXPARAM ; nbp ; nbp--) {
							strcpy (ps[nbp-1], "%%VIDE%%");
							pn[nbp-1] = EOF;
						}
						mode = ATT_FCT_OU_PAR;
						return;
					};
					if (carrecu != EOF) {
						buffer [indbuf++] = carrecu;
					}
				} while (carrecu != ',');
				buffer [--indbuf] = '\0';
			};
			case '}' :
			case ',' : {
#ifdef DEBUG_G
printf ("%c", carrecu);
#endif
				if (mode == ATT_CHAINE) {
					strcpy (ps[nbp++], buffer);
				};
				if (mode == ATT_NOMBRE) {
					buffer[indbuf] = '\0';
					sscanf (buffer, "%d", &pn[nbp]);
					pn[nbp] *= negatif;
					strcpy (ps[nbp++], "%%VIDE%%");
				};
				indbuf = 0;
				negatif = 1;
				if ( (mode != ATT_CHAINE) &&
				     (mode != ATT_NOMBRE) ) {
#ifdef DEBUG_G
printf ("  NAKV ");
#endif
					RS232_PutChar (NAK);
					RS232_PutChar ('\n');
					nbp = 0;
					return;
				};
				mode = ATT_FCT;
				if (carrecu == '}') {
					return;
				}
				break;
			};
			default : {
#ifdef DEBUG_G
printf ("  NAKM ");
#endif
				RS232_PutChar (NAK);
				RS232_PutChar ('\n');
				mode = ATT_ESC;
				printf ("PI=%c",carrecu);
				return;
			};
		}
	}
}

void graphique ();
/************************************************************************/
/* la boucle principale de reception d'une commande graphique ESC{1}A   */
/************************************************************************/
void graphique () {
	int pasfini = TRUE;
	int carrecu = 0;

	while (pasfini) {
		carrecu = RS232_GetChar ();
		switch (carrecu) {
			case '\n' : {
#ifdef DEBUG_G
printf ("\n");
#endif
				break;
			}
			case EOF : {
				break;
			}
			case 27 : {
						      /* Debut de trame */
						      /* -------------- */
#ifdef DEBUG_G
printf ("  R");
#endif
				for (nbp=MAXPARAM ; nbp ; nbp--) {
					strcpy (ps[nbp-1], "%%VIDE%%");
					pn[nbp-1] = EOF;
				}
				mode = ATT_FCT_OU_PAR;
				break;
			};
			case '{' : {
#ifdef DEBUG_G
printf ("{");
#endif
				if (mode == ATT_FCT_OU_PAR) {
					mode = ATT_FCT;
					recoit_param ();
				} else {
#ifdef DEBUG_G
printf ("  NAKM ");
#endif
					RS232_PutChar (NAK);
					RS232_PutChar ('\n');
					mode = ATT_ESC;
				};
				break;
			};
			default : {
#ifdef DEBUG_G
printf ("%c", carrecu);
#endif
				switch (mode) {
					case ATT_FCT :
					case ATT_FCT_OU_PAR : {
				    		if ((carrecu >= 'A') &&
				    		(carrecu <= 'z')) {
							fct = carrecu;
							mode = ATT_NUM_PQT;
						} else {
#ifdef DEBUG_G
printf ("  NAKF ");
#endif
							RS232_PutChar (NAK);
							RS232_PutChar ('\n');
						};
						break;
					};
					case ATT_NUM_PQT : {
						numpqt = carrecu;
						mode = ATT_CHKSUM;
						break;
					};
					case ATT_CHKSUM : {
						chk = carrecu;
						verif_trame ();
						mode = ATT_ESC;
						break;
					};
					default : {
						printf ("%c", carrecu);
					};
				};
				
			}
		}
	}
	
}

void main ();
/************************************************************************/
void main () {
	int caremis = 0,
	    carrecu = 0;
	char str[80];

	_setvideomode (_TEXTC80);
	_settextcolor (2);
	RS232_InstallIntr ();

	printf ("GR: emission identification\n");
	sprintf (str, "\n\n<o>GROK<o>\n");
	if (RS232_PutStr (str)) {
		printf ("GR: ERREUR: impossible emettre identification\n");
		exit (1);
	};
	while (RS232_GetChar () != '~') {
	};
	printf ("GR: dialogue etabli\n");
	
	graphique ();

				    /* NE PAS OUBLIER de DESINSTaller ! */
				    /* -------------------------------- */
	RS232_DesinstIntr ();
	_setvideomode (_DEFAULTMODE);
}
