# include "include.h"
# include "edeclar.h"
# include "zeus.h"
# include "stat.h"
# include "ndefine.h"

char ** PATH_CATA_LIB;

void read_mbk_env()
{
char *getenv();
char *strchr();
char *str, *s, *stc, *c;
int argc = 0;

	str = getenv("MBK_WORK_LIB");
	if(str != NULL)
	  {
		sprintf (acc_pathfile, "%s/", str);
	  }

	str = getenv("MBK_CATA_LIB");
	if(str != NULL)
	  {
		s = (char *)ALLOC((unsigned int)(strlen(str) + 1) * sizeof(char));
		(void)strcpy(s, str);
		str = s;   /* let's not modify the environement values */
		stc = str; /* for counting purposes */
		while (1)
		  {
			if ((c = strchr(stc, ':')) == NULL)
			  break;
			argc++;
			stc = ++c;
		  }
		PATH_CATA_LIB = (char **)ALLOC((unsigned int)(argc + 2) * sizeof(char *));
		argc = 0;
		while (1)
		  {
			if ((s = strchr(str, ':')) == NULL)
			  break;
			*(s++) = '\0';
			PATH_CATA_LIB[argc++] = str; /* no allocation necessary */
			str = s;
		  }
		if (s == NULL)
		  PATH_CATA_LIB[argc++] = (str == NULL || *str == '\0') ? NULL : str;
		PATH_CATA_LIB[argc] = NULL;
	  }
	else
	  { /* no specific path is given */
		PATH_CATA_LIB = (char **)ALLOC((unsigned int)2 * sizeof(char *));
		PATH_CATA_LIB[0] = acc_pathcatal;
		PATH_CATA_LIB[1] = NULL;
	  }
}

FILE * alcfopen(name, extension, mode)
char *name, *extension, *mode;
{
  FILE *in;
  register int i = 0;
  char filename[TAILLE_CHAINE];
  
  if (*mode != 'r')
	return NULL;
  
  while (PATH_CATA_LIB[i]) {
	if (extension)
	  (void)sprintf(filename, "%s/%s.%s", PATH_CATA_LIB[i++],
					name, extension);
	else
	  (void)sprintf(filename, "%s/%s", PATH_CATA_LIB[i++], name);
	if (in = fopen(filename, mode))
	  return in;
  }
  return NULL;
}

/* charge un setup */
chargir(pset,nom)
type_setup *pset;
char *nom;

  {
   FILE *in;
   char nam[TAILLE_CHAINE];

   sprintf(nam,"%s.stp",nom);
   in=fopen(nam,LBI);
   if (in==0) return(1) ;
   else
    {
          fread(pset,sizeof(*pset),1,in);
          fclose(in);
          return(0);
    }
  }



#ifndef V_EXTERNE
hardcopy()
{
char buff[20];
static int nb=0;
FILE *lst;
int i,j;
#define Himp 7

erreur(88,"");
sprintf(buff,"imp%02d.tmp",nb++);
lst=fopen(buff,EBI);
fprintf(lst,"\0331\n");
for(i=0;i<=RESOLY(3) / Himp;i++)
	{
	fprintf(lst,"\033L");
	fprintf(lst,"%c%c",RESOLX(3) % 256, RESOLX(3) >> 8);
	for(j=0;j<RESOLX(3);j++)
		{
		unsigned int b=0;
		int k;

		for(k=0;k<Himp;k++)
			if(Himp*i+k<RESOLY(3))
	  	b |= (!(!vdi_get_pixel(graph.handle,j,i*Himp+k)) << (7-k));
	if(b== 0x1A) b=0x18;
     	fprintf(lst,"%c",b);
		}
	info_time();
	fprintf(lst,"\012\015");
	}
fprintf(lst,"\0330\014");
fclose(lst);
erreur(95,buff);
m_valid();
informe();
}
#endif

charge_catal(pol,pl) /* charge un fichier ASCII.                */
                     /* -pol nom du fichier                     */
                     /* -pl  pointeur sur un pointeur tableau   */
char pol[];
char * pl[];
{
	lnat v;
	char bam[80];
	FILE *in;
   
	in=fopen(pol,LTE);
	if (in==0)
		{
		pl[0]=(char *)((lnat)(0));
		return(0);
/*		return(16);*/
		}
	v=1;
	while(fgets(bam,80,in)!=0)
		{
		if (bam[strlen(bam)-1] == '\n')
			bam[strlen(bam)-1] = '\0';
		pl[v++]=(char *)namealloc(bam);
		}
	pl[0]=(char *)((lnat)(v-1));
	fclose(in);
	return(0);
}

verif_transistor(nom,l,w)
char * nom;
lnat * l, * w;
{
	char * paux, ntemp[TAILLE_CHAINE];
	cnat i;

	strcpy(ntemp,nom);
	if (ntemp[0] != 'T')
		return(0);
	if ((ntemp[1] != 'N') && (ntemp[1] != 'P'))
		return(0);
	if (ntemp[2] != '_')
		return(0);

	if ((paux = (char *)strchr(ntemp + 3,'_')) == NULL)
		return(0);
	*paux = '\0';
	for (i=3;(ntemp[i] != '\0') && (i < TAILLE_CHAINE);i++)
		if ((ntemp[i] < '0') || (ntemp[i] > '9'))
			return(0);
	for(i++;(ntemp[i] != '\0') && (i < TAILLE_CHAINE);i++)
		if ((ntemp[i] < '0') || (ntemp[i] > '9'))
			return(0);
	if (i >= TAILLE_CHAINE)
		return(0);
	*l = atol(ntemp+3)<<1;
	paux++;
	*w = atol(paux)<<1;
	if ((*l <= 0) || (*w <= 0))
		return(0);
	return(1);
}

#ifndef V_EXTERNE
bsave(ptbloc,nbdes,nomfic,pdx,pdy,xmin,ymin)
cnat *ptbloc;
cnat nbdes;
char *nomfic;
lnat *pdx,*pdy,*xmin,*ymin;
{
	FILE *in;
	lnat temp1;
	cnat j,m,a,h,n,s;
	lnat x, y, dx, dy;
	cnat i;
	char filename[TAILLE_CHAINE],filebak[TAILLE_CHAINE];

	if (verif_transistor(nomfic,&x,&x))
		{
		erreur(2,"");
		return(1);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nomfic,acc_nmotif(i))==0)
			{
			erreur(2,"");
			return(1);
			}
	sprintf(filename,"%s%s.%s",acc_pathfile,nomfic,acc_suffphy);
	if((in=fopen(filename,LTE))!= 0l)
		{
			fclose(in);
#ifndef V_EXTERNE
			erreur(55,filename);
			if(!(testchar("NNOY")))
				return(1);
#endif
			sprintf(filebak,"%s%s.b%s",acc_pathfile,nomfic,acc_suffphy);
			sys_copy(filename,filebak);
		}
	*pdx= *pdy=0;
	*xmin= *ymin=10000;
/* calcule les coordonnees min et max, resultat dans xymin et pdxy */
	for(i=0;i<nbdes;i++)
		{
			x = LX___(fbuf1,ptbloc[i]);
			y = LY___(fbuf1,ptbloc[i]);
			*xmin=inf(*xmin,x);
			*ymin=inf(*ymin,y);
			dx = LDX__(fbuf1,ptbloc[i]);
			dy = LDY__(fbuf1,ptbloc[i]);
			*pdx = sup(*pdx,x+dx);
			*pdy = sup(*pdy,y+dy);
		}
	for(i=0;i<nbdes;i++)
		{
			if (NNDES(fbuf1,ptbloc[i]))
				ENUEQ(fbuf1,ptbloc[i],"*");
			ELL__(fbuf1,ptbloc[i],0);
		}
	*xmin = (*xmin>>1)<<1;
	*ymin = (*ymin>>1)<<1;
	*pdx += *pdx % 2;
	*pdy += *pdy % 2;
	*pdx -= *xmin;
	*pdy -= *ymin;

	in = fopen(filename,ETE);
	if (!in)
		{
		erreur(29,"");
		return(1);
		}
	if (fprintf(in,"V ALLIANCE 2.2 SETUP : %ld\n",acc_version) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	if (fprintf(in,"H %s,P,-1,%d,",nomfic,nbdes) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	sys_time(&j,&m,&a,&h,&n,&s);
	if (fprintf(in,"%2d/%2d/%d,0,",j,m,a) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	if (fputs("PAS A JOUR,",in) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	if (fprintf(in,"%ld,%ld,%ld,%ld,\n",*xmin>>1,*ymin>>1,*pdx>>1,*pdy>>1) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	for(i=0;i<nbdes;i++)
		{
			if (TBLOC(fbuf1,ptbloc[i]))
				{
				x = LX___(fbuf1,ptbloc[i])>>1;
				y = LY___(fbuf1,ptbloc[i])>>1;
				if (fprintf(in,"I %d,%ld,%ld,%s,%s," , i, x, y, LNOPR(fbuf1,ptbloc[i]), LNOMB(fbuf1,ptbloc[i])) == EOF)
					{
					erreur(29,"");
					fclose(in);
					return(1);
					}
				switch(LOPGE(fbuf1,ptbloc[i]))
					{
						case 2  :
							if (fputs("NOSYM,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 3  :
							if (fputs("ROT_P,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 4  :
							if (fputs("ROT_M,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 5  :
							if (fputs("SYM_Y,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 6  :
							if (fputs("SYM_X,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 7  :
							if (fputs("SYMXY,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 8  :
							if (fputs("SY_RP,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 9  :
							if (fputs("SY_RM,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						default :
							if (fputs("??,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
					}
				temp1 = LCHAI(fbuf1,ptbloc[i]);
				if (TFEQU(fbuf1,ptbloc[i]))
					{
					if (fprintf(in,"%ld,FIN\n",temp1) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					}
 				else
					{
					if (fprintf(in,"%ld,NON\n",temp1) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					}
				}
			else
				if (TMOTI(fbuf1,ptbloc[i]))
					{
					x = LX___(fbuf1,ptbloc[i])>>1;
					y = LY___(fbuf1,ptbloc[i])>>1;
					if (fprintf(in,"M %d,%ld,%ld,%s,%s,%d,", i, x, y, LNOPR(fbuf1,ptbloc[i]), LNOMB(fbuf1,ptbloc[i]), LNIVE(fbuf1,ptbloc[i])) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					temp1 = LCHAI(fbuf1,ptbloc[i]);
					if (TFEQU(fbuf1,ptbloc[i]))
						{
						if (fprintf(in,"%ld,FIN\n",temp1) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					else
						{
						if (fprintf(in,"%ld,NON\n",temp1) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					}
				else
				if (TTRAN(fbuf1,ptbloc[i]))
					{
					x = LX___(fbuf1,ptbloc[i])>>1;
					y = LY___(fbuf1,ptbloc[i])>>1;
					if (fprintf(in,"T %d,%ld,%ld,%s,%s,", i, x, y, LNOPR(fbuf1,ptbloc[i]), LNOMB(fbuf1,ptbloc[i])) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					switch(LOPGE(fbuf1,ptbloc[i]))
						{
							case 2  :
								if (fputs("NOSYM,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 3  :
								if (fputs("ROT_P,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 4  :
								if (fputs("ROT_M,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 5  :
								if (fputs("SYM_Y,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 6  :
								if (fputs("SYM_X,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 7  :
								if (fputs("SYMXY,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 8  :
								if (fputs("SY_RP,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 9  :
								if (fputs("SY_RM,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							default :
								if (fputs("??,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
						}
					temp1 = LCHAI(fbuf1,ptbloc[i]);
					if (TFEQU(fbuf1,ptbloc[i]))
						{
						if (fprintf(in,"%ld,FIN\n",temp1) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					else
						{
						if (fprintf(in,"%ld,NON\n",temp1) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					}
				else
					if (TES__(fbuf1,ptbloc[i]))
						{
						x = LXSMB(fbuf1,ptbloc[i])>>1;
						y = LYSMB(fbuf1,ptbloc[i])>>1;
						if (fprintf(in,"C %d,%ld,%ld,%ld,", i, x, y, LWSMB(fbuf1,ptbloc[i])>>1) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						switch(LORIE(fbuf1,ptbloc[i]))
							{
								case NORD :
									if (fputs("NORD,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
								case SUD :
									if (fputs("SUD,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
								case EST :
									if (fputs("EST,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
								case OUEST :
									if (fputs("OUEST,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
							}
						if (fprintf(in,"%s,%s,",acc_nniv(LNIVE(fbuf1,ptbloc[i])),LNOME(fbuf1,ptbloc[i])) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						if (TSERV(fbuf1,ptbloc[i]))
							{
							if (fputs("INOUT,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						else
							if (TENTR(fbuf1,ptbloc[i]))
								{
								if (fputs("IN,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
							else
								if (TSORT(fbuf1,ptbloc[i]))
									{
									if (fputs("OUT,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									}
								else
									{
									if (fputs("XXX,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									}
						temp1 = LCHAI(fbuf1,ptbloc[i]);
						if (TFEQU(fbuf1,ptbloc[i]))
							{
							if (fprintf(in,"%ld,FIN\n",temp1) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						else
							{
							if (fprintf(in,"%ld,NON\n",temp1) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						}
					else /* c'est un segment */
						{
							x = LXSMB(fbuf1,ptbloc[i])>>1;
							y = LYSMB(fbuf1,ptbloc[i])>>1;
							dx = LLSMB(fbuf1,ptbloc[i])>>1;
							dy = LWSMB(fbuf1,ptbloc[i])>>1;
							if (fprintf(in,"S %d,%ld,%ld,%ld,%ld,%c,%s,%s,%ld,", i, x, y, dx, dy, (TH___(fbuf1,ptbloc[i]))?'H':'V', acc_nniv(LNIVE(fbuf1,ptbloc[i])), LNOME(fbuf1,ptbloc[i]), LCHAI(fbuf1,ptbloc[i])) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							if (TFEQU(fbuf1,ptbloc[i]))
								{
								if (fputs("FIN\n",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
							else
								{
								if (fputs("NON\n",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
						}
		} /* for */
	if (fputs("EOF\n",in) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	fclose(in);
}
#endif

lire_ajout_bbab(buf,n,nom,ecrit)
desc * buf;
cnat n;
char * nom,ecrit;
{
	FILE *in;
	char ligne[255];
	char nomfic[TAILLE_CHAINE], * paux, *ptemp;
	lnat i,xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab,l,w;

	if (verif_transistor(nom,&l,&w))
		{
/* chargement d'un transistor */
			if (ecrit)
				{
				
				switch ( LOPGE(buf,n) ) {
					case 2 :
					case 5 :
					case 6 :
					case 7 : /* pas de permutation des dimensions du bloc */
						ELSMB(buf,n,0);
						EWSMB(buf,n,l);
						break ;
					case 3 :
					case 4 :
					case 8 :
					case 9 : /* permutation des dimensions du bloc */
						ELSMB(buf,n,l);
						EWSMB(buf,n,0);
						break ;
					default : break;
				 } /* fin du switch */
				}
			ajout_bbab(nom, 0l, 0l, w+8l+(((w>>1)%2)<<1), l+(acc_ext(TRSPPOLY)<<1)+((acc_ext(TRSPPOLY)%2)<<1), (w>>1)+4l+((w>>1)%2), acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2), 0l, l);
			return(0);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nom,acc_nmotif(i))==0)
			{
			if (ecrit)
				{
				ELSMB(buf,n,2);
				EWSMB(buf,n,2);
				}
			ajout_bbab(nom,acc_xbbmotif(i), acc_ybbmotif(i), acc_dxbbmotif(i), acc_dybbmotif(i), acc_xabmotif(i), acc_yabmotif(i), acc_dxabmotif(i), acc_dyabmotif(i));
			return(0);
			}
	sprintf(nomfic,"%s%s.%s",acc_pathfile,nom,acc_suffphy);
	in=fopen(nomfic,LTE);
	if (in==0)
		{
		in=alcfopen(nom, acc_suffphy,LTE);
		if (in==0)
			return(NF) ;
		}
	fgets(ligne,255,in);
	i=0;
	sscanf(ligne,"V ALLIANCE 2.2 SETUP : %ld",&i);
	if (i!=acc_version)
		return(BAD);
/* Analyse de la ligne d'entete H */
	fgets(ligne,255,in);
	if (ligne[0]!='H')
		return(BAD);
	if ((paux=(char *)strchr(ligne,',')) == NULL) return(BAD);
	*paux='\0';
/* controle du nom */
	if (strcmp(ligne+2,nom)!=0)
		return(BAD);
	paux++;
/*controle du type de fichier */
	if (*paux!='P')
		return(BAD);
	ptemp=paux+2;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* index d'abutment box */
	i=atol(ptemp);
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* nombre de descripteur */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* controle de la mise a jour des chainages */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* lecture de la bounding box */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	xbb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	ybb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	dxbb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	dybb=atol(ptemp)<<1;
/* lecture et mise dans le cache de l'abutment box */
	if (i != -1)
		{
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			xab=atol(ptemp)<<1;
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			yab=atol(ptemp)<<1;
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			dxab=atol(ptemp)<<1;
			ptemp=paux+1;
			dyab=atol(ptemp)<<1;
			ajout_bbab(nom,xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab);
			if (ecrit)
				{
				
				switch ( LOPGE(buf,n) ) {
					case 2 :
					case 5 :
					case 6 :
					case 7 : /* pas de permutation des dimensions du bloc */
						ELSMB(buf,n,dxab);
						EWSMB(buf,n,dyab);
						break ;
					case 3 :
					case 4 :
					case 8 :
					case 9 : /* permutation des dimensions du bloc */
						ELSMB(buf,n,dyab);
						EWSMB(buf,n,dxab);
						break ;
					default : break;
				 } /* fin du switch */
				}
		}
	else
		{
			ajout_bbab(nom,xbb,ybb,dxbb,dybb,xbb,ybb,dxbb,dybb);
			if (ecrit)
				{
				
				switch ( LOPGE(buf,n) ) {
					case 2 :
					case 5 :
					case 6 :
					case 7 : /* pas de permutation des dimensions du bloc */
						ELSMB(buf,n,dxbb);
						EWSMB(buf,n,dybb);
						break ;
					case 3 :
					case 4 :
					case 8 :
					case 9 : /* permutation des dimensions du bloc */
						ELSMB(buf,n,dybb);
						EWSMB(buf,n,dxbb);
					break ;
					default : break;
				 } /* fin du switch */
				}
		}
	fclose(in);
	return(0);
}

charger(buf,nom)
desc *buf;
char *nom;
{
	FILE *in;
	char ligne[255]/*, sauve_det*/;
	char nomfic[10], * nommod, * paux, *ptemp;
	lnat nbdes,i,j,d,w,sens;
	lnat xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab;
	lnat inst_avant;
	type_bbab * pbbab;

	if (verif_transistor(nom,&d,&w))
		{
/* chargement d'un transistor */
			ENDES(buf,7);
/* connecteur */
/* source */
			ECLCL(buf,0);
			EES__(buf,0);
			ENIVE(buf,0,(nom[1]=='P')?GDIFP:GDIFN);
			ENOME(buf,0,"Source");
			EXSMB(buf,0,2);
			EYSMB(buf,0,((d>>2)<<1)+acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,0,0);
			EWSMB(buf,0,((d>>2)<<2)-6);
			EOOUE(buf,0);
			EH___(buf,0);
			ELL__(buf,0,0);
/* drain */
			ECLCL(buf,1);
			EES__(buf,1);
			ENIVE(buf,1,(nom[1]=='P')?GDIFP:GDIFN);
			ENOME(buf,1,"Drain");
			EXSMB(buf,1,w+6+(((w>>1)%2)<<1));
			EYSMB(buf,1,((d>>2)<<1)+acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,1,0);
			EWSMB(buf,1,((d>>2)<<2)-6);
			EOEST(buf,1);
			EH___(buf,1);
			ELL__(buf,1,0);
/* gate 1 */
			ECLCL(buf,2);
			EES__(buf,2);
			ENIVE(buf,2,GPOLY);
			ENOME(buf,2,"Gate");
			EXSMB(buf,2,(w>>1)+4+((w>>1)%2));
			EYSMB(buf,2,d+acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,2,0);
			EWSMB(buf,2,2);
			EONOR(buf,2);
			EV___(buf,2);
			ELL__(buf,2,0);
/* gate 2 */
			ECLCL(buf,3);
			EES__(buf,3);
			ENIVE(buf,3,GPOLY);
			ENOME(buf,3,"Gate");
			EXSMB(buf,3,(w>>1)+4+((w>>1)%2));
			EYSMB(buf,3,acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,3,0);
			EWSMB(buf,3,2);
			EOSUD(buf,3);
			EV___(buf,3);
			ELL__(buf,3,0);
/* segment */
/* dif */
			ECLCL(buf,4);
			ESEG_(buf,4);
			ENUEQ(buf,4,"*");
			EV___(buf,4);
			ENIVE(buf,4,(nom[1]=='P')?GDIFP:GDIFN);
			EXSMB(buf,4,(w>>1)+4+((w>>1)%2));
			EYSMB(buf,4,4+acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,4,d-8);
			EWSMB(buf,4,w+8);
			ELL__(buf,4,0);
/* poly */
			ECLCL(buf,5);
			ESEG_(buf,5);
			ENUEQ(buf,5,"*");
			EV___(buf,5);
			ENIVE(buf,5,TRSPPOLY);
			EXSMB(buf,5,(w>>1)+4+((w>>1)%2));
			EYSMB(buf,5,acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,5,d);
			EWSMB(buf,5,w);
			ELL__(buf,5,0);
/* Abutment Box */
			ECLCL(buf,6);
			EAB__(buf,6);
			EABI_(buf,6);
			EXSMB(buf,6,(w>>1)+4+((w>>1)%2));
			EYSMB(buf,6,acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2));
			ELSMB(buf,6,0);
			EWSMB(buf,6,d);
			ENOMB(buf,6,nom);
			ENOPR(buf,6,"Abutment Box");
			ELL__(buf,6,0);
			EOPGE(buf,6,GNOP);
			ajout_bbab(nom, 0l, 0l, w+8l+(((w>>1)%2)<<1), d+(acc_ext(TRSPPOLY)<<1)+((acc_ext(TRSPPOLY)%2)<<1), (w>>1)+4l+((w>>1)%2), acc_ext(TRSPPOLY)+(acc_ext(TRSPPOLY)%2), 0l, d);
			return(0);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nom,acc_nmotif(i))==0)
			{
			erreur(2,"");
			return(1);
			}
	sprintf(nomfic,"%s%s.%s",acc_pathfile,nom,acc_suffphy);
	in=fopen(nomfic,LTE);
	if (in==0)
		{
		in=alcfopen(nom, acc_suffphy,LTE);
		if (in==0)
			return(NF) ;
		}
	fgets(ligne,255,in);
	i=0;
	sscanf(ligne,"V ALLIANCE 2.2 SETUP : %ld",&i);
	if (i!=acc_version)
		return(STP);
/* Analyse de la ligne d'entete H */
	fgets(ligne,255,in);
	if (ligne[0]!='H')
		return(BAD);
	if ((paux=(char *)strchr(ligne,',')) == NULL) return(BAD);
	*paux='\0';
/* controle du nom */
	if (strcmp(ligne+2,nom)!=0)
		return(BAD);
	paux++;
/*controle du type de fichier */
	if (*paux!='P')
		return(BAD);
	ptemp=paux+2;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
/* index d'abutment box */
	EABI_(buf,i=atol(ptemp));
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
/* nombre de descripteur */
	nbdes=atol(ptemp);
	if(nbdes>TMAX)
		return(OVER);
	ENDES(buf,nbdes);
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	EDEBU(buf,atol(ptemp));
/* controle de la mise a jour des chainages --> mis dans status */
	ptemp=paux+1;
	RSTATL;
	ASTAT(EQUI,((*ptemp=='A')?VRAI:FAUX));
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* lecture de la bounding box */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	xbb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	ybb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	dxbb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	dybb=atol(ptemp)<<1;
/* lecture et mise dans le cache de l'abutment box */
	if (i != -1)
		{
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			xab=atol(ptemp)<<1;
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			yab=atol(ptemp)<<1;
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			dxab=atol(ptemp)<<1;
			ptemp=paux+1;
			dyab=atol(ptemp)<<1;
			ajout_bbab(nom,xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab);
			EXSMB(buf,i,xab);
			EYSMB(buf,i,yab);
			ELSMB(buf,i,dxab);
			EWSMB(buf,i,dyab);
			ENOMB(buf,i,nom);
			ENOPR(buf,i,"Abutment Box");
			ECLCL(buf,i);
			EAB__(buf,i);
			ENIVE(buf,i,acc_nbniv-1);
			EABI_(buf,i);
			ELL__(buf,i,0);
		}
	else
		ajout_bbab(nom,xbb,ybb,dxbb,dybb,xbb,ybb,dxbb,dybb);
	EENVX(buf,xbb+dxbb);
	EENVY(buf,ybb+dybb);
/* boucle de lecture */
	for(i=0,inst_avant = - 1/*,sauve_det = FAUX*/;;i++)
		{
			if (fgets(ligne,255,in)==NULL)
				return(BAD);
			if (strncmp(ligne,"EOF",3)==0)
				break;
			switch(ligne[0])
				{
					case 'C' :
						if ((paux=(char *)strchr(ligne+2,',')) == NULL) return(BAD);
						*paux='\0';
						j=atol(ligne+2);
						if (inst_avant > -1)
							{
							ASTAT(ZOOP,VRAI);
							EBLPA(buf,inst_avant);
							ELL__(buf,j,1);
/*							sauve_det = VRAI;*/
							}
						else
							{
							ELL__(buf,j,0);
							}
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EXSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EYSMB(buf,j,atol(ptemp)<<1);
						ELSMB(buf,j,0);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EWSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						switch(*ptemp)
							{
								case 'N' :
									EONOR(buf,j);
									EV___(buf,j);
									break;
								case 'S' :
									EOSUD(buf,j);
									EV___(buf,j);
									break;
								case 'E' :
									EOEST(buf,j);
									EH___(buf,j);
									break;
								case 'O' :
									EOOUE(buf,j);
									EH___(buf,j);
									break;
								default :
									return(BAD);
							}
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						for(xbb=0;xbb < acc_nbniv;xbb++)
							if (strcmp(ptemp,acc_nniv(xbb))==0)
								break;

						if (xbb >= acc_nbniv)
							return(BAD);
						ENIVE(buf,j,xbb);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ENOME(buf,j,ptemp);
						ECLCL(buf,j);
						ptemp=paux+1;
						if (*ptemp=='O')
							{
								ESORT(buf,j);
							}
						else
							if (*ptemp=='I')
								if (ptemp[2]=='O')
									{
										EES__(buf,j);
									}
								else
									{
										EENTR(buf,j);
									}
							else
								return(BAD);
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ECHAI(buf,j,atol(ptemp));
						paux++;
						if (*paux=='F')
							EFEQU(buf,j);
						else
							ECEQU(buf,j);
						break;
					case 'S' :
						inst_avant= -1;
						if ((paux=(char *)strchr(ligne+2,',')) == NULL) return(BAD);
						*paux='\0';
						j=atol(ligne+2);
						ELL__(buf,j,0);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EXSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EYSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ELSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EWSMB(buf,j,atol(ptemp)<<1);
						paux++;
						if (*paux=='H')
							EH___(buf,j);
						else
							EV___(buf,j);
						ptemp=paux+2;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						for(xbb=0;xbb < acc_nbniv;xbb++)
							if (strcmp(ptemp,acc_nniv(xbb))==0)
								break;

						if (xbb >= acc_nbniv)
							return(BAD);
						ENIVE(buf,j,xbb);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ENUEQ(buf,j,ptemp);
						ECLCL(buf,j);
						ESEG_(buf,j);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ECHAI(buf,j,atol(ptemp));
						paux++;
						if (*paux=='F')
							EFEQU(buf,j);
						else
							ECEQU(buf,j);
						break;
					case 'I' :
					case 'M' :
					case 'T' :
						if ((paux=(char *)strchr(ligne+2,',')) == NULL) return(BAD);
						*paux='\0';
						j=atol(ligne+2);
						ECLCL(buf,j);
						ELL__(buf,j,0);
						EBLMO(buf,j);
						if (ligne[0]=='T')
							{
								ETRAN(buf,j);
							}
						else
							if (ligne[0]=='M')
								{
								EMOTI(buf,j);
								}
							else
								{
								EBLOC(buf,j);
								}
						inst_avant=j;
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EXSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						EYSMB(buf,j,atol(ptemp)<<1);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ENOPR(buf,j,ptemp);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ENOMB(buf,j,ptemp);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						if (ligne[0] == 'M')
							i = atol(ptemp);
						else
						if (*ptemp=='N')
							i=2;
						else
							{
							if (*ptemp=='R')
								i = 3;
							if (*ptemp=='S')
								i = 5;
							if (ptemp[4]=='M')
								i += 1;
							if (ptemp[4]=='Y')
								i += 1;
							if (ptemp[3]=='X')
								i += 1;
							if (ptemp[3]=='R')
								i += 3;
							if ((i == 5) || (i == 6))
								if (i == 5)
									i = 6;
								else
									i = 5;
							}
						EOPGE(buf,j,i);
						nommod = LNOMB(buf,j);
						if ((pbbab = (type_bbab *) cherche_bbab(nommod))==NULL)
							{
							if (lire_ajout_bbab(buf,(cnat)j,nommod,VRAI))
								return(NFILS);
							}
						else
							{
							if (NMOTI(buf,j))
								switch((cnat)i)
								{
									case 2 :
									case 5 :
									case 6 :
									case 7 : /* pas de permutation des dimensions du bloc */
										ELSMB(buf,j,pbbab->dxab);
										EWSMB(buf,j,pbbab->dyab);
										break;
									case 3 :
									case 4 :
									case 8 :
									case 9 : /* permutation des dimensions du bloc */
										ELSMB(buf,j,pbbab->dyab);
										EWSMB(buf,j,pbbab->dxab);
										break;
									default : break;
								} /* fin du switch */
							else
								{
								ELSMB(buf,j,pbbab->dxab);
								EWSMB(buf,j,pbbab->dyab);
								}
							}
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ECHAI(buf,j,atol(ptemp));
						paux++;
						if (*paux=='F')
							EFEQU(buf,j);
						else
							ECEQU(buf,j);
						break;
					default :
						return(BAD);
				} /* switch */
		} /* for */
	fclose(in);
	ASTAT(MODI,VRAI);
	ELL__(fbuf1,(TMAX-2),(-1));
	harpic();
	num_eq=0;
	if (strcmp(nom, "BUFFE") != 0)
	{
		for(i=0;i< nbdes;i++)
			if ((TTRAN(buf,i)) && (NBLPA(buf,i)))
			{
				dzoomplus((cnat)i, buf);
				nbdes = LNDES(buf);
			}
	}
	return(0);
}

charg_log(buf,nom)
desc *buf;
char *nom;
{
	FILE *in;
	char ligne[255];
	char nomfic[10], * paux, *ptemp;
	lnat nbdes,i,j,d,w,sens;
	lnat xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab;

	if (verif_transistor(nom,&j,&j))
		{
		erreur(2,"");
		return(1);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nom,acc_nmotif(i))==0)
			{
			erreur(2,"");
			return(1);
			}
	sprintf(nomfic,"%s%s.%s",acc_pathfile,nom,acc_sufflog);
	in=fopen(nomfic,LTE);
	if (in==0)
		{
		in=alcfopen(nom, acc_sufflog,LTE);
		if (in==0)
			return(NF) ;
		}
	fgets(ligne,255,in);
	i=0;
	sscanf(ligne,"V ALLIANCE 2.2 SETUP : %ld",&i);
	if (i!=acc_version)
		return(BAD);
/* Analyse de la ligne d'entete H */
	fgets(ligne,255,in);
	if (ligne[0]!='H')
		return(BAD);
	if ((paux=(char *)strchr(ligne,',')) == NULL) return(BAD);
	*paux='\0';
/* controle du nom */
	if (strcmp(ligne+2,nom)!=0)
		return(BAD);
	paux++;
/*controle du type de fichier */
	if (*paux!='L')
		return(BAD);
	ptemp=paux+2;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	ptemp=paux+1;
/* nombre de descripteur */
	nbdes=atol(ptemp);
	if(nbdes>TMAX)
		return(OVER);
	ENDES(buf,nbdes);
/* boucle de lecture */
	for(i=0;;i++)
		{
			if (fgets(ligne,255,in)==NULL)
				return(BAD);
			if (strcmp(ligne,"EOF")!=0)
				break;
			switch(ligne[0])
				{
					case 'C' :
						if ((paux=(char *)strchr(ligne+2,',')) == NULL) return(BAD);
						*paux='\0';
						j=atol(ligne+2);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ENOME(buf,j,ptemp);
						ptemp=paux+1;
						if (*ptemp=='O')
							{
								ESORT(buf,j);
							}
						else
							if (*ptemp=='I')
								if (ptemp[2]=='O')
									{
										EES__(buf,j);
									}
								else
									{
										EENTR(buf,j);
									}
							else
								return(BAD);
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						ptemp=paux+1;
						switch(*ptemp)
							{
								case 'N' :
									EONOR(buf,j);
									break;
								case 'S' :
									EOSUD(buf,j);
									break;
								case 'E' :
									EOEST(buf,j);
									break;
								case 'O' :
									EOOUE(buf,j);
									break;
								default :
									return(BAD);
							}
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						ptemp=paux+1;
						EBUEQ(buf,j,atol(ptemp));
						break;
					case 'I' :
						if ((paux=(char *)strchr(ligne+2,',')) == NULL) return(BAD);
						*paux='\0';
						j=atol(ligne+2);
						ptemp=paux+1;
						if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
						*paux='\0';
						ENOPR(buf,j,ptemp);
						ptemp=paux+1;
						ENOMB(buf,j,ptemp);
						break;
					default :
						return(BAD);
				} /* switch */
		} /* for */
	if (i != nbdes)
		return(BAD);
	fclose(in);
	ASTAT(MODI,VRAI);
	num_eq=0;
	return(0);
}

dstocker(buf,nom,detaille)
desc *buf;
char *nom  ;
char detaille;
{
	FILE *in;
	char nomfic[TAILLE_CHAINE];
	lnat nbdes;
	lnat xmin,ymin,xmax,ymax,temp;
	cnat ja,ma,aa,ha,na,sa;
	lnat x, y, dx, dy;
	lnat i;

	if (verif_transistor(nom,&x,&x))
		{
		erreur(2,"");
		return(1);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nom,acc_nmotif(i))==0)
			{
			erreur(2,"");
			return(1);
			}
	if (strcmp(nom,"BUFFE") != 0)
		if (detaille)
			TSTAT(ZOOP,
				NSTAT(EQUI, extract(); ASTAT(EQUI,VRAI));
			)
			else
				{
				zpar();
				extract();
				ASTAT(EQUI,VRAI)
				}
		else 
			zbmmoins();
	sprintf(nomfic,"%s%s.%s",acc_pathfile,nom,acc_suffphy);
	harpic();
	in=fopen(nomfic,ETE);
	if(!in) return(1);
	ESTAT(buf,(status & 0xff0000ffl));
	xmax=ymax=0;
	xmin=ymin=1000000;
	ENOMP(buf,nom);
	nbdes = LNDES(buf);
	for(i=0;i<nbdes;i++)
		{	x = LX___(buf,i);
			y = LY___(buf,i);
			xmin = inf(xmin,x);
			ymin = inf(ymin,y);
			dx = LDX__(buf,i);
			dy = LDY__(buf,i);
			xmax = sup(xmax,x+dx);
			ymax = sup(ymax,y+dy);
		}
	xmax += xmax % 2;
	ymax += ymax % 2;
	xmin -= xmin % 2;
	ymin -= ymin % 2;
	EENVX(buf,xmax);
	EENVY(buf,ymax);
	if (fprintf(in,"V ALLIANCE 2.2 SETUP : %ld\n",acc_version) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	temp = LABI_(buf);
	if (fprintf(in,"H %s,P,%ld,%ld,",nom,temp,nbdes) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	sys_time(&ja,&ma,&aa,&ha,&na,&sa);
	if (fprintf(in,"%2d/%2d/%d,%ld,",ja,ma,aa,LDEBU(buf)) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	TSTAT(EQUI,
		if (fputs("A JOUR,",in) == EOF)
			{
			erreur(29,"");
			fclose(in);
			return(1);
			}
	)
	else
		if (fputs("PAS A JOUR,",in) == EOF)
			{
			erreur(29,"");
			fclose(in);
			return(1);
			}
	if (fprintf(in,"%ld,%ld,%ld,%ld,",xmin>>1,ymin>>1,(xmax-xmin)>>1,(ymax-ymin)>>1) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	if (temp == -1)
		{
		if (fputs("\n",in) == EOF)
			{
			erreur(29,"");
			fclose(in);
			return(1);
			}
		}
	else
		{
			x = LXSMB(buf,temp)>>1;
			y = LYSMB(buf,temp)>>1;
			dx = LLSMB(buf,temp)>>1;
			dy = LWSMB(buf,temp)>>1;
			if (fprintf(in,"%ld,%ld,%ld,%ld\n", x, y, dx, dy) == EOF)
				{
				erreur(29,"");
				fclose(in);
				return(1);
				}
			ENOMB(buf,i,nom);
		}
	for(i=0;i<nbdes;i++)
		{
			if (TAB__(buf,i))
				continue;
			if (TBLOC(buf,i))
				{
				x = LX___(buf,i)>>1;
				y = LY___(buf,i)>>1;
				if (fprintf(in,"I %ld,%ld,%ld,%s,%s,", i, x, y, LNOPR(buf,i), LNOMB(buf,i)) == EOF)
					{
					erreur(29,"");
					fclose(in);
					return(1);
					}
				switch(LOPGE(buf,i))
					{
						case 2  :
							if (fputs("NOSYM,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 3  :
							if (fputs("ROT_P,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 4  :
							if (fputs("ROT_M,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 5  :
							if (fputs("SYM_Y,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 6  :
							if (fputs("SYM_X,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 7  :
							if (fputs("SYMXY,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 8  :
							if (fputs("SY_RP,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						case 9  :
							if (fputs("SY_RM,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
						default :
							if (fputs("??,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							break;
					}
				temp = LCHAI(buf,i);
				if (TFEQU(buf,i))
					{
					if (fprintf(in,"%ld,FIN\n",temp) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					}
				else
					{
					if (fprintf(in,"%ld,NON\n",temp) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					}
				}
			else
				if (TMOTI(buf,i))
					{
					x = LX___(buf,i)>>1;
					y = LY___(buf,i)>>1;
					if (fprintf(in,"M %ld,%ld,%ld,%s,%s,%d,", i, x, y, LNOPR(buf,i), LNOMB(buf,i), LNIVE(buf,i)) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					temp = LCHAI(buf,i);
					if (TFEQU(buf,i))
						{
						if (fprintf(in,"%ld,FIN\n",temp) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					else
						{
						if (fprintf(in,"%ld,NON\n",temp) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					}
			else
				if (TTRAN(buf,i))
					{
					x = LX___(buf,i)>>1;
					y = LY___(buf,i)>>1;
					if (fprintf(in,"T %ld,%ld,%ld,%s,%s,", i, x, y, LNOPR(buf,i), LNOMB(buf,i)) == EOF)
						{
						erreur(29,"");
						fclose(in);
						return(1);
						}
					switch(LOPGE(buf,i))
						{
							case 2  :
								if (fputs("NOSYM,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 3  :
								if (fputs("ROT_P,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 4  :
								if (fputs("ROT_M,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 5  :
								if (fputs("SYM_Y,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 6  :
								if (fputs("SYM_X,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 7  :
								if (fputs("SYMXY,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 8  :
								if (fputs("SY_RP,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							case 9  :
								if (fputs("SY_RM,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								break;
							default :
								if (fputs("??,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
						}
					temp = LCHAI(buf,i);
					if (TFEQU(buf,i))
						{
						if (fprintf(in,"%ld,FIN\n",temp) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					else
						{
						if (fprintf(in,"%ld,NON\n",temp) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						}
					}
				else
					if (TES__(buf,i))
						{
						x = LXSMB(buf,i)>>1;
						y = LYSMB(buf,i)>>1;
						if (fprintf(in,"C %ld,%ld,%ld,%ld,", i, x, y, LWSMB(buf,i)>>1) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						switch(LORIE(buf,i))
							{
								case NORD :
									if (fputs("NORD,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
								case SUD :
									if (fputs("SUD,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
								case EST :
									if (fputs("EST,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
								case OUEST :
									if (fputs("OUEST,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									break;
							}
						
						
						if (fprintf(in,"%s,%s,",acc_nniv(LNIVE(buf,i)),LNOME(buf,i)) == EOF)
							{
							erreur(29,"");
							fclose(in);
							return(1);
							}
						if (TSERV(buf,i))
							{
							if (fputs ("INOUT,",in) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						else
							if (TENTR(buf,i))
								{
								if (fputs("IN,",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
							else
								if (TSORT(buf,i))
									{
									if (fputs("OUT,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									}
								else
									{
									if (fputs("XXX,",in) == EOF)
										{
										erreur(29,"");
										fclose(in);
										return(1);
										}
									}
						temp = LCHAI(buf,i);
						if (TFEQU(buf,i))
							{
							if (fprintf(in,"%ld,FIN\n",temp) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						else
							{
							if (fprintf(in,"%ld,NON\n",temp) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							}
						}
					else /* c'est un segment */
						{
							x = LXSMB(buf,i)>>1;
							y = LYSMB(buf,i)>>1;
							dx = LLSMB(buf,i)>>1;
							dy = LWSMB(buf,i)>>1;
							if (fprintf(in,"S %ld,%ld,%ld,%ld,%ld,%c,%s,%s,%ld,", i, x, y, dx, dy, (TH___(buf,i))?'H':'V', acc_nniv(LNIVE(buf,i)), LNUEQ(buf,i), LCHAI(buf,i)) == EOF)
								{
								erreur(29,"");
								fclose(in);
								return(1);
								}
							if (TFEQU(buf,i))
								{
								if (fputs("FIN\n",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
							else
								{
								if (fputs("NON\n",in) == EOF)
									{
									erreur(29,"");
									fclose(in);
									return(1);
									}
								}
						}
		} /* for */
	if (fputs("EOF\n",in) == EOF)
		{
		erreur(29,"");
		fclose(in);
		return(1);
		}
	fclose(in);
	ASTAT(MODI,VRAI);
	return(0);
}

/* lit le fichier de message */
charge(er,mes,flag,format)

        cnat er;
        char *mes;
        char *flag,*format;

        {


        int i=0;

        FILE *fp;
        char car;
        sprintf(mes,"");

        switch(config->nation)
                {
                case 0 : fp = fopen("frmes.mes",LTE);
                         break;
                case 1 : fp = fopen("ukmes.mes",LTE);
                         break;
                }
 if(fp == 0l)
        {
        dstocker(fbuf1,"BUFFE",FAUX);
        system("mode co80");
        printf("File frmes.mes not found.\n");
        printf("Current file backuped as BUFFE.AP.\n");
        printf("Contact LOLA Technical Support.\n");
        exit(0);
        }
        fseek(fp,(long)(64*(er-1)),0);
        *flag = (fgetc(fp))-48;
        *format = (fgetc(fp))-48;
        while((mes[i++] = fgetc(fp)) != '@');
        mes[i-1] = '\0';
        fclose(fp);
 }

#ifndef V_EXTERNE
load()

        {
        cnat temp;

	lundo = -3;
	close_menu();
        TSTAT(MODI,load1();)
        else
                {
                erreur(68,fichier);
                if(testchar("NNOY"))
                        {
                        load1();
                        }
                }
        return(0);
        }


load1()
{
	char buff[TAILLE_CHAINE];

	if (erreur(70,buff))
		return(1);
	eff_bbab();
	switch(charger(fbuf1,buff))
		{
			case 0   :
				sprintf(fichier,"%s",buff);
				break;
			case NF  :
				erreur(69,buff);
				if(testchar("NNOY"))
					{
						ENDES(fbuf1,0);
						EENVX(fbuf1,0);
						EENVY(fbuf1,0);
						EDEBU(fbuf1,-1);
						EABI_(fbuf1,-1);
						zoom = 0;
						set_mire(2l,2l);
						sprintf(fichier,"%s",buff);
						RSTAT;
					}
				break;
			case OVER:
				erreur(27,"");
				return(1);
			case BAD :
				erreur(28,"");
				ENDES(fbuf1,0);
				EENVX(fbuf1,0);
				EENVY(fbuf1,0);
				EDEBU(fbuf1,-1);
				EABI_(fbuf1,-1);
				zoom = 0;
				set_mire(2l,2l);
				sprintf(fichier,"%s",buff);
				RSTAT;
				return(1);
			case NFILS :
				erreur(44,"");
				ENDES(fbuf1,0);
				EENVX(fbuf1,0);
				EENVY(fbuf1,0);
				EDEBU(fbuf1,-1);
				EABI_(fbuf1,-1);
				zoom = 0;
				set_mire(2l,2l);
				sprintf(fichier,"%s",buff);
				RSTAT;
				return(1);
			case STP :
				erreur(87,"DE SETUP");
				m_valid();
				ENDES(fbuf1,0);
				EENVX(fbuf1,0);
				EENVY(fbuf1,0);
				EDEBU(fbuf1,-1);
				EABI_(fbuf1,-1);
				zoom = 0;
				set_mire(2l,2l);
				sprintf(fichier,"%s",buff);
				RSTAT;
				urefresh();
				return(1);
		}
	daffiche(LNDES(fbuf1),0);	
	informe();
	return(0);
}

load_log()
{
	char mes[TAILLE_CHAINE];
	char buff[TAILLE_CHAINE];
	lnat nbdes;
	cnat i=0;

	if (erreur(70,buff))
		return (1);
	switch(charg_log(fbuf1,buff))
		{
			case 0   :
				sprintf(fichier,"%s",buff);
				break;
			case NF  :
				erreur(69,buff);
				if(testchar("NNOY"))
					{
						ENDES(fbuf1,0);
						EENVX(fbuf1,0);
						EENVY(fbuf1,0);
						EDEBU(fbuf1,0);
						EABI_(fbuf1,-1);
						zoom = 0;
						set_mire(2l,2l);
						sprintf(fichier,"%s",buff);
					}
				break;
			case OVER:
				erreur(27,"");
				return(1);
			case BAD :
				erreur(28,"");
				return(1);
		}
	
	daffiche(LNDES(fbuf1),0);	
	informe();
	return(0);
}

bload()
        {
	close_menu();
        bload1();
        }

bload1()
{
	char buff[TAILLE_CHAINE];
	char nom[TAILLE_CHAINE];
	char nomb[TAILLE_CHAINE];
	char ligne[255];
	FILE *in;
	lnat n;
	char  * paux, *ptemp;
	lnat i,xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab;
	lnat lx,ly;
	type_bbab * pbbab;

	if (erreur(30,nom)) return(1);
	if (verif_transistor(nom,&i,&i))
		{
		erreur(2,"");
		return(1);
		}
	for(i=0;i < acc_nbmotif;i++)
		if (strcmp(nom,acc_nmotif(i))==0)
			{
			erreur(2,"");
			return(1);
			}
	if (LNDES(fbuf1)>TMAX-3)
		{
			erreur(13,"");
			return(1);
		}
	if ((pbbab = (type_bbab *)cherche_bbab(nom)) != NULL)
		{
			xbb = pbbab->xbb;
			ybb = pbbab->ybb;
			xab = pbbab->xab;
			yab = pbbab->yab;
			dxab = pbbab->dxab;
			dyab = pbbab->dyab;
		}
	else
	{
	sprintf(buff,"%s%s.%s",acc_pathfile,nom,acc_suffphy);
	if(!(in=fopen(buff,LTE)))
		{
		if(!(in=alcfopen(nom, acc_suffphy,LTE)))
			{
				erreur(3,"");
				return(1);
			}
		}
	fgets(ligne,255,in);
	i=0;
	sscanf(ligne,"V ALLIANCE 2.2 SETUP : %ld",&i);
	if (i!=acc_version)
		return(BAD);
/* Analyse de la ligne d'entete H */
	fgets(ligne,255,in);
	if (ligne[0]!='H')
		return(BAD);
	if ((paux=(char *)strchr(ligne,',')) == NULL) return(BAD);
	*paux='\0';
/* controle du nom */
	if (strcmp(ligne+2,nom)!=0)
		return(BAD);
	paux++;
/*controle du type de fichier */
	if (*paux!='P')
		return(BAD);
	ptemp=paux+2;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* index d'abutment box */
	i=atol(ptemp);
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* nombre de descripteur */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* controle de la mise a jour des chainages */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
/* lecture de la bounding box */
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	xbb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	ybb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	dxbb=atol(ptemp)<<1;
	ptemp=paux+1;
	if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
	*paux='\0';
	dybb=atol(ptemp)<<1;
/* lecture et mise dans le cache de l'abutment box */
	if (i != -1)
		{
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			xab=atol(ptemp)<<1;
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			yab=atol(ptemp)<<1;
			ptemp=paux+1;
			if ((paux=(char *)strchr(ptemp,',')) == NULL) return(BAD);
			*paux='\0';
			dxab=atol(ptemp)<<1;
			ptemp=paux+1;
			dyab=atol(ptemp)<<1;
			ajout_bbab(nom,xbb,ybb,dxbb,dybb,xab,yab,dxab,dyab);
		}
	else
		{
			ajout_bbab(nom,xbb,ybb,dxbb,dybb,xab = xbb,yab = ybb,dxab = dxbb,dyab = dybb);
		}
	fclose(in);
	} /* else */
	while(1)
	{
	n = LNDES(fbuf1);
	if (n>TMAX-3)
		{
			erreur(13,"");
			break;
		}
	if (erreur(36,nomb)) return(1);
	if (nomb[0] == '\0')
		{
		nomb[0] = '*';
		nomb[1] = '\0';
		}
	if (sinser(&lx,&ly,SXY,nom)) return(1);
	if ((xmire - (xab - xbb) < 0) || (ymire - (yab - ybb) < 0))
		{
			erreur(14,"");
			return(BAD);
		}
	ENOPR(fbuf1,n,nomb);
	ENOMB(fbuf1,n,nom);
	ECLCL(fbuf1,n);
	EBLOC(fbuf1,n);
	EBLMO(fbuf1,n);
	EOPGE(fbuf1,n,GNOP);
	ELL__(fbuf1,n,0);
	EXSMB(fbuf1,n,xmire);
	EYSMB(fbuf1,n,ymire);
	ELSMB(fbuf1,n,dxab);
	EWSMB(fbuf1,n,dyab);
	ENDES(fbuf1,n+1);
	aff_mire(OFF);
/* traitement du undo */
	lundo = -2;
	EXSMB(fbuf1,TMAX-2,n);
/**/
	dexpl((cnat)n);
	aff_mire(ON);
	}
	informe();
	RSTAT
	return(0);
}


save(detaille)
char detaille;
{
	char mes[TAILLE_CHAINE],bak[TAILLE_CHAINE];
	char buff[TAILLE_CHAINE];
	char flag;
	FILE *fp;

	lundo = -3;
	if(strcmp(fichier,"LOLA0"))
		{
			if (erreur(71,fichier))
				return(1);
			flag = testchar("NNOY");
		}
	if(( !flag ) || (!strcmp(fichier,"LOLA0")))
		{
			if (erreur(70,buff))
				return(1);
			sprintf(mes,"%s%s.%s",acc_pathfile,buff,acc_suffphy);
			if((fp=fopen(mes,LTE))!= 0l)
				{
					fclose(fp);
					erreur(55,mes);
					if(!(testchar("NNOY")))
						return(1);
					sprintf(bak,"%s%s.b%s",acc_pathfile,buff,acc_suffphy);
					sys_copy(mes,bak);
				}
			sprintf(fichier,"%s",buff);
		}
	else
		sprintf(buff,"%s",fichier);
	if(dstocker(fbuf1,buff,detaille))
		{
			erreur(29,"");
			return(1);
		}
	return(0);
}

/* charge un texte dans buf a partir du fichier nom */
chargt(buf,nom)
char *buf,*nom;
        {
        FILE *fp;
        char *ty;

        if(!(fp=fopen(nom,LTE))) return(1);
        ty=buf;
        while(fscanf(fp,"%c",ty)!=EOF) ty++;
        *ty= '\0';
        fclose(fp);
        return(0);
        }

charge_net(ne)
lnat *ne;
  {
  FILE *in;
  lnat u;
	char ligne[255],* paux;
	lnat i,j,inom;
   
   if(!(in=fopen("NETLIST",LBI))) return(1);
   fread(ne,sizeof(lnat),2,in);
    inom=ne[OFSOFS];
    fread(ne+2,sizeof(lnat),(int)inom-2,in);
    while(inom < ne[0])
        {
            fgets(ligne,255,in);
            paux = (char *)strchr(ligne,'\n');
            if (paux)
                        *paux = '\0';
            ne[inom]=(lnat)namealloc(ligne);
            i = inom+1;
            if ((ne[OFSCLE] & EQP)==EQP)
				{
                	j=inom+ne[OFSPAS];
            		fread(ne+i,sizeof(lnat),(int)(j-i),in);
                	inom+=ne[OFSPAS]+(ne[inom+ne[OFSPAS]-1]&MASK);
            		fread(ne+j,sizeof(lnat),(int)(inom-j),in);
				}
            else
				{
                	inom+=ne[OFSPAS];
            		fread(ne+i,sizeof(lnat),(int)(inom-i),in);
				}
       }
   fclose(in);
   return(0);
 }

/*sauve un setup */
savir(pset,nom)
type_setup *pset;
char *nom;
	{
	FILE *set;
	char mes[TAILLE_CHAINE];

	sprintf(mes,"%s.stp",nom);
	if((set=fopen(mes,EBI))==0) return(1);
	fwrite(pset,sizeof(type_setup),1,set);
	fclose(set);
	}

sauve_cont()
	{
	FILE *fp;

	fp=fopen("contexte.con",EBI);
	fwrite(setup,sizeof(type_setup),1,fp);
	fwrite(&dmenu,sizeof(cnat),1,fp);
	fwrite(&fmenu,sizeof(cnat),1,fp);
	fwrite(&bens,sizeof(bens),1,fp);
	fwrite(fichier,6,1,fp);
	fwrite(&xmire,sizeof(lnat),1,fp);
	fwrite(&ymire,sizeof(lnat),1,fp);
	fwrite(&xfen,sizeof(lnat),1,fp);
	fwrite(&yfen,sizeof(lnat),1,fp);
	fwrite(&xo,sizeof(lnat),1,fp);
	fwrite(&yo,sizeof(lnat),1,fp);
	fclose(fp);
	}

lire_cont(c)
char c;
	{
	FILE *fp;
	char buf[6];

	fp=fopen("contexte.con",LBI);
	fread(setup,sizeof(type_setup),1,fp);
	fread(&dmenu,sizeof(cnat),1,fp);
	fread(&fmenu,sizeof(cnat),1,fp);
	fread(&bens,sizeof(bens),1,fp);
	if (c=='f') fread(fichier,6,1,fp);
	else
	fread(buf,6,1,fp);
	if (c!='r')
	{
	fread(&xmire,sizeof(lnat),1,fp);
	fread(&ymire,sizeof(lnat),1,fp);
	fread(&xfen,sizeof(lnat),1,fp);
	fread(&yfen,sizeof(lnat),1,fp);
	fread(&xo,sizeof(lnat),1,fp);
	fread(&yo,sizeof(lnat),1,fp);
	}
	fclose(fp);
	}
#endif
