;	Static Name Aliases
;
	TITLE	bit
;	NAME	bit.C


pile	STRUC
	old_BP	DW	?
	old_DI	DW	?
	old_SI	DW	?
	old_DS	DW	?
	old_ES	DW	?
	old_BX	DW	?
	old_CX	DW	?
	old_DX	DW	?
	retour	DD	?
	param1	DW	?
	param2	DW	?
	param3	DW	?
	param4	DW	?
	param5	DW	?
	param6	DW	?
pile	ENDS
lvar	EQU	[BP - OFFSET old_BP]
;

_DATA	SEGMENT  WORD PUBLIC 'DATA'
direct	DW	?
x2	DW	?
y2	DW	?
xstep	DW	?
ystep	DW	?
_DATA	ENDS

EXTRN	__chkstk:FAR

BIT_TEXT      SEGMENT PUBLIC 'CODE'
	ASSUME	CS: BIT_TEXT, DS: _DATA

	PUBLIC	_bit
	PUBLIC	_plotxy
	PUBLIC	_v_pixel
	PUBLIC	_border
	PUBLIC	_color
	PUBLIC	_line
	PUBLIC	_invline
	PUBLIC	_textmode
	PUBLIC	_grafmode
	PUBLIC	_egamode

_bit	PROC FAR
	 push	 bp
	 mov	 bp,sp
	 mov	 ax,4
	 call	 FAR PTR __chkstk
; Line 3
;	chaine = 6
;	i = -4
; Line 5
	 push	ds
	mov	dx,[bp+10]
	mov	ds,[bp+12]
	mov	ah,1Ah
	int 21h
	 mov	 dX,[bp+6]	 ;chaine
	 mov	 dS,[bp+8]
	mov	ah,4Eh
	int 21h
	mov	dx,[BP+10]
	MOV	DS,[BP+12]
	mov ah,11H
	int 21h
	push	bp
	mov SI,DX
	mov ax,[SI+27]
	pop	bp
	pop	ds
; Line 6
	 mov	 sp,bp
	 pop	 bp
	 ret
dta:	db 'zone de dta il faut quelle fasse au moins 32 octets'
_bit	ENDP

;*********************************************************************
;* Fichier : PLOTXY.ASM                       date : ../../88        *
;*                                                                   *
;* Programmeur : Stphane                                            *
;*                                                                   *
;* Commentaires :                                                    *
;*      * Routines d'accs  la carte EGA                            *
;*                                                                   *
;*      * Accs du C :                                               *
;*   grafmode()         mise en mode EGA et effacement d'cran       *
;*   textmode()         mise en mode couleur 80x25                   *
;*   border(c)		Coloration du contour ecran                  *
;*   border(r,c)	Changement de la table des couleurs          *
;*   plotxy(x,y,c)      affichage du point (x,y)  la couleur : c    *
;*   c=getcol(x,y)      lecture de la couleur du point (x,y)         *
;*   line(x,y,dx,dy,c)  Dessin d'une ligne                           *
;*   invline(x,y,dx,dy) Dessin d'une ligne en couleur inverse        *
;*                                                                   *
;*      * Accs assembleur :                                         *
;*  _egamode     commande de la carte EGA                            *
;*  _positxy     affichage du point (x,y)  la couleur : c           *
;*********************************************************************
;

;*********************************************************************
;*      Commande de la carte EGA                                     *
;*                                                                   *
;* SPE : BH numro de commande                                       *
;*       BL paramtre de commande                                    *
;* SPS : AL,DX modifis                                              *
;*                                                                   *
;*********************************************************************
;
_egamode	PROC	NEAR
	MOV	DX,3CEh
	MOV	AL,BH
	OUT	DX,AL
	INC	DX
	MOV	AL,BL
	OUT	DX,AL
	RET
_egamode	ENDP
;
;*********************************************************************
;*      Calcul de l'octet mmoire d'un point en (X,Y)                *
;*                                                                   *
;* SPE : SI position sur l'cran en X                                *
;*       DX position sur l'cran en Y                                *
;* SPS : AX modifi                                                  *
;*       DI adresse OFFSET de l'octet image                          *
;*       CL indice du bit de l'octet image                           *
;*       BL valeur du masque d'affichage                             *
;*       CH = 0                                                      *
;*********************************************************************
;
_positxy	PROC	NEAR
	MOV	AX,80
	MUL	DX
	MOV	DI,SI
	SHR	DI,1
	SHR	DI,1
	SHR	DI,1
	ADD	DI,AX       	; Lig*80 + Col/8
;
	MOV	CX,SI
	AND	CX,7
	XOR	CL,7            ; Numbit a masquer
	MOV	BL,1
	SHL	BL,CL		; Calcul du mask
	RET
_positxy	ENDP
;
;*********************************************************************
;*                                                                   *
;*      MODE GRAPHIQUE 'ESUPER'                                      *
;*                                                                   *
;*********************************************************************
;
_grafmode	PROC	FAR
	MOV	AX,0010h
	INT	10h
	XOR	AX,AX
	RET
_grafmode	ENDP
;
;*********************************************************************
;*                                                                   *
;*      MODE TEXTE COULEUR 80 x 25                                   *
;*                                                                   *
;*********************************************************************
;
_textmode	PROC	FAR
	MOV	AX,0003h
	INT	10h
	XOR	AX,AX
	RET
_textmode	ENDP
;
;*********************************************************************
;*                                                                   *
;*      COULEUR DU CONTOUR ECRAN                                     *
;*                                                                   *
;*********************************************************************
;
_border	PROC	FAR
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	BP,SP
;
	MOV	BX,lvar.param1
	MOV	BH,BL
	MOV	AX,1001h
	INT	10h
	XOR	AX,AX
;
	POP	BP
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	POP	BX
	POP	CX
	POP	DX
	RET
_border	ENDP
;
;*********************************************************************
;*                                                                   *
;*      COULEUR DU CONTOUR ECRAN                                     *
;*                                                                   *
;*********************************************************************
;
_color	PROC	FAR
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	BP,SP
;
	MOV	BX,lvar.param1
	MOV	CX,lvar.param2
	MOV	BH,CL
	MOV	AX,1000h
	INT	10h
	XOR	AX,AX
;
	POP	BP
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	POP	BX
	POP	CX
	POP	DX
	RET
_color	ENDP
;
;*********************************************************************
;*                                                                   *
;*            PROCEDURE D'AFFICHAGE D'UN POINT                       *
;*                                                                   *
;*********************************************************************
;
_plotxy	PROC	FAR
;
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	BP,SP
;
	MOV	BX,0502h	; Init mode write2
	CALL	_egamode
;
	MOV	AX,0a000h	; Init segment cran
	MOV	DS,AX
;
	MOV	SI,lvar.param1	; X
	MOV	DX,lvar.param2	; Y
	CALL	_positxy        ; Calcul de l'octet ecran
;
	MOV	BH,08h		; Init registre de masque
	CALL	_egamode
;
	MOV	AL,DS:[DI]	; Ecriture selon le masque
	MOV	AX,lvar.param3	; COULEUR
	MOV	DS:[DI],AL
;
; Restauration de la carte EGA : write mode 0
;
	MOV	BX,0500h	; Init mode WRITE0
	CALL	_egamode
;
; restore mask register
;
	MOV	BX,08FFh	; Restore registre masque
	CALL	_egamode
;
; Dpilement des registres et fin de procedure
;
	XOR	AX,AX
	POP	BP
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	POP	BX
	POP	CX
	POP	DX
	RET
_plotxy	ENDP
;
;*********************************************************************
;*                                                                   *
;*            PROCEDURE DE LECTURE DE LA COULEUR D'UN POINT          *
;*                                                                   *
;*********************************************************************
;
_v_pixel	PROC	FAR
;
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	BP,SP
;
	MOV	AX,0a000h	; Init segment cran
	MOV	DS,AX
;
	MOV	SI,lvar.param1	;X
	MOV	DX,lvar.param2	;Y
	CALL	_positxy
;
;
	MOV	CH,BL
	MOV	BX,0403h
rread0:
	CALL	_egamode
	SHL	CL,1
	TEST	CH,DS:[DI]	; Lecture de la comparaison
	JZ	rread1
	OR	CL,1
rread1:
	DEC	BL
	JGE	rread0
;
; restore mask register
;
	MOV	BX,08FFh	; Restore registre masque
	CALL	_egamode
;
	MOV	AX,CX
	AND	AX,000Fh
;
; Dpilement des registres et fin de procedure
;
	POP	BP
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	POP	BX
	POP	CX
	POP	DX
	RET
_v_pixel	ENDP
;
;*********************************************************************
;*                                                                   *
;*            PROCEDURE D'AFFICHAGE D'UNE LIGNE GRAPHIQUE            *
;*                                                                   *
;*********************************************************************
;
_line	PROC	FAR
;
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	BP,SP
;
	MOV	BX,0502h	; Init mode write2
	CALL	_egamode
;
	MOV	AX,0a000h	; Init segment cran
	MOV	ES,AX
	MOV	AX,_DATA	; Init segment cran
	MOV	DS,AX
;
;
	MOV	SI,lvar.param1	; X
	MOV	xstep,1
	MOV	ystep,1
	MOV	AX,lvar.param3	; DX
	ADD	SI,AX
	INC	SI
	MOV	x2,SI
	TEST	AX,8000h
	JE	l1
	NEG	xstep
	NEG	AX
l1:
	MOV	DX,lvar.param2  ; Y
	MOV	BX,lvar.param4	; DY
	ADD	DX,BX
	INC	DX
	MOV	y2,DX
	TEST	BX,8000h
	JE	l2
	NEG	ystep
	NEG	BX
l2:
	MOV	SI,lvar.param1	; X
	MOV	DX,lvar.param2	; Y
	MOV	direct,0
	CMP	AX,0
	JNE	l10
	MOV	direct, -1
	JMP	l10
;
lineloop:
	PUSH	AX
	PUSH	BX
	PUSH	DX
	MOV	BX,lvar.param5  ; Couleur
	CALL	_positxy        ; Calcul de l'octet ecran
	MOV	BH,08h		; Init registre de masque
	CALL	_egamode
;
	MOV	AL,ES:[DI]	; Ecriture selon le masque
	MOV	AX,lvar.param5	; COULEUR
	MOV	ES:[DI],AL
;
	POP	DX
	POP	BX
	POP	AX
;
	TEST	direct,8000h
	JE	l9
	ADD	DX,ystep
	ADD	direct,AX
	JMP	l10
l9:
	ADD	SI,xstep
	SUB	direct,BX
l10:
;
	CMP	SI,x2
	JNE	lineloop
	CMP	DX,y2
	JNE	lineloop
;
; Restauration de la carte EGA : write mode 0
;
	MOV	BX,0500h	; Init mode WRITE0
	CALL	_egamode
;
; restore mask register
;
	MOV	BX,08FFh	; Restore registre masque
	CALL	_egamode
;
; Dpilement des registres et fin de procedure
;
	XOR	AX,AX
	POP	BP
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	POP	BX
	POP	CX
	POP	DX
	RET
;
_line	ENDP
;
;*********************************************************************
;*            PROCEDURE D'AFFICHAGE D'UNE LIGNE GRAPHIQUE            *
;*        EN COULEUR INVERSE PAR RAPPORT AU FOND DE L'ECRAN          *
;*********************************************************************
;
_invline	PROC	FAR
;
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	BP
	MOV	BP,SP
;
	MOV	AX,0a000h	; Init segment cran
	MOV	ES,AX
	MOV	AX,_DATA	; Init segment cran
	MOV	DS,AX
;
	MOV	BX,0502h	; Init mode write2
	CALL	_egamode
;
	MOV	SI,lvar.param1	; X
	MOV	DX,lvar.param2  ; Y
	MOV	xstep,1
	MOV	ystep,1
	MOV	AX,lvar.param3	; DX
	ADD	SI,AX
	MOV	x2,SI
	TEST	AX,8000h
	JE	il1
	NEG	xstep
	NEG	AX
il1:
	MOV	BX,lvar.param4	; DY
	ADD	DX,BX
	MOV	y2,DX
	TEST	BX,8000h
	JE	il2
	NEG	ystep
	NEG	BX
il2:
	MOV	SI,lvar.param1	; X
	MOV	DX,lvar.param2	; Y
	MOV	direct,0
	CMP	AX,0
	JNE	il10
	MOV	direct, -1
	JMP	il10
;
ilineloop:
	PUSH	AX
	PUSH	BX
	PUSH	DX
	CALL	_positxy        ; Calcul de l'octet ecran
;
	MOV	CH,BL
	MOV	AH,BL
	MOV	BX,0403h
iread0:
	CALL	_egamode
	SHL	CL,1
	TEST	CH,ES:[DI]	; Lecture de la comparaison
	JZ	iread1
	OR	CL,1
iread1:
	DEC	BL
	JGE	iread0
;
	MOV	BH,08h		; Init registre de masque
	MOV	BL,AH
	CALL	_egamode
;
	MOV	AL,ES:[DI]	; Ecriture selon le masque
	XOR	CL,0Fh
	MOV	ES:[DI],CL
;
	POP	DX
	POP	BX
	POP	AX
;
	TEST	direct,8000h
	JE	il9
	ADD	DX,ystep
	ADD	direct,AX
	JMP	il10
il9:
	ADD	SI,xstep
	SUB	direct,BX
il10:
;
	CMP	SI,x2
	JNE	ilineloop
	CMP	DX,y2
	JNE	ilineloop
;
; Restauration de la carte EGA : write mode 0
;
	MOV	BX,0500h	; Init mode WRITE0
	CALL	_egamode
;
; restore mask register
;
	MOV	BX,08FFh	; Restore registre masque
	CALL	_egamode
;
; Dpilement des registres et fin de procedure
;
	XOR	AX,AX
	POP	BP
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	POP	BX
	POP	CX
	POP	DX
	RET
;
_invline	ENDP

BIT_TEXT	ENDS
		END
