# include "include.h"
# include "edeclar.h"
# include "zeus.h"
# include "stat.h"
# include "ndefine.h"

# ifdef PC
# include "time.h"
# endif

# define DXFEUILLE 125  /* Dimensions de la feuille */
# define DYFEUILLE 88   /*       (en cm)            */

init_bens()
{
	char vert, rouge, bleu, noir;

	vert = 1;
	rouge = 2;
	bleu = 3;
	noir = 4;

	bens.coul[GCONT]    = noir ;
	bens.coul[GVIA]     = noir ;
	bens.coul[GALU1]    = bleu ;
	bens.coul[GALU2]    = noir ;
	bens.coul[GPOLY]    = rouge;
	bens.coul[GDIFN]    = vert ;
	bens.coul[GDIFP]    = vert ;
	bens.coul[TRSPPOLY] = rouge;
	bens.coul[TRSPALU1] = bleu ;
	bens.coul[TRSPALU2] = noir ;
	bens.coul[GCAISP]   = noir ;
	bens.coul[GCAISN]   = noir ;
	bens.coul[GNULL]    = noir ;
	bens.coul[28]       = noir ;
	bens.coul[29]       = noir ;

	bens.scale = 4;
	bens.mode = UNIF | TRES;
	bens.cle = COPI | CART | CADR;
}

benson1()
	{
	cnat i,pxy[4];
	char titre[16];
	char u=0;
	uchar couleur[5];

	couleur[0] = BLANC;
	couleur[1] = CVERT;
	couleur[2] = ROUGE;
	couleur[3] = BLEU;
	couleur[4] = BRUN;

	init_info();
	texte2(LTEXT,4,config->teinte[INFO],acc_titre,&info);



	while(1)
	{
	init_menu();
	pxy[0]=menu.xo>>1;pxy[1]=menu.yo>>1;
	pxy[2]=(menu.xo+menu.dx)>>1;pxy[3]=(menu.yo+menu.dy)>>1;
	strcpy(titre,(config->nation)?"COLORS":"COULEURS");
	texte2(((16-strlen(titre))/2)*LTEXT,menu.dy-2*HTEXT,config->teinte[TITRE],titre,&menu);
	for(i=0;i<acc_nbniv;i++)
		{
		sprintf(titre,"%s %c",acc_nniv(i),(couleur[bens.coul[i]]!=BLANC)?'#':' ');
		texte2(3*LTEXT,menu.dy-(i+4)*HTEXT,couleur[bens.coul[i]],titre,&menu);
		}
	texte2(3*LTEXT,menu.dy-(i+4)*HTEXT,couleur[bens.coul[29]],(config->nation)?"BLOCKS":"BLOCS",&menu);
	i++;
	texte2(3*LTEXT,menu.dy-(i+4)*HTEXT,couleur[bens.coul[28]],(config->nation)?"TEXT":"TEXTE",&menu);
	i++;
	texte2(3*LTEXT,menu.dy-(i+4)*HTEXT,config->teinte[CHOIX],(config->nation)?"POP":"RETOUR",&menu);
	if (c_souris(pxy,LTEXT,menu.dy-(u+4)*HTEXT,HTEXT,VRAI))
	{close_menu();return(1);}
	u+=ch;
	ch=(char)u;
	if ((ch<0)||(ch>acc_nbniv+1)) {close_menu();break;}
	if (ch<acc_nbniv) { if (bens.coul[u]<4) bens.coul[u]++;
			   else	bens.coul[u]=0;}
	if (ch==acc_nbniv) { if (bens.coul[29]<4) bens.coul[29]++;
			   else	bens.coul[29]=0;}
	if (ch==(acc_nbniv+1)) { if (bens.coul[28]<4) bens.coul[28]++;
			   else	bens.coul[28]=0;}
	}
	return(0);
	}


benson2()

	{
	cnat i,pxy[4],d;
	char titre[TAILLE_CHAINE];
	char u;
	static char tes1[17][16];
	type_bbab * pbbab;


	if ((pbbab = (type_bbab *)cherche_bbab(fichier))==NULL)
		if (lire_ajout_bbab(fbuf1,(cnat)LNDES(fbuf1),fichier,FAUX))
			return(1);
		else
			pbbab = (type_bbab *)cherche_bbab(fichier);
	strcpy(tes1[0],"  0.10 mm/l");
	strcpy(tes1[1],"  0.15 mm/l");
	strcpy(tes1[2],"  0.20 mm/l");
	strcpy(tes1[3],"  0.30 mm/l");
	strcpy(tes1[4],"  0.50 mm/l");
	strcpy(tes1[5],"  0.75 mm/l");
	strcpy(tes1[6],"  1.00 mm/l");
	strcpy(tes1[7],"  2.00 mm/l");
	strcpy(tes1[8],"  5.00 mm/l");
	strcpy(tes1[9]," 10.00 mm/l");

	u=0;
	while(1)
	{
	init_info();
	texte2(LTEXT,4,config->teinte[INFO],acc_titre,&info);
	init_menu();
	pxy[0]=menu.xo>>1;pxy[1]=menu.yo>>1;
	pxy[2]=(menu.xo+menu.dx)>>1;pxy[3]=(menu.yo+menu.dy)>>1;
	sprintf(titre,config->nation ? "SCALE" : "ECHELLE");
	texte2(((16-strlen(titre))/2)*LTEXT,menu.dy-2*HTEXT,config->teinte[TITRE],titre,&menu);
	for(i=0;i<10;i++)
		{
		sprintf(titre,"%s %c",tes1[i],(bens.scale==i)?'#':' ');
		texte2(1*LTEXT,menu.dy-(i+4)*HTEXT,config->teinte[CHOIX],titre,&menu);
		}
	i++;
	texte2(3*LTEXT,menu.dy-(i+4)*HTEXT,config->teinte[CHOIX],(config->nation)?"POP":"RETOUR",&menu);
	aff_taille(bens.scale,pbbab->dxbb,pbbab->dybb);
	if (c_souris(pxy,LTEXT,menu.dy-(u+4)*HTEXT,HTEXT,VRAI))
	{close_menu();return(1);}
	u+=ch;
	ch=(char)u;
	if ((ch<0)||(ch>10)) {close_menu();break;}
	else  bens.scale=u;
	}
	return(0);
	}

aff_taille(scale,xm,ym)

	cnat scale;
	lnat xm,ym;

	{
	float dx,dy;
	static float lbd[10] ={0.1,0.15,0.2,0.3,0.5,0.75,1.,2,5.,10.};
	char chaine[20];

	dx = (xm*lbd[scale])/10;
	dy = (ym*lbd[scale])/10+1;
	if(bens.cle & CART) dy+=1;
	if(bens.cle & CADR) {dx+=4;dy+=4;}

        strcpy(chaine,config->nation ? "SIZE" : "ENCOMBREMENT");
	texte2(((16-strlen(chaine))/2)*LTEXT,4+5*HTEXT,config->teinte[TITRE],chaine,&menu);

	if(dx<99999)
	sprintf(chaine,"%5.1f cm",dx);
	else
	strcpy(chaine,"OVER");
	texte2(6*LTEXT,4+3*HTEXT,(dx<DXFEUILLE) ? (config->teinte[CHOIX]) : CROUGE,chaine,&menu);

	if(dy<99999)
	sprintf(chaine,"%5.1f cm",dy);
	else
	strcpy(chaine,"OVER");
	texte2(6*LTEXT,4+2*HTEXT,(dy<DYFEUILLE) ? (config->teinte[CHOIX]) : CROUGE,chaine,&menu);
	}






benson3()
	{
	cnat i,pxy[4],d;
	char titre[16];
	char u;

	u=0;
	while(1)
	{
	i=0;
	init_info();
	texte2(LTEXT,4,config->teinte[INFO],acc_titre,&info);
	init_menu();
	pxy[0]=menu.xo>>1;pxy[1]=menu.yo>>1;
	pxy[2]=(menu.xo+menu.dx)>>1;pxy[3]=(menu.yo+menu.dy)>>1;
	strcpy(titre,config->nation ? "SETTINGS" : "OPTIONS");
	texte2(((16-strlen(titre))/2)*LTEXT,menu.dy-2*HTEXT,config->teinte[TITRE],titre,&menu);


	sprintf(titre,"%s %c",(config->nation)?"Unificat.":"Unificat.",(bens.mode & UNIF)?'#':' ');
	texte2(1*LTEXT,menu.dy-((i++)+4)*HTEXT,config->teinte[CHOIX],titre,&menu);
	sprintf(titre,"%s %c",(config->nation)?"I/O names":"Noms E/S ",(bens.mode & TRES)?'#':' ');
	texte2(1*LTEXT,menu.dy-((i++)+4)*HTEXT,config->teinte[CHOIX],titre,&menu);
	sprintf(titre,"%s %c",(config->nation)?"Copy file":"Copie fic",(bens.cle & COPI)?'#':' ');
	texte2(1*LTEXT,menu.dy-((i++)+4)*HTEXT,config->teinte[CHOIX],titre,&menu);
	sprintf(titre,"%s %c",(config->nation)?"Info     ":"Cartouche",(bens.cle & CART)?'#':' ');
	texte2(1*LTEXT,menu.dy-((i++)+4)*HTEXT,config->teinte[CHOIX],titre,&menu);
	sprintf(titre,"%s %c",(config->nation)?"Rulers   ":"Cadre    ",(bens.cle & CADR)?'#':' ');
	texte2(1*LTEXT,menu.dy-((i++)+4)*HTEXT,config->teinte[CHOIX],titre,&menu);




	i++;
	texte2(3*LTEXT,menu.dy-(i+4)*HTEXT,config->teinte[CHOIX],(config->nation)?"POP":"RETOUR",&menu);
	if (c_souris(pxy,LTEXT,menu.dy-(u+4)*HTEXT,HTEXT,VRAI))
	{return(1);}
	u+=ch;ch=(char)u;
	if ((ch<0)||(ch>4)) {return(1);}
	if (ch==0) bens.mode ^= UNIF;
	if (ch==1) bens.mode ^= TRES;
	if (ch==2) bens.cle  ^= COPI;
	if (ch==3) bens.cle  ^= CART;
	if (ch==4) bens.cle  ^= CADR;
	}
	}

benson4()
	{
	static nbtrace=0;
	char nomfic[TAILLE_CHAINE];

	if(!LNDES(fbuf1)) return(1);
	erreur(49,menus[dmenu].options[dfonc]+1);
	if (testchar("OYNN")) return(1);
	sprintf(nomfic,"%s%s.ben",acc_pathfile,fichier);
	if(!traceur(nomfic))
		{
		nbtrace++;
		erreur(95,nomfic);
		m_valid();
		}
	informe();
	}
/*********************************************************************/
/*                    TRACEUR BENSON                                 */
/*********************************************************************/
/* NATEGHI Bahman  COHEN Phillipe  release  02/88 GIORDANO Olivier   */
/*********************************************************************/




#define micb 16383          /*  nombre maximum d'increments par commandes  */
#define niv_imbrication 16  /*  nombre superieur au niveau d'imbrication maximum  */
#define tinc 0.05           /*  taille d'un increment en mm  */

/*  DECLARATION POUR LE TRACE DU CARTOUCHE  */
#define cart_mg         5   /*  espace entre 2 lignes en mm  */
#define cart_mh         2   /*  hauteur des lettres minuscules en mm  */
#define cart_ml         2   /*  largeur des lettres minuscules en mm  */
#define cart_Mh         5   /*  hauteur des lettres majuscules en mm  */
#define cart_Ml         5   /*  largeur des lettres majuscules en mm  */
#define esp_cartouche 680   /*  espace pris par le cartouche en increments  */

/* DECLARATION POUR LE TRACE DU CADRE */
#define ecr_marge 20        /*  marge de 20 increments pour les coordonnees :1 mm  */
#define chln_h    20        /*  echelon de 20 increments de hauteur :1 mm  */
#define car_hmm    2        /*  hauteur en mm des coordonnees  */
#define car_lmm    2        /*  largeur en mm des coordonnees  */
#define esp_cadre 180       /*  espace pris par un cote du cadre , en increments  */
#define p_trait  80         /*  petit trait  */
#define g_trait  110        /*  grand trait  */


#define SIZEB	40	/* Taille des caracteres (noms de blocs et d'E/S)  */
#define BLMIN 	SIZEB*4 /* Nombre min d'increments du dx d'un bloc pour que l'on*/
			/* puisse tracer son nom. 			*/


static unsigned char plniv[40];
static lnat benmaxx,benmaxy,benposx,benposy,ibenposx,ibenposy;  /* benmaxx,benmaxy:coordonnees maximums du circuit en lamda */
static lnat benminx,benminy;  /* benminx,benminy:coordonnees minimums du circuit en lamda */

FILE *pbenson;  /* pointeur sur le fichier resultat*/

/**************************************************************/
/*  TRACE DU CIRCUIT DONT LE FICHIER EST PRESENT EN MEMOIRE   */
/**************************************************************/

tracebens(nom,dx,dy,echelle,nomfic,nom_circuit)
char *nom;
lnat dx,dy;      /* taille de circuit */
lnat echelle;
char *nomfic;
char *nom_circuit;
{
	unsigned char car, carsymb;
	lnat x1,x2,y1;
	cnat date[6];
	cnat i;

	pbenson = fopen(nomfic,ETE);
	benminx= benminy= 0;
	benmaxx=dx;
	benmaxy=dy;

	vu('+');
	plniv[0] = bens.coul[29] ;
	for (i=0;i<acc_nbniv;i++)
		plniv[i+1] = bens.coul[i];
	dem_date(&date[0]) ;
	benposx=benposy=0;   /* position initiale de la plume */
	ibenposx=ibenposy=0; /* idem                          */
	vu('-');
	/*****************************************************/
	/*  DEPLACEMENT DE LA PLUME EN FONCTION DES OPTIONS  */
	/*****************************************************/
	if(bens.cle & CART )
	{
		fprintf(pbenson,"PL0 %d 0 ",esp_cartouche);
	}
	if(bens.cle & CADR )
	{
	  ibenposx=ibenposy=esp_cadre;
	  fprintf(pbenson,"NP0 PL%-5ld %5ld 0 ",ibenposx,ibenposy);
	}

	if(tracer_circuit(echelle))
		{
		fclose(pbenson);
		return(1);
		}

	/***********************************************/
	/*  TRACE DU CADRE ET DU CARTOUCHE DU CIRCUIT  */
	/***********************************************/

	/*  POSITIONNEMENT DE LA PLUME A L'ORIGINE DU CIRCUIT  */
	x1 = benposx+ibenposx ;
	y1 = benposy+ibenposy ;
	while(x1!=0 || y1!=0)
	{
		x2 =(x1 > micb) ? micb : x1 ;
		fprintf(pbenson,"PL-%-5ld -%-5ld 0 ",x2,y1);
		x1 -= x2;
		y1 = 0;


	}
	benposx = benposy = 0;


	/*****************************/
	/*  REALISATION DES OPTIONS  */
	/*****************************/
	if(bens.cle & CADR) cadre1(echelle);
	if(bens.cle & CART) cartouche(date,echelle);

	/****************************************************/
	/* nom du circuit et fermeture du fichier de sortie */
	/****************************************************/

	fprintf(pbenson,"PL0 -140 0 ");
	fprintf(pbenson,"SZ%d 0 0 %d ",(int)(cart_Ml*80/3),(int)(cart_Mh*80/3));
	fprintf(pbenson,"TX%d  %s              ",(cnat)(strlen(nom_circuit)+4),nom_circuit);
	fprintf(pbenson,"NT%d 0 ",(int)((cart_Ml*(cnat)(strlen(nom_circuit)+4))/ tinc));
	x1 = 102*cart_ml/tinc;
	x2 = 2*esp_cadre+benmaxx*echelle;
	x1 = sup(x1,x2);
	fprintf(pbenson,"PL%ld 0 0 ",x1);
	fprintf(pbenson,"PL0 0 0 \015 \015 \015 \015 ");
	fclose(pbenson);
	return(0);

}

/******************************************/
/*  TRACE DU DESCRIPTEUR POINTE PAR PD    */
/******************************************/
tracerect(pd,type,echelle)
cnat pd;     /* DESCRITEUR DU RECTANGLE */
char type;    /*  type ='r'  les coordonnees sont relatives a l'echelle
                 type <> 'r' les coordonnees sont absolues          */
lnat echelle;

{
	lnat x,y,dx,dy,x1,x2,y1,xd,yd,dxd,dyd,lxd,lyd;
	uchar plume;
	static unsigned char plact='*';        /*  plume dernierement selectionnee  */
 	char * nomb;

	plume=0;                    /*  Couleur par defaut               */

	vu('+');
	xd=LX___(fbuf1,pd);
	yd=LY___(fbuf1,pd);
	dxd=LDX__(fbuf1,pd);
	dyd=LDY__(fbuf1,pd);
	lxd=xd+dxd;lyd=yd+dyd;
	/***************************/
	/*  SELECTION DE LA PLUME  */
	/***************************/
	if (TNDES(fbuf1,pd))
		plume=bens.coul[29];
	if (TMOTI(fbuf1,pd))
		plume=bens.coul[LNIVE(fbuf1,pd)];
	if (NNDES(fbuf1,pd))
		plume=bens.coul[LNIVE(fbuf1,pd)];

	/************************************************************/
	/*  Ici on verifie si le circuit ne depasse pas la fenetre  */
	/************************************************************/


	if (type == 'r')
	{
		if ((xd>benmaxx) || (lxd<benminx) ||
		    (yd>benmaxy) || (lyd<benminy))
			{vu('-');return(1);}    /* rectangle hors de la fenetre */
		if(xd >= benminx) xd -= benminx;
		else {
			dxd -= benminx - xd;
			xd = 0;
		}
		if( yd >= benminy ) yd -= benminy;
		else {
			dyd -= benminy - yd;
			yd = 0;
		}
		if (lxd > benmaxx) dxd = benmaxx-benminx-xd;
		if (lyd > benmaxy) dyd = benmaxy-benminy-yd;
	}

	if(plume==0)
		{vu('-');return(1);}
	          /*  le descripteur n'est pas a tracer */
	plume--;
	if(plume!=plact)
	/*  GENERATION DE LA COMMANDE DE SELECTION DE PLUME  */
	{
		plact=plume;
		fprintf(pbenson,"NP%d  ",plact);
	}


	/******************************************************/
	/*  DEPLACEMENT DE LA PLUME A L'ORIGINE DU RECTANGLE  */
	/******************************************************/
	if(type == 'r') {
		x=echelle*xd;
		y=echelle*yd;
		dx = echelle*dxd;
		dy = echelle*dyd;
	}
	else {
		x=xd;
		y=yd;
		dx=dxd;
		dy=dyd;
	};

	x1 = x-benposx;
	y1 = y-benposy;
	while((x1!=0) ||(y1!=0))
	{
		if(x1>micb)
		{
			x2=micb;
			x1 -= micb;
		}
		else if(x1< (-1)*micb)
		{
			x2= (-1)*micb;
			x1 += micb;
		}
		else {
			x2 = x1;
			x1 = 0;
		}
		fprintf( pbenson,"PL%-6ld %-6ld 0  ",x2,y1);
		y1 = 0;
	}


	/************************************************************************************/
	/* TRACER DU RECTANGLE  la coordonnee en x n'est pas limitees a 16383 increments  */
	/************************************************************************************/


	if ((NMOTI(fbuf1,pd)) && (NAB__(fbuf1,pd)) && (TNDES(fbuf1,pd)) && (type == 'r'))
			{
			nomb = LNOPR(fbuf1,pd);
			if (strcmp(nomb,"*") == 0)
				{ nomb = LNOMB(fbuf1,pd); }
			if((dxd*echelle>=BLMIN) && (type == 'r'))
				TEXT1(pbenson,SIZEB,SIZEB,'h',nomb);
 			else
				TEXT(pbenson,SIZEB,SIZEB,'v',nomb);
			}

	if((bens.mode & TRES) && (type == 'r') && (TES__(fbuf1,pd)))
		if(dxd*echelle>=BLMIN)
			TEXT1(pbenson,SIZEB,SIZEB,'h',LNOME(fbuf1,pd));
		else
			TEXT(pbenson,SIZEB,SIZEB,'v',LNOME(fbuf1,pd));


	x1 = dx;
	while(x1!=0)
	{
		x2=(x1>micb) ? micb : x1 ;
		fprintf( pbenson,"PL%-5ld 0 1  ",x2);
		x1 -= x2;
	}
	fprintf( pbenson,"PL0 %-5ld 1  ",dy);
	x1 = dx;
	while(x1!=0)
	{
		x2=(x1>micb) ? micb : x1 ;
		fprintf( pbenson,"PL-%-5ld 0 1  ",x2);
		x1 -= x2;
	}
	fprintf( pbenson,"PL0 -%-5ld 1  ",dy);
	benposx = x;
	benposy = y;           /*  archivage de la nouvelle position  */
	/*****************************************/
	/*  ENVOI DE CARACTERES DE COMMANDE  */
	/*****************************************/
	fprintf( pbenson,"%c",'\0');
	vu('-');
}

/******************/
/* TRACE DU CADRE */
/******************/
cadre1(echelle)

lnat echelle;
{
	vu('+');
	mise_en_forme(0l,0l,(lnat)(2*esp_cadre+benmaxx*echelle),
	    (lnat)(2*esp_cadre+benmaxy*echelle),echelle);
	mise_en_forme((lnat)esp_cadre,(lnat)esp_cadre,benmaxx*echelle,benmaxy*echelle,echelle);
	if(!(bens.mode & TRES))
	graduation ((lnat)esp_cadre,(lnat)esp_cadre,(lnat)(benmaxx*echelle),(lnat)(benmaxy*echelle),echelle);
	vu('-');
}

/**********************/
/* TRACE DU CARTOUCHE */
/**********************/
cartouche(date,echelle)
cnat date[];
lnat echelle;
{
	int i;
	unsigned char plume;
	cnat dep=0;
	char bl[TAILLE_CHAINE];
	static float lbd[10]={
		0.1,0.15,0.2,0.3,0.5,0.75,1.,2.,5.,10. };

	strcpy(bl,"BLOCS");
	/**************************************************/
	/*  POSITIONNEMENT ET TRACE DE LA PREMIERE LIGNE  */
	/**************************************************/

	vu('+');
	/* impression d'une ligne de texte des diffrents materiaux utilises avec */
	/* leurs couleurs                                                        */
	fprintf(pbenson,"PL0 -%d 0 ",2*esp_cadre);
 	if(bens.coul[29]!= 0)
		{
		fprintf(pbenson,"NP%d ",bens.coul[29]-1);
		fprintf(pbenson,"SZ%d 0 0 %d ",(cnat)(cart_ml*80/3),(cnat)(cart_mh*80/3));
		fprintf(pbenson,"TX%d   %s  ",strlen(bl)+2,bl);
		fprintf(pbenson,"NT%d 0 ",(cnat)((strlen(bl)+2)*cart_ml/tinc));
/*		fprintf(pbenson,"PL%d 0 0 ",(cnat)((strlen(bl)+2)*cart_ml/tinc));*/
		dep += (cnat)((strlen(bl)+2)*cart_ml/tinc);
		}
for(i=0;i<acc_nbniv;i++)
	{
 	if(bens.coul[i] != 0)
		{
		fprintf(pbenson,"NP%d ",bens.coul[i]-1);
		fprintf(pbenson,"SZ%d 0 0 %d ",(cnat)(cart_ml*80/3),(cnat)(cart_mh*80/3));
		fprintf(pbenson,"TX%d   %s  ",strlen(acc_nniv(i))+2,acc_nniv(i));
		fprintf(pbenson,"NT%d 0 ",(cnat)((strlen(acc_nniv(i))+2)*cart_ml/tinc));
/*		fprintf(pbenson,"PL%d 0 0 ",(cnat)((strlen(acc_nniv(i))+2)*cart_ml/tinc));*/
		dep += (cnat)((strlen(acc_nniv(i))+2)*cart_ml/tinc);
		}
	}
fprintf(pbenson,"PL-%d 0 0 ",dep);


	/**************************************************/
	/*  POSITIONNEMENT ET TRACE DE LA DEUXIEME LIGNE  */
	/**************************************************/

	/* impression des coordonnees temporelles,de l'echelle et de la taille du */
	/* lambda correspondant ( en millimetres ).                               */

	fprintf(pbenson,"NP0 ");
	fprintf(pbenson,"PL0 -%d 0 ",(int)((cart_mg + cart_mh) / tinc));
	fprintf(pbenson,"SZ%d 0 0 %d  ",(int)(cart_ml*80/3),(int)(cart_mh*80/3));
	fprintf(pbenson,"TX80 le %2d\/%2d\/%2d a %2dH %2dmn %2dsec       echelle: %d  taille d'un lambda: %2.4f mm          ",
	    date[0],date[1],date[2],date[3],date[4],date[5],bens.scale,lbd[bens.scale]);
	fprintf(pbenson,"NT%d 0 ",(int)((cart_ml*80) / tinc));
	fprintf(pbenson,"PL-%d 0 0 ",(int)(cart_ml*80/tinc));
	vu('-');
}

/**************************************************************************/
/* saisie des coordonnees temporelles dans le cas du tracage du cartouche */
/**************************************************************************/

# ifdef PC
dem_date(date)
int date[];
{

	struct tm *localtime(),*temp;
	long   t,time();
	t=time(0L);
	temp=localtime(&t);
	date[0]=temp->tm_mday;
	date[1]=temp->tm_mon;
	date[2]=temp->tm_year;
	date[3]=temp->tm_hour;
	date[4]=temp->tm_min;
	date[5]=temp->tm_sec;
}
# endif

# ifndef PC
dem_date(date)
int date[];
{

	date[0]=0;
	date[1]=0;
	date[2]=0;
	date[3]=0;
	date[4]=0;
	date[5]=0;
}
# endif


/*********************************************************/
/*    Tracage d'un cadre       ou positionement          */
/*********************************************************/

mise_en_forme(x,y,dx,dy,echelle)
lnat x,y,dx,dy,echelle;
{

#ifdef TRACE
	printf("mise_en_forme  x:%ld,y:%ld,dx:%ld,dy:%ld\n", x,y,dx,dy);
#endif
	lnat nbdes;
	vu('+');
	nbdes = LNDES(fbuf1);
	EOPGE(fbuf1,nbdes,GNOP);
	EXSMB(fbuf1,nbdes,x);
	EYSMB(fbuf1,nbdes,y);
	ELSMB(fbuf1,nbdes,dx);
	EWSMB(fbuf1,nbdes,dy);
	EBLOC(fbuf1,nbdes);
	tracerect((cnat)nbdes,'c',echelle);
	vu('-');
}

/******************************************/
/*     Graduation du cadre                */
/******************************************/
graduation(x,y,benmaxx,benmaxy,echelle)
lnat x,y,benmaxx,benmaxy,echelle;
{
	lnat compt,px,py,trait;
	static lnat tabcoef[10] ={ 100,60,50,30,20,15,10,5,2,1 };
 	compt =0;
	px = x+echelle;
	/* px pointe sur le debut de cadre */
	mise_en_forme(px,y,0l,0l,echelle);
	/* graduation des abcisses */
	while( px< benmaxx+esp_cadre) {
		vu('+');
		compt+=(tabcoef[bens.scale]/5) ;
		if (compt % tabcoef[bens.scale] != 0) trait=(lnat)(p_trait);
		else trait=(lnat)(g_trait);
		fprintf(pbenson,"PL0 -%ld 1 ",trait);
		if (compt % tabcoef[bens.scale] ==0) ecrire1(compt,'v');
		fprintf(pbenson,"PL0 %ld 0 ",trait);
		px += (echelle*tabcoef[bens.scale]/5) ;
		mise_en_forme(px,y,0l,0l,echelle);
		vu('-');
	};
	benmaxy /= echelle ;
	benmaxy -= (benmaxy % (tabcoef[bens.scale]/5)) ;
	compt = benmaxy ;
	benmaxy *= echelle ;
	py = benmaxy-echelle+esp_cadre;
	/* py pointe sur la fin du cadre */
	mise_en_forme(x,py,0l,0l,echelle);
	/* graduation des ordonnees */
	while (py > y) {
		vu('+');
		compt-=(tabcoef[bens.scale]/5) ;
		if (compt % tabcoef[bens.scale] != 0) trait=(lnat)(p_trait);
		else trait=(lnat)(g_trait);
		fprintf(pbenson,"PL-%ld 0 1 ",trait);
		if (compt % tabcoef[bens.scale] ==0) ecrire1(compt,'h');
		fprintf(pbenson,"PL%ld 0 0 ",trait);
		py -=(echelle*tabcoef[bens.scale]/5) ;
		mise_en_forme(x,py,0l,0l,echelle);
		vu('-');
	};
}

/******************************************/
/*  ecriture des valeurs de graduation    */
/******************************************/

ecrire1(cpt,s)
lnat cpt;
char s;
{
	char tampon[20];
	sprintf(tampon,"%ld",cpt);
	TEXT(pbenson,30,30,s,tampon);
}



traceur(nomfic)
char *nomfic;
{
    FILE *in ;
    lnat dx,dy,p;
	type_bbab * pbbab;
	char nombak[TAILLE_CHAINE];
	static lnat cfech[10]={
		2,3,4,6,10,15,20,40,100,200}; /* l'echelle etant l'indice du tableau:nombre d'increments par lambda*/

	vu('+');
        sprintf(nombak,"%s",fichier);
	p=0;
	TSTAT(ZOOP, TSTAT(EQUI,p=1;))
	dstocker(fbuf1,"BUFFE",p);
	ENOMP(fbuf1,fichier);
	if (LABI_(fbuf1) > -1)
		ENOMB(fbuf1,p,fichier);
	if ((pbbab = (type_bbab *)cherche_bbab(fichier))==NULL)
		if (lire_ajout_bbab(fbuf1,(cnat)LNDES(fbuf1),fichier,FAUX))
			return(1);
		else
			pbbab = (type_bbab *)cherche_bbab(fichier);
	if(!(bens.cle & COPI))
		if(parcnet(0,0,1,0l)) return(1);
	if(bens.mode & UNIF) polygone1();
	vu('-');
	if(tracebens(fichier,pbbab->dxbb,pbbab->dybb,cfech[bens.scale],nomfic,nombak)) return(1);
charger(fbuf1,"BUFFE");
sprintf(fichier,"%s",nombak);
return(0);
}

/*******************************************************/
/*    Tracer le circuit en parcour recursif            */
/*******************************************************/
tracer_circuit(echelle)
	lnat echelle;

{
    uchar loop ;

	if(bens.coul[29] != 0)
		if(tparcours(255,echelle)) return(1);;
	if(bens.coul[28] != 0)
		if(tparcours(28,echelle)) return(1);;
	for(loop=0;loop<acc_nbniv;loop++)
		if(bens.coul[loop] != 0)
			if(tparcours(loop,echelle)) return(1);
	return(0);
}

tparcours(loop,echelle)

	uchar loop;
	lnat echelle;

	{
    lnat nbdes,dx,dy;
    uchar niv_a_exp;
	type_bbab * pbbab;

	nbdes = LNDES(fbuf1);
	niv_a_exp = 16 ;
	if ( bens.cle & COPI)
	  {
    vu('+');
	if ((pbbab = (type_bbab *)cherche_bbab(fichier))==NULL)
		if (lire_ajout_bbab(fbuf1,(cnat)nbdes,fichier,FAUX))
			return(1);
		else
			pbbab = (type_bbab *)cherche_bbab(fichier);
	EOPGE(fbuf1,nbdes,GNOP);
	EXSMB(fbuf1,nbdes,pbbab->xab - pbbab->xbb);
	EYSMB(fbuf1,nbdes,pbbab->yab - pbbab->ybb);
	ELSMB(fbuf1,nbdes,pbbab->dxab);
	EWSMB(fbuf1,nbdes,pbbab->dyab);
	EBLOC(fbuf1,nbdes);
	   parcourir((cnat)nbdes,niv_a_exp,loop,echelle) ;
    vu('-');
	  }
	else

		if(parcnet(loop,niv_a_exp,0,echelle)) return(1);
	return(0);
	}
/*******************************************************************/
parcourir(pere,niveau,loop,echelle)
cnat pere ;
uchar niveau ;
uchar loop ;
lnat echelle;
{
	lnat i, k;
	lnat nbdes;
	lnat dx,dy,nb;
	char * nom;
	char * nomb;
	char nivmotif;
	lnat xm, ym, dxm, dym;
	type_bbab * pbbab;

	nbdes = LNDES(fbuf1);
	dx = LDX__(fbuf1,pere);
	dy = LDY__(fbuf1,pere);
	nom = LNOMP(fbuf1);
	if ((pbbab = (type_bbab *)cherche_bbab(nom))==NULL)
		if (lire_ajout_bbab(fbuf1,pere,nom,FAUX))
			return(1);
		else
			pbbab = (type_bbab *)cherche_bbab(nom);
	for(i=0;i<nbdes;i++)
		{
		vu('+');
		if(LLL__(fbuf1,i) <= niveau)
		{
	 	if  (loop ==255)
			{
			if ((NMOTI(fbuf1,i)) && (TNDES(fbuf1,i)))
				{
				nomb = LNOMB(fbuf1,i);
				if ( type_simul(nomb) || (bens.cle & COPI) )
					{
					vu('+');
					dcalcul_coorddim(pere,i,pbbab->xab,pbbab->yab,pbbab->dxab,pbbab->dyab);
					tracerect(i,'r',echelle);
					vu('-');
					}
				}
			}
		else
			{
			if (TMOTI(fbuf1,i))
				{
				nivmotif = LNIVE(fbuf1,i);
				xm = LXSMB(fbuf1,i);
				ym = LYSMB(fbuf1,i);
				dxm = LLSMB(fbuf1,i);
				dym = LWSMB(fbuf1,i);
				for(k = 0; k < acc_nbsegmotif(nivmotif); k++)
					if (acc_layersegmotif(nivmotif,k) == loop)
						{
						EXSMB(fbuf1,i,xm + acc_xsegmotif(nivmotif,k) - (acc_xabmotif(nivmotif) - acc_xbbmotif(nivmotif)));
						EYSMB(fbuf1,i,ym + acc_ysegmotif(nivmotif,k) - (acc_yabmotif(nivmotif) - acc_ybbmotif(nivmotif)));
						ELSMB(fbuf1,i,acc_dxsegmotif(nivmotif,k));
						EWSMB(fbuf1,i,acc_dysegmotif(nivmotif,k));
						ENIVE(fbuf1,i,acc_layersegmotif(nivmotif,k));
						EBLOC(fbuf1,i);
						dcalcul_coorddim(pere,i,pbbab->xab,pbbab->yab,pbbab->dxab,pbbab->dyab);
						EMOTI(fbuf1,i);
						tracerect(i,'r',echelle);
						EXSMB(fbuf1,i,xm);
						EYSMB(fbuf1,i,ym);
						ELSMB(fbuf1,i,dxm);
						EWSMB(fbuf1,i,dym);
						ENIVE(fbuf1,i,nivmotif);
						}
			}
			else
			if ((NNDES(fbuf1,i)) && (TNIVE(fbuf1,i,loop)))
				{
					dcalcul_coorddim(pere,i,pbbab->xab,pbbab->yab,pbbab->dxab,pbbab->dyab);
					tracerect(i,'r',echelle);
				}
			}
		}
		vu('-');
		}
}


/*****************************************************************************/
/*                     DEMANDE L'ECRITURE D'UN TEXTE                         */
/*****************************************************************************/

TEXT(pbens,lh,hh,s,texte)
FILE *pbens;           /* Nom logique du fichier de sortie    */
cnat lh,               /* Hauteur de caractere    */
     hh;	       /* Largeur de caractere    */
unsigned char s;       /* Sens d'ecriture         */
char *texte;	       /* Texte a ecrire          */

{
	cnat i=0,em,retour;
	while(texte[i] != '\0')
		++i;
	if(s=='v')
	{
                em=lh*i/2;
		fprintf(pbens,"PL-%d -%d 0 \015\012",lh,hh);
		fprintf(pbens,"SZ%d 0 0 %d ",lh,hh);
		fprintf(pbens,"TX%d %s ",i,texte);
		fprintf(pbens,"NT%d 0 \015\012",em);
		if( i==1) retour=lh/2; 
		   else retour=(-((lh/2)*(i-2)));
		fprintf(pbens,"PL%d %d 0 \015\012 ",retour,hh);
	}
	else
	{
                em=lh*i/2;
		fprintf(pbens,"PL-%d 0 0 \015\012 ",em);
		fprintf(pbens,"SZ%d 0 0 %d ",lh,hh);
		fprintf(pbens,"TX%d %s ",i,texte);
		fprintf(pbens,"NT%d 0 \015\012",em);
	}
}



TEXT1(pbens,lh,hh,s,texte)
FILE *pbens;           /* Nom logique du fichier de sortie    */
cnat lh,               /* Hauteur de caractere    */
     hh;	       /* Largeur de caractere    */
unsigned char s;       /* Sens d'ecriture         */
char *texte;	       /* Texte a ecrire          */

{
	cnat i=0,em,retour;
	while(texte[i] != '\0')
		++i;
	if(s=='v')
	{
                em=lh*i/2;
		fprintf(pbens,"PL-%d -%d 0 \015\012",0,em);
		fprintf(pbens,"SZ%d 0 0 %d ",lh,hh);
		fprintf(pbens,"TX%d %s ",i,texte);
		fprintf(pbens,"NT%d 0 \015\012",em);
	}
	else
	{
                em=0;
  		fprintf(pbens,"PL-%d 0 0 \015\012 ",em);
		fprintf(pbens,"SZ%d 0 0 %d ",lh,hh);
		fprintf(pbens,"TX%d %s ",i,texte);
    		fprintf(pbens,"NT%d 0 \015\012",em);
	}
}




parcnet(loop,niv_a_exp,reset,echelle)

	uchar loop;
	uchar niv_a_exp;
	uchar reset;
	lnat echelle;

{
    lnat p;
    lnat *entnet;
    lnat nbdes,dx,dy;
    lnat nomb,x,y;
    type_bbab *pbbab;
    uchar llex,opgeom;
    static lnat nbbloc;
    static lnat blocour;
    static lnat passtot;
    cnat i;
    char pourcent[20];

	if(reset) {
	 	  passtot=0;
 		  for(i=0;i<30;i++)
			if(bens.coul[i] !=0) passtot++;
		  blocour=0;

		TSTAT(NETB, {})
		else
			{
			ENOMP(fbuf1,fichier);
			if (LABI_(fbuf1) > -1)
				ENOMB(fbuf1,p,fichier);
       		  	if(netlist((lnat)(T2MAX*8),6162l,(lnat *)fbuf2,(char *)fbuf1))
				{
				charger(fbuf1,"BUFFE");
 				return(1);
				}
 			ASTAT(NETI,FAUX)
 			ASTAT(NETH,FAUX)
 			ASTAT(NETL,FAUX)
 			ASTAT(NETB,VRAI)
			}
		return(0);

               }
	charge_net((lnat *)fbuf2);
	entnet=(lnat*)fbuf2;
	p=entnet[OFSOFS];
	nbbloc=(cnat)entnet[OFSNBL];
	   while ( (entnet[OFSNBL])-- )
	     {
		blocour++;
		sprintf(pourcent,"%02ld %%",(blocour*100)/( nbbloc * passtot ));
		texte2(info.dx-6*LTEXT,4,config->teinte[CHOIX],pourcent,&info);
		nomb=p++;
		llex=(uchar)entnet[p++];
		x=entnet[p++];
		y=entnet[p++];
		opgeom=entnet[p++];
		if ( llex <= niv_a_exp)
			{
			vu('+');
			charger(fbuf1,(char *)entnet[nomb]);
			if(bens.mode & UNIF) polygone1();
			nbdes = LNDES(fbuf1);
			if ((pbbab = (type_bbab *)cherche_bbab((char *)entnet[nomb]))==NULL)
				if (lire_ajout_bbab(fbuf1,(cnat)nbdes,(char *)entnet[nomb],FAUX))
					return(1);
				else
					pbbab = (type_bbab *)cherche_bbab((char *)entnet[nomb]);
			EBLOC(fbuf1,nbdes);
			EXSMB(fbuf1,nbdes,x);
			EYSMB(fbuf1,nbdes,y);
			ELSMB(fbuf1,nbdes,pbbab->dxab);
			EWSMB(fbuf1,nbdes,pbbab->dyab);
			EOPGE(fbuf1,nbdes,opgeom);
			ELL__(fbuf1,nbdes,llex);
			parcourir((cnat)nbdes,0,loop,echelle) ;
			vu('-');
			}
	    }
	return(0);
      }



