/************************************************************
   Copyright (C) 1993 by The Trustees of Columbia University in the City 
   of New York

   OBJECT-ORIENTED Protein Data Bank Project
   Biochemistry and Molecular Biophysics, Computer Science depts.
 **************************************************************

   File: i_aa.h
   Responsable: Weider Chang, Ph.D

 **************************************************************/
#ifndef _H_COREAARESIDUE
#define _H_COREAARESIDUE

#include "oopdb_setup.h"
#include "structure.h"

class IntrAAResidue : public SubEntity {
 protected:  
  IntrAAResidue(char* name) : SubEntity(name) {}
  ~IntrAAResidue();

 public:
#if NEED_CALC

  double phi_angle(int =0) const;
  double psi_angle(int =0) const;
  double delta_omega(int =0) const;
  double omega_angle(int =0) const;

#endif  

};

class IntrNucleotide : public SubEntity {
 protected:
  IntrNucleotide(char* name) : SubEntity(name) {}
};

class IntrSaccharide : public SubEntity {
 protected:
  IntrSaccharide(char* name) : SubEntity(name) {}
};

class HetMonomer;

class IntrHetMonomer : public SubEntity {
 protected:
  IntrHetMonomer(char* name) : SubEntity(name) {};

 public:
  HetMonomer *next_het_subentity(){return (HetMonomer*)next_p;}
};


#endif

#ifdef _H_AARESIDUE_LEVEL
#define _CORECAARESIDUE

class IntrCAAResidue : public AAResidue {
 protected:
  IntrCAAResidue(char* name) : AAResidue(name) {}

 public:
  Atom * N_atom() const {return d_atom_p;}
  Atom * CA_atom() const {
    Atom *atom_p=N_atom();
    if (atom_p) atom_p=atom_p->next_atom_p();
    return atom_p;
  }
  Atom * C_atom() const {
    Atom *atom_p=CA_atom();
    if (atom_p) atom_p=atom_p->next_atom_p();
    return atom_p;
  }
  
};

class IntrNCAAResidue : public AAResidue {
 protected:
  IntrNCAAResidue(char* name) : AAResidue(name) {}
};

class IntrCNucleotide : public Nucleotide {
 protected:
  IntrCNucleotide(char* name) : Nucleotide(name) {}
};

class IntrNCNucleotide : public Nucleotide {
 protected:
  IntrNCNucleotide(char* name) : Nucleotide(name) {}
};

#endif






