/*  


                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  


*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "maxdefs.h"

#define CONV_ATOMS 57

extern void PrintMessage();
extern char *cvector();
extern float sumx,sumy,sumz;
extern char *GetAtmName();
extern int MSDdataWrite();
extern int PowerDataWrite();
extern int TrajectoryStepFrame();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern int   GetResNum1();
extern float GetBValue();
extern char *GetSegName();
extern char *GetResName();
extern char *GetAtmName();
extern int    CalcCluster();
extern int    DeleteClusterData();
extern int    GetClusterSpace();
extern int    PutClusterData();

    extern struct {
      int corr_wind;   /* switch to indicate that window is on = 1 , off = 0 */
      int corr_vec1;   /* number of correlation vector 1 */
      int corr_vec2;   /* number of correlation vector 2 */
      int corr_obs;    /* number of points in vectors 1 and 2 */
      float *corr_val;} /* pointer to the correlation values */  
    corr_info;

    extern  int *phi_i;  /* index array to phi torsion angle array */
    extern  int *psi_i;  /* index array to psi torsion angle array */
    extern  int *omega_i;  /* index array to omega torsion angle array */
    extern  int phi_e;     /* length of array */
    extern  int psi_e;
    extern  int omega_e;
    extern  float *phi_v;  /* the real values */
    extern  float *psi_v;
    extern  float *omega_v;

     extern int minres1;
     extern int maxres1;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern char   *atnam;
     extern char   *resnam;
     extern char   *segment;
     extern float  *bvalue;
     extern int    *res1;
     extern int    *res2;
     extern float  *x;
     extern float  *y;
     extern float  *z;
     extern char   *disp_list;
     extern int current_struct;
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int traj_file_set;

    extern  struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu;

    extern struct {
       int NumSets;
       float *DataArray;
     } ClusterData;

     extern char parsed[MAXparse][MAXlinel];
     extern int dynamics_pasback[20];

     int WriteClusterData();

/************************************************************************/
write_fac(input,num)   /* write command */
   char *input; 
   int num;
/************************************************************************/
{

  
     static char *wrf = "\n\
 ************************  write facility ******************\n\
   write time arra*y/list nr file.ext  ! Write time list/array to disk \n\
         clus*ter data file.ext        ! Write cluster data to file \n\
         corr*elation arra*ay file.ext ! Write correlation series to disk \n\
         coor*dinates free file.ext [dm]   ! Write coordinates in free format \n\
                      char*mm file.ext [dm]! Write coordinates in CHARMm format\n\
                      b&s  file.ext [dm]   ! Write a ball & stick input file\n\
                      pdb  file.ext [dm]   ! Write coordinates in PDB format \n\
         msdi*splacement file.ext      ! Write MSD array to file\n\
         powe*rspectrum file.ext       ! Write PS array to file\n\
         rdf  file.ext                 ! Write the RDF to disk\n\
         seco*ndary stru*cture file.ext! Write phi,psi and omega angles \n\
     \n\
 ************************  end of help    *******************\n";

     int i;
     int ihelp;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
    toller(parsed[1]);

   if(indexo(parsed[1],"?") == 1) {
     printf("%s\n",wrf);
     return;}

/* write filled array from dynamics facility          */
/* write time array nr file.name                           */
   if(indexo(parsed[1],"time") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"list") == 1) {
/* check file name */
   if(parsed[4][0] == '\0') strncpy(parsed[4],"TIME.SERIES",MAXlinel);
     study_dynamics(22);
   return;}
   }

/* write correlation array file.name                           */
   if(indexo(parsed[1],"corr") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"list") == 1) {  
/* see if there is something to write */
       if(corr_info.corr_obs == 0) {
         PrintMessage("?ERROR - no correleation data to write ");
         return;}
/* check file name */
   if(parsed[3][0] == '\0') strncpy(parsed[3],"CORR.SERIES",MAXlinel);

      write_corr(parsed[3]);

   return;}
   }

/* write phi, psi and omega angles */
   if(indexo(parsed[1],"seco") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"stru") == 1) {
        if(phi_e == 0 && psi_e == 0 && omega_e == 0) {
        PrintMessage("?ERROR - no secondary data to write ");
        return;}

        write_seco(parsed[3]);

        return;}
     }

/* write coordinates in (CHARMM) free coordinates */
    if(indexo(parsed[1],"coo") == 1) {
       toller(parsed[2]);

         ihelp = 0;
         toller(parsed[4]);
         if(indexo(parsed[4],"dm") == 1) { /* use current display mask */
            ihelp = 1;}

       if(indexo(parsed[2],"free") == 1) {
       write_coord_free(parsed[3] , ihelp);
       return;}
       if(indexo(parsed[2],"pdb") == 1) {
       write_coord_pdb(parsed[3] , ihelp);
       return;}
       if((indexo(parsed[2],"char") == 1) ||
          (indexo(parsed[2],"karp") == 1)) {
       write_coord_charmm(parsed[3] , ihelp);
       return;}
       if(indexo(parsed[2],"b&s") == 1) {  /* ball & stick format */
         ihelp = 0;
         toller(parsed[4]);
         if(indexo(parsed[4],"dm") == 1) { /* use current display mask */
            ihelp = 1;}
       write_coord_BaS(parsed[3] , ihelp);
       return;}
    }

/* write the RDF to disk                    */
    if(indexo(parsed[1],"rdf") == 1) {
        if(write_RDF(parsed[2])) return;
       return;
    }

/* write the mean square displament to disk                    */
    if(indexo(parsed[1],"msdi") == 1) {
        if(MSDdataWrite(parsed[2])) return;
       return;
    }

/* write the POWER spectrum to disk                    */
    if(indexo(parsed[1],"powe") == 1) {
        toller(parsed[3]);
          ihelp = 0;
        if(indexo(parsed[3],"freq") == 1)
          ihelp = 1;
        if(PowerDataWrite(parsed[2] , ihelp)) return;
       return;
    }

/* write cluster data to disk                    */
    if(indexo(parsed[1],"clus") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"data") == 1) {
        if(WriteClusterData(parsed[3] , "#Default cluster title")) return;}
       return;
      }

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of write_fac */

/************************************************************************/
write_to_disk(obs_vec_point,obs_vec,numset)
       int obs_vec_point;
       int numset;
       float *obs_vec;
/************************************************************************/
{

     FILE *write_p;
     int nr;
     int i;
     int ihelp;
     char OutText[BUFF_LEN];
     int Step;

     if(parsed[4][0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?' ");
       return;}

     nr = atoi(parsed[3]);
     ihelp = dynamics_pasback[2];

     if(nr < 1 || nr > obs_vec_point) {
     sprintf(OutText,"?ERROR - you are trying to write a non existing array (%d)\n",nr);
     PrintMessage(OutText);
        return;}

     write_p = fopen(parsed[4],"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : %s ",parsed[4]);
       PrintMessage(OutText);
        return;}

/* ready to write now ... */
     sprintf(OutText,"Writing array nr: %d to file '%s' on disk ",nr,parsed[4]);
     PrintMessage(OutText);

     if(ihelp < 1) {
        PrintMessage("?WARNING - I don't know the time between the frames");
        ihelp = 1;}

     Step = TrajectoryStepFrame();

     if(traj_file_set == 5) {  /* mumod trajectories start from time = 0 */
     for(i = 0 ; i < numset ; i++) {
       fprintf(write_p," %d %f \n",Step * ihelp * i,
               obs_vec[i + (nr-1) * numset]);}
     }
     else {
     for(i = 0 ; i < numset ; i++) {
       fprintf(write_p," %d %f \n", ihelp * (Step * i + 1),
       obs_vec[i + (nr-1) * numset]);}
     }

     fclose(write_p);
}

/************************************************************************/
write_corr(text)
      char *text;
/************************************************************************/
{

     FILE *write_p;
     int i,ihelp;
     char OutText[BUFF_LEN];

     if(text[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?' ");
       return;}

     write_p = fopen(text,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : '%s' ",text);
       PrintMessage(OutText);
        return;}

/* ready to write now ... */
     sprintf(OutText,"Writing correlation series to file '%s' on disk",text);
     PrintMessage(OutText);

     ihelp = dynamics_pasback[2];

     if(ihelp < 1) {
        PrintMessage("?WARNING - I don't know the time between the frames");
        ihelp = 1;}

     if(traj_file_set == 5) {  /* mumod trajectories start from time = 0 */
       for(i = 0 ; i < corr_info.corr_obs ; i++) {
         fprintf(write_p," %d %f \n",ihelp * i,corr_info.corr_val[i]);}
     }
     else {
     for(i = 0 ; i < corr_info.corr_obs ; i++) {
       fprintf(write_p," %d %f \n",ihelp * (i+1),corr_info.corr_val[i]);}
      }

     fclose(write_p);
     PrintMessage("Done...");
}

/************************************************************************/
write_seco(text)
      char *text;
/************************************************************************/
{

     FILE *write_p;
     int i;
     char OutText[BUFF_LEN];

     if(text[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?' ");
       return;}

     write_p = fopen(text,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : '%s'",text);
        return;}

/* ready to write now ... */
     sprintf(OutText,"Writing phi, psi and omega angles to file '%s' on disk",text);
     PrintMessage(OutText);
 
     fprintf(write_p," index      phi      psi      omega \n");

     i = 0;
       fprintf(write_p," %d             %f  %f \n",(i+1),psi_v[i],omega_v[i]);
     for(i = 0 ; i < psi_e - 1 ; i++) {
       fprintf(write_p," %d     %f  %f  %f \n",(i+1),
               phi_v[i],psi_v[i+1],
                        omega_v[i+1]);}
      i = psi_e -1;
       fprintf(write_p," %d     %f \n",(i+1),phi_v[i]);

     fclose(write_p);
     PrintMessage("Done...");
}

/************************************************************************/
write_coord_free(file_name , alt)
      char *file_name;
      int   alt;
/************************************************************************/
{

     FILE *write_p;
     int nr;
     int i;
     int ihelp;
     char OutText[BUFF_LEN];

     if(file_name[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?'");
       return;}

     write_p = fopen(file_name,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : %s ",file_name);
       PrintMessage(OutText);
        return;}

/* ready to write now ... */

     if(alt)
         PrintMessage("!!! Using current display mask ");

     sprintf(OutText,"Writing current molecule/system (nr:%d)",(current_struct+1));
     PrintMessage(OutText);

     ihelp = 0;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
       if(alt) {
        if(disp_list[i] == 0) continue;
       }
        ihelp++;}

     fprintf(write_p,"* Output in CHARMM free format \n");
     fprintf(write_p,"*        \n");
     fprintf(write_p," %d \n",ihelp);

     ihelp = 1;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
     if(alt) {
      if(disp_list[i] == 0) continue;
     }
      fprintf(write_p," %d %d %.4s %.4s %f %f %f %.4s %d %f \n",
       ihelp,res1[i],resnam+4*i,atnam+4*i,
       (x[i] + sumx),(y[i] + sumy),(z[i] + sumz),segment+4*i,res1[i],
        bvalue[i]);
         ihelp++;}

     fclose(write_p);
}

/************************************************************************/
int write_RDF(FileName)
    char *FileName;
/************************************************************************/
{
     FILE *write_p;
     int i;
     char OutText[BUFF_LEN];

     if(!RaDiFu.Set || !RaDiFu.Numbers) {
        PrintMessage("?ERROR - no RDF to be written to disk");
        return(1);}

     if(indexo(FileName,"?") > 0)  {
       PrintMessage("?ERROR - file name can't contain '?'");
       return(1);}

     if(FileName[0] == '\0') 
        strncpy(FileName,"rdf_file.dat",BUFF_LEN);

     write_p = fopen(FileName,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : %s ",FileName);
       PrintMessage(OutText);
        return(1);}

/* ready to write now ... */

     sprintf(OutText,"Writing the RDF to file '%s'",FileName);
     PrintMessage(OutText);

     for(i = 0 ; i < RaDiFu.Numbers ; i++) {
      fprintf(write_p," %f %f \n",RaDiFu.XValues[i],
                                  RaDiFu.YValues[i]);}


     fclose(write_p);

     return(0);
}

/************************************************************************/
write_coord_BaS(file_name , alt)
      char *file_name;
      int   alt;
/************************************************************************/
{

     FILE *write_p;
     int nr;
     int i;
     int ihelp;
     char OutText[BUFF_LEN];
     char *element_vec;
     int ret_val;

     if(file_name[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?'");
       return;}

     write_p = fopen(file_name,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : %s ",file_name);
       PrintMessage(OutText);
        return;}

/* ready to write now ... */

     if(alt)
         PrintMessage("!!! Using current display mask ");

     sprintf(OutText,"Writing current molecule/system (nr:%d)",(current_struct+1));
     PrintMessage(OutText);

 element_vec = cvector(2*(mliste[current_struct]-mlists[current_struct] + 1));

     ihelp = 0;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
       if(alt) {
        if(disp_list[i] == 0) continue;
       }
        strncpy(element_vec+2*ihelp,GetAtmName(i),2);
        ihelp++;}

   ret_val = PrepareAtoms(element_vec , ihelp); 

     fprintf(write_p,"Title SCARECROW output to B&S\n");

     ihelp = 0;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
     if(alt) {
      if(disp_list[i] == 0) continue;
     }
      fprintf(write_p,"%.2s  %f  %f  %f \n",
       element_vec+2*ihelp,(x[i] + sumx),(y[i] + sumy),(z[i] + sumz));
         ihelp++;}

     fprintf(write_p,"END\n");

     fclose(write_p);

     free(element_vec);
}

/**********************************************************************/
int PrepareAtoms(element_vec , Iatoms)

      char *element_vec;
      int   Iatoms;
/**********************************************************************/
{


      static int nsymbl= CONV_ATOMS; /* atom symbol list */
/*
*
*/
      static char  *pt =
"?? HHeLiBe B C N O FNeNaMgAlSi P SClArCACBCGCDCECZNANBNGNDNENZOAOBOGODOEOZOHSASBSGSDHHHGHZNHCHOCHAHBHCHDHEHNHTHOCa";
      static char  *PT =
" HHeLiBe B C N O FNeNaMgAlSi P SClArCa";

      static int ihelpv[CONV_ATOMS] = {0,
                  1,2,
                  3,4,
                  5,6,7,8,9,10,
                  11,12,
                  13,14,15,16,17,18,
                  6,6,6,6,6,6,
                  7,7,7,7,7,7,
                  8,8,8,8,8,8,8,
                  16,16,16,16,
                  1,1,1,7,6,8,1,1,1,1,1,1,1,1,19};

       static int i,j,swtch,nerror;

       static char OutText[BUFF_LEN];

/* clear all numbers in the element vector */
      for(i = 0 ; i < Iatoms ; i++) {

         if(element_vec[2*i+1] == ' ' || 
            element_vec[2*i+1] == '\0') {
                    element_vec[2*i+1] = element_vec[2*i];
                    element_vec[2*i]   = ' ';}

         if(isdigit(element_vec[2*i+1])) {
           element_vec[2*i+1] = element_vec[2*i];
           element_vec[2*i] = ' ';}
       }

      for(i = 0 ; i < Iatoms ; i++) {

       swtch = 0;

       for(j = 0 ; j < nsymbl ; j++) { 
          if(strncmp((element_vec+2*i),(pt+2*j),2) == 0)  {
             strncpy((element_vec+2*i),PT+2*(ihelpv[j]-1),2);
                swtch = 1;
                break;
           break;
           }
        }
        if(swtch != 0) continue;

        sprintf(OutText," ?WARNING - can't translate element  >%.2s<",
              element_vec+2*i);
        PrintMessage(OutText);
        PrintMessage("Known atoms are:\n");
         for(j = 0 ; j < strlen(PT)/ 30 ; j++) {
         sprintf(OutText,"%s",PT+j*30);
         PrintMessage(OutText);}
         if(strlen(PT) - 30 * ( strlen(PT) / 30)) {
           sprintf(OutText,"%s",PT+(strlen(PT) / 30)*30);
           PrintMessage(OutText);}
        nerror++;
      }
        return(0);
}

/************************************************************************/
write_coord_pdb(file_name , alt)
      char *file_name;
      int   alt;
/************************************************************************/
{

     FILE *write_p;
     int nr;
     int i;
     int ihelp;
     char OutText[BUFF_LEN];

     if(file_name[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?'");
       return;}

     write_p = fopen(file_name,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : %s ",file_name);
       PrintMessage(OutText);
        return;}

/* ready to write now ... */

     if(alt)
         PrintMessage("!!! Using current display mask ");

     sprintf(OutText,"Writing current molecule/system (nr:%d)",(current_struct+1));
     PrintMessage(OutText);

     fprintf(write_p,"REMARK   1 PDB output from SCARECROW\n");
     fprintf(write_p,"REMARK   1 =========================\n");

     ihelp = 1;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
     if(alt) {
      if(disp_list[i] == 0) continue;
     }
      fprintf(write_p,
      "ATOM  %5d  %-3.3s %-3.3s %1.1s%4d    %8.3f%8.3f%8.3f%6.2f%6.2f\n",
       ihelp,GetAtmName(i),GetResName(i),GetSegName(i),GetResNum1(i),
       (GetXCoord(i)+sumx),(GetYCoord(i)+sumy),(GetZCoord(i)+sumz)
       ,0.0,GetBValue(i));
         ihelp++;}

     fclose(write_p);
}


/************************************************************************/
write_coord_charmm(file_name , alt)
      char *file_name;
      int   alt;
/************************************************************************/
{

     FILE *write_p;
     int nr;
     int i;
     int ihelp;
     char OutText[BUFF_LEN];

     if(file_name[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?'");
       return;}

     write_p = fopen(file_name,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : %s ",file_name);
       PrintMessage(OutText);
        return;}

/* ready to write now ... */

     if(alt)
         PrintMessage("!!! Using current display mask ");

     sprintf(OutText,"Writing current molecule/system (nr:%d)",(current_struct+1));
     PrintMessage(OutText);

     ihelp = 0;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
       if(alt) {
        if(disp_list[i] == 0) continue;
       }
        ihelp++;}

     fprintf(write_p,"* Output in CHARMM format \n");
     fprintf(write_p,"* ======================= \n");
     fprintf(write_p,"*        \n");
     fprintf(write_p,"%5d \n",ihelp);

     ihelp = 1;
     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
     if(alt) {
      if(disp_list[i] == 0) continue;
     }
      fprintf(write_p,
          "%5d%5d %-4.4s %-4.4s%10.5f%10.5f%10.5f %4.4s %-4d%10.5f \n",
       ihelp,res1[i],resnam+4*i,atnam+4*i,
       (x[i] + sumx),(y[i] + sumy),(z[i] + sumz),segment+4*i,res1[i],
        bvalue[i]);
         ihelp++;}

     fclose(write_p);
}

/*************************************************************************/
int WriteClusterData(char *FileName , char *FileTitle)
/*************************************************************************/
{

    FILE *File_p;
    char OutText[BUFF_LEN];
    int ContrlR;

    if(!ClusterData.NumSets) {
        PrintMessage("?ERROR - no cluster data available");
        return(1);}

    if(FileName[0] == '\0') {
       PrintMessage("?ERROR - file name missing");
       return(1);}


    File_p = fopen(FileName,"w");
    if(File_p == NULL) {
       sprintf(OutText,"?ERROR - can't open file '%s'",FileName);
       PrintMessage(OutText);
       return(1);}   

/* title write */
    ContrlR = fwrite(FileTitle,sizeof(char),80,File_p);
/* size record  */
    ContrlR = fwrite(&ClusterData.NumSets,sizeof(int),1,File_p);
/* data         */
    ContrlR = fwrite(ClusterData.DataArray,sizeof(float),
    ClusterData.NumSets * (ClusterData.NumSets - 1) /2 ,File_p);

    fclose(File_p);
    return(0);
}








