/*  

                       Copyright (c) 1990,1991,1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

/*
 *   Program to display text for the Scarecrow program
 *	
 *   Leif Laaksonen  1990
 *  
 */
#include <stdio.h>
#include <string.h>
#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#include <fmclient.h>
#endif
#include "maxdefs.h"

#define TXT_LINE  BUFF_LEN
#define TXT_LINES 50

#define MOUSEXMAP(x)  (((float)(x) - (float)xr)/(float)(xsz))
#define MOUSEYMAP(y)  (((float)(y) - (float)yr)/(float)(ysz))

     extern FILE *own_p_file;
     extern FILE *push_file;
     extern int rfile_deep;
     extern FILE *rfile_point[MAX_FILES];

     extern float idmat[4][4];
     extern float rotB[4][4];

extern int term_type;
extern int display_text;
extern float near,far;
extern char *bottom_line;
extern int fake_now;
extern int name_to_rgb();
extern void PrintMessage();
extern void MakeOrtho();
extern char *cvector();
extern char *cvector_add();
extern int   ShowTextInput(); 
extern void  RedrawScreen();
extern int   IsStereoON();

/*  debug structure */
    extern struct {
    int DebugL;} DebugS;

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

int    txt_deep = 0; /* elements in text stack */
char txt_mgr[TXT_LINES][TXT_LINE];  /* text stack */
char txt_fnt[TXT_LINES][TXT_LINE];  /* font for text in stack */
int  txt_col[TXT_LINES][3];         /* text colour */
float txt_size[TXT_LINES];          /* font size */
float txt_xc[TXT_LINES];            /* x coordinate stack  (0 ... 1)*/ 
float txt_yc[TXT_LINES];            /* y coordinate stack  (0 ... 1)*/
float txt_Xstep[TXT_LINES];         /* x step for moving text */
float txt_Ystep[TXT_LINES];         /* y step for moving text */
float txt_Xlim[TXT_LINES];          /* place in x for the text to stop */
float txt_Ylim[TXT_LINES];          /* place in y for the text to stop */

    struct FM_FONTS_AVAIL {
      int  Numbers;                /* number of fonts defined */
      int  NumCharacters;          /* number of characters for storage */
      char *FontString;} FM_fonts = { 0 , BUFF_LEN , NULL };

int FontManagerInit();

/*************************************************************************/
read_txt(alt)
     int alt;
/*************************************************************************/
{
    static int rgb[3];
    static int ret_val;
    static float xs,ys,Xstep,Ystep,Xlimit,Ylimit;
    static float size;
    static int retv;
    static char colo[BUFF_LEN];

    char temp[BUFF_LEN];
    char temp1[BUFF_LEN];
    char temp2[BUFF_LEN];

    if(alt == 0) {
      txt_deep = 0;
      return;}

    if(term_type == 1 && !fake_now) {

    while(1) {

#ifdef sgi

#ifdef USEFORMS

     if(retv = ShowTextInput(temp ,    /* text input */
                   temp1,              /* font name  */
                   rgb  ,              /* rgb code   */
                   &size)) {           /* text size  */
                           return;}

           RedrawScreen();
#else
    strncpy(temp,"Give text string (finish with 'end')",BUFF_LEN);
    get_keyboard(temp);

    strncpy(colo,temp,BUFF_LEN);
    toller(colo);
    if(indexo(colo,"exit") == 1 || indexo(colo,"end") == 1){
     strncpy(bottom_line,"** Choose from main menu ",PORTchar);
      return;}

font_loop:;
    strncpy(temp1,"Give font name :",BUFF_LEN);
    get_keyboard(temp1);

    retv = check_font(temp1);
    if(txt_deep < 1 && retv < 0) goto font_loop;

    strncpy(colo,"Give font size ",BUFF_LEN);
    get_keyboard(colo);
    sscanf(colo,"%f",&size);

  try_again:;

    strncpy(colo,"Give colour : ",BUFF_LEN);
    get_keyboard(colo);

    retv = name_to_rgb(colo,&rgb[0],&rgb[1],&rgb[2]);

    if(retv > 0) goto try_again;

#endif

    PrintMessage("****> move pointer to desired place and press LEFT mouse button ");

    strncpy(bottom_line,"****> move pointer to desired place and press LEFT mouse button",PORTchar);
    going_on();

    get_xy(&xs,&ys);

#endif

    Xstep = 0.0;
    Ystep = 0.0;
    Xlimit = xs;
    Ylimit = ys;

    ret_val =  
          push_txt_stack(temp,temp1,rgb,size,xs,ys,Xstep,Ystep,Xlimit,Ylimit);

   if(ret_val > 0) {
     txt_deep = 0;
     return;}
     
  }
  }
    else if (term_type == 3 || fake_now) {
    while(1) {
     PrintMessage("Give text string (finish with 'end'): ");
     fgets(temp,MAXlinel,rfile_point[rfile_deep - 1]);
/* this is done to remove the new line \n (line feed) character from the end */
      if(temp[strlen(temp)-1] == '\n') temp[strlen(temp)-1] = '\0';
     
     PrintMessage(temp);

    strncpy(colo,temp,BUFF_LEN);
    toller(colo);
    if(indexo(colo,"exit") == 1 || indexo(colo,"end") == 1) return;

     PrintMessage("Give font name :");
     fgets(temp1,MAXlinel,rfile_point[rfile_deep - 1]);
/* this is done to remove the new line \n (line feed) character from the end */
      if(temp1[strlen(temp1)-1] == '\n') temp1[strlen(temp1)-1] = '\0';
     PrintMessage(temp1);

/* check font, if non-existent exit program */

     retv = check_font(temp1);
     if(retv < 0) check_if_fatal(1);

     PrintMessage("Give font size : ");
     fgets(colo,MAXlinel,rfile_point[rfile_deep - 1]);
     sscanf(colo,"%f",&size);
     PrintMessage(colo);

     PrintMessage("Give colour : ");
     fgets(colo,MAXlinel,rfile_point[rfile_deep - 1]);
/* this is done to remove the new line \n (line feed) character from the end */
      if(colo[strlen(colo)-1] == '\n') colo[strlen(colo)-1] = '\0';
     PrintMessage(colo);

     name_to_rgb(colo,&rgb[0],&rgb[1],&rgb[2]);

     PrintMessage("Give x- and y-coordinate (0-1.) ");
     fgets(temp2,MAXlinel,rfile_point[rfile_deep - 1]);
     sscanf(temp2,"%f %f %f %f %f %f",&xs,&ys,&Xstep,&Ystep,&Xlimit,&Ylimit);
     PrintMessage(temp2);

    Xstep = 0.0;
    Ystep = 0.0;
    Xlimit = xs;
    Ylimit = ys;

     push_txt_stack(temp,temp1,rgb,size,xs,ys,Ystep,Ystep,Xlimit,Ylimit);

    }

    }
  }

/************************************************************************/
int push_txt_stack(text,font,col,size,xc,yc,Xstep,Ystep,Xlimit,Ylimit)
    char *text;
    char *font;
    int  *col;
    float size;
    float xc;
    float yc;
    float Xstep;
    float Ystep;
    float Xlimit;
    float Ylimit;
/************************************************************************/
{
    int i;
/*
    txt_mgr = (char **) realloc( txt_mgr , sizeof(char *));

    txt_mgr[txt_deep] = (char *) realloc(txt_mgr[txt_deep] , sizeof(text));


    txt_fnt = (char **) realloc( txt_fnt , sizeof(char *));

    txt_fnt[txt_deep] = (char *) realloc(txt_fnt[txt_deep] , sizeof(font));



    txt_size = (float *) realloc((char *) txt_size , (txt_deep + 1) *
                                        sizeof(float));
    txt_size[txt_deep] = size;

    txt_xc =   (float *) realloc((char *) txt_xc , (txt_deep + 1) *
                                        sizeof(float));
    txt_xc[txt_deep] = xc;

    txt_yc =   (float *) realloc((char *) txt_yc , (txt_deep + 1) *
                                        sizeof(float));
    txt_yc[txt_deep] = yc;
*/
    if(txt_deep == 0 && text[0] == '\0')
      return(1);

    strncpy(txt_mgr[txt_deep],text,TXT_LINE);

    if(txt_deep == 0 && font[0] == '\0')
      return(1);

/* check font once more */
    i = check_font_silent(font);

    if(font[0] == '\0' || i < 0)
      strncpy(txt_fnt[txt_deep] , txt_fnt[txt_deep - 1] , TXT_LINE);
    else
      strncpy(txt_fnt[txt_deep],font,TXT_LINE);

      txt_col[txt_deep][0] = col[0];
       txt_col[txt_deep][1] = col[1];
        txt_col[txt_deep][2] = col[2];

      txt_size[txt_deep] = size;

    txt_xc[txt_deep] = xc;
    txt_yc[txt_deep] = yc;

    txt_Xstep[txt_deep] = Xstep;         /* x step for moving text */
    txt_Ystep[txt_deep] = Ystep;         /* y step for moving text */
    txt_Xlim[txt_deep]  = Xlimit;        /* place in x for the text to stop */
    txt_Ylim[txt_deep]  = Ylimit;        /* place in y for the text to stop */

    txt_deep++;

    if(txt_deep == (TXT_LINES - 1)) 
    PrintMessage("** Don't read more text (BUFFER FULL) \007\007 ");
    
    if(txt_deep == TXT_LINES) {
      PrintMessage("?ERROR - I just warned you already \007 ");
      txt_deep = 0;}

    return(0);

}

#ifdef sgi

/************************************************************************/
int show_text(text,fontn,col,size,xc,yc,State)
char *text;     /* text to be displayed */
char *fontn;    /* fontname */
int  *col;      /* text colour */
float size;     /* font size */
float xc;       /* x coordinate of text (0...1) */
float yc;       /* y coordinate of text (0...1) */
int   State;
/************************************************************************/
{
    fmfonthandle f;
    fmfonthandle fsized;
    char TempS[BUFF_LEN];
    static float saveM[4][4];
    static float saveP[4][4];


    if(IsStereoON())
                      return(0);

/* initialize fontmanager */

    (void)FontManagerInit();

    f = fmfindfont(fontn);
    if (!f) {
	sprintf(TempS,"can't find font '%s' (will try to substitute)",fontn);
        PrintMessage(TempS);
	return(-1);
    }

    fsized = fmscalefont(f, size);
    fmsetfont(fsized);

    if(State == BACKBUFFER) {
                frontbuffer(FALSE);
                backbuffer(TRUE);}
    else {
                frontbuffer(TRUE);
                backbuffer(FALSE);}                

    getmatrix(saveM);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

        zbuffer(FALSE);
        ortho2(0.0 , 1.0 , 0.0 , 1.0);
        loadmatrix(idmat); 

    cmov2(xc,yc);
    c3i(col);

    if(fmprstr((unsigned char *)text) < 0) 
       PrintMessage("?ERROR - error in 'show_text'");

        zbuffer(TRUE);
        MakeOrtho();                            /* put transformation
                                                        matrix back */
        loadmatrix(saveM);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

    frontbuffer(FALSE); /* just for sure */
    backbuffer(TRUE);
    return(0);
}

/************************************************************************/
int show_text_world(text,fontn,col,size,xc,yc,zc,State)
char *text;     /* text to be displayed */
char *fontn;    /* fontname */
int  *col;      /* text colour */
float size;     /* font size */
float xc;       /* x coordinate of text */
float yc;       /* y coordinate of text */
float zc;       /* z coordinate of text */
int   State;
/************************************************************************/
{
    fmfonthandle f;
    fmfonthandle fsized;
    char TempS[BUFF_LEN];
    static float saveM[4][4];

/* initialize fontmanager */

    (void)FontManagerInit();

    f = fmfindfont(fontn);
    if (!f) {
	sprintf(TempS,"Can't find font '%s' (will try to substitute) ",fontn);
        PrintMessage(TempS);
	return(-1);
    }

    fsized = fmscalefont(f, size);
    fmsetfont(fsized);

    if(State == BACKBUFFER) {
                frontbuffer(FALSE);
                backbuffer(TRUE);}
    else {
                frontbuffer(TRUE);
                backbuffer(FALSE);}
                
#ifdef INDIGO_ENTRY
    zbuffer(FALSE);
#endif

    cmov(xc,yc,zc);

    c3i(col);

    if(fmprstr((unsigned char *)text) < 0) {
       PrintMessage("?ERROR - can't write to screen");
       zbuffer(TRUE);
       return(-1);}

#ifdef INDIGO_ENTRY
    zbuffer(TRUE);
#endif

    frontbuffer(FALSE);  /* just for sure */
    backbuffer(TRUE);

    return(0);
}
/************************************************************************/
get_xy(xs,ys)
    float *xs;
    float *ys;
/************************************************************************/
{
       static int dev_xy;
       static short val_xy;
       static long xsz,ysz;
       static long xr,yr;
       static long ii,jj;

       for(;;) {
        while(qtest()) {
         dev_xy=qread(&val_xy);
         if (dev_xy == LEFTMOUSE ) {
      
         getsize(&xsz,&ysz);
         getorigin(&xr,&yr);
         ii=getvaluator(MOUSEX);
         jj=getvaluator(MOUSEY);

         if(ii < xr || jj < yr || ii > (xr + xsz) ||
                                      jj > (yr + ysz)) {
         PrintMessage("?ERROR - outside range \007\007");
         break;}

         *xs = MOUSEXMAP(ii);
         *ys = MOUSEYMAP(jj);

           qreset();
          return;}
         if( dev_xy == REDRAW ) {
          reshapeviewport();
           bang_it();
         }
       }
      }
}
/************************************************************************/
drive_text()
/************************************************************************/
{
    int i;

    for(i = 0 ; i < txt_deep; i++) {

    show_text(txt_mgr[i],txt_fnt[i],txt_col[i],txt_size[i],
              txt_xc[i],txt_yc[i],BACKBUFFER);

    txt_xc[i] += txt_Xstep[i];
    txt_yc[i] += txt_Ystep[i];
  }
}

/************************************************************************/
get_keyboard(text)
    char *text;
/************************************************************************/
{

     extern int keyb_input();
     extern int dev;
     extern short val;

     int cstatus;
     static char command[BUFF_LEN];

     strncpy(bottom_line,text,PORTchar);
     going_on();

      while(1) {
       while(qtest()) {
       dev=qread(&val);

         if( dev == REDRAW ) {
          reshapeviewport();
           bang_it();
          }

          else if (dev == KEYBD)   {
          cstatus = keyb_input(command);
          strncpy(bottom_line,command,PORTchar);
          going_on();
           if(cstatus) { 
           PrintMessage(command);
           strncpy(text,command,BUFF_LEN - 1);
           return;}
	}}}
}

#endif

/*************************************************************************/
edit_text(text1,text2,alt)
         char *text1;
         char *text2;
         int alt;
/*************************************************************************/
{
     char TempS[BUFF_LEN];
     int i,j;
     char txt_colo[BUFF_LEN];

     if(txt_deep == 0) { /* no text to edit */
       PrintMessage("?ERROR - no text to edit ");
       return;}

#ifdef USEFORMS

       if(term_type == 1) {  /* allowed terminal type */
       ShowTextInputEdit();}
       else {
       PrintMessage("?ERROR - no meaning on an ascii terminal");}

       return; 

#else

     switch(alt) {

       case 0:    /* list the text */

     PrintMessage("**** Text to be displayed as it is now ****"); 
     for(i = 0 ; i < txt_deep ; i++) {
     rgb_to_name(txt_colo,txt_col[i][0],txt_col[i][1],txt_col[i][2]);
     sprintf(TempS,"(%d) Font: '%s' , font size: '%5.2f' , text colour: '%s' , x-'%4.2f' , y-'%4.2f' \n '%s'\n",(i+1),txt_fnt[i],txt_size[i],txt_colo,txt_xc[i],
     txt_yc[i],txt_mgr[i]);
     PrintMessage(TempS);}

     break;

     case 1:    /* delete option */

       j = atoi(text2);
           if(j < 1 || j > txt_deep) {
              PrintMessage("?ERROR - wrong index into text array ");
              return;}

     sprintf(TempS,"Removing text string nr: %d ",j);
     PrintMessage(TempS);

       for(i = (j - 1) ; i < txt_deep - 1 ; i++) {
          strncpy(txt_mgr[i],txt_fnt[i+1],TXT_LINE);
          strncpy(txt_fnt[i],txt_fnt[i+1],TXT_LINE);
           txt_col[i][0] = txt_col[i+1][0];
            txt_col[i][1] = txt_col[i+1][1];
             txt_col[i][2] = txt_col[i+1][2];
          txt_size[i] = txt_size[i+1];
          txt_xc[i] = txt_xc[i+1];
          txt_yc[i] = txt_yc[i+1];}

        txt_deep--;

        break;
     }
#endif
}

/*************************************************************************/
int check_font(font_name)     /* on return, if < 0 , font undefined */
    char *font_name;          /*               > 0 , font defined   */
/*************************************************************************/
{
#if defined(sgi)
    fmfonthandle f;
    fmfonthandle fsized;
    char TempS[BUFF_LEN];

/* initialize fontmanager */

    (void)FontManagerInit();

    f = fmfindfont(font_name);
    if (!f) {
	sprintf(TempS,"Can't find font '%s' (will try to substitute)\n",font_name);
        PrintMessage(TempS);
	return(-1);
    }
#endif
    return(1);
}
/*************************************************************************/
int check_font_silent(font_name)     /* on return, if < 0 , font undefined */
    char *font_name;                 /*               > 0 , font defined   */
/*************************************************************************/
{
#if defined(sgi)
    fmfonthandle f;
    fmfonthandle fsized;

/* initialize fontmanager */

    (void)FontManagerInit();

    f = fmfindfont(font_name);
    if (!f) {
	return(-1);
    }

#endif
    return(1);
}

/*************************************************************************/
void StoreFMname(FontName)
     char *FontName;
/*************************************************************************/
{
#if defined(sgi)
     if(FM_fonts.Numbers) {
       FM_fonts.FontString = cvector_add(FM_fonts.FontString , 
                                         (FM_fonts.Numbers + 1) * BUFF_LEN);
     }
     else {
       FM_fonts.FontString = cvector(BUFF_LEN);}

     strncpy(FM_fonts.FontString + BUFF_LEN * FM_fonts.Numbers , 
             FontName , BUFF_LEN);

     FM_fonts.Numbers++;

     if(DebugS.DebugL) {
        PrintMessage(FontName);}
#endif
}

/*************************************************************************/
void GetFMfonts()
/*************************************************************************/
{
#if defined(sgi)
    (void)FontManagerInit();

                if(FM_fonts.Numbers) {
                   free(FM_fonts.FontString);
                   FM_fonts.Numbers = 0;}
                fmenumerate(StoreFMname);
#endif
}
/*************************************************************************/
char *ReturnTextString(TextIndex)
      int TextIndex;
/*************************************************************************/
{

     if(TextIndex < txt_deep) {

       return(txt_mgr[TextIndex]);}

     PrintMessage("?ERROR - can't return the text");
       return(NULL);
}
/*************************************************************************/
int PutTextString(TextString , TextIndex)
      char *TextString;
      int   TextIndex;
/*************************************************************************/
{

     if(TextIndex < txt_deep) {
       strncpy(txt_mgr[TextIndex],TextString,BUFF_LEN);
       return(0);}

     PrintMessage("?ERROR - can't save the text");
       return(1);
}
/*************************************************************************/
char *ReturnTextFont(TextIndex)
      int TextIndex;
/*************************************************************************/
{
     if(TextIndex < txt_deep) {

       return(txt_fnt[TextIndex]);}

     PrintMessage("?ERROR - can't return the text font");
       return(NULL);
}
/*************************************************************************/
int PutTextFont(TextFont , TextIndex)
      char *TextFont;
      int   TextIndex;
/*************************************************************************/
{
     if(TextIndex < txt_deep) {
       strncpy(txt_fnt[TextIndex] , TextFont , BUFF_LEN);
       return(0);}

     PrintMessage("?ERROR - can't save the text font");
       return(1);
}
/*************************************************************************/
int *ReturnTextColour(TextIndex)
      int TextIndex;
/*************************************************************************/
{
     if(TextIndex < txt_deep) {

       return(txt_col[TextIndex]);}

     PrintMessage("?ERROR - can't return the text colour");
       return(NULL);
}
/*************************************************************************/
int PutTextColour(TxtColour , TextIndex)
      int *TxtColour;
      int  TextIndex;
/*************************************************************************/
{
     if(TextIndex < txt_deep) {

       txt_col[TextIndex][0] = TxtColour[0];
       txt_col[TextIndex][1] = TxtColour[1];
       txt_col[TextIndex][2] = TxtColour[2];

     return(0);
     }

     PrintMessage("?ERROR - can't change the text colour");
       return(1);
}

/*************************************************************************/
float *ReturnTextPosition(TextIndex)
       int TextIndex;
/*************************************************************************/
{
     static float CoordPos[2];

     if(TextIndex < txt_deep) {

       CoordPos[0] = txt_xc[TextIndex];
       CoordPos[1] = txt_yc[TextIndex];

       return(CoordPos);}

     PrintMessage("?ERROR - can't return the text position");
       return(NULL);
}
/*************************************************************************/
int PutTextPosition(CoordPosX , CoordPosY , TextIndex)
       float  CoordPosX,CoordPosY;
       int    TextIndex;
/*************************************************************************/
{

     if(TextIndex < txt_deep) {

       txt_xc[TextIndex] = CoordPosX;
       txt_yc[TextIndex] = CoordPosY;

       return(0);}

     PrintMessage("?ERROR - can't update the text position");
       return(0);
}

/*************************************************************************/
float ReturnTextSize(TextIndex)
       int TextIndex;
/*************************************************************************/
{

     if(TextIndex < txt_deep) {
       return(txt_size[TextIndex]);}

     PrintMessage("?ERROR - can't return the text font size");
       return(NULL);
}
/*************************************************************************/
int PutTextSize(TxtSize , TextIndex)
       int   TxtSize;
       int   TextIndex;
/*************************************************************************/
{

     if(TextIndex < txt_deep) {

       txt_size[TextIndex] = (float)TxtSize;

     return(0);}

     PrintMessage("?ERROR - can't change the text font size");
       return(1);
}
/*************************************************************************/
int ReturnTextEntries()
/*************************************************************************/
{
    return(txt_deep);
}
/*************************************************************************/
int FontManagerInit()
/*************************************************************************/
{
    static int Set = 0;

    if(!Set) {
        fminit();
        Set = 1;
        return(1);}

    return(0);
}  
