/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <setjmp.h>

#include "maxdefs.h"

     extern int rfile_deep;
     extern FILE *rfile_point[MAX_FILES];
     extern float near,far;
     extern void PrintMessage();
     extern int video_mode;
     extern int term_type;
     extern void qcomm();

     extern struct {       /* log file structure */
      char file[BUFF_LEN];
      FILE *log_p;
      int ok;
      int lines;} LogFile;

     FILE *own_p_file;  /* pointer to input command file */

     char prompt[BUFF_LEN] = ":>"; /* default prompt */

     jmp_buf jumper;

/************************************************************************/
plot_mol_term()   /* main control routine for the terminal driver */
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern char input_from_file[BUFF_LEN];
     extern int input_file_set;

     static int num_inputs=0;
     static int num_pos;        /* number of positions in the input string */
     static char input[MAXlinel];
     static int return_val;
     static char *ret_val;
     static int i;

     char OutText[BUFF_LEN];

     build_array();            /* calculate the array needed for surface
                                  calculations */
/* check if the input will be from a file */
     if(input_from_file[0] != '\0') {
       own_p_file = fopen(input_from_file,"r");

       if(own_p_file == NULL) {
         sprintf(OutText,"?ERROR - unable to open input file : %s ",input_from_file);
         PrintMessage(OutText);
         shut_down(1);
       }

/* update file pointer array */
       rfile_point[rfile_deep] = own_p_file;
       rfile_deep++;

     }

#ifdef sgi
/* I don't know why this call has to be made ?????? */
     if(term_type == 1 || term_type == 3)
                                         scale( 0.999 , 0.999 , 0.999);
#endif

     PrintMessage("     =============================oo=============================");

     while(1) {

     return_val = setjmp(jumper);

     if(return_val != 0) {
       PrintMessage("*** User Interrupt ***");}

/* this can't go through the "PrintMessage" routine */
     printf("%s ",prompt);

/* code for reading the input from a file                */
      if(input_from_file[0] != '\0') { /* read from file */
      ret_val = fgets(input,MAXlinel,rfile_point[rfile_deep - 1]);
      if(ret_val == NULL) shut_down(1);
/* this is done to remove the new line \n (line feed) character from the end */
      if(input[strlen(input)-1] == '\n') input[strlen(input)-1] = '\0';
/* check the input line for '?name' entries */
      qcomm(input);
      sprintf(OutText," %s",input);
      PrintMessage(OutText);
      }
/* normal input typed from the terminal or directed from a file by '<'       */
     else {
     if(gets(input) == NULL) { /* input string to be parsed */
        shut_down(1);}
      if(!LogFile.ok) {
        sprintf(OutText,"%s %s",prompt,input);
        WriteToLogFile(OutText);}
     }

/* check the input line for '?name' entries */
      qcomm(input);

     own_parser(input,parsed,&num_pos,SEP_STRING); /* parsing driver */

     if(num_pos < 1) continue;

     return_val = exe_command(input,num_pos); /* execute the command on input string */

     }

}      /* end of plot_mol_term routine */





















