/*

       System statistics for the running process

       Leif Laaksonen 1992

       Centre for Scientific Computing, Espoo, Finland

*/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/fault.h>
#include <sys/syscall.h>
#include <sys/procfs.h>
#include <sys/stat.h>
#include <fcntl.h>

#define String_Len  20

   prusage_t ProcessInfo;

/***************************************************************************/
int RunStatistics()
/***************************************************************************/
{
    pid_t CurrentPID;
    int Fdes;
    static char PidString[String_Len];

    CurrentPID = getpid();              /* get the pid */
     sprintf(PidString,"/debug/%5.5d",CurrentPID);  

    if((Fdes = open(PidString , O_RDONLY)) == -1) {
        perror("?ERROR - can't open process file");
        return(-1);}

    if(ioctl(Fdes , PIOCUSAGE , &ProcessInfo) == -1) {
        perror("?ERROR - can't get process info");
        close(Fdes);
        return(-1);}

     close(Fdes);
    return(0);
}


