/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/signal.h>
#include "maxdefs.h"

#define CHARMM_CMD "/bin/csh -c charmm        >  CHARMM.OUT"
#define VSS_CMD    "/bin/csh -c vss           >  VSS.OUT"
#define  ICON8_CMD "/bin/csh -c icon8         >  ICON8.OUT"
#define  PROBESURF_CMD "/bin/csh -c probesurf >  PROBESURF.OUT"
#define  DENSITY_CMD "/bin/csh -c density     >  DENSITY.OUT"

#define HOOK_FILE(a,b) {{  FILE *hook_p;\
                        hook_p = fopen(&input[1],"r");\
                        if(hook_p == NULL) {\
                        printf("?ERROR - can't open file '%s'\n",&input[1]);\
                           pclose(a);\
                           fclose(b);\
                           if(Sub_Proc) {\
                                kill(Process_pid,SIGUSR1);\
                                exit(1);}\
                           check_if_fatal(1);\
                           return;}\
                        while(1) {\
                        ret_val = fgets(input,MAXlinel,hook_p);\
                        if(ret_val == NULL) {\
                           fclose(hook_p);\
                           goto go_on;}\
                        if((ok = fprintf(ptr,"%s",input)) == 0) {\
                        printf("?ERROR - can't write into pipe \n");\
                           if(Sub_Proc) exit(1);\
                           check_if_fatal(1);\
                        pclose(ptr);\
                        return;}}}}


     extern int reado();
     extern void tupper();
     extern void going_on();
     extern void PrintMessage();

     extern char parsed[MAXparse][MAXlinel];
     extern char scr_bin[BUFF_LEN];
     extern char *bottom_line;
     extern int numat;

     int Process_pid;

     struct StreamST {
     char CHARMM[BUFF_LEN];
     char VSS[BUFF_LEN];
     char ICON8[BUFF_LEN];
     char PROBESURF[BUFF_LEN];
     char DENSITY[BUFF_LEN];};

     struct StreamST StreamerInfo = {
          "/bin/csh -c charmm        >  CHARMM.OUT",
          "/bin/csh -c vss           >  VSS.OUT",
          "/bin/csh -c icon8         >  ICON8.OUT",
          "/bin/csh -c probesurf     >  PROBESURF.OUT",
          "/bin/csh -c density       >  DENSITY.OUT"};

/************************************************************************/
stream_p(input,num)   /* stream commands by a pipe to a program */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     char OutText[BUFF_LEN];

/* get process pid */
     if(!Process_pid)
         Process_pid = getpid();

/* switch to small characters                 */
     toller(parsed[1]);

     if(indexo(parsed[1],"mopa") == 1) { /* stream file to mopac */
       strm_mopac(parsed[2]);
       return;}


     if(indexo(parsed[1],"char") == 1) { /* stream file to charmm */
/*
     parsed[2] : file name 
     parsed[3] : switch for wait or subrocess (&)
                 The main process is informed when child has finish
*/
       strm_charmm(parsed[2],parsed[3]);
       return;}

     if(indexo(parsed[1],"icon") == 1) { /* stream file to icon8 */
       strm_icon8(parsed[2],parsed[3]);
       return;}

     if(indexo(parsed[1],"vss") == 1) { /* stream file to vss */
       strm_vss(parsed[2],parsed[3]);
       return;}

     if(indexo(parsed[1],"dens") == 1) { /* stream file to density */
       strm_density(parsed[2],parsed[3]);
       return;}

     if(indexo(parsed[1],"prob") == 1) { /* stream file to probesurf */
       strm_probesurf(parsed[2],parsed[3]);
       return;}




/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of connect_fac */


/************************************************************************/
strm_mopac(text)
     char *text;
/************************************************************************/
{
     FILE *ptr;
     FILE *mopac_p;
     FILE *mopac_o;
     static char cmd[BUFF_LEN];

     char input[BUFF_LEN];

     strncpy(cmd,scr_bin,BUFF_LEN);
     strncat(cmd,"/rmopac < ",(BUFF_LEN - strlen(cmd)));
     strncat(cmd,text,(BUFF_LEN - strlen(cmd)));

     printf(":%s:\n",cmd);

/* open mopac output file */
   mopac_o = fopen("MOPAC.OUT","w");
   if(mopac_o == NULL) {
     printf("?ERROR - can't open MOPAC.OUT file \n");
     return;}

/* open pipe in read mode */
    ptr = popen(cmd,"r");
    if(ptr == NULL) {
      printf("?ERROR - can't open pipe to MOPAC \n");
      return;}

/* open fort.91 */
    mopac_p = fopen("fort.91","r");
    if(mopac_p == NULL) {
      printf("?ERROR - can't open fort.91 \n");
      return;}
    
    while(fgets(input,BUFF_LEN,mopac_p) != NULL) {
      printf(":%s:\n",input);     
      get_mopac_c(input); /* get mopac coordinates */
    }

    while(fgets(input,BUFF_LEN,ptr) != NULL) {
      fprintf(mopac_o,"%s",input);     
    }
    fclose(mopac_o);

/* close file and pipe */
        pclose(ptr);
        fclose(mopac_p);
}
/************************************************************************/
get_mopac_c(text)
    char *text;
/************************************************************************/
{
    static char first = 0;
    static char last = 0;
    static int xyz_c = 0;


    if(strncmp(text,"****start",9) == 0) { /* first card */
      first = 1;
      last = 0;
      return;}

     if(strncmp(text,"****end",7) == 0) { /* last card */
       first = 0;
       last = 1;
     printf("Coordinates %d \n",xyz_c);
      xyz_c = 0;
       return;}

    if(first) { /* coordinates follow */
     xyz_c++;
      return;}

}

/************************************************************************/
strm_charmm(text,text1)
     char *text;
     char *text1;
/************************************************************************/
{
     FILE *ptr;
     FILE *charmm_in;

     static char cmd[BUFF_LEN];
     char input[BUFF_LEN];
     char *ret_val;
     char OutText[BUFF_LEN];
     int lines,ok;
     int Sub_Proc;

     void child_done();  /* process to inform that child has finished */

     strncpy(cmd,StreamerInfo.CHARMM,BUFF_LEN);

     Sub_Proc = 0; /* no */
     if(!strncmp(text1,"&",1)) Sub_Proc = 1; /* yes */

     if(!Sub_Proc) {
        sprintf(OutText,"> Executing command '%s'\n",cmd);
        PrintMessage(OutText);}
     else {
        sprintf(OutText,"> Executing command '%s' as a subrocess\n",cmd);
        PrintMessage(OutText);}

     if(Sub_Proc) { /* fork it and remember to kill the subprocess */
       if(fork() != 0) {                 /* parent process */
         signal(SIGUSR1,child_done);     /* I'm ready to receive signal */
         return;}
     }
/* open pipe in write mode */
    ptr = popen(cmd,"w");
    if(ptr == NULL) {
      if(!Sub_Proc)
        PrintMessage("?ERROR - can't open pipe to CHARMM");
      else
        printf("?ERROR - can't open pipe to CHARMM \n");

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

/* open charmm input file */
    charmm_in = fopen(text,"r");
    if(charmm_in == NULL) {
     if(!Sub_Proc){
      sprintf(OutText,"?ERROR - can't open CHARMM input file '%s'",text);
      PrintMessage(OutText);}
     else
      printf("?ERROR - can't open CHARMM input file '%s'\n",text);

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

      lines = 0;
/* start reading charmm input file */
      while(1) {

go_on:;
      ret_val = fgets(input,MAXlinel,charmm_in);

        if(ret_val == NULL) {
         if(!Sub_Proc) {
           sprintf(OutText,"End of file: %s (read %d lines)",text,lines);
           PrintMessage(OutText);}
         else
           printf("End of file: %s (read %d lines)\n",text,lines);

/* close pipe */
        pclose(ptr);
/* close file */
        fclose(charmm_in);
        if(Sub_Proc) { 
                kill(Process_pid,SIGUSR1);
                exit(1);}
          return;}

      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';

          lines++;

/* look for a '@' in first position on line */
      if(input[0] == '@') { /* hook onto new file */
      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';
      HOOK_FILE(ptr,charmm_in);
      }

        if((ok = fprintf(ptr,"%s\n",input)) < 0) {
          if(!Sub_Proc) 
           PrintMessage("?ERROR - can't write into pipe");
          else
           printf("?ERROR - can't write into pipe \n");

              if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
              check_if_fatal(1);
           return;}

        tupper(input);
        if(indexo(input,"STOP") > 0) {
         if(!Sub_Proc) {
          sprintf(OutText,"End of file: %s (read %d lines)",text,lines);
          PrintMessage(OutText);}
         else
          printf("End of file: %s (read %d lines)\n",text,lines);

/* close pipe */
        pclose(ptr);
/* close file */
        fclose(charmm_in);
        if(Sub_Proc) {
          kill(Process_pid,SIGUSR1);
          exit(1);}

        return;}

      }
}

/************************************************************************/
void child_done(sig)  /* do this upon receiving signal SIGUSR1          */
int sig;
/************************************************************************/
{
/* PrintMessage can't be used here because this subrocess has no 
   graphics window allocated 
*/

/*
        printf("\07\n\n");
        printf("       >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
        printf("       >>>> Subprocess has finished <<<<\n");
        printf("       >>>> Check output!!!!!!      <<<<\n");
        printf("       <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        return ;
*/
        printf("\07\n\n");
        PrintMessage("       >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        PrintMessage("       >>>> Subprocess has finished <<<<");
        PrintMessage("       >>>> Check output!!!!!!      <<<<");
        PrintMessage("       <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return ;
}


/************************************************************************/
strm_vss(text,text1)
     char *text;
     char *text1;
/************************************************************************/
{
     FILE *ptr;
     FILE *charmm_in;

     static char cmd[BUFF_LEN];
     char input[BUFF_LEN];
     char *ret_val;
     char OutText[BUFF_LEN];
     int lines,ok;
     int Sub_Proc;

     void child_done();  /* process to inform that child has finished */

     strncpy(cmd,StreamerInfo.VSS,BUFF_LEN);

     Sub_Proc = 0; /* no */
     if(!strncmp(text1,"&",1)) Sub_Proc = 1; /* yes */

     if(!Sub_Proc) {
        sprintf(OutText,"> Executing command '%s'\n",cmd);
        PrintMessage(OutText);}
     else {
        sprintf(OutText,"> Executing command '%s' as a subrocess\n",cmd);
        PrintMessage(OutText);}

     if(Sub_Proc) { /* fork it and remember to kill the subprocess */
       if(fork() != 0) {                 /* parent process */
         signal(SIGUSR1,child_done);     /* I'm ready to receive signal */
         return;}
     }
/* open pipe in write mode */
    ptr = popen(cmd,"w");
    if(ptr == NULL) {
      if(!Sub_Proc)
        PrintMessage("?ERROR - can't open pipe to VSS");
      else
        printf("?ERROR - can't open pipe to VSS \n");

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

/* open charmm input file */
    charmm_in = fopen(text,"r");
    if(charmm_in == NULL) {
     if(!Sub_Proc){
      sprintf(OutText,"?ERROR - can't open VSS input file '%s'",text);
      PrintMessage(OutText);}
     else
      printf("?ERROR - can't open VSS input file '%s'\n",text);

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

      lines = 0;
/* start reading VSS input file */
      while(1) {

go_on:;
      ret_val = fgets(input,MAXlinel,charmm_in);

        if(ret_val == NULL) {
         if(!Sub_Proc) {
           sprintf(OutText,"End of file: %s (read %d lines)",text,lines);
           PrintMessage(OutText);}
         else
           printf("End of file: %s (read %d lines)\n",text,lines);

/* close pipe */
        pclose(ptr);
/* close file */
        fclose(charmm_in);
        if(Sub_Proc) { 
                kill(Process_pid,SIGUSR1);
                exit(1);}
          return;}

      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';

          lines++;

/* look for a '@' in first position on line */
      if(input[0] == '@') { /* hook onto new file */
      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';
      HOOK_FILE(ptr,charmm_in);
      }

        if((ok = fprintf(ptr,"%s\n",input)) < 0) {
          if(!Sub_Proc) 
           PrintMessage("?ERROR - can't write into pipe");
          else
           printf("?ERROR - can't write into pipe \n");

              if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
              check_if_fatal(1);
           return;}

      }
}

/************************************************************************/
strm_icon8(text,text1)
     char *text;
     char *text1;
/************************************************************************/
{
     FILE *ptr;
     FILE *charmm_in;

     static char cmd[BUFF_LEN];
     char input[BUFF_LEN];
     char *ret_val;
     char OutText[BUFF_LEN];
     int lines,ok;
     int Sub_Proc;

     void child_done();  /* process to inform that child has finished */

     strncpy(cmd,StreamerInfo.ICON8,BUFF_LEN);

     Sub_Proc = 0; /* no */
     if(!strncmp(text1,"&",1)) Sub_Proc = 1; /* yes */

     if(!Sub_Proc) {
        sprintf(OutText,"> Executing command '%s'\n",cmd);
        PrintMessage(OutText);}
     else {
        sprintf(OutText,"> Executing command '%s' as a subrocess\n",cmd);
        PrintMessage(OutText);}

     if(Sub_Proc) { /* fork it and remember to kill the subprocess */
       if(fork() != 0) {                 /* parent process */
         signal(SIGUSR1,child_done);     /* I'm ready to receive signal */
         return;}
     }
/* open pipe in write mode */
    ptr = popen(cmd,"w");
    if(ptr == NULL) {
      if(!Sub_Proc)
        PrintMessage("?ERROR - can't open pipe to ICON8");
      else
        printf("?ERROR - can't open pipe to ICON8 \n");

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

/* open charmm input file */
    charmm_in = fopen(text,"r");
    if(charmm_in == NULL) {
     if(!Sub_Proc){
      sprintf(OutText,"?ERROR - can't open ICON8 input file '%s'",text);
      PrintMessage(OutText);}
     else
      printf("?ERROR - can't open ICON8 input file '%s'\n",text);

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

      lines = 0;
/* start reading icon8 input file */
      while(1) {

go_on:;
      ret_val = fgets(input,MAXlinel,charmm_in);

        if(ret_val == NULL) {
         if(!Sub_Proc) {
           sprintf(OutText,"End of file: %s (read %d lines)",text,lines);
           PrintMessage(OutText);}
         else
           printf("End of file: %s (read %d lines)\n",text,lines);

/* close pipe */
        pclose(ptr);
/* close file */
        fclose(charmm_in);
        if(Sub_Proc) { 
                kill(Process_pid,SIGUSR1);
                exit(1);}
          return;}

      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';

          lines++;

/* look for a '@' in first position on line */
      if(input[0] == '@') { /* hook onto new file */
      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';
      HOOK_FILE(ptr,charmm_in);
      }

        if((ok = fprintf(ptr,"%s\n",input)) < 0) {
          if(!Sub_Proc) 
           PrintMessage("?ERROR - can't write into pipe");
          else
           printf("?ERROR - can't write into pipe \n");

              if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
              check_if_fatal(1);
           return;}

      }
}


/************************************************************************/
strm_probesurf(text,text1)
     char *text;
     char *text1;
/************************************************************************/
{
     FILE *ptr;
     FILE *charmm_in;

     static char cmd[BUFF_LEN];
     char input[BUFF_LEN];
     char *ret_val;
     char OutText[BUFF_LEN];
     int lines,ok;
     int Sub_Proc;

     void child_done();  /* process to inform that child has finished */

     strncpy(cmd,StreamerInfo.PROBESURF,BUFF_LEN);

     Sub_Proc = 0; /* no */
     if(!strncmp(text1,"&",1)) Sub_Proc = 1; /* yes */

     if(!Sub_Proc) {
        sprintf(OutText,"> Executing command '%s'\n",cmd);
        PrintMessage(OutText);}
     else {
        sprintf(OutText,"> Executing command '%s' as a subrocess\n",cmd);
        PrintMessage(OutText);}

     if(Sub_Proc) { /* fork it and remember to kill the subprocess */
       if(fork() != 0) {                 /* parent process */
         signal(SIGUSR1,child_done);     /* I'm ready to receive signal */
         return;}
     }
/* open pipe in write mode */
    ptr = popen(cmd,"w");
    if(ptr == NULL) {
      if(!Sub_Proc)
        PrintMessage("?ERROR - can't open pipe to PROBESURF");
      else
        printf("?ERROR - can't open pipe to PROBESURF \n");

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

/* open charmm input file */
    charmm_in = fopen(text,"r");
    if(charmm_in == NULL) {
     if(!Sub_Proc){
      sprintf(OutText,"?ERROR - can't open PROBESURF input file '%s'",text);
      PrintMessage(OutText);}
     else
      printf("?ERROR - can't open PROBESURF input file '%s'\n",text);

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

      lines = 0;
/* start reading PROBESURF input file */
      while(1) {

go_on:;
      ret_val = fgets(input,MAXlinel,charmm_in);

        if(ret_val == NULL) {
         if(!Sub_Proc) {
           sprintf(OutText,"End of file: %s (read %d lines)",text,lines);
           PrintMessage(OutText);}
         else
           printf("End of file: %s (read %d lines)\n",text,lines);

/* close pipe */
        if(pclose(ptr)) {
         if(!Sub_Proc) {
           PrintMessage("?WARNING - exit from child is != 0");}
         else
           printf("?WARNING - exit from child is != 0");
       }

/* close file */
        fclose(charmm_in);

        if(Sub_Proc) { 
                kill(Process_pid,SIGUSR1);
                exit(1);}
          return;}

      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';

          lines++;

/* look for a '@' in first position on line */
      if(input[0] == '@') { /* hook onto new file */
      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';
      HOOK_FILE(ptr,charmm_in);
      }

        if((ok = fprintf(ptr,"%s\n",input)) < 0) {
          if(!Sub_Proc) 
           PrintMessage("?ERROR - can't write into pipe");
          else
           printf("?ERROR - can't write into pipe \n");
              if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
              check_if_fatal(1);
           pclose(ptr);
           return;}

        }
}

/************************************************************************/
strm_density(text,text1)
     char *text;
     char *text1;
/************************************************************************/
{
     FILE *ptr;
     FILE *charmm_in;

     static char cmd[BUFF_LEN];
     char input[BUFF_LEN];
     char *ret_val;
     char OutText[BUFF_LEN];
     int lines,ok;
     int Sub_Proc;

     void child_done();  /* process to inform that child has finished */

     strncpy(cmd,StreamerInfo.DENSITY,BUFF_LEN);

     Sub_Proc = 0; /* no */
     if(!strncmp(text1,"&",1)) Sub_Proc = 1; /* yes */

     if(!Sub_Proc) {
        sprintf(OutText,"> Executing command '%s'\n",cmd);
        PrintMessage(OutText);}
     else {
        sprintf(OutText,"> Executing command '%s' as a subrocess\n",cmd);
        PrintMessage(OutText);}

     if(Sub_Proc) { /* fork it and remember to kill the subprocess */
       if(fork() != 0) {                 /* parent process */
         signal(SIGUSR1,child_done);     /* I'm ready to receive signal */
         return;}
     }
/* open pipe in write mode */
    ptr = popen(cmd,"w");
    if(ptr == NULL) {
      if(!Sub_Proc)
        PrintMessage("?ERROR - can't open pipe to DENSITY");
      else
        printf("?ERROR - can't open pipe to DENSITY \n");

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

/* open charmm input file */
    charmm_in = fopen(text,"r");
    if(charmm_in == NULL) {
     if(!Sub_Proc){
      sprintf(OutText,"?ERROR - can't open DENSITY input file '%s'",text);
      PrintMessage(OutText);}
     else
      printf("?ERROR - can't open DENSITY input file '%s'\n",text);

       if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
       check_if_fatal(1);
      return;}

      lines = 0;
/* start reading DENSITY input file */
      while(1) {

go_on:;
      ret_val = fgets(input,MAXlinel,charmm_in);

        if(ret_val == NULL) {
         if(!Sub_Proc) {
           sprintf(OutText,"End of file: %s (read %d lines)",text,lines);
           PrintMessage(OutText);}
         else
           printf("End of file: %s (read %d lines)\n",text,lines);

/* close pipe */
        pclose(ptr);
/* close file */
        fclose(charmm_in);
        if(Sub_Proc) { 
                kill(Process_pid,SIGUSR1);
                exit(1);}
          return;}

      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';

          lines++;

/* look for a '@' in first position on line */
      if(input[0] == '@') { /* hook onto new file */
      ok = strlen(input) - 1;
      if(input[ok] == '\n') input[ok] = '\0';
      HOOK_FILE(ptr,charmm_in);
      }

        if((ok = fprintf(ptr,"%s\n",input)) < 0) {
          if(!Sub_Proc) 
           PrintMessage("?ERROR - can't write into pipe");
          else
           printf("?ERROR - can't write into pipe \n");

              if(Sub_Proc) {
                kill(Process_pid,SIGUSR1);
                exit(1);}
              check_if_fatal(1);
           return;}

      }
}


