/*  

                       Copyright (c) 1993 by:
        Leif Laaksonen , Centre for Scientific Computing , ESPOO , FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#ifdef sgi
#include <gl/gl.h>
#include <gl/device.h>
#include <get.h>
#endif
#include <math.h>
#include "maxdefs.h"

#ifdef sgi
#define YSTEREO        491    /* subfield hight in pixels */
#define YOFFSET_LEFT   532    /* YSTEREO + YBLANK */
#define XXMAXSCREEN     getgdesc(GD_XPMAX)
#define YYMAXSCREEN     getgdesc(GD_YPMAX)
#endif

#define TRANSLATE(a,b,c) translateO(a,b,c) /* use own translation function */

struct {
     int  IsON;
     long MousePosition;
     long Monitor;
     short MatrixMode;
     long WinID;
     long SaveMainWindowID;
     float saveMV[4][4];
     float savePV[4][4];
     long  OLDXposition;
     long  OLDYposition;
     long  OLDXsize;
     long  OLDYsize;
     float dist;
     float eye;
                        } StereoSetting = { 0 , 0 , 0 , 0};

/*  structure to contain window information */
extern struct {
    long win_ids[MAX_WINDOWS];    /* array to contain window ids */
    long win_num;                 /* number of open windows      */
    int  plot_type[MAX_WINDOWS];  /* type of plot in window      */
    int  Off;                       /* != 0 , control off          */
    int  update;                    /* number of windows to update */
    long needs_update[MAX_WINDOWS]; /* windows that need update    */
                   } WinControl;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;

 extern long  GetMainWindowID();
 extern void  draw_obj();
 extern void  draw_other_stuff();

 extern float near;
 extern float far;
 extern int   term_type;

  int IsStereo();
  int IsStereoON();
  int ShowRealStereo();
  int SetRealStereoParams();
  int ResetRealStereoParams();
  int ADDdistStereo(float a);
  int SUBdistStereo(float a);
  int ADDeyeStereo(float a);
  int SUBeyeStereo(float a);

/***************************************************************************/
int SetRealStereoON()
/***************************************************************************/
{
#ifdef sgi

    char OutText[BUFF_LEN];
   
    if(!IsStereo())
                  return(1);

   (void) SetRealStereoParams();

    mmode(MVIEWING);
        getmatrix(StereoSetting.saveMV); /* save transformation matrix */
    
    getorigin( &StereoSetting.OLDXposition , &StereoSetting.OLDYposition);
    getsize(   &StereoSetting.OLDXsize     , &StereoSetting.OLDYsize);

    winposition(0 , XXMAXSCREEN , 0 , YYMAXSCREEN);
    winpop();
    viewport(0 , XXMAXSCREEN , 0 , YYMAXSCREEN);
    reshapeviewport();

    StereoSetting.Monitor    = getmonitor();
    StereoSetting.MatrixMode = getmmode();

    StereoSetting.MousePosition = getvaluator(CURSORY);
    setvaluator(CURSORY , YSTEREO / 2 , 0 , YSTEREO);

    clear();
    zclear();

    setmonitor(STR_RECT); 

    StereoSetting.IsON    = 1;

   sprintf(OutText,"Distance: %f , eye: %f",StereoSetting.dist,
                                            StereoSetting.eye);
   PrintMessage(OutText);

#else
    PrintMessage("?ERROR - stereo mode not supported on this hardware");
#endif
     return(0);
}
/***************************************************************************/
int SetRealStereoOFF()
/***************************************************************************/
{
#ifdef sgi

    char OutText[BUFF_LEN];
   
    if(!StereoSetting.IsON) {
        PrintMessage("?ERROR - stereo mode is not on");
        return(1);}

    setmonitor(StereoSetting.Monitor); 

    mmode(StereoSetting.MatrixMode);
    setvaluator(CURSORY,StereoSetting.MousePosition , 0 , YMAXSCREEN);

    StereoPlot.Active     = 0;
    StereoSetting.IsON    = 0;

    loadmatrix(StereoSetting.saveMV);

        winposition(StereoSetting.OLDXposition , 
                   (StereoSetting.OLDXposition + StereoSetting.OLDXsize) , 
                    StereoSetting.OLDYposition , 
                   (StereoSetting.OLDYposition + StereoSetting.OLDYsize));
        winpop();
/*        viewport(0 , XXMAXSCREEN , 0 , YYMAXSCREEN); */
        reshapeviewport();

    sprintf(OutText,"Distance: %f , eye: %f",StereoSetting.dist,
                                           StereoSetting.eye);
    PrintMessage(OutText);


#else
    PrintMessage("?ERROR - stereo not supported on this hardware");
#endif
    
    return(0);
}
/***************************************************************************/
int IsStereo()
/***************************************************************************/
{
#ifdef sgi
    if(term_type == 1 || term_type == 3) {
       return(getgdesc(GD_STEREO));
     }
    else {
       return(0);
    }
#else
    PrintMessage("?ERROR - stereo not supported on this hardware");
    return(0);
#endif
}

/* This routine performs the perspective projection for one eye's subfield

   The projection is in the direction of the negative z axis.

   xmin, xmax, ymin, ymax = the coordinate range, in the plane of zero
                            parallax setting, that will be displayed on the
                            screen. The ratio between (xmax-xmin) and
                            (ymax-ymin) should equal the aspect ratio of
                            the display.

   znear,zfar             = the x-coordinate values of the plane of zero 
                            parallax setting.

   zzps                   = the z-coordinate of the plane of zero parallax
                            setting.

   dist                   = the distance from the center of projection
                            to the plane of zero parallax.

   eye                    = half the eye separation; positive for the
                            right eye subfield, negative for the left eye
                            subfield.
*/

/***************************************************************************/
void StereoProj(float xmin , float xmax , float ymin , float ymax ,
                float znear, float zfar , float zzps , float dist ,
                float eye)
/***************************************************************************/
{

#ifdef sgi
     static float xmid, ymid, clip_near , clip_far, top, bottom, left, right ,
                 dx, dy , n_over_d;

     static long Xwind;
     static long Ywind;

     register float GlobalScale;


     getsize(&Xwind , &Ywind);

     GlobalScale = (float)Xwind / (float)Ywind;

    dx = xmax - xmin;
    dy = ymax - ymin;

    xmid = (xmax + xmin) / 2.0;
    ymid = (ymax + ymin) / 2.0;

    clip_near = dist + zzps - znear;
    clip_far  = dist + zzps - zfar;

    n_over_d  = clip_near / dist;

    top       = n_over_d * dy / 2.0;

    bottom    = -top;

    right     = n_over_d * ( dx / 2.0 - eye);
    left      = n_over_d * (-dx / 2.0 - eye);

    window(GlobalScale * left,GlobalScale * right,
           bottom,top,clip_near,clip_far);

    TRANSLATE(-xmid-eye , -ymid, -zzps-dist);

#else
    PrintMessage("?ERROR - stereo not supported on this hardware");
#endif

    return;
}

/***************************************************************************/
int IsStereoON()
/***************************************************************************/
{

#ifdef sgi
    return(StereoSetting.IsON);
#else
    PrintMessage("?ERROR - stereo not supported on this hardware");
    return(0);
#endif

}
/***************************************************************************/
int ShowRealStereo()
/***************************************************************************/
{


#ifdef sgi

   viewport(0 , XXMAXSCREEN , YOFFSET_LEFT , YOFFSET_LEFT + YSTEREO);

   pushmatrix();

   StereoProj(near  , far , near , far , far , near , 0.0 , 
              StereoSetting.dist , -StereoSetting.eye);


    draw_obj();
     draw_other_stuff();

   popmatrix();

   pushmatrix();   

   viewport(0 , XXMAXSCREEN, 0 , YSTEREO);


   StereoProj(near , far , near , far , far , near, 0.0 ,
              StereoSetting.dist ,  StereoSetting.eye);

    draw_obj();
     draw_other_stuff();

   popmatrix();

#else
    PrintMessage("?ERROR - stereo not supported on this hardware");
#endif

   return(0);
}

/***************************************************************************/
int SetRealStereoParams()
/***************************************************************************/
{
  if(StereoSetting.dist < 1.e-05)
     StereoSetting.dist = 1.2 * far;

  if(StereoSetting.eye  < 1.e-05) 
     StereoSetting.eye  = 0.31;

  return(0);
}
/***************************************************************************/
int ResetRealStereoParams()
/***************************************************************************/
{
     StereoSetting.dist = 0.0;
     StereoSetting.eye  = 0.0;
     StereoSetting.IsON = 0;

  return(0);
}

/***************************************************************************/
int ADDdistStereo(float a)
/***************************************************************************/
{
    StereoSetting.dist += a;

    return(0);
}
/***************************************************************************/
int SUBdistStereo(float a)
/***************************************************************************/
{
    StereoSetting.dist -= a;

    if(StereoSetting.dist < 0.0) 
       StereoSetting.dist = 0.0;

    return(0);
}

/***************************************************************************/
int ADDeyeStereo(float a)
/***************************************************************************/
{
    StereoSetting.eye += a;

    return(0);
}

/***************************************************************************/
int SUBeyeStereo(float a)
/***************************************************************************/
{
    StereoSetting.eye -= a;

    if(StereoSetting.eye < 0.0) 
       StereoSetting.eye = 0.0;

    return(0);
}
