/*

   Tools to be used with spectrum

   Leif Laaksonen 1991
*/


#include <stdio.h>
#include <malloc.h>
#ifdef sgi
#ifdef IRIX4
#include <audio.h>
#else
#include <sys/audio.h>
#endif
#endif
#include "spectrum.h"

#define SHORT_PEAK 32000.


/***************************************************************************/
int LinesInFileSpec(FPointer)
    FILE *FPointer;
/***************************************************************************/
{

    int   i = 0;
    char  InText[BUFF_LEN];

    rewind(FPointer);

    while(fgets(InText,BUFF_LEN,FPointer) != NULL) i++;

    rewind(FPointer);

#ifdef DEBUG
    printf("Number of lines %d\n",i);
#endif

    return(i);
}
/***************************************************************************/
int GetXYFileSpec(FPointer , Lines)
    FILE *FPointer;
    int   Lines;
/***************************************************************************/
{
    int i,j;
    char InLine[BUFF_LEN];

    j = 2 * check_pow_2(Lines / 2);

    for(i = 0 ; i < j ; i++) {

       if(i < Lines) {
       if(fgets(InLine, BUFF_LEN , FPointer) == NULL) return(1);

       sscanf(InLine,"%f %f",&TimeSeries.XData[i],
                               &TimeSeries.YData[i]);}
       else {
           TimeSeries.XData[i] = 0.0;
           TimeSeries.YData[i] = 0.0;}}

    TimeSeries.SFreq   = NSECO / (TimeSeries.XData[1] - TimeSeries.XData[0]);
    TimeSeries.Observ  = j;
    TimeSeries.RealObs = Lines;

    return(0);
}

/***************************************************************************/
void GoGetSpaceSpec(Lines)
   int Lines;
/***************************************************************************/
{

   TimeSeries.XData  = vector(Lines);
   TimeSeries.YData  = vector(Lines);
   TimeSeries.Spec   = vector(Lines);
   TimeSeries.SpecX1 = vector(Lines);
   TimeSeries.SpecX2 = vector(Lines);

   if(TimeSeries.XData == NULL ||
      TimeSeries.YData == NULL ||
      TimeSeries.Spec  == NULL ||
      TimeSeries.SpecX1 == NULL ||
      TimeSeries.SpecX2 == NULL) {
      PrintMessage("?ERROR - can't allocate space");
      shut_down(1);}
}
/***************************************************************************/
int PowSpec()
/***************************************************************************/
{

    int   i,j;
    float temp1,temp2,temp3;


    temp3 = 1.0 / ((float) TimeSeries.Observ);

    TimeSeries.Spec[0]                        = 
               TimeSeries.YData[0] * TimeSeries.YData[0] * temp3; 
     TimeSeries.Spec[TimeSeries.Observ/2 - 1] = 
               TimeSeries.YData[1] * TimeSeries.YData[1] * temp3; 

    j = 2;
    for(i = 1 ; i < TimeSeries.Observ/2 - 1 ; i++) {
        temp1 = TimeSeries.YData[j];
         temp2 = TimeSeries.YData[j+1];
        TimeSeries.Spec[i] = (temp1*temp1 + temp2*temp2) * temp3;
         j +=2;}

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
       temp1 = (TimeSeries.SFreq * ((float)(i)) / 
                        ((float)TimeSeries.Observ));
       temp2 = 100. * temp1 / SPEEDLIGHT;
       TimeSeries.SpecX1[i] = temp1;
       TimeSeries.SpecX2[i] = temp2;
/*       printf("%f %f %f\n",temp1,temp2,TimeSeries.Spec[i]); */
    }

/*    if(DoAudio()) exit(1); */

    return(0);
}
/***************************************************************************/
int CalcAverSpec(Lines)
    int Lines;
/***************************************************************************/
{
    int i;
    float Aver;
    char OutText[BUFF_LEN];

    Aver = 0;


    for(i = 0 ; i < Lines ; i++) Aver += TimeSeries.YData[i];

    Aver = Aver / (float)(Lines);

    sprintf(OutText,"* Shifting data: %f",-Aver);
    PrintMessage(OutText);

    for(i = 0 ; i < Lines ; i++) TimeSeries.YData[i] -= Aver;

    return(0);
}

/***************************************************************************/
int DeleteSpecData()
/***************************************************************************/
{
    if(TimeSeries.Observ) {

       TimeSeries.Observ = 0;
       free(TimeSeries.XData);
        free(TimeSeries.YData);
         free(TimeSeries.Spec);
          free(TimeSeries.SpecX1);
           free(TimeSeries.SpecX2);
            free(TimeSeries.ASpec);
     }
     else {
        PrintMessage("?ERROR - no frequence data available to be deleted");
        return(1);}

     return(0);
}

/************************************************************************/
int PowerDataWrite(FileName,TimeAlt)
    char *FileName;
    int   TimeAlt;
/************************************************************************/
{
     FILE *write_p;
     int i,j;
     char OutText[BUFF_LEN];
     float temp1,temp2;

     if(!TimeSeries.Observ) {
        PrintMessage("?ERROR - no data for the power spectra defined");
         return(1);}

     if(FileName[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?' ");
       return(1);}

     write_p = fopen(FileName,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : '%s' ",FileName);
       PrintMessage(OutText);
        return(1);}

/* ready to write now ... */
     sprintf(OutText,"Writing power spectrum to file '%s' on disk",FileName);
     PrintMessage(OutText);

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
       temp1 = TimeSeries.SpecX1[i];
       temp2 = TimeSeries.SpecX2[i];
      if(TimeAlt)    /* frequency */
       fprintf(write_p,"%f %f\n",temp1,TimeSeries.Spec[i]);
      else           /* cm-1      */
       fprintf(write_p,"%f %f\n",temp2,TimeSeries.Spec[i]);
     }

     fclose(write_p);
     PrintMessage("Done...");

     return(0);
}

/************************************************************************/
int GetPowerObs()
/************************************************************************/
{
    return(TimeSeries.Observ/2);
}
/************************************************************************/
float *GetPowerVec()
/************************************************************************/
{
   return(TimeSeries.Spec);
}

#ifdef sgi
#ifdef AUDIO
/***************************************************************************/
int DoAudio()
/***************************************************************************/
{

    float Smax;
    float Smin = 0.0;

    int i,j;

    ALconfig audio_port_config;
    ALport p;


    Smax = 0.0;
    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
        if(TimeSeries.Spec[i] > Smax) Smax = TimeSeries.Spec[i];
      }

    TimeSeries.ASpec = svector(TimeSeries.Observ/2);

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
                    TimeSeries.ASpec[i] = 
                    (short) (SHORT_PEAK * TimeSeries.Spec[i] / Smax);
      }


    audio_port_config = ALnewconfig();

    ALsetwidth( audio_port_config , AL_SAMPLE_16);
    ALsetchannels( audio_port_config , AL_MONO);

    p  = ALopenport("hello", "w", audio_port_config);

    if(p == NULL) {
    PrintMessage("?ERROR - can't open audio port");
    exit(1);}

    TempBuff = svector(TempBuffLen);

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
     
     for(j = 0 ; j < TempBuffLen ; j++) TempBuff[j] = TimeSeries.ASpec[i];

     ALwritesamps(p, TempBuff , TempBuffLen );    /* play buffer of sound */
     while(ALgetfilled(p) > 0)   /* still sound to play */
     sginap(1);              /* sleep for 1/60 of a second */
   }
     ALcloseport(p);
   
     return(0); 
}
#endif
#endif



