/*
   Main program for the spectrum package for the analysation of the
   main components in time series.

   Leif Laaksonen 1991, 1993
*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "spectrum.h"
#include "maxdefs.h"

/***************************************************************************/
int DoTheJobSpec(InVec,InNumb)
     float *InVec;
     int    InNumb;
/***************************************************************************/
{
   int i,j,k;
   int Lines;
   int VecIndex;
   char OutText[BUFF_LEN];

   float *Data;

    if(TimeSeries.Observ) 
       (void)DeleteSpecData();

#ifdef JUNK
   strncpy(FileNameSpec,SpecFile,BUFF_LEN);

   if(FileNameSpec[0] == '\0') {
     PrintMessage("?Error - input file name not defined");
     return(1);}

   PFileSpec = fopen(FileNameSpec,"r");
           if(PFileSpec == NULL) {
              sprintf(OutText,"?ERROR - can't open input file '%s'",FileNameSpec);
              PrintMessage(OutText);
              return(1);}

   Lines = LinesInFileSpec(PFileSpec);

#endif

   if(InNumb < 1) {
      PrintMessage("?ERROR - number of observables for FTT undefined");
      return(1);}

   if(dynamics_pasback[2] < 1) {
      PrintMessage("?ERROR - time between frames undefined, can't do FFT");
      return(1);}

   Lines = InNumb;

   k = 2 * check_pow_2(Lines/2);

   GoGetSpaceSpec(k);

     if(traj_file_set == 5)   /* mumod trajectories start from time = 0 */
       j = 0;
     else
       j = 1;

   for(i = 0 ; i < k ; i++) {

      if(i < InNumb) {
       TimeSeries.XData[i] = (i + j) * dynamics_pasback[2];
        TimeSeries.YData[i] = InVec[i];}
      else {
       TimeSeries.XData[i]   = 0.0;
         TimeSeries.YData[i] = 0.0;}
    }

    TimeSeries.SFreq   = NSECO / (TimeSeries.XData[1] - TimeSeries.XData[0]);
    TimeSeries.Observ  = k;
    TimeSeries.RealObs = Lines;

   sprintf(OutText,"Number of lines: %d , value used: %d \n",Lines,k);
   PrintMessage(OutText);

/*
   if(GetXYFileSpec(PFileSpec , Lines)) return(1);
*/

   if(CalcAverSpec(Lines)) return(1);

   Data = TimeSeries.YData;
  
   realft((Data-1),TimeSeries.Observ/2,1);

#ifdef DEBUG   
   for(i = 0 ; i < TimeSeries.Observ ; i++) {
   printf(" %d %f \n",(i+1),Data[i]);}
#endif

   if(PowSpec()) {
     PrintMessage("?ERROR in PowSpec");
     return(1);}
}

