#define BUFF_LEN 256    /* this has to match the value in 'maxdefs.h' */
#define NSECO    1000.
#define SPEEDLIGHT 2.997925

#ifdef SPEC_MAIN

   int  ReadSeriesSpec();
   int  DoTheJobSpec();
   int  LinesInFileSpec();
   int  GetXYFileSpec();
   void PrintMessage();
   void GoGetSpaceSpec();
   int PowSpec();
   int CalcAverSpec();
   int DeleteSpecData();
   int PowerDataWrite();
   int GetPowerObs();
   float *GetPowerVec();

/*   int DoAudio(); */

   char  FileNameSpec[BUFF_LEN];

   short *TempBuff;
   int    TempBuffLen;

   FILE *PFileSpec = NULL;

   struct T_series {
      int      Observ;   /* if = 0 no series defined */
      int      RealObs;  /* number of real observations (not the value rounded
                            to a value equal to a power of two) */
      float    SFreq;     /* sampling frequency in unit of 10**12 Hz. 
                             !!!!OBSERVE that the data is sampled in
                                 units of fs (femtoseconds) */ 
      float   *XData;     /* pointer to the X data      */
      float   *YData;     /* pointer to the Y data      */
      float   *Spec;      /* Power spectrum             */
      float   *SpecX1;    /* x-axis                     */
      float   *SpecX2;    /* in units of cm-1           */
      short   *ASpec;     /* pointer to the stuff for the audio */
    } TimeSeries = { 0 , 0 , 0.0 , NULL , NULL , NULL , NULL , NULL , NULL};

   struct Err_Trap {
      int ErrorCode;
    } ErrorTrap = { 0 };

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

    extern int dynamics_pasback[20];

    extern int traj_file_set;

#else

   extern void realft();
   extern void four1();
   extern int  ReadSeriesSpec();
   extern int  DoTheJobSpec();
   extern int  LinesInFileSpec();
   extern int  GetXYFileSpec();
   extern void PrintMessage();
   extern void shut_down();
   extern void GoGetSpaceSpec();
   extern int check_pow_2();
   extern int PowSpec();
   extern int CalcAverSpec();
   extern int DoAudio();
   extern int DeleteSpecData();
   extern int PowerDataWrite();
   extern int   *ivector();
   extern float *vector();
   extern char  *cvector();
   extern short *svector();

   extern char FileNameSpec[BUFF_LEN];
   extern short *TempBuff;
   extern int    TempBuffLen;

   extern FILE *PFileSpec;
   
   extern struct T_series {
      int      Observ;   /* if = 0 no series defined */
      int      RealObs;  /* number of real observations (not avalue rounded
                            to a value equal to a power of two) */
      float    SFreq;     /* sampling frequency. 
                             !!!!OBSERVE that the data is sampled in
                                 units of fs (femtoseconds) */ 
      float   *XData;     /* pointer to the X data      */
      float   *YData;     /* pointer to the Y data      */
      float   *Spec;      /* Power spectrum             */
      float   *SpecX1;    /* x-axis                     */
      float   *SpecX2;    /* in units of cm-1           */
      short   *ASpec;     /* pointer to the stuff for the audio */
    } TimeSeries;

   extern struct Err_Trap {
      int ErrorCode;
    } ErrorTrap;

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

    extern int dynamics_pasback[20];

    extern int traj_file_set;

#endif










